/*-----------------------------------------------------*\
|                                                       |
|  Title   :      Constants for Drawing                 |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :         Jacomme Ludovic                    |
|                                                       |
\------------------------------------------------------*/

#ifndef RULESDEF
#define RULESDEF

  char MBK_VIA_TO_LAYER_RDS [ 9 ][ 7 ] =
 
       {
         { RDS_POLY, 15, RDS_CONT, 05, RDS_ALU1, 10, END_LIST }, /* CONT_POLY  */
         { RDS_ALU1, 10, RDS_VIA1, 05, RDS_ALU2, 15, END_LIST }, /* CONT_VIA   */
         { RDS_NDIF, 15, RDS_CONT, 05, RDS_ALU1, 10, END_LIST }, /* CONT_DIFN  */
         { RDS_PDIF, 15, RDS_CONT, 05, RDS_ALU1, 10, END_LIST }, /* CONT_DIFP  */
         { RDS_NTIE, 15, RDS_CONT, 05, RDS_ALU1, 10, END_LIST }, /* CONT_BODYN */
         { RDS_PTIE, 15, RDS_CONT, 05, RDS_ALU1, 10, END_LIST }, /* CONT_BODYP */
         { RDS_NDIF, 25, RDS_GATE, 05, END_LIST, 00, END_LIST }, /* C_X_N      */
         { RDS_PDIF, 25, RDS_GATE, 05, END_LIST, 00, END_LIST }, /* C_X_P      */
         { RDS_ALU2, 25, RDS_VIA2, 05, RDS_ALU3, 25, END_LIST }  /* CONT_VIA2  */
       };

  char LAYER_RDS_TO_MBK_VIA [ RDS_MAX_LAYER ] =

       {
         END_LIST   ,     /* NWELL   */
         END_LIST   ,     /* PWELL   */
         CONT_DIF_N ,     /* NDIF    */
         CONT_DIF_P ,     /* PDIF    */
         CONT_BODY_N,     /* NTIE    */
         CONT_BODY_P,     /* PTIE    */
         CONT_POLY  ,     /* POLY    */
         END_LIST   ,     /* GATE    */
         END_LIST   ,     /* TPOLY   */
         END_LIST   ,     /* CONT    */
         CONT_VIA   ,     /* ALU1    */
         END_LIST   ,     /* TALU1   */
         END_LIST   ,     /* VIA1    */
         CONT_VIA2  ,     /* ALU2    */
         END_LIST   ,     /* TALU2   */ 
         END_LIST   ,     /* VIA2    */
         END_LIST   ,     /* ALU3    */
         END_LIST   ,     /* TALU3   */ 
         END_LIST   ,     /* REF     */
         END_LIST   ,     /* ABOX    */
         END_LIST         /* DEFAULT */
       };

  long SEGMENT_EXTENTION[ RDS_MAX_LAYER ] =

       {
         00,     /* NWELL                       */
         00,     /* PWELL       SEGMENT         */
         05,     /* NDIF                        */
         05,     /* PDIF                        */
         05,     /* NTIE        /-----\         */
         05,     /* PTIE        |     |         */
         05,     /* POLY        |  X  |         */
         00,     /* GATE        |  |  |         */
         05,     /* TPOLY       |  |  |         */
         00,     /* CONT        |  |  |         */
         05,     /* ALU1        |  |  |         */
         05,     /* TALU1       |  |  |         */
         00,     /* VIA1        |  X  |         */
         10,     /* ALU2        |  :  |         */
         10,     /* TALU2       \--:--/         */
         00,     /* VIA2        :  :            */
         15,     /* ALU3        <-->            */
         15,     /* TALU3                       */
         00,     /* REF                         */
         00,     /* ABOX                        */
         00      /* DEFAULT                     */
       };


  long SEGMENT_WIDTH[ RDS_MAX_LAYER ] =

       {
         40,     /* NWELL                       */
         40,     /* PWELL       SEGMENT         */
         20,     /* NDIF                        */
         20,     /* PDIF                        */
         20,     /* NTIE        /-----\         */
         20,     /* PTIE        |     |         */
         10,     /* POLY        |  X  |         */
         10,     /* GATE        |  |  |         */
         10,     /* TPOLY       |  |  |         */
         10,     /* CONT        |  |  |         */
         10,     /* ALU1        |  |  |         */
         10,     /* TALU1       |  |  |         */
         10,     /* VIA1        |  X  |         */
         20,     /* ALU2        |     |         */
         20,     /* TALU2       \-----/         */
         10,     /* VIA2        :     :         */
         30,     /* ALU3        <----->         */
         30,     /* TALU3                       */
         10,     /* REF                         */
         00,     /* ABOX                        */
         00      /* DEFAULT                     */
       };

  long TRANSISTOR_WIDTH     = 20;
  long TRANSISTOR_EXTENTION = 15;

  long REFERENCE_SIZE = 10;

#endif
