/*-----------------------------------------------------*\
|                                                       |
|  Title   :   Types and Constants for Fence            |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :        Jacomme Ludovic                     |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                    Les constantes                     |
\------------------------------------------------------*/

#ifndef FENCEDEF
#define FENCEDEF

#define MAX_FENCE_LAYER  RDS_REF

/*-----------------------------------------------------*\
|                       Les Types                       |
\*-----------------------------------------------------*/

  typedef struct LynxFenceList
  {
    struct LynxFenceList *Next;
    chain_list           *LayerTable[MAX_FENCE_LAYER];

  } FenceList;

/*-----------------------------------------------------*\
|                  Les variables globales               |
\------------------------------------------------------*/

  extern char       FenceLayerEnable[ MAX_FENCE_LAYER ];
  extern FenceList *HeadFence;
  extern long       MaskCounterRds;
  extern long       XMaxRds;
  extern long       YMaxRds;
  extern long       XMinRds;
  extern long       YMinRds;

/*-----------------------------------------------------*\
|                      Les fonctions                    |
\------------------------------------------------------*/

  extern FenceList *AllocFenceList();
  extern void       FreeFenceList();
  extern void       LinkFenceRectangle();
  extern void       DelFenceList();
  extern long       BuildFenceList();

#endif
