/*------------------------------------------------------\
|                                                       |
|  Title   :     Extract Tools Box for Lynx             |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :         Jacomme ludovic                    |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                Les fichiers a inclure                 |
\*-----------------------------------------------------*/

#  include MUT_H
#  include MLO_H
#  include MPH_H
#  include RDS_H
#  include EXTRACT_H
#  include <stdio.h>
#  include <ctype.h>
#  include "extractor.h"

/*-----------------------------------------------------*\
|                  Les Messages d'erreur                |
\*-----------------------------------------------------*/

#  include "lyerror.h"
      
/*-----------------------------------------------------*\
|                 Les variables globales                |
\*-----------------------------------------------------*/

#  include "capalayer.h"

  lofig_list *HeadLogicalFigure = (lofig_list *)NULL;
  lofig_list *HeadLogicalModel  = (lofig_list *)NULL;

  capa_box   *CapacityTable[ MAX_CAPACITY ];

/*-----------------------------------------------------*\
|          Dump d'une equi dans une figure MBK          |
\*-----------------------------------------------------*/

  void DumpEqui( FigureMbk, FigureRds, FirstEqui )

       phfig_list *FigureMbk;
       rds_fig    *FigureRds;
       rds_rec    *FirstEqui;
  {
    rds_rec    *RectangleAbox;

    if ( ( RectangleAbox = FigureRds->layertab[ RDS_ABOX ] ) != (rds_rec *)NULL )
    {
      FigureMbk->XAB1 = RectangleAbox->x;
      FigureMbk->XAB2 = RectangleAbox->x + RectangleAbox->dx;
      FigureMbk->YAB1 = RectangleAbox->y;
      FigureMbk->YAB2 = RectangleAbox->y + RectangleAbox->dy;
    }

    while ( FirstEqui != (rds_rec *)NULL )
    {
      RectangleRdsMbk( FigureMbk, RectangleAbox, FirstEqui );

      if ( (FirstEqui->flags & EXTRACT_BITS) == EXTRACT_END ) break;

      FirstEqui = FirstEqui->equi;
    }
  }

  void DumpAllEqui( FigureMbk, FigureRds )

       phfig_list *FigureMbk;
       rds_fig    *FigureRds;
  {
    rds_rec *FirstEqui;
    rds_rec *RectangleAbox;

    if ( ( RectangleAbox = FigureRds->layertab[ RDS_ABOX ] ) != (rds_rec *)NULL )
    {
      FigureMbk->XAB1 = RectangleAbox->x;
      FigureMbk->XAB2 = RectangleAbox->x + RectangleAbox->dx;
      FigureMbk->YAB1 = RectangleAbox->y;
      FigureMbk->YAB2 = RectangleAbox->y + RectangleAbox->dy;
    }

    for ( FirstEqui  = HeadChainEqui;
          FirstEqui != (rds_rec *)NULL;
          FirstEqui  = FirstEqui->equi )
    {
       RectangleRdsMbk( FigureMbk, RectangleAbox, FirstEqui );
    }
  }

/*-----------------------------------------------------*\
|          Calcul des capacites pour une equi           |
\*-----------------------------------------------------*/

  float ComputeCapacity( FirstEqui )
  
       rds_rec *FirstEqui;
  {
    rds_rec   *ScanEqui;

    capa_box  *NewBox; 
    capa_box  *DelBox; 
    capa_box  *ScanBox;
    capa_box  *IndexBox;
    capa_box **PreviousIndexBox;
    capa_box **PreviousScanBox;

    float      Capacity;
    char       Layer;
    char       Intersec;
    char       Sum;

    char       NextIndex;

    long       X1;
    long       X2;
    long       Y1;
    long       Y2;

    long       x1;
    long       x2;
    long       y1;
    long       y2;
    
    if ( FirstEqui == (rds_rec *)NULL ) return ( 0.0 );

    Capacity = 0.0;

    for ( Layer = 0; Layer < MAX_CAPACITY; Layer++ )
     
      CapacityTable[ Layer ] = (capa_box *)NULL;

    for ( ScanEqui  = FirstEqui;
          ScanEqui != (rds_rec *)NULL;
          ScanEqui  = ScanEqui->equi )
    {
      if ( CapacityByLayer[ ScanEqui->layer ] != 0.0 )
      {
        ScanBox = (capa_box *)RAZStruct( sizeof( capa_box ) );
      
        ScanBox->X1   = ScanEqui->x;
        ScanBox->Y1   = ScanEqui->y;
        ScanBox->X2   = ScanEqui->dx + ScanEqui->x;
        ScanBox->Y2   = ScanEqui->dy + ScanEqui->y;
        ScanBox->NEXT = CapacityTable[ ScanEqui->layer ];

        CapacityTable[ ScanEqui->layer ] = ScanBox;
      }

      if ( (ScanEqui->flags & EXTRACT_BITS) == EXTRACT_END ) break;
    }

    for ( Layer = 0; Layer < MAX_CAPACITY; Layer++ )
    {
      PreviousIndexBox = &CapacityTable[ Layer ];
      IndexBox         = CapacityTable[ Layer ];

      while ( IndexBox != (capa_box *)NULL )
      {
        NextIndex = TRUE;

        X1 = IndexBox->X1;
        X2 = IndexBox->X2;
        Y1 = IndexBox->Y1;
        Y2 = IndexBox->Y2;

        PreviousScanBox = &IndexBox->NEXT;
        ScanBox         = IndexBox->NEXT;

        while ( NextIndex && ( ScanBox != (capa_box *)NULL ) )
        {
          if ( ( ( x1 = ScanBox->X1 ) < X2 ) &&
               ( ( y1 = ScanBox->Y1 ) < Y2 ) &&
               ( ( x2 = ScanBox->X2 ) > X1 ) &&
               ( ( y2 = ScanBox->Y2 ) > Y1 ) )
          {
            Sum      = 0;
            Intersec = 0;

            if ( y1 < Y1 ) { Intersec |= 4; Sum++; }
            if ( x2 > X2 ) { Intersec |= 2; Sum++; }
            if ( y2 > Y2 ) { Intersec |= 1; Sum++; }

            if ( x1 < X1 )  
            {
              switch ( Sum )
              {
                case 3 :  /* Destroy Index Box */

                          NextIndex = FALSE;

                       break;

                case 2 :  /* Modify Index Box  */
                   
                          switch ( Intersec )
                          {
                            case 3 : if ( y1 == Y1 ) NextIndex = FALSE;
                                     else            Y2 = IndexBox->Y2 = y1;

                                   break;

                            case 5 : if ( x2 == X2 ) NextIndex = FALSE;
                                     else            X1 = IndexBox->X1 = x2;

                                   break;

                            case 6 : if ( y2 == Y2 ) NextIndex = FALSE;
                                     else            Y1 = IndexBox->Y1 = y2;

                          }

                          if ( NextIndex ) 
                          { 
                            PreviousScanBox = &ScanBox->NEXT;
                            ScanBox         = ScanBox->NEXT;
                          } 

                       break;
                          
                case 1 :  /* Cut Scan Box  */
                   
                          NewBox = (capa_box *)RAZStruct( sizeof( capa_box ) );

                          switch ( Intersec )
                          {
                            case 1 : ScanBox->Y1 = Y2;
                                     NewBox->X1  = x1;
                                     NewBox->X2  = X1;
                                     NewBox->Y1  = y1;
                                     NewBox->Y2  = Y2;

                                   break;

                            case 2 : ScanBox->X1 = X2;
                                     NewBox->X1  = x1;
                                     NewBox->X2  = X1;
                                     NewBox->Y1  = y1;
                                     NewBox->Y2  = y2;

                                   break;

                            case 4 : ScanBox->Y2 = Y1;
                                     NewBox->X1  = x1;
                                     NewBox->X2  = X1;
                                     NewBox->Y1  = Y1;
                                     NewBox->Y2  = y2;
                          }

                          NewBox->NEXT    = ScanBox->NEXT;
                          ScanBox->NEXT   = NewBox;
                          ScanBox         = NewBox->NEXT; 
                          PreviousScanBox = &NewBox->NEXT;

                       break;

                case 0 :  /* Modify Scan Box  */
                   
                          ScanBox->X2 = X1;
                          ScanBox     = ScanBox->NEXT;
              }
            }
            else
            {
              switch ( Sum )
              {
                case 0 :  /* Destroy Scan Box */

                          DelBox          = ScanBox;
                          ScanBox         = ScanBox->NEXT;
                         *PreviousScanBox = ScanBox;
                          mbkfree( DelBox );

                       break;

                case 1 :  /* Modify Scan Box  */
                   
                          switch ( Intersec )
                          {
                            case 1 : ScanBox->Y1 = Y2;

                                   break;

                            case 2 : ScanBox->X1 = X2;

                                   break;

                            case 4 : ScanBox->Y2 = Y1;

                          }

                          PreviousScanBox = &ScanBox->NEXT;
                          ScanBox         = ScanBox->NEXT;
                          

                       break;
                          
                case 2 :  /* Cut Scan Box  */
                   
                          NewBox = (capa_box *)RAZStruct( sizeof( capa_box ) );

                          switch ( Intersec )
                          {
                            case 3 : ScanBox->Y1 = Y2;
                                     NewBox->X1  = X2;
                                     NewBox->X2  = x2;
                                     NewBox->Y1  = y1;
                                     NewBox->Y2  = Y2;

                                   break;

                            case 5 : ScanBox->Y1 = Y2;
                                     NewBox->X1  = x1;
                                     NewBox->X2  = x2;
                                     NewBox->Y1  = y1;
                                     NewBox->Y2  = Y1;

                                   break;

                            case 6 : ScanBox->Y2 = Y1;
                                     NewBox->X1  = X2;
                                     NewBox->X2  = x2;
                                     NewBox->Y1  = Y1;
                                     NewBox->Y2  = y2;
                          }

                          NewBox->NEXT    = ScanBox->NEXT;
                          ScanBox->NEXT   = NewBox;
                          ScanBox         = NewBox->NEXT; 
                          PreviousScanBox = &NewBox->NEXT;

                       break;

                case 3 :  /* Modify Index Box  */
                   
                          if ( x1 != X1 ) 
                          {
                            X2 = IndexBox->X2 = x1;
                            PreviousScanBox = &ScanBox->NEXT;
                            ScanBox         = ScanBox->NEXT;
                          }
                          else
                          {
                            NextIndex = FALSE;
                          }
              }
            }
          }
          else 
          {
            PreviousScanBox = &ScanBox->NEXT;
            ScanBox = ScanBox->NEXT;
          }
        }

        if ( NextIndex ) 
        {
          PreviousIndexBox = &IndexBox->NEXT;
          IndexBox = IndexBox->NEXT;
        }
        else
        {
          DelBox           = IndexBox;
          IndexBox         = IndexBox->NEXT;
         *PreviousIndexBox = IndexBox;
          mbkfree( DelBox );
        }
      }

      ScanBox  = CapacityTable[ Layer ];
  
      while ( ScanBox != (capa_box *)NULL )
      {
        Capacity += CapacityByLayer[ Layer ]      * 
                    ( ScanBox->X2 - ScanBox->X1 ) * 
                    ( ScanBox->Y2 - ScanBox->Y1 ) ;

        DelBox   = ScanBox;
        ScanBox  = ScanBox->NEXT;
        mbkfree( DelBox );
      }
    }
    return( Capacity );
  }


/*-----------------------------------------------------*\
|                  Is Lynx Equi                         |
\*-----------------------------------------------------*/

  char IsLynxEqui( LynxEqui, Name )

       chain_list *LynxEqui; 
       char       *Name;
  {
    chain_list *Index;

    for ( Index  = LynxEqui;
          Index != (chain_list *)NULL;
          Index = Index->NEXT )
    {
      if ( (char *)(Index->DATA) == Name ) break;
    }

    if ( Index != (chain_list *)NULL ) return( 1 );
    else                               return( 0 );
  }


/*-----------------------------------------------------*\
|            Construction des signaux logiques          |
\*-----------------------------------------------------*/

  long BuildLogicalSignal( FigureRds, Core, Capa, LynxEqui  )

       rds_fig    *FigureRds;
       char        Core;
       char        Capa;
       chain_list *LynxEqui;
  {
     phfig_list  *FigureMbkEqui;
     phfig_list  *FigureMbkFloat;
     phfig_list  *FigureMbkLynxEqui;
     char         DumpLynxEqui;
   
     losig_list *Signal;
     losig_list *ScanSignal;
     float       SignalCapacity;
     chain_list *SignalChain;
     long        SignalIndex;
     char        SignalType;

     char        SignalFloat;
     char        FirstSignalFloat;

     chain_list *ScanSignalChain;
     chain_list *DeleteChain;
     ptype_list *SignalPtype;
     ptype_list *ScanPtype;

     char       *ConnectorName;
     locon_list *LogicalConnector;

     rds_rec    *ScanEqui;
     rds_rec    *FirstEqui;
     rds_rec    *IndexEqui;
    
     long        Counter;

     Counter        = 0;
     SignalIndex    = 1;
     SignalPtype    = (ptype_list *)NULL;
     SignalType     = INTERNAL;

     HeadLogicalFigure  = addlofig ( FigureRds->name);

     if ( Core ) FigureMbkEqui = addphfig( "core_equi" );
     else        FigureMbkEqui = (phfig_list *)NULL;
     
     if ( LynxEqui != (chain_list *)NULL ) FigureMbkLynxEqui = addphfig( "lynx_equi" );
     else                                  FigureMbkLynxEqui = (phfig_list *)NULL;

     if ( Capa ) SignalCapacity = ComputeCapacity( HeadChainEqui );
     else        SignalCapacity = 0.0;

     SignalFloat      = Core;
     FirstSignalFloat = TRUE;

     for ( FirstEqui = ScanEqui = HeadChainEqui;
           ScanEqui != (rds_rec *)NULL;
           ScanEqui  = ScanEqui->equi )
     { 
       if ( ( Capa                               == 0   ) &&
            ( CapacityByLayer[ ScanEqui->layer ] != 0.0 ) ) 

         SignalCapacity += ( CapacityByLayer[ ScanEqui->layer ] * 
                             ScanEqui->dx  *
                             ScanEqui->dy 
                           ); 

       if ( ScanEqui->u_rec.name != (char *)NULL )
       { 
         if (( ScanEqui->extract_type == RDS_SEG_BANAL ) ||
             ( ScanEqui->extract_type == RDS_CON_EXTER ))
         {
           if ( ScanEqui->extract_type == RDS_CON_EXTER ) 
           {
             SignalType    = EXTERNAL;
             ConnectorName = ScanEqui->u_rec.name;
           }

           SignalPtype = addptype
           ( 
             SignalPtype, 
             GOOD,
             (void *)( ScanEqui->u_rec.name )
           );
         }
       }

       if ( ( Core ) &&
            ( ( ScanEqui->extract_type == RDS_CON_INTER  ) ||
              ( ScanEqui->extract_type == RDS_CON_EXTER  ) ||
              ( ScanEqui->extract_type == RDS_SEG_DRAIN  ) || 
              ( ScanEqui->extract_type == RDS_SEG_SOURCE ) ) )

         SignalFloat = FALSE;

       if ( (ScanEqui->flags & EXTRACT_BITS) == EXTRACT_END )
       {
         if ( SignalFloat ) 
         {
           if ( FirstSignalFloat ) 

             FigureMbkFloat = addphfig( "core_float" );

           FirstSignalFloat = FALSE; 

           DumpEqui( FigureMbkFloat, FigureRds, FirstEqui );
         }

         if ( SignalPtype != (ptype_list *)NULL )
         {
           for ( Signal  = HeadLogicalFigure->LOSIG;
                 Signal != (losig_list *)NULL;
                 Signal  = Signal->NEXT )
           {
             for ( ScanPtype  = SignalPtype;
                   ScanPtype != (ptype_list *)NULL;
                   ScanPtype  = ScanPtype->NEXT )
             {
               ScanSignalChain = Signal->NAMECHAIN;

               while ( ScanSignalChain != (chain_list *)NULL )
               {
                 if ( ScanPtype->DATA == ScanSignalChain->DATA )
                 {
                    DeleteChain     = ScanSignalChain;
                    ScanSignalChain = ScanSignalChain->NEXT;
                    ScanPtype->TYPE = DELETE;

                    Signal->NAMECHAIN = delchain
                    ( 
                      Signal->NAMECHAIN, 
                      DeleteChain 
                    );
                 }
                 else 
                 {
                   ScanSignalChain  = ScanSignalChain->NEXT;
                 }
               }
             }
           }
         }
          
         SignalChain = (chain_list *)NULL;

         for ( ScanPtype  = SignalPtype;
               ScanPtype != (ptype_list *)NULL;
               ScanPtype  = ScanPtype->NEXT )
         {
           if ( ScanPtype->TYPE == GOOD )
           {
             SignalChain = addchain( SignalChain, ScanPtype->DATA );
           }
         }

         freeptype ( SignalPtype );
  
         Counter = Counter + 1;
         Signal  = addlosig
         ( 
           HeadLogicalFigure, 
           SignalIndex++, 
           SignalChain, 
           SignalType, 
           SignalCapacity
         );

         if ( SignalType == EXTERNAL )
         {
            for ( LogicalConnector  = HeadLogicalFigure->LOCON;
                  LogicalConnector != (locon_list *)NULL;
                  LogicalConnector  = LogicalConnector->NEXT )
                
              if ( LogicalConnector->NAME == ConnectorName ) break;
                
            if ( LogicalConnector == (locon_list *)NULL) 
            { 
              LogicalConnector = addlocon
              ( 
                HeadLogicalFigure,
                ConnectorName,
                Signal,
                UNKNOWN  
              );

              LogicalConnector->USER = (ptype_list *)FirstEqui;
            }
            else
            {
              ErrorPhysicalConnector( ConnectorName, Core );

              if ( Core ) 
              {
                DumpEqui( FigureMbkEqui, FigureRds, FirstEqui );
                DumpEqui( FigureMbkEqui, FigureRds, (rds_rec *)( LogicalConnector->USER ) );
                savephfig( FigureMbkEqui );
              }
              exit( ERROR );
           }

           IndexEqui = FirstEqui;

           DumpLynxEqui = (LynxEqui != (chain_list *)NULL);

           for ( IndexEqui  = FirstEqui;
                 IndexEqui != ScanEqui->equi;
                 IndexEqui  = IndexEqui->equi )
           {
             if ( IndexEqui->extract_type == RDS_CON_EXTER )
             {
               if ( DumpLynxEqui )
               {
                 if ( IsLynxEqui( LynxEqui, IndexEqui->u_rec.name ) )
                 {
                   DumpEqui( FigureMbkLynxEqui, FigureRds, FirstEqui );
                   DumpLynxEqui = FALSE;
                 }
               }

               if ( IndexEqui->u_rec.name != ConnectorName )
               {
                 ErrorPhysicalConnectors( IndexEqui->u_rec.name, ConnectorName, Core );

                 if ( Core ) 
                 {
                   DumpEqui( FigureMbkEqui, FigureRds, FirstEqui );
                   savephfig( FigureMbkEqui );
                 }
                 exit ( ERROR );
               }
             }

             IndexEqui->user = (void *)Signal;
           }
         }
         else
         {
           for ( IndexEqui  =  FirstEqui;
                 IndexEqui != ScanEqui->equi;
                 IndexEqui  = IndexEqui->equi )
           {
             IndexEqui->user = (void *)Signal; 
           }
         }

         if ( ! Capa ) SignalCapacity = 0.0;
         else          SignalCapacity = ComputeCapacity( ScanEqui->equi );

         SignalPtype    = (ptype_list *)NULL;
         SignalType     = INTERNAL;
         SignalFloat    = Core;

         FirstEqui = ScanEqui->equi;
       }
     }
  
     if ( FigureMbkLynxEqui != (phfig_list *)NULL ) savephfig( FigureMbkLynxEqui );

     if ( ! FirstSignalFloat ) 
     {
       savephfig( FigureMbkFloat );
       Counter = - Counter;
     }

     return( Counter );
   }

/*-----------------------------------------------------*\
|           Construction des instances logiques         |
\*-----------------------------------------------------*/

   long BuildLogicalInstance( FigureRds)

        rds_fig *FigureRds;
   {
     chain_list *SignalChain;
     chain_list *ScanChain;
     chain_list *NameChain;

     lofig_list *LogicalModel;
     loins_list *LogicalInstance;
     rds_ins    *PhysicalInstance;

     rds_rec    *Rectangle;
     char       *RectangleName;

     char        Layer;
     boolean     BuildModel;
     long        Counter;

     Counter = 0;

     for ( PhysicalInstance  = FigureRds->instance;
           PhysicalInstance != (rds_ins *)NULL;
           PhysicalInstance  = PhysicalInstance->next )
     {
       SignalChain  = (chain_list *)NULL;
       NameChain    = (chain_list *)NULL;
       LogicalModel = (lofig_list *)NULL;

       if ( ! ( BuildModel = ( HeadLogicalModel == (lofig_list *)NULL )))
       {
         LogicalModel = getlomodel
         (  
           HeadLogicalModel, 
           PhysicalInstance->mod_name 
         );

         BuildModel = ( LogicalModel == (lofig_list *)NULL);
       }

       if ( BuildModel )
       {
         LogicalModel = HeadLogicalModel = addlomodel 
         (  
           HeadLogicalModel, 
           PhysicalInstance->mod_name 
         );
       }
      
       for ( Layer = RDS_NWELL; 
             Layer < MAX_FENCE_LAYER;
             Layer++ )
       {
         if ( ! FenceLayerEnable[ Layer ] ) continue;

         for ( Rectangle  = PhysicalInstance->layertab[ Layer ];
               Rectangle != (rds_rec *)NULL;
               Rectangle  = Rectangle->next )
         {
           if (( Rectangle->extract_type != RDS_CON_INTER ) && 
               ( Rectangle->extract_type != RDS_REF_CON   ))

              continue; 

           RectangleName = Rectangle->u_rec.name;

           for ( ScanChain  = NameChain;
                 ScanChain != (chain_list *)NULL;
                 ScanChain  = ScanChain->NEXT )

               if ( (char *)ScanChain->DATA  == RectangleName ) break;

           if ( ScanChain == (chain_list *)NULL )
           {
             NameChain = addchain
             ( 
               NameChain, 
               RectangleName
             );

             if ( BuildModel )
             {
               addlocon
               ( 
                 LogicalModel, 
                 RectangleName, 
                 (losig_list *)NULL,
                  UNKNOWN
               );
             }

             SignalChain = addchain
             ( 
               SignalChain, 
               Rectangle->user 
             );
           }
         }
       }

       Counter         = Counter + 1;
       LogicalInstance = addloins
       (
         HeadLogicalFigure,
         PhysicalInstance->ins_name,
         LogicalModel,
         SignalChain
       );

       freechain( NameChain );
    }
    return( Counter );
  }

/*-----------------------------------------------------*\
|         Construction des transistors logiques         |
\*-----------------------------------------------------*/
 
  long BuildLogicalTransistor( FigureRds )

       rds_fig *FigureRds;
  {
    rds_rec *Grid;
    rds_rec *Source;
    rds_rec *Drain;

    long     Width;
    long     Length;
    long     Counter;

    Counter = 0;

    for ( Grid  = FigureRds->layertab[ RDS_GATE ];
          Grid != (rds_rec *)NULL;
          Grid  = Grid->next )
    {
      if ( Grid->extract_type == RDS_SEG_GRILLE )
      {
        Source = Grid  ->u_rec.link;
        Drain  = Source->u_rec.link;

        if ( Source->y == Drain->y )
        {
          Width  = Source->dy;
          Length = Grid  ->dx;
        }
        else
        {
          Width  = Source->dx;
          Length = Grid  ->dy;
        }

        Counter++;

        addlotrs
        ( 
          HeadLogicalFigure,
          ( Drain->layer == RDS_NDIF ) ? TRANSN : TRANSP,
          Grid->x + ( Grid->dx >> 1),
          Grid->y + ( Grid->dy >> 1),
          Width,
          Length,
          ( Source->dx << 1) + ( Source->dy << 1),
          ( Drain->dx  << 1) + ( Drain->dy  << 1),
          (( Source->dx * Source->dy ) / Width ),
          (( Drain->dx  * Drain->dy  ) / Width ),
          (losig_list *)Grid->user,
          (losig_list *)Source->user,
          (losig_list *)Drain->user
        );
      }
    }
    return( Counter );
  }

  void VectorizeConnectors( Figure )

       lofig_list *Figure;

  {
    loins_list *Instance;

    sortlocon( &Figure->LOCON );

    for ( Instance  = Figure->LOINS;
          Instance != (loins_list *)NULL;
          Instance  = Instance->NEXT )
    {
      sortlocon( &Instance->LOCON );
    }
  }
