/*-----------------------------------------------------*\
|                                                       |
|  Title   :     Extract Tools Box for Lynx             |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :         Jacomme ludovic                    |
|                                                       |
\*-----------------------------------------------------*/

/*-----------------------------------------------------*\
|                Les fichiers a inclure                 |
\*-----------------------------------------------------*/

#  include MUT_H
#  include MLO_H
#  include MPH_H
#  include RDS_H
#  include MBKRDS_H
#  include EXTRACT_H

#  include <stdio.h>

/*-----------------------------------------------------*\
|                 Les variables globales                |
\*-----------------------------------------------------*/

#  include "graphlayer.h"
#  include "transistor.h"  

  rds_rec    *HeadChainEqui = (rds_rec    *)NULL;

/*-----------------------------------------------------*\
|                   Dump Transistor                     |
\*-----------------------------------------------------*/

  void DumpTransistor( Contact, Gate )

       rds_rec    *Contact;
       chain_list *Gate;
  {
    chain_list *ScanGate;
    phfig_list *FigureMbk;

    FigureMbk = addphfig( "core_cx" ); 

    RectangleRdsMbk( FigureMbk, NULL, Contact );

    for ( ScanGate  = Gate;
          ScanGate != (chain_list *)NULL;
          ScanGate  = ScanGate->NEXT )
    {
       RectangleRdsMbk( FigureMbk, NULL, (rds_rec *)( ScanGate->DATA ));
    }

    savephfig( FigureMbk );
  }

/*-----------------------------------------------------*\
|               Cut Transistor Elbow                    |
\*-----------------------------------------------------*/

  long CutTransistorElbow( FigureRds, Core )

       rds_fig *FigureRds;
       char     Core;
  {
    long        CXCounter;

    long        X;
    long        Y;

    long        X1;
    long        X2;
    long        Y1;
    long        Y2;

    rds_rec    *Rectangle;
    rds_rec    *ScanGate;
    rds_rec    *Diffusion;
    rds_rec    *FirstDiff;

    chain_list *ScanFence;
    chain_list *ScanIndex;
    chain_list *HeadGate;

    char        Flag;
    char        Error;
    char        Index;

    CXCounter = 0;

    for ( Rectangle  = FigureRds->layertab[ RDS_GATE ];
          Rectangle != (rds_rec *)NULL;
          Rectangle  = Rectangle->next )
    {
      if ( Rectangle->mbk_type == MBK_VIA )
      {
        CXCounter++;

        X1 = Rectangle->x;
        X2 = Rectangle->dx + X1;
        Y1 = Rectangle->y;
        Y2 = Rectangle->dy + Y1;
        X = X1 + ( Rectangle->dx >> 1 );
        Y = Y1 + ( Rectangle->dy >> 1 );

        Error   = 0;
        Flag    = 0;

        HeadGate = (chain_list *)NULL;
   
        for ( ScanFence   =  (chain_list *)(Rectangle->user);
              ( ScanFence != (chain_list *)NULL ) &&
              ( Error     == 0                  );
              ScanFence   = ScanFence->NEXT )
        {
          for ( ScanIndex   =  (( FenceList *)ScanFence->DATA)->LayerTable[ RDS_GATE ];
                ( ScanIndex != ( chain_list *)NULL ) && 
                ( Error     == 0                   );
                ScanIndex   = ScanIndex->NEXT )
          {
            ScanGate = (rds_rec *)(ScanIndex->DATA);

            if ( ( ScanGate->mbk_type == MBK_SEGMENT ) && 
                 ( IsExtractNone( ScanGate->flags )  ) )
            {
              if ( ( ScanGate->x                    <= X2 ) &&
                   ( ScanGate->y                    <= Y2 ) &&
                   ( ( ScanGate->x + ScanGate->dx ) >= X1 ) &&
                   ( ( ScanGate->y + ScanGate->dy ) >= Y1 ) )
              {
                SetExtractTag( ScanGate->flags );

                HeadGate = addchain( HeadGate, ScanGate );

                if ( ScanGate->y == Y )                     /* Up  bit 0 */
                { 
                  Error  = Flag & 1;
                  Flag  |= 1;
                }
                else

                if ( ( ScanGate->y + ScanGate->dy ) == Y )  /* Down  bit 1 */
                { 
                  Error  = Flag & 2;
                  Flag  |= 2;
                }
                else

                if ( ( ScanGate->x + ScanGate->dx ) == X )  /* Left  bit 2 */
                { 
                  Error  = Flag & 4;
                  Flag  |= 4;
                }
                else

                if ( ScanGate->x == X )                     /* Right  bit 3 */
                { 
                  Error  = Flag & 8;
                  Flag  |= 8;
                }
                else Error = 1;
              } 
            }
          }
        }

        if ( ( Error == 0  ) && 
             ( CUT_TRANSISTOR_ELBOW[ Flag ] [ 0 ] [ 0 ] != (char)255 ) )
        {
          for ( ScanIndex  = HeadGate;
                ScanIndex != (chain_list *)NULL;
                ScanIndex  = ScanIndex->NEXT )
          {
            ScanGate = (rds_rec *)(ScanIndex->DATA);

            SetExtractNone( ScanGate->flags );
          }

          freechain( HeadGate );

          FirstDiff = Rectangle->u_rec.link;

          X1 = FirstDiff->x;
          Y1 = FirstDiff->y;

          FirstDiff->x  += CUT_TRANSISTOR_ELBOW[ Flag ] [ 0 ] [ 0 ];
          FirstDiff->y  += CUT_TRANSISTOR_ELBOW[ Flag ] [ 0 ] [ 1 ];
          FirstDiff->dx  = CUT_TRANSISTOR_ELBOW[ Flag ] [ 0 ] [ 2 ];
          FirstDiff->dy  = CUT_TRANSISTOR_ELBOW[ Flag ] [ 0 ] [ 3 ];

          for ( Index = 1;
                Index < 4;
                Index++ )
          {
            if ( CUT_TRANSISTOR_ELBOW[ Flag ] [ Index ] [ 0 ] == (char)255 ) 

              break;

            Diffusion = AddRectangleFigRds( FigureRds, NULL, 
                                            X1 + CUT_TRANSISTOR_ELBOW[ Flag ] [ Index ] [ 0 ],
                                            Y1 + CUT_TRANSISTOR_ELBOW[ Flag ] [ Index ] [ 1 ],
                                            CUT_TRANSISTOR_ELBOW[ Flag ] [ Index ] [ 2 ],
                                            CUT_TRANSISTOR_ELBOW[ Flag ] [ Index ] [ 3 ],
                                            FirstDiff->layer,
                                            MBK_VIA, RDS_NONE, NULL 
                                          );

            for ( ScanFence  = (chain_list *)(FirstDiff->user);
                  ScanFence != (chain_list *)NULL;
                  ScanFence  = ScanFence->NEXT )
            {
              LinkFenceRectangle( (FenceList *)(ScanFence->DATA), Diffusion );
            }
          }
        }
        else
        {
           if ( Core  ) DumpTransistor( Rectangle->u_rec.link, HeadGate );

           return( -1 );
        }
      }
    }

    return( CXCounter );
  }

/*-----------------------------------------------------*\
|                   Chainage des Equis                  |
\*-----------------------------------------------------*/

  long ChainEqui()

  {
    FenceList *Fence;

    chain_list *ScanFence;
    chain_list *ScanIndex;
    chain_list *Index;

    rds_rec   *Rectangle;
    rds_rec   *ScanRectangle;
    rds_rec  **Previous;

    char       ScanLayer;
    char       Layer;
    char       Counter;

    long       X1;
    long       X2;
    long       Y1;
    long       Y2;
    long       CounterChain;

    HeadChainEqui = (rds_rec *)NULL;
    Previous      = &HeadChainEqui;
    CounterChain  = 0;

    for ( Fence  = HeadFence; 
          Fence != (FenceList *)NULL;
          Fence  = Fence->Next )
    {
      for ( Layer = RDS_NDIF; 
            Layer < MAX_FENCE_LAYER;
            Layer++ )
      {
        for ( Index  = Fence->LayerTable[ Layer ]; 
              Index != (chain_list *)NULL;
              Index  = Index->NEXT )
        {
          Rectangle = (rds_rec *)( Index->DATA );

          if ( IsExtractNone( Rectangle->flags ))
          {
            SetExtractTag( Rectangle->flags );

           *Previous = Rectangle;
            Previous = &(Rectangle->equi);

            X1 = Rectangle->x;
            Y1 = Rectangle->y;
            X2 = X1 + Rectangle->dx;
            Y2 = Y1 + Rectangle->dy;

            for ( ScanFence  = (chain_list *)(Rectangle->user);
                  ScanFence != (chain_list *)NULL;
                  ScanFence  = ScanFence->NEXT )
            {
              for ( Counter = 0;
                    Counter < MAX_GRAPH_LAYER;
                    Counter++ )
              {
                ScanLayer = GraphLayer[ Layer ][ Counter ];

                for ( ScanIndex  = (( FenceList *)ScanFence->DATA)->LayerTable[ ScanLayer ];
                      ScanIndex != ( chain_list *)NULL;
                      ScanIndex  = ScanIndex->NEXT )
                {
                  ScanRectangle = (rds_rec *)( ScanIndex->DATA );

                  if (( IsExtractNone( ScanRectangle->flags )          ) &&
                      ( ScanRectangle->x                         <= X2 ) &&
                      ( ScanRectangle->y                         <= Y2 ) &&
                      ( ( ScanRectangle->x + ScanRectangle->dx ) >= X1 ) &&
                      ( ( ScanRectangle->y + ScanRectangle->dy ) >= Y1 ) )
                  {
                    SetExtractTag( ScanRectangle->flags );
                   *Previous = ScanRectangle;
                    Previous = &(ScanRectangle->equi);
                  }
                }
                if ( ScanLayer == Layer ) break;
              }
            }

            while ( Rectangle->equi != (rds_rec *)NULL )
            {
              Rectangle = Rectangle->equi;

              X1 = Rectangle->x;
              Y1 = Rectangle->y;
              X2 = X1 + Rectangle->dx;
              Y2 = Y1 + Rectangle->dy;

              for ( ScanFence  = (chain_list *)(Rectangle->user);
                    ScanFence != (chain_list *)NULL;
                    ScanFence  = ScanFence->NEXT )
              {
                for ( Counter = 0;
                      Counter < MAX_GRAPH_LAYER;
                      Counter++ )
                {
                  ScanLayer = GraphLayer[ Rectangle->layer ][ Counter ];

                  for ( ScanIndex  = (( FenceList *) ScanFence->DATA )->LayerTable[ ScanLayer ];
                        ScanIndex != (chain_list *)NULL;
                        ScanIndex  = ScanIndex->NEXT )
                  {
                    ScanRectangle = (rds_rec *)( ScanIndex->DATA );

                    if (( IsExtractNone( ScanRectangle->flags )          ) &&
                        ( ScanRectangle->x                         <= X2 ) &&
                        ( ScanRectangle->y                         <= Y2 ) &&
                        ( ( ScanRectangle->x + ScanRectangle->dx ) >= X1 ) &&
                        ( ( ScanRectangle->y + ScanRectangle->dy ) >= Y1 ) )
                    {
                      SetExtractTag( ScanRectangle->flags );
                     *Previous = ScanRectangle;
                      Previous = &(ScanRectangle->equi);
                    }
                  }

                  if ( ScanLayer == Rectangle->layer ) break;
                }
              }
            }

            SetExtractEnd( Rectangle->flags ); 
            CounterChain++;
          }
        }
      }
    } 

    return ( CounterChain );
  }

/*-----------------------------------------------------*\
|                Verification chainage equis            |
\*-----------------------------------------------------*/

  void Verify()

  {
    rds_rec *FirstEqui;
    rds_rec *Equi;
    long     Counter;

    Counter = 0;

    for ( FirstEqui = Equi  = HeadChainEqui;
          Equi != (rds_rec *)NULL;
          Equi  = Equi->equi )
    {
      Counter++;

      if  ( *(rds_rec **)(((chain_list *) Equi ->user )->DATA) != FirstEqui )
      {
        printf("\nVerify Error %d", Counter );
        exit ( ERROR );
      }

      if ( IsExtractEnd( Equi->flags ))
      {
        FirstEqui = Equi->equi;
      }
    }
    printf("\nVerify Ok %d", Counter );
  }

/*-----------------------------------------------------*\
|                Fusion de deux Equis                   |
\*-----------------------------------------------------*/

 void ComputeFusionEqui( First, Second )
     
      rds_rec *First;
      rds_rec *Second;
 {
   rds_rec  *BeginFirst;
   rds_rec  *EndFirst;
   rds_rec **PreviousFirst;

   rds_rec  *BeginSecond;
   rds_rec  *EndSecond;
   rds_rec **PreviousSecond;

   rds_rec  *SwapEqui;

   PreviousFirst  =  (rds_rec **)(((chain_list *) First ->user )->DATA);
   BeginFirst     = *PreviousFirst;
   PreviousSecond =  (rds_rec **)(((chain_list *) Second->user )->DATA);
   BeginSecond    = *PreviousSecond;

   if ( BeginFirst == BeginSecond ) return;

   for ( EndFirst = First;
         ! IsExtractEnd( EndFirst->flags );
         EndFirst = EndFirst->equi );

   for ( EndSecond = BeginSecond;
         ! IsExtractEnd( EndSecond->flags );
         EndSecond = EndSecond->equi )
   {
     EndSecond->user = First->user;
   }

   EndSecond->user = First->user;

   if ( EndFirst->equi == BeginSecond )
   {
     SetExtractTag( EndFirst->flags );

     return;
   }

   if ( EndSecond->equi == BeginFirst )
   {
     SetExtractTag( EndSecond->flags );

     ((chain_list *)First->user)->DATA = (void *)PreviousSecond;

     return;
   }

   SetExtractTag( EndFirst->flags );

   SwapEqui        = EndSecond->equi;
   EndSecond->equi = EndFirst ->equi;
  *PreviousSecond  = SwapEqui;

   if ( SwapEqui != (rds_rec *)NULL ) 

     ((chain_list *) SwapEqui->user )->DATA = (void *)PreviousSecond;

   SwapEqui        = EndFirst->equi;
   EndFirst ->equi = BeginSecond;

   if ( SwapEqui != (rds_rec *)NULL ) 

     ((chain_list *) SwapEqui->user )->DATA = (void *)&( EndSecond->equi );
 }

/*-----------------------------------------------------*\
|                    Fusion des Equis                   |
\*-----------------------------------------------------*/

   long FusionEqui( FigureRds )

        rds_fig *FigureRds;
   { 
     rds_rec    *Rectangle;
     rds_rec    *ScanRectangle;
     rds_ins    *Instance;

     chain_list *HeadFirstEqui;

     char        Layer;
     char        ScanLayer;
     long        Counter;

     Counter       = 0;
     HeadFirstEqui = addchain
     (
       ( chain_list *)NULL,
       ( void       *)&HeadChainEqui
     );

     for ( Rectangle  = HeadChainEqui; 
           Rectangle != (rds_rec *)NULL;
           Rectangle  = Rectangle->equi )
     {
       Rectangle->user = (void *)HeadFirstEqui;

       if ( IsExtractEnd( Rectangle->flags ) )
       {
         HeadFirstEqui = addchain
         (
           HeadFirstEqui,
           ( void *)&(Rectangle->equi)
         );
       }
     }

     for ( Instance  = FigureRds->instance; 
           Instance != (rds_ins *)NULL;
           Instance  = Instance->next )
     {
       for ( Layer = RDS_NDIF; 
             Layer < MAX_FENCE_LAYER;
             Layer++ )
       {
         if ( ! FenceLayerEnable[ Layer ] ) continue;

         for ( Rectangle  = Instance->layertab[ Layer ];
               Rectangle != (rds_rec *)NULL;
               Rectangle  = Rectangle->next )
         {
           if (( Rectangle->mbk_type != MBK_CONNECTOR ) &&
               ( Rectangle->mbk_type != MBK_REFERENCE ))

                continue;

           for ( ScanRectangle  = Rectangle->next;
                 ScanRectangle != (rds_rec *)NULL;
                 ScanRectangle  = ScanRectangle->next )
           {
             if ((( ScanRectangle->mbk_type == MBK_CONNECTOR ) ||
                  ( ScanRectangle->mbk_type == MBK_REFERENCE )) &&
                  ( ScanRectangle->u_rec.name == Rectangle->u_rec.name ))
             {
                Counter++;
                ComputeFusionEqui( ScanRectangle, Rectangle );
             }
           }
                
           for ( ScanLayer = Layer + 1; 
                 ScanLayer < MAX_FENCE_LAYER;
                 ScanLayer++ )
           {
             if ( ! FenceLayerEnable[ ScanLayer ] ) continue;

             for ( ScanRectangle  = Instance->layertab[ ScanLayer ];
                   ScanRectangle != (rds_rec *)NULL;
                   ScanRectangle  = ScanRectangle->next )
             {
               if ((( ScanRectangle->mbk_type == MBK_CONNECTOR ) ||
                    ( ScanRectangle->mbk_type == MBK_REFERENCE )) &&
                    ( ScanRectangle->u_rec.name == Rectangle->u_rec.name ))
               {
                 Counter++;
                 ComputeFusionEqui( ScanRectangle, Rectangle );
               }
             }
           } 
         }
       }
     }

     freechain( HeadFirstEqui );
     return( Counter );
   }

/*-----------------------------------------------------*\
|             Visualisation d'une chaine d'equi         |
\*-----------------------------------------------------*/

  long ViewChainEqui( Rectangle )

       rds_rec *Rectangle;
  {
    long     Counter;

    for ( Counter    = 0; 
          Rectangle != (rds_rec *)NULL; 
          Rectangle  = Rectangle->equi,
          Counter++ )

      ViewRectangleRds( Rectangle );

    return( Counter );
  }
