/*************************************************/
/*  nom          : hash.h                        */
/*  auteurs      : renaud & venot                */
/*  date         : 03/03/92                      */
/*************************************************/

/*------------------------------------------------------------*
 *      CONSTANTES DE LA LIBRAIRIE                            *
 *------------------------------------------------------------*/
#define GNP_HASHSIZE  13
/*------------------------------------------------------------*
 *      TYPES DE LA LIBRAIRIE                                 *
 *------------------------------------------------------------*/
typedef struct _elt
                  {
                    char *name;
                    int  num_index;
                    int  sens;  /* definit l'ordre de declaration des poids
                                                  des elements d'un vecteur */
                    struct _elt *next;
                  }elt;
/*------------------------------------------------------------*
 *      TABLES DE HACHAGE                                     *
 *------------------------------------------------------------*/
extern elt    *hash_paiol[GNP_HASHSIZE];
extern elt    *hash_pagrp[GNP_HASHSIZE];
extern elt    *hash_ident[GNP_HASHSIZE];
/*------------------------------------------------------------*
 *      FONCTIONS DE LA LIBRAIRIE                             *
 *------------------------------------------------------------*/
extern void  InitHash    ();
extern elt*  ExisteIdent ();
extern elt*  SymbAlloc   ();
extern char* LocalAlloc  ();
extern int   FindIdent   ();
extern int   FindLocal   ();
extern void  Freehash    ();
extern int   Hash        ();


