%{

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <pat103.h>
#include "y.tab.h"
#include"mem.h"
#include"hash.h"
#include"libpat_l.h"
#undef yywrap
%}

delim       [ \t\n]
blanc       {delim}+
extension   [BXIORSTbxiorst]
lettre      [A-Za-z]
ident       {lettre}({dec}*|{lettre}*|[_]*)*
ident_t     {lettre}({dec}*|{lettre}*|[_]*|[.]*)*
binaire     \??0[bB]{bin}+
bin         [01*]
octal       \??0[oO]?{oct}+
oct         [0-7*]
decimal     {dec}+
dec         [0-9]
hexa        \??0[xX]{hex}+
hex         [0-9a-fA-F*]

%S ccom
%S ylab
%%
[/][*]           {BEGIN ccom;if (verbose) ECHO;}
<ccom>[^/]                  {if (verbose) ECHO;}
[*][/]            {BEGIN INITIAL;if (verbose) ECHO;}


{blanc}                     {if (verbose) ECHO;}
"#include"[^\n]*[\n]        {if (verbose) ECHO;}
<ylab>[(]                   {if (verbose) ECHO;                         return (*yytext);}
<ylab>[\"]                  {if (verbose) ECHO;                         return (*yytext);}
<ylab>[^\"(]*    {BEGIN INITIAL; if (verbose) ECHO; yylval.chaine = LocalAlloc(yytext,hash_ident);
                                                           return (AUTRE);}
<INITIAL>"#define"              {if (verbose) ECHO;                         return (DEFINE);}
<INITIAL>"PORT"                 {if (verbose) ECHO;                         return (PORT);}
<INITIAL>"SIGNAL"               {if (verbose) ECHO;                         return (SIGNAL);}
<INITIAL>"REGISTER"             {if (verbose) ECHO;                         return (REGISTRE);}
<INITIAL>"ARRAY"                {if (verbose) ECHO;                         return (ARRAY);}
<INITIAL>"LABEL"    {BEGIN ylab; if (verbose) ECHO;                         return (LABEL);}
<INITIAL>"COMMENT"  {BEGIN ylab; if (verbose) ECHO;                         return (COMMENT);}
<INITIAL>"ACTION"               {if (verbose) ECHO;                         return (ACTION);}
<INITIAL>"AFFECT"               {if (verbose) ECHO;                         return (AFFECT);}
<INITIAL>"for"                  {if (verbose) ECHO;                         return (FOR);}
<INITIAL>"INIT"                 {if (verbose) ECHO;                         return (INIT);}
<INITIAL>"CONV"                 {if (verbose) ECHO;                         return (CONV);}
<INITIAL>"CONVCMP"              {if (verbose) ECHO;                         return (CONVCMP);}
<INITIAL>"to"|"TO"              {if (verbose) ECHO;                         return (TO);}
<INITIAL>"downto"|"DOWNTO"      {if (verbose) ECHO;                         return (DOWNTO);}
<INITIAL>"main"|"MAIN"          {if (verbose) ECHO;                         return (MAIN);}
<INITIAL>"void"                 {if (verbose) ECHO;                         return (VOID);}
<INITIAL>"int"                  {if (verbose) ECHO;                         return (INT);}
<INITIAL>"DEF_GENPAT"           {if (verbose) ECHO;                         return (DEFPAT);}
<INITIAL>"SAV_GENPAT"           {if (verbose) ECHO;                         return (SAVPAT);}
<INITIAL>"<="                   {if (verbose) ECHO;                         return (TINFEQ);}
<INITIAL>">="                   {if (verbose) ECHO;                         return (TSUPEQ);}
<INITIAL>"||"                   {if (verbose) ECHO;                         return (TORL);}
<INITIAL>"&&"                   {if (verbose) ECHO;                         return (TANDL);}
<INITIAL>"=="                   {if (verbose) ECHO;                         return (TEQUAL);}
<INITIAL>"!="                   {if (verbose) ECHO;                         return (TDIFF);}
<INITIAL>"!="                   {if (verbose) ECHO;                         return (TDIFF);}
<INITIAL>"<<"                   {if (verbose) ECHO;                         return (LSL);}
<INITIAL>">>"                   {if (verbose) ECHO;                         return (LSR);}
<INITIAL>{extension}            {if (verbose) ECHO; yylval.chaine = LocalAlloc(yytext,hash_ident);
                                                           return (EXTENSION);}
<INITIAL>{ident}                {if (verbose) ECHO; yylval.chaine = LocalAlloc(yytext,hash_ident);
                                                           return (IDENT);}
<INITIAL>{ident_t}              {if (verbose) ECHO; yylval.chaine = LocalAlloc(yytext,hash_ident);
                                                           return (IDENT_T);}
<INITIAL>{binaire}              {if (verbose) ECHO; yylval.chaine = LocalAlloc(yytext,hash_ident);
                                                           return (BINAIRE);}
<INITIAL>{octal}                {if (verbose) ECHO; yylval.chaine = LocalAlloc(yytext,hash_ident);
                                                           return (OCTAL);}
<INITIAL>{decimal}              {if (verbose) ECHO; sscanf(yytext,"%lu",&yylval.val);
                                                           return (DECIMAL);}
<INITIAL>{hexa}                 {if (verbose) ECHO; yylval.chaine = LocalAlloc(yytext,hash_ident);

                                                           return (HEXA);}

<INITIAL>.                      {if (verbose) ECHO;                         return (*yytext);}
%%
int yywrap()
{
  return(1) ;
}


