/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : foconf.c                                                    */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "ariel.h"


foconf_list *HEAD_FOCONF=NULL;
befig_list * VHB_HEDFIG = NULL ;

short total_conf=0, no_conf=0, total_hz=0, no_hz=0;
short profondeur=0; short index_bdd = 0 ;
short fausse_b=0;
short passe=0;
FILE *res=NULL;
long MaxNoeud =0;

pCircuit badnode;
char FCF_LANG ;

/*****************************************************************************
*                            function fxConfHz()                             *
*****************************************************************************/
/*---------------------------------------------------------------------------+
| Refute les faux conflits et les faux tristate d'une figure desb            |
| Entree : FIG, la pour laquelle on veut evaluer les conflits et les etats   |
|          tri-state.                                                        |
|          CONEiNDEX. Si cette valeur est non nulle, alors un fichier vhdl   |
|          du cone de logique du cone d'index coneIndex est genere           |
|          TRACE. Si cette valeur est non nulle, un message accompagne le    |
|          traitement de chaque nouveau cone                                 |
| Sortie : Neant.                                                            |
+---------------------------------------------------------------------------*/ 
void fxConfHz( fig, coneIndex,trace,prof,lang )
desafig_list * fig ;
int coneIndex ;
short trace ;
int prof ;
char lang ;
{
char  RES_FILE[200]; 
char  VCX_FILE[200];
char  FILENAME[200];
int total_fb=0;
long Tstart=0, Tend=0;
foconf_list *fc;
cone_list  *dirty_cone, *ptr;

char *libfcfVersion=namealloc("@(#)libfcf version 1.63 du 17 06 92 ");

PROF_MAX = prof;
FCF_LANG = lang ;

(void)strcpy(FILENAME,fig->NAME) ;


/* Ouverture du fichier de diagnostique 
res = mbkfopen(FILENAME,"fcf",WRITE_TEXT); 
(void)fprintf(res,"FOCONF\t%s/%s\n\n",*CATA_LIB,fig->NAME);*/

(void)time(&Tstart);

/*--------------------------------+
 | Initialisation des contrainte  |
 *-------------------------------*/                 
{  
   InitContrainte();
}


/*------------------------------------------------*
 | Initialisation du champs USER ABL_UP des cones |
 *------------------------------------------------*
{
cone_list * cone;
   for(cone=fig->CONE;cone!=NULL;cone=cone->NEXT)
      if(getptype(cone->USER,ABL_UP)!=NULL) cone->USER=delptype(cone->USER,ABL_UP);
}

/*--------------*
 |   myfunc     |
 *--------------*/
   do 
   {  
   befig_list * bfig = NULL;
   passe++;
   total_fb=0;
   total_conf=0;
   no_conf=0;
   total_hz=0;
   no_hz=0; 
      
      if(((fig->CONE->TYPE)&(CONFLICT | HZ))!=0)
      dirty_cone=fig->CONE ;
      else dirty_cone=next_conflit(fig->CONE);

      for (ptr=dirty_cone; ptr; ptr=next_conflit(ptr)) 
      {
      short jePasse = 0 ;
      short signChanged = 0;
      ptype_list * user;
      FCF_X_CONTR = 0 ;
      FCF_PRIM_INDEX = NULL ;
      fausse_b=0;


         if(trace !=0)
         {
         printf("\n--- Foconf sur (%d)%s ---\n",ptr->INDEX,ptr->NAME);
         fflush(stdout);
         }

         /*--------------------------------------------+
         | Si le cone n'a pas de branche fonctionnelle |
         | On passe au suivant                         |
         +--------------------------------------------*/
         if(fcfPathInCone(ptr)==-1) continue ;

      /* ----------- TEST ---------------------------
      user=getptype(ptr->USER,FCF_SIGN);
         if(user != NULL)
         {
            if((char*)user->DATA !=NULL)
            printf("Avant: %s\n",(char*)user->DATA);
            else printf("Avant: SigCone->(Null)\n");
         }
         else printf("Avant: SigCone->Neant\n");
      fflush(stdout);
      -------------- TEST -------------------------*/

      /*------------------------------------+
      | Creation de la befig et des Abl/Bdd |
      +------------------------------------*/
      bfig=makeBefigFromCone(ptr,coneIndex,trace,&signChanged);         

         /*---------------------------------+
         |Affichage de la signature du cone |
         +---------------------------------*/
      /* -----------DEBUT TEST ---------------------------
         if(trace !=0)
         {
         ptype_list * user;  
         char * sign ;
         user=getptype(ptr->USER,FCF_SIGN);
            if(user!=NULL)
            {
            sign=(char*)user->DATA;
               if(sign!=NULL)
               printf("Apres: %s\n",sign);
               else
               printf("Apres: SigCone->(NULL)\n");
            fflush(stdout);
            }
         }
      -------------- FIN TEST -------------------------*/

         /*------------------------------------+
         | La signature est identique  a celle | 
         | calcule a l'iteration precedente    |
         +------------------------------------*/
         if(signChanged == 0)
         {
         jePasse=1;

            if(trace!=0)
            {
            printf("Je passe ce cone. Signature Identique\n");
            fflush(stdout);
            }
         }

         if((trace != 0)&&(jePasse==0))
         {
         printf("Apres MakeBefig: Bdd Node = %d\n",numberNodeAllBdd());
         fflush(stdout);
         }

         if(numberNodeAllBdd()>=MAX_NODE)
         {
         jePasse =1 ;
            if(FCF_LANG == 'F')
            fprintf(stderr,"[WAR] %d noeuds Bdd :je passe le cone (%d)%s\n",numberNodeAllBdd(),ptr->INDEX,ptr->NAME);
            else if (FCF_LANG == 'E')
            fprintf(stderr,"[WAR] %d Bdd nodes : Skipping the cone (%d)%s\n",numberNodeAllBdd(),ptr->INDEX,ptr->NAME);
         fflush(stdout);
         }

         /*----------------------*
         | Refutation de conflit |
         +----------------------*/
         if (((ptr->TYPE & CONFLICT) == CONFLICT)) 
         {
         short test = 0;
         total_conf++;

            if((trace != 0)&&(jePasse==0))
            {
            printf("Refutation de conflits\n");
            fflush(stdout);
            }

            if(jePasse == 0) test=fcfConflit(bfig,ptr); 
            
            if(test != 0)
            {
            jePasse=1;
            printf("je passe Cf() et Hz()\n");
            fflush(stdout);
            }
         }

         /*--------------------------*
         | Refutation de three-state |
         +--------------------------*/
         if ((ptr->TYPE & HZ) == HZ) 
         {
         short test=0;
         total_hz++;

            if((trace != 0)&&(jePasse == 0))
            {
            printf("Refutation de tri-state \n");
            fflush(stdout);
            }

            if(jePasse == 0) test=fcfHz(bfig,ptr);

            if(test !=0)
            {
            printf("Je passe Hz()\n");
            fflush(stdout);
            }
         }

      MaxNoeud=(MaxNoeud<sysBdd.pRT->compteur?sysBdd.pRT->compteur:MaxNoeud);


      total_fb +=fausse_b;

         if (fausse_b >0) marq_incone(ptr);

         if (signChanged != 0) resetCct(bfig->CIRCUI);

         if(FCF_X_CONTR !=0)
         freetag();

         if(FCF_PRIM_INDEX != NULL)
         freechain(FCF_PRIM_INDEX);

      CleanPath(ptr);
      CleanAllCone();
      CleanAllConect();
      resetBdd();

      VHB_HEDFIG=beh_delbefig(VHB_HEDFIG,bfig,'Y');
      }

   /*-------------------------------------------------------------------
   (void)fprintf(res,"(Passe %d\n",passe);
   (void)fprintf(res," Fausses branches : %d\n",total_fb);
   (void)fprintf(res," Total conflits : %d Faux conflits : %d Total hz : %d Faux hz : %d)\n",total_conf,no_conf,total_hz,no_hz);
   (void)fflush(res);
   *--------------------------------------------------------------------*/

   } while ((total_fb != 0) || (no_conf != 0) || (no_hz != 0));  

(void)time(&Tend);


   {
   cone_list * cone;
      for(cone=fig->CONE;cone != NULL ; cone=cone->NEXT)
      {
      rmvBleedPath(cone);
      rmvLoopIn(cone);
      rmvLoopOut(cone);
      }
   }
   
   /*-------------------------------------------------------------------
(void)fprintf(res,"\nFOCONF TIME :  %02d:%02d\n",(Tend - Tstart)/60, (Tend - Tstart)%60);
fprintf(res,"Nombre de Noeud Maximun cree par les Bdd : %ld\n",MaxNoeud);
(void)fclose(res);
   *--------------------------------------------------------------------*/

}

