/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : genexpr.c                                                   */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

                     /*------------------------------------*
                      |  Generation VHDL "bas-niveau"      |
                      *------------------------------------*/  

#include "head.h"

static int LABEL_INDEX = 0 ;

static short pathIsResist();

/****************************************************************************
 *                         fonction dualexpr();                             *
 ****************************************************************************/

    /*-----------------------------------------------------------*
     |  Renvoie une chaine de caracteres contenant l'expression  |
     |  VhDl d'un cone  ~HZ                                      |
     *-----------------------------------------------------------*/

char * dualexpr(cone)
cone_list * cone;
{
short flagup = 0;
short flagex = 0;
short flagdw = 0;
short pathVss = 0 ;
list_list * path;
int i=1;
int maxLength = 4000 ;
char * res ;



char * expr=(char*)malloc(5000);

strcpy(expr,(char*)cone->NAME);

strcat(expr," <= ");
   for(path=cone->PATH;path != NULL;path=path->NEXT)
   {
      if(((path->TYPE)&BLEEDER) ==BLEEDER) continue;   

      if(((path->TYPE)&VSS )== VSS) 
      {
      pathVss = 1;
      continue;
      }

      if(((path->TYPE)&VDD)==VDD)
      {
      flagup=1;
      strcat(expr,genprod(path));
      strcat(expr," or ");
      }
      if(((path->TYPE)&EXT)==EXT)
      {
         if(((link_list*)path->DATA)->NEXT!=NULL)
         {
         flagex=1;
         strcat(expr,genexprod(path));
         strcat(expr," or ");
         }
      }

      if(strlen(expr) > maxLength)
      {
      expr=(char*)realloc(expr,((5000)+(i*1000)));
         if(expr==NULL)
         {
         d2vFatalError(4,NULL,NULL,NULL,0);
         }
      i++ ;
      maxLength+=1000 ;
      }
   }

   if (((flagup+flagex)==0) && (pathVss!=0))
   {
   strcat(expr,"not(");
      for (path=cone->PATH;path != NULL; path=path->NEXT)
      {
         if  ((path->TYPE & (VSS|BLEEDER))==VSS)
         {
         flagdw =1 ;
         strcat(expr,genprod(path));
         strcat(expr," or ");
         }
         else continue ;
      }
   }

   if (((flagup+flagex)==0) && (pathVss==0)) /* cone connecteur */
   {
   free(expr);
   return(""); 
   }
   
   /* on enleve le dernier or */ 
   expr[strlen(expr)-4]='\0';

   if(flagdw!=0) strcat(expr,")");

strcat(expr," ;\n");
res=(char*)mbkalloc(strlen(expr)+1);
strcpy(res,expr);
free(expr);
return(res);
}




/****************************************************************************
 *                         fonction genprod();                              *
 ****************************************************************************/

    /*----------------------------------------------*
     |  renvoie l'expression vhdl dune branche VDD  |
     |          ou VSS                              |
     |  entree : un pointeur de branche             |
     |  sortie : une chaine de caractere            |
     *----------------------------------------------*/

char * genprod(ptpath)
list_list * ptpath;
{
char buff[3000];
char * res = NULL;
cone_list * ptcone = NULL ;
link_list * ptlink = NULL ;
short n_link = 0;
short n_resist = 0;

strcpy(buff,"(");

   for ( ptlink = (link_list*)ptpath->DATA;ptlink != NULL ;ptlink=ptlink->NEXT)
   {
   n_link++;

      if ((ptlink->TYPE & TP ) == TP ) 
      {
      strcat(buff,"not ");
      }

   ptcone=(cone_list*)ptlink->TRANS->GRID;
   strcat(buff,(char*)ptcone->NAME);
   strcat(buff," and ");
   }

   /*  J'enleve le dernier ET , on rajoute une parenthese */
   buff[strlen(buff)-5]=')';
   buff[strlen(buff)-4]='\0';

res=(char*)mbkalloc(strlen(buff)+1);
strcpy(res,buff);
return(res);
} 
         
         

/****************************************************************************
 *                         fonction genexprod();                            *
 ****************************************************************************/

    /*----------------------------------------------*
     |  renvoie l'expression vhdl dune branche EXT  |
     |          connecteur compris                  |
     |  entree : un pointeur de branche             |
     |  sortie : une chaine de caractere            |
     *----------------------------------------------*/
char * genexprod(ptpath)
list_list * ptpath;
{
char buff[3000];
char * res = NULL;
cone_list * ptcone = NULL ;
link_list * ptlink = NULL ;
locon_list * connect = NULL ;

strcpy(buff,"(");

   for ( ptlink = (link_list*)ptpath->DATA;ptlink != NULL ;ptlink=ptlink->NEXT)
   {
      if ((ptlink->TYPE & TP ) == TP ) 
      {
      strcat(buff,"not ");
      ptcone=(cone_list*)ptlink->TRANS->GRID;
      strcat(buff,(char*)ptcone->NAME);
      strcat(buff," ");
      }
      else  if((ptlink->TYPE & TN)==TN)
      {
      ptcone=(cone_list*)ptlink->TRANS->GRID;
      strcat(buff,(char*)ptcone->NAME);
      }
      else if((ptlink->NEXT== NULL))
      {
      connect=(locon_list*)ptlink->TRANS;
      strcat(buff,(char*)connect->NAME);
      }

   strcat(buff," and ");
   }
   

/*on enleve le dernier ET , on rajoute une parenthese */
buff[strlen(buff)-5]=')';
buff[strlen(buff)-4]='\0';

res=(char*)mbkalloc(strlen(buff)+1);
strcpy(res,buff);
return(res);
} 
         
         
/****************************************************************************
 *                         fonction genexssconct();                           *
 ****************************************************************************/

    /*----------------------------------------------*
     |  renvoie l'expression vhdl dune branche EXT  |
     |          connecteur non compris              |
     |  entree : un pointeur de branche             |
     |  sortie : une chaine de caractere            |
     *----------------------------------------------*/

char * genexssconct(ptpath)
list_list * ptpath;
{
char buff[3000];
char * res = NULL;
cone_list * ptcone = NULL ;
link_list * ptlink = NULL ;

strcpy(buff,"(");

   for ( ptlink = (link_list*)ptpath->DATA;ptlink != NULL ;ptlink=ptlink->NEXT)
   {
      if ((ptlink->TYPE & TP ) == TP ) 
      {
      strcat(buff,"not ");
      ptcone=(cone_list*)ptlink->TRANS->GRID;
      strcat(buff,(char*)ptcone->NAME);
      strcat(buff," ");
      }
      else  if((ptlink->TYPE & TN)==TN)
      {
      ptcone=(cone_list*)ptlink->TRANS->GRID;
      strcat(buff,(char*)ptcone->NAME);
      }
      else break ;

   strcat(buff," and ");
   }
   

/*on enleve le dernier ET , on rajoute une parenthese */

buff[strlen(buff)-5]=')';
buff[strlen(buff)-4]='\0';

res=(char*)mbkalloc(strlen(buff)+1);
strcpy(res,buff);
return(res);
} 

/****************************************************************************
 *                         fonction hzexpr();                               *
 ****************************************************************************/

     /*---------------------------------------------------*
      |   Renvoie l'expression vhdl d' un cone HZ         |
      |   Entree : Un pointeur de cone HZ                 |
      |   Sortie : Une chaine de caractere                |
      *---------------------------------------------------*/

char * hzexpr(cone)
cone_list * cone ;
{
short flagup = 0;
short flagdw = 0;
short flagex = 0;
char *res;
char buff[5];
list_list * path;

char * fup=(char*)malloc(5000);
char * fdw=(char*)malloc(5000);
char * fex=(char*)malloc(5000);
char * expr=(char*)malloc(14000);

int szFup = 4000 ;
int szFdw = 4000 ;
int szFex = 4000 ;
int szExp = 12000 ;

int iFup = 1;
int iFdw = 1;
int iFex = 1;
int iExp = 1; 


expr[0]='\0';



   for(path=cone->PATH;path != NULL;path=path->NEXT)
   {
      if((path->TYPE & BLEEDER)==BLEEDER) continue ;
      if((path->TYPE & VDD)==VDD)
      {
         if(flagup==0)
         {
         sprintf(fup,"\nlb%d",LABEL_INDEX++);
         strcat(fup," : block (( ");
         }
      flagup=1;
      strcat(fup,genprod(path));
      strcat(fup," or ");
      }

      else if((path->TYPE & VSS)==VSS)
      {
         if(flagdw==0)
         {
         sprintf(fdw,"\nlb%d",LABEL_INDEX++);
         strcat(fdw," : block (( ");
         }
      flagdw=1;
      strcat(fdw,genprod(path));
      strcat(fdw," or ");
      }

      else if(((path->TYPE & EXT)==EXT)&&(((link_list*)path->DATA)->NEXT!=NULL))
      {
      link_list * link;
         if(flagex==0) sprintf(fex,"\nlb%d",LABEL_INDEX++);
         else 
         {
         sprintf(buff,"\nlb%d",LABEL_INDEX++);
         strcat(fex,buff);
         }
      flagex=1;
      strcat(fex," : block (( ");
      strcat(fex,genexssconct(path));
      strcat(fex," ) ='1' )\nbegin\n");
         for(link=(link_list*)path->DATA;link->NEXT!=NULL;link=link->NEXT) ;
      strcat(fex,"   ");
      strcat(fex,cone->NAME);
      strcat(fex," <= guarded ");
      strcat(fex,((locon_list*)(link->TRANS))->NAME);
      strcat(fex," ;\n end block ;\n");
      }

      if(strlen(fup)>szFup)
      {
      fup=(char*)realloc(fup,5000+(iFup*1000));
         if(fup==NULL)
         {
         d2vFatalError(4,NULL,NULL,NULL,0);
         }
      iFup++;
      szFup+=1000;
      }

      if(strlen(fdw)>szFdw)
      {
      fdw=(char*)realloc(fdw,5000+(iFdw*1000));
         if(fdw==NULL)
         {
         d2vFatalError(4,NULL,NULL,NULL,0);
         }
      iFdw++;
      szFdw+=1000;
      }

      if(strlen(fex)>szFex)
      {
      fex=(char*)realloc(fex,5000+(iFex*1000));
         if(fex==NULL)
         {
         d2vFatalError(4,NULL,NULL,NULL,0);
         }
      iFex++;
      szFex+=1000;
      }

      if(strlen(expr)>szExp)
      {
      expr=(char*)realloc(expr,14000+(iExp*2000));
         if(expr==NULL)
         {
         d2vFatalError(4,NULL,NULL,NULL,0);
         }
      iExp++;
      szExp+=2000;
      }
   }

   if ((flagup+flagdw+flagex)==0) return("");
   if(flagup==1)
   {
   fup[strlen(fup)-4]='\0'; /* on eleve le dernier OR */
   strcat(fup," ) ='1' )\nbegin\n");
   strcat(fup,"   ");
   strcat(fup,cone->NAME);
   strcat(fup," <= guarded '1' ;\n");
   strcat(fup,"end block ;\n");
   strcat(expr,fup);
   }
   if(flagdw==1)
   {
   fdw[strlen(fdw)-4]='\0'; /* on eleve le dernier OR */
   strcat(fdw," ) ='1' )\nbegin\n");
   strcat(fdw,"   ");
   strcat(fdw,cone->NAME);
   strcat(fdw," <= guarded '0' ;\n");
   strcat(fdw,"end block ;\n");
   strcat(expr,fdw);
   }
   if(flagex==1) strcat(expr,fex);

res=(char*)mbkalloc(strlen(expr)+1);
strcpy(res,expr);
free(fup);
free(fdw);
free(fex);
free(expr);
return(res);
}

      

/****************************************************************************
 *                         fonction latchexpr();                            *
 ****************************************************************************/
char * latchexpr(cone)
cone_list * cone;
{
chain_list * moslist=NULL;
chain_list * chain=NULL;
cone_list * slave ;
ptype_list * mastUser;
list_list * path;
list_list * path1;
char bidon[5];
char * res;

int szBuff=4000 ;
int iBuff =1 ;

char * buff=(char*)malloc((unsigned)5000);

buff[0]='\0';

   if((cone->TYPE & MAST) == MAST)
   {
   mastUser=getptype(cone->USER,SLAVE);
   slave=(cone_list*)mastUser->DATA;
   }

   for(path=cone->PATH;path != NULL; path=path->NEXT)
   {
   link_list * link;
   char * mos;

      if((path->TYPE & VSS)==VSS) continue ;
      if((path->TYPE & BLEEDER)==BLEEDER) continue ;

   link=(link_list*)path->DATA;
   mos=(char*)link->TRANS;

      /*-------------------------------------------------*
       | on regarde si le mos de passage est deja traite |
       *-------------------------------------------------*/

      for(chain = moslist; chain!=NULL;chain=chain->NEXT)
      {
         if((char*)chain->DATA==mos) break;
      }
       
      if(chain == NULL)
      {
         /*---------------------------------------------*
          | le pass transistor est non rencontre        |
          | on traite toutes le branches suivantes qui  |
          | le contiennent                              |
          *---------------------------------------------*/
     
      sprintf(bidon,"lb%d",LABEL_INDEX++);
      strcat(buff,"\n");
      strcat(buff,bidon);
      strcat(buff," : block ( ");
      strcat(buff,((cone_list*)((trans_list*)mos)->GRID)->NAME);

         if((cone->TYPE & MAST)==MAST)
         {
            if(((trans_list*)mos)->TYPE==TP)
            {
            strcat(buff," = '1' and not ");
            strcat(buff,((cone_list*)((trans_list*)mos)->GRID)->NAME);
            strcat(buff,"'stable  )\nbegin\n   ");
            }
            else
            {
            strcat(buff," = '0' and not ");
            strcat(buff,((cone_list*)((trans_list*)mos)->GRID)->NAME);
            strcat(buff,"'stable )\nbegin\n   ");
            }
         strcat(buff,slave->NAME);
         }

         else 
         {
            if(((trans_list*)mos)->TYPE==TP)
            strcat(buff," = '0' )\nbegin\n   ");
            else
            strcat(buff," = '1' )\nbegin\n   ");
         strcat(buff,cone->NAME);
         }
      strcat(buff," <= guarded ");
      
         if(link->NEXT == NULL)
         {
         strcat(buff,"'1'");
         strcat(buff," ;\nend block ;\n");
         /* on rajoute le mos de passage a la liste */
         moslist=addchain(moslist,(void*)mos);
         continue;
         }

         for(path1=path;path1 != NULL;path1=path1->NEXT)
         {

            if((path1->TYPE & VSS)==VSS) continue ;
            if((path1->TYPE & BLEEDER)==BLEEDER) continue ;

         link=(link_list*)path1->DATA;

            if((char*)link->TRANS==mos)
            {
               /*---------------------------------------------*
                | si la branche le contient on rajoute le fup |
                | partiel correspondant                       |
                *---------------------------------------------*/

            link_list * sav_link=(link_list*)path1->DATA;
            path1->DATA=((char*)((link_list*)path1->DATA)->NEXT);
               
               if((path1->TYPE & VDD)==VDD)
               strcat(buff,genprod(path1));

               else if((path1->TYPE & EXT)==EXT)
               strcat(buff,genexprod(path1));

            path1->DATA=(char*)sav_link;
            strcat(buff," or ");
 
               if(strlen(buff)>szBuff)
               {
               buff=(char*)realloc(buff,(unsigned)(5000+(iBuff*1000)));
                  if(buff==NULL)
                  {
                  d2vFatalError(4,NULL,NULL,NULL,0);
                  }
               iBuff++;
               szBuff+=1000 ;
               }
            }
         }
         
      /* on enleve le dernier ou */
      buff[strlen(buff)-4]='\0';
      strcat(buff," ; \nend block ;\n");

      /* on rajoute le mos de passage a la liste */
      moslist=addchain(moslist,(void*)mos);
      }
            
      else continue ;      
   }


   /*----------------------------------------------------+
   | On traite les branches essentiellement VSS          |
   +----------------------------------------------------*/
   for(path=cone->PATH;path != NULL; path=path->NEXT)
   {
   link_list * link;
   char * mos;

      if((path->TYPE & VDD)==VDD) continue ;
      if((path->TYPE & BLEEDER)==BLEEDER) continue ;

   link=(link_list*)path->DATA;
   mos=(char*)link->TRANS;

      /*-------------------------------------------------*
       | on regarde si le mos de passage est deja traite |
       *-------------------------------------------------*/

      for(chain = moslist; chain!=NULL;chain=chain->NEXT)
      {
         if((char*)chain->DATA==mos) break;
      }
       
      if(chain == NULL)
      {
         /*---------------------------------------------*
          | le pass transistor est non rencontre        |
          | on traite toutes le branches suivantes qui  |
          | le contiennent                              |
          *---------------------------------------------*/
     
      sprintf(bidon,"lb%d",LABEL_INDEX++);
      strcat(buff,"\n");
      strcat(buff,bidon);
      strcat(buff," : block ( ");
      strcat(buff,((cone_list*)((trans_list*)mos)->GRID)->NAME);

         if((cone->TYPE & MAST)==MAST)
         {
            if(((trans_list*)mos)->TYPE==TP)
            {
            strcat(buff," = '1' and not ");
            strcat(buff,((cone_list*)((trans_list*)mos)->GRID)->NAME);
            strcat(buff,"'stable  )\nbegin\n   ");
            }
            else
            {
            strcat(buff," = '0' and not ");
            strcat(buff,((cone_list*)((trans_list*)mos)->GRID)->NAME);
            strcat(buff,"'stable )\nbegin\n   ");
            }
         strcat(buff,slave->NAME);
         }

         else 
         {
            if(((trans_list*)mos)->TYPE==TP)
            strcat(buff," ='0' )\nbegin\n   ");
            else
            strcat(buff," ='1' )\nbegin\n   ");
         strcat(buff,cone->NAME);
         }
      strcat(buff," <= guarded ");

         if(link->NEXT == NULL)
         {
         strcat(buff,"'0'");
         strcat(buff," ;\nend block ;\n");
         /* on rajoute le mos de passage a la liste */
         moslist=addchain(moslist,(void*)mos);
         continue;
         }
         else
         {
         strcat(buff,"not(");
         }
      
         for(path1=path;path1 != NULL;path1=path1->NEXT)
         {

            if((path1->TYPE & VDD)==VDD) continue ;
            if((path1->TYPE & BLEEDER)==BLEEDER) continue ;

         link=(link_list*)path1->DATA;

            if((char*)link->TRANS==mos)
            {
               /*---------------------------------------------*
                | si la branche le contient on rajoute le fdn |
                | partiel correspondant                       |
                *---------------------------------------------*/

            link_list * sav_link=(link_list*)path1->DATA;
            path1->DATA=((char*)((link_list*)path1->DATA)->NEXT);
               
               if((path1->TYPE & VSS)==VSS)
               strcat(buff,genprod(path1));

               else if((path1->TYPE & EXT)==EXT)
               strcat(buff,genexprod(path1));

            path1->DATA=(char*)sav_link;
            strcat(buff," or ");

               if(strlen(buff)>szBuff)
               {
               buff=(char*)realloc(buff,(unsigned)(5000+(iBuff*1000)));
                  if(buff==NULL)
                  {
                  d2vFatalError(4,NULL,NULL,NULL,0);
                  }
               iBuff++;
               szBuff+=1000 ;
               }
            }
         }
         
      /* on enleve le dernier ou */
      buff[strlen(buff)-4]='\0';
      /* on ajoute un parenthese pour le not */
      strcat(buff,")");
      strcat(buff," ; \nend block ;\n");

      /* on rajoute le mos de passage a la liste */
      moslist=addchain(moslist,(void*)mos);
      }
            
      else continue ;      
   }
res=(char*)mbkalloc(strlen(buff)+1);
strcpy(res,buff);
free(buff);
return(res);
}


/****************************************************************************
 *                         fonction pathIsResist();                         *
 ****************************************************************************/
/*-------------------------------------------------------------------------+
| teste si une branche est essentiellememnt composee de resistances        |
| entree : path Un pointeur de branche                                     |
| retiur : 0 la branche est composee uniquement de resistances             |
|         -1 la branche ne contient pas que des resistances                |
+-------------------------------------------------------------------------*/
static short pathIsResist(path)
list_list * path ;
{
link_list * link ;

   for(link=(link_list*)path->DATA;link!=NULL;link=link->NEXT)
   {
      if((link->TYPE & RESIST)!=RESIST) break ;
   }

   if(link==NULL) return(0);
   else return(-1);
}
