/* ###--------------------------------------------------------------### */
/*                                                                      */
/* file         : bvl_parse.c                                           */
/* date         : Jan 18 1993						*/
/* version	: v106							*/
/* author       : L.A TABUSSE & H.N. VUONG & P. BAZARGAN-SABET          */
/* description  : Parser VHDL --> BEH                                   */
/* Called Func. : mbkalloc						*/
/*                                                                      */
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include <string.h>
#include <mut309.h>
#include <beh104.h>
#include "../util/bvl_utype.h"
#include "../util/bvl_utdef.h"
#include "bvl_parse.h"

struct befig *vhdlloadbefig (pt_befig, figname, trace_mode)

struct befig *pt_befig;
char         *figname;
int           trace_mode;

  {
  char          *env_valu;
  char          *buffer;
  char          *str;
  struct chain  *search_lst = NULL;
  struct chain  *behsfx_lst = NULL;
  struct chain  *libpath = NULL;
  struct chain  *suffix = NULL;

	/* ###------------------------------------------------------### */
	/*    Create the list of search libraries from the environment	*/
	/* variable VH_LIBLST						*/
	/* ###------------------------------------------------------### */

  str = getenv("VH_LIBLST");
  if(str == NULL)
    {
    str = getenv("MBK_CATA_LIB");
    }
  if(str != NULL)
    {
    env_valu = (char *)mbkalloc((unsigned int)(strlen(str) + 1) * sizeof(char));
    (void)strcpy(env_valu,str);
    }
  if (env_valu == NULL)
    search_lst = addchain (NULL,".");
  else
    {
    buffer = strtok (env_valu,":");
    do
      search_lst = addchain (search_lst,buffer);
    while ((buffer = strtok (NULL,":")) != NULL);

    search_lst = reverse (search_lst);
    }
    
	/* ###------------------------------------------------------### */
	/*    Create list of suffix for behavioural files from the	*/
	/* environment variable VH_BEHSFX				*/
	/* ###------------------------------------------------------### */

  env_valu = NULL;
  str = getenv("VH_BEHSFX");
  if(str != NULL)
    {
    env_valu = (char *)mbkalloc((unsigned int)(strlen(str) + 1) * sizeof(char));
    (void)strcpy(env_valu,str);
    }
  if (env_valu == NULL)
    behsfx_lst = addchain (NULL,"vbe");
  else
    {
    buffer = strtok (env_valu,":");
    do
      behsfx_lst = addchain (behsfx_lst,buffer);
    while ((buffer = strtok (NULL,":")) != NULL);

    behsfx_lst = reverse (behsfx_lst);
    }

	/* ###------------------------------------------------------### */
	/*    Searching the root file					*/
	/* ###------------------------------------------------------### */

/*   bvl_message(5,figname,0);*/
  
  libpath = search_lst;
  while (libpath != NULL)
    {
    suffix  = behsfx_lst;
    while ( suffix != NULL)
      {
      sprintf (BVL_CURFIL,"%s/%s.%s",libpath->DATA,figname,suffix->DATA);
      if ((bvl_y_in = fopen (BVL_CURFIL,"r")) != NULL)
        break;
      suffix = suffix->NEXT;
      }
    if (suffix != NULL)
      break;
    libpath = libpath->NEXT;
    }

  if (bvl_y_in == NULL)
    {
    bvl_error (100,figname);
    exit (1);
    }

	/* ###------------------------------------------------------### */
	/*    Running the behavioural compiler on the current file	*/
	/* ###------------------------------------------------------### */

  if (trace_mode == 1)
    bvl_message(3,BVL_CURFIL,0);

  BVL_LINNUM = 1;

  bvl_y_parse ();
  fclose (bvl_y_in);

  return (BVL_HEDFIG);
  }
