
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebepor.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebepor						*/
/* description	: delete a list of BEAUX structures and all objects	*/
/*		  pointed by any os BEAUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebepor (listbepor)

struct bepor *listbepor;	/* list of bepor to be deleted		*/

  {
  struct bepor *ptbepor;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, delete the object itself	*/
	/* ###------------------------------------------------------### */

  while (listbepor != NULL)
    {
    ptbepor   = listbepor;
    listbepor = listbepor->NEXT;
    mbkfree (ptbepor);
    }

  }
