
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebeout.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebeout						*/
/* description	: delete a list of BEOUT structures and all objects	*/
/*		  pointed by any os BEOUTs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebeout (listbeout)

struct beout *listbeout;	/* list of beout to be deleted		*/

  {
  struct beout *ptbeout;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbeout != NULL)
    {
    freeExpr (listbeout->ABL);

    ptbeout   = listbeout;
    listbeout = listbeout->NEXT;
    mbkfree (ptbeout);
    }

  }
