
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebebus.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebebus						*/
/* description	: delete a list of BEBUS structures and all objects	*/
/*		  pointed by any os BEBUSs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebebus (listbebus)

struct bebus *listbebus;	/* list of bebus to be deleted		*/

  {
  struct bebus *ptbebus;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbebus != NULL)
    {
    beh_frebiabl  (listbebus->BIABL);
    beh_frebinode (listbebus->BINODE);

    ptbebus   = listbebus;
    listbebus = listbebus->NEXT;
    mbkfree (ptbebus);
    }

  }
