
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_delbinod.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_delbinode						*/
/* description	: delete a BINODE structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N	*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct binode *beh_delbinode (listbinode, ptbinode, mode)

struct binode *listbinode;	/* list of binode containing the object	*/
struct binode *ptbinode;	/* pointer of the BINODE to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct binode  headnode;
  struct binode *ptlastnode;

  if ((listbinode != NULL) && (ptbinode != NULL))
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headnode.NEXT = listbinode;
    ptlastnode    = &headnode;
    while ((ptlastnode != NULL) && (ptlastnode->NEXT != ptbinode))
      ptlastnode = ptlastnode->NEXT;

    if (ptlastnode != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if ((ptbinode->VALNODE != NULL) || (ptbinode->CNDNODE != NULL))
          (void) fprintf (stderr,"BEH_warning : binode not empty\n");
        }

      ptlastnode->NEXT = ptbinode->NEXT;
      mbkfree (ptbinode);
      }

    listbinode = headnode.NEXT;
    }

  return(listbinode);
  }
