
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: vh_util.c						*/
/* date		: Feb  8 1993						*/
/* author	: Pirouz BAZARGAN SABET					*/
/* version	: v1.9							*/
/* description	: This file contains some utility functions :		*/
/*		  vhu_addtab , vhu_chktab , vhu_fretab , vhu_error  ,	*/
/*		  vhu_addent , vhu_addrcd , vhu_toolbug, vhu_message,	*/
/*		  vhu_warning, vhu_initab , vhu_deltab , vhu_avers  ,	*/
/*		  vhdlname   , vhu_abl2str				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include <mut309.h>
#include "vh_utype.h"
#include "vh_util.h"
#include "vh_utdef.h"

/* ###--------------------------------------------------------------### */
/* function	: vhu_deltab						*/
/* description	: remove a record from the dictionnary			*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

void vhu_deltab (head,key_str,ctx_str)

struct dct_entry **head;
char              *key_str;
char              *ctx_str;

  {
  int               found = 0;
  int               valu = 0;
  int               index;
  struct dct_entry *entry_pnt;
  struct dct_entry *last_entry = NULL;
  struct dct_recrd *recrd_pnt;
  struct dct_recrd *last_recrd = NULL;

  index     = (int)key_str % VHU_HSZDFN;
  entry_pnt = head [index];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    last_entry = entry_pnt;
    entry_pnt  = entry_pnt->next;
    }

  if (found == 1)
    {
    found = 0;
    recrd_pnt = entry_pnt->data;
    while (recrd_pnt != NULL)
      {
      if (recrd_pnt->key == ctx_str)
        {
        found = 1;
        break;
        }
      last_recrd = recrd_pnt;
      recrd_pnt  = recrd_pnt->next;
      }

    if (found == 1)
      {
      if (last_recrd == NULL)
        entry_pnt->data  = recrd_pnt->next;
      else
        last_recrd->next = recrd_pnt->next;

      recrd_pnt->next = VHU_DCRHED;
      VHU_DCRHED      = recrd_pnt;

      if (entry_pnt->data == NULL)
        {
        if (last_entry == NULL)
          head[index]      = entry_pnt->next;
        else
          last_entry->next = entry_pnt->next;

        entry_pnt->next = VHU_DCEHED;
        VHU_DCEHED      = entry_pnt;
        }
      }
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_initab						*/
/* description	: create a new dictionnary				*/
/* called func.	: mbkalloc						*/
/* ###--------------------------------------------------------------### */

struct dct_entry **vhu_initab ()

  {
  struct dct_entry **head;
  int                i;

  head = (struct dct_entry **)
         mbkalloc (sizeof(struct dct_entry *) * VHU_HSZDFN);

  for (i=0 ; i<VHU_HSZDFN ; i++)
    head[i] = NULL;

  return (head);
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_warning						*/
/* description	: print a warning message corresponding to the argument	*/
/*		  code							*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

void vhu_warning (code,str1)

int   code;
char *str1;

  {
  (void) fprintf (stderr,"Warning %d : ",code);
  switch (code)
    {
    case 1:
      (void) fprintf (stderr,"cannot find register `%s`\n",str1);
      break;
    case 2:
      (void) fprintf (stderr,"consistency checks will be disabled\n");
      break;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_toolbug						*/
/* description	: print a fatal error message corresponding to the	*/
/*		  argument code and exit				*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

void vhu_toolbug (code,str1,str2,nbr1)

int   code;
char *str1;
char *str2;
int   nbr1;

  {
  (void) fprintf (stderr,"Fatal error %d executing `%s`: ", code,str1);
  switch (code)
    {
    case 1:
      (void) fprintf (stderr,"unknown operator\n");
      break;
    case 2:
      (void) fprintf (stderr,"cannot create empty atom\n");
      break;
    case 3:
      (void) fprintf (stderr,"cannot build NOT of empty expression\n");
      break;
    case 4:
      (void) fprintf (stderr,"cannot combine empty expressions\n");
      break;
    case 5:
      (void) fprintf (stderr,"cannot find terminal\n");
      break;
    case 6:
      (void) fprintf (stderr,"cannot make BDD of empty expression\n");
      break;
    case 7:
      (void) fprintf (stderr,"unknown type `%c` for IO `%s`\n",nbr1,str2);
      break;
    case 8:
      (void) fprintf (stderr,"illegal signal value : hex `%x`\n",nbr1);
      break;
    case 9:
      (void) fprintf (stderr,"unknown mode `%c` for IO `%s`\n",nbr1,str2);
      break;
    case 10:
      (void) fprintf (stderr,"decompiler called on empty befig\n");
      break;
    case 12:
      (void) fprintf (stderr,"illegal user value '%c' for IO\n",nbr1);
      break;
    case 13 :
      (void) fprintf (stderr,"cannot find model of `%s`\n",str2);
      break;
    case 14 :
      (void) fprintf (stderr,"cannot convert empty expression\n");
      break;
    case 15 :
      (void) fprintf (stderr,"illegal bit string value : `%c`\n",nbr1);
      break;
    case 16 :
      (void) fprintf (stderr,"the same expression cannot be used twice\n");
      break;
    case 17 :
      (void) fprintf (stderr,"unknown base specifier : `%c`\n",nbr1);
      break;
    case 18:
      (void) fprintf (stderr,"unknown mode `%c` for port `%s`\n",nbr1,str2);
      break;
    case 19:
      (void) fprintf (stderr,"empty guard expression: `%s`\n",str2);
      break;
    case 20:
      (void) fprintf (stderr,"empty waveform expression: `%s`\n",str2);
      break;
    case 21:
      (void) fprintf (stderr,"cannot find structural level\n");
      break;
    case 22:
      (void) fprintf (stderr,"`%s` : `%c` unknown resolution function\n",str2,nbr1);
      break;
    }
  exit (1);
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_message						*/
/* description	: print a message corresponding to the argument code	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

void vhu_message (code,str1,nmb1)

int   code;
char *str1;
int   nmb1;

  {
  switch (code)
    {
    case 1:
      (void) fprintf (stderr,"Usage : asimut <root> [<pattern> <result_file>] [-option]\n");
      (void) fprintf (stderr,"or      asimut -help\n");
      break;
    case 2:
      (void) fprintf (stdout,"Initializing ...\n");
      break;
    case 3:
      (void) fprintf (stdout,"Compiling `%s` (Behaviour) ...\n",str1);
      break;
    case 4:
      (void) fprintf (stdout,"Compiling `%s` (Structural) ...\n\n",str1);
      break;
    case 5:
      (void) fprintf (stdout,"Searching `%s` ...\n",str1);
      break;
    case 6:
      (void) fprintf (stdout,"Searching pattern file : `%s` ...\n",str1);
      break;
    case 8:
      (void) fprintf (stdout,"Compiling `%s` (Pattern) ...\n\n",str1);
      break;
    case 9:
      (void) fprintf (stdout,"Linking ...\n");
      break;
    case 10:
      (void) fprintf (stdout,"###----- processing pattern %d -----###\n",nmb1);
      break;
    case 11:
      (void) fprintf (stdout,"Decompiling ...\n");
      break;
    case 12:
      (void) fprintf (stdout,"Generating the file '%s' ...\n",str1);
      break;
    case 13:
      (void) fprintf (stdout,"of the figure '%s'.\n",str1);
      break;
    case 14:
      (void) fprintf (stdout,"File '%s' has been generated.\n",str1);
      break;
    case 15:
      (void) fprintf (stdout,"Making Bdd ...\n\n");
      break;
    case 16:
      (void) fprintf (stdout,"Restoring external ports mode ...\n\n");
      break;
    default:
      (void) fprintf (stderr,"vhu_message : code %d unknown.\n",code);
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_addtab						*/
/* description	: add a new information into a dictionnary. If the	*/
/*		  key or the context doesn't exist create a new record	*/
/* called func.	: vhu_addrcd, vhu_addent				*/
/* ###--------------------------------------------------------------### */

void vhu_addtab (head,key_str,ctx_str,field,valu)

struct dct_entry **head;
char              *key_str;
char              *ctx_str;
int                field;
int                valu;

  {
  int               found = 0;
  int               index;
  struct dct_entry *entry_pnt;
  struct dct_recrd *recrd_pnt;

  index     = (int) key_str % VHU_HSZDFN;
  entry_pnt = head[index];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 0)
    {
    head[index] = vhu_addent (head[index],key_str); 
    entry_pnt = head[index]; 
    }

  found = 0;
  recrd_pnt = entry_pnt->data;
  while (recrd_pnt != NULL)
    {
    if (recrd_pnt->key == ctx_str)
      {
      found = 1;
      break;
      }
    recrd_pnt = recrd_pnt->next;
    }

  if (found == 0)
    {
    entry_pnt->data = vhu_addrcd (entry_pnt->data,ctx_str); 
    recrd_pnt       = entry_pnt->data ;
    }

  switch (field)
    {
    case 0 :
      recrd_pnt->fd0_val = valu;
      break;
    case 1 :
      recrd_pnt->fd1_val = valu;
      break;
    case 2 :
      recrd_pnt->fd2_val = valu;
      break;
    case 3 :
      recrd_pnt->fd3_val = valu;
      break;
    case 4 :
      recrd_pnt->fd4_val = valu;
      break;
    case 5 :
      recrd_pnt->fd5_val = valu;
      break;
    case 6 :
      recrd_pnt->fd6_val = valu;
      break;
    case 7 :
      recrd_pnt->pnt_val = valu;
      break;
    }

  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_chktab						*/
/* description	: extract an information from a dictionnary. Return	*/
/*		  0 if the information has not been found.		*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

int  vhu_chktab (head,key_str,ctx_str,field)

struct dct_entry **head;
char              *key_str;
char              *ctx_str;
int                field;

  {
  int               found = 0;
  int               valu = 0;
  struct dct_entry *entry_pnt;
  struct dct_recrd *recrd_pnt;

  entry_pnt = head [(int)key_str % VHU_HSZDFN];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 1)
    {
    found = 0;
    recrd_pnt = entry_pnt->data;
    while (recrd_pnt != NULL)
      {
      if (recrd_pnt->key == ctx_str)
        {
        found = 1;
        break;
        }
      recrd_pnt = recrd_pnt->next;
      }
    if (found == 1)
      {
      switch (field)
        {
        case 0 :
          valu = recrd_pnt->fd0_val;
          break;
        case 1 :
          valu = recrd_pnt->fd1_val;
          break;
        case 2 :
          valu = recrd_pnt->fd2_val;
          break;
        case 3 :
          valu = recrd_pnt->fd3_val;
          break;
        case 4 :
          valu = recrd_pnt->fd4_val;
          break;
        case 5 :
          valu = recrd_pnt->fd5_val;
          break;
        case 6 :
          valu = recrd_pnt->fd6_val;
          break;
        case 7 :
          valu = recrd_pnt->pnt_val;
          break;
        }
      }
    }

  return (valu);
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_fretab						*/
/* description	: remove entirely a dictionnary				*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void vhu_fretab (pt_hash)

struct dct_entry **pt_hash;
  {
  struct dct_entry *pt_entry;
  struct dct_entry *pt_nxtentry;
  struct dct_recrd *pt_record;
  int               i;

  if (pt_hash != NULL)
    {
    for (i=0 ; i<VHU_HSZDFN ; i++)
      {
      if ((pt_entry = pt_hash[i]) != NULL)
        {
        while (pt_entry != NULL)
          {
          pt_record = pt_entry->data;

          while (pt_record->next != NULL)
            pt_record = pt_record->next;

          pt_record->next = VHU_DCRHED;
          VHU_DCRHED      = pt_entry->data;

          pt_nxtentry     = pt_entry->next;
          pt_entry->next  = VHU_DCEHED;
          VHU_DCEHED      = pt_entry;
          pt_entry        = pt_nxtentry;
          }
        }
      }
    mbkfree (pt_hash);
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_error						*/
/* description	: print an error message depending on the argument code	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

void vhu_error (code,str1)

int   code;
char *str1;

  {
  VHU_ERRFLG++;
  if (code < 200)
    (void)fprintf (stderr,"Error %d :",code);

  switch (code)
    {
    case 100:
      (void) fprintf (stderr,"cannot find `%s`\n",str1);
      break;
    case 102:
      (void) fprintf (stderr,"instance and model of `%s` mismatch\n",str1);
      break;
    case 103:
      (void) fprintf (stderr,"incompatible input/output mode for `%s`\n",str1);
      break;
    case 104:
      (void) fprintf (stderr,"input/output `%s` doesn't exist\n",str1);
      break;
    case 105:
      (void) fprintf (stderr,"Possible combinatory loop. Simulation aborted\n");
      break;
    case 106:
      (void) fprintf (stderr,"Too many errors. Simulation interrupted\n");
      break;
    case 107:
      (void) fprintf (stderr,"Cannot open result file\n");
      break;
    case 108:
      (void) fprintf (stderr,"signal `%s` never used\n",str1);
      break;
    case 109:
      (void) fprintf (stderr,"signal `%s` never assigned\n",str1);
      break;
    case 110:
      (void) fprintf (stderr,"signal `%s` connected to less than 2 ports\n",str1);
      break;
    case 111:
      (void) fprintf (stderr,"illegal connections on signal `%s`\n",str1);
      break;
    case 112:
      (void) fprintf (stderr,"multiple driver on guarded signal `%s`\n",str1);
      break;
    case 113:
      (void) fprintf (stderr,"expected value and simulation's result mismatch on `%s`\n",str1);
      VHU_ERRFLG--;
      break;
    case 114:
      (void) fprintf (stderr,"multiple driver on unguarded signal `%s`\n",str1);
      break;
    case 115:
      (void) fprintf (stderr,"save file doesn't match with the description\n");
      break;

    case 200:
      (void) fprintf (stderr,"\n	cannot continue further more.\n");
      (void) fprintf (stderr,"\n		Have a nice day...\n");
      break;

    default:
      (void) fprintf (stderr,"syntax error\n");
      break;
    }

  if (VHU_ERRFLG > VHU_MXRDFN)
    {
    (void) fprintf (stderr,"Too many errors. Cannot continue further more\n");
    (void) fprintf (stderr,"\n		Have a nice day...\n");
    exit (1);
    }

  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_addent						*/
/* description	: add a new entry in a dictionnary			*/
/* called func.	: mbkaloc						*/
/* ###--------------------------------------------------------------### */

static struct dct_entry *vhu_addent (head , key)

struct dct_entry *head;
char             *key;

  {
  struct dct_entry *entry;
  int               i;

  if (VHU_DCEHED == NULL)
    {
    VHU_DCEHED = (struct dct_entry *)
                 mbkalloc (sizeof(struct dct_entry) * VHU_ALODFN);

    entry = VHU_DCEHED;
    for (i=1 ; i<VHU_ALODFN ; i++)
      {
      entry->next = entry + 1;
      entry++;
      }
    entry->next = NULL;
    }

  entry       = VHU_DCEHED;
  VHU_DCEHED  = VHU_DCEHED->next;

  entry->next = head;
  entry->data = NULL;
  entry->key  = key;

  return (entry);
  }

static struct dct_recrd *vhu_addrcd (head , key)

struct dct_recrd *head;
char             *key;

  {
  struct dct_recrd *recrd;
  int               i;

  if (VHU_DCRHED == NULL)
    {
    VHU_DCRHED = (struct dct_recrd *)
                 mbkalloc (sizeof(struct dct_recrd) * VHU_ALODFN);

    recrd = VHU_DCRHED;
    for (i=1 ; i<VHU_ALODFN ; i++)
      {
      recrd->next = recrd + 1;
      recrd++;
      }
    recrd->next = NULL;
    }

  recrd           = VHU_DCRHED;
  VHU_DCRHED      = VHU_DCRHED->next;

  recrd->next     = head;
  recrd->fd0_val  = 0;
  recrd->fd1_val  = 0;
  recrd->fd2_val  = 0;
  recrd->fd3_val  = 0;
  recrd->fd4_val  = 0;
  recrd->fd5_val  = 0;
  recrd->fd6_val  = 0;
  recrd->pnt_val  = 0;
  recrd->key      = key;

  return (recrd);
  }

/* ###--------------------------------------------------------------### */
/* function	: vhu_avers						*/
/* description	: return the current version				*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

char *vhu_avers ()
  {
  return ("-- V 1.9 --");
  }

char *vhdlname (name)

char *name;

  {
  char                     *new_name;
  char                     *prv_name;
  char                     *tmp_name;
  char                      buffer[200];
  int                       i,j,flag,number;
  static struct dct_entry **namtab=NULL;

  if (namtab == NULL)
    namtab = vhu_initab ();

  tmp_name = namealloc (name);
  new_name = (char *) vhu_chktab (namtab,tmp_name,NULL,VHU_PNTDFN);

  if (vhu_chktab (namtab,tmp_name,NULL,VHU_NAMDFN) == 0)
    {
    i = 0;
    j = 0;
    number = 0;
    flag = 1;
    while (tmp_name[i] != '\0')
      {
      buffer[j] = tmp_name[i];
      if ( ((tmp_name[i] >= 'a') && (tmp_name[i] <= 'z')) ||
           ((tmp_name[i] >= 'A') && (tmp_name[i] <= 'Z')) ||
           ((tmp_name[i] >= '0') && (tmp_name[i] <= '9') && (i != 0)))
        flag = 0;
      else
        {
        if (flag == 1)
          buffer[j++] = 'v';
        buffer[j] = '_';
        flag = 1;
        }
      i++;
      j++;
      }
    if (buffer[j-1] == '_')
      buffer[j++] = '0';
    buffer[j] = '\0';
    new_name = namealloc (buffer);

    prv_name = new_name;
    while (vhu_chktab (namtab,new_name,NULL,VHU_NEWDFN) != 0)
      {
      new_name = prv_name;
      sprintf (buffer,"%s_%d",new_name,number++);
      prv_name = new_name;
      new_name = namealloc (buffer);
      }
    vhu_addtab (namtab,new_name,NULL,VHU_NEWDFN,1);
    vhu_addtab (namtab,tmp_name,NULL,VHU_PNTDFN,(int)new_name);
    vhu_addtab (namtab,tmp_name,NULL,VHU_NAMDFN,1);
    }

  return (new_name);
  }


char *vhu_abl2str (expr,chaine,taille)

struct chain *expr;
char         *chaine;
int          *taille;

  {

  char        *oper;
  extern char *operToChar ();

  if (expr->NEXT == NULL)
   {
   if (*taille < strlen(chaine)+50)		/* re-allocation */
     {
     *taille = *taille + 100;
     chaine = (char *) realloc(chaine,*taille);
     }

   if ((expr->DATA == (void *)namealloc("'0'")) ||
       (expr->DATA == (void *)namealloc("'1'")))
      strcat (chaine,expr->DATA);
   else
      strcat (chaine,vhdlname(expr->DATA));
   return (chaine);
   }
  else
    {
    oper = operToChar((short)((chain_list *)expr->DATA)->DATA);

    if (!strcmp(oper,"not"))
      {
      strcat(chaine,"not ");
      chaine = vhu_abl2str (expr->NEXT->DATA,chaine,taille);
      return(chaine);
      }
    else
      {
      strcat (chaine,"(");
      while (expr = expr->NEXT)
        {
        chaine = vhu_abl2str (expr->DATA,chaine,taille);
        if (expr->NEXT)
          {
          strcat (chaine," ");
          strcat (chaine,oper);
          if (strlen (chaine) > 60)
            strcat (chaine,"\n");
          else
            strcat (chaine," ");
          }
        }
      strcat (chaine,")");
      return (chaine);
      }
    }
  }
