# include "graph.h"

# define NORES	3

# define _HERCMONO 8


int fleche[32]={0x3FFF,0x1FFF,0x0FFF,0x07FF,0x03FF,0x01FF,0x00FF,0x007F,
		0x003F,0x001F,0x01FF,0x10FF,0x30FF,0xF87F,0xF87F,0xFC7F,
		0x0000,0x4000,0x6000,0x7000,0x7800,0x7C00,0x7E00,0x7F00,
		0x7F80,0x7C00,0x6C00,0x4600,0x0600,0x0300,0x0300,0x0000 };

#define CURS_FLECHE fleche,-1,-1

int doigt[32]= {0xE1FF,0xE1FF,0xE1FF,0xE1FF,0xE1FF,0xE000,0xE000,0x0000,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0xC001,0xC001,
		0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0DB4,0x0DB6,
		0x6DB6,0x6FFE,0x6FFE,0x7FFE,0x7FFE,0x3FFE,0x1FFC,0x0000 };

#define CURS_DOIGT doigt,15,6

int croix2[32]= {0xFC7F,0xF83F,0xF01F,0xFE3F,0xDC77,0x8C63,0x0001,0x0001,
		0x0001,0x8C63,0xDC77,0xFE3F,0xF01F,0xF83F,0xFC7F,0xFFFF,
		0x0100,0x0380,0x07C0,0x0100,0x0100,0x2108,0x610C,0xFFFE,
		0x610C,0x2108,0x0100,0x0100,0x07C0,0x0380,0x0100,0x0000 };

#define CURS_CROIX2 croix2,7,7

int sablier[32]={0x0000,0x8001,0x8001,0xC003,0xC003,0xE007,0xF00F,0xF81F,
		0xF81F,0xF00F,0xE007,0xC003,0xC003,0x8001,0x8001,0x0000,
		0x0000,0x3FFC,0x1008,0x1008,0x0990,0x07E0,0x03C0,0x0180,
		0x0180,0x0240,0x0420,0x0990,0x13C8,0x17E8,0x3FFC,0x0000 };

#define CURS_SABL sablier,7,7

int croix[32]={0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0x0000,0x0000,
		0x0000,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFFFF,
		0x0000,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x7FFC,
		0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000,0x0000 };

#define CURS_CROIX croix,7,7

int evide[32]={0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0x0381,0x0381,
		0x0381,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFC7F,0xFFFF,
		0x0000,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000,0x7C7C,
		0x0000,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000,0x0000 };

#define CURS_EVIDE evide,7,7


static cnat vdimss[10];

char patern[16][8];

# define VPLEIN vdimss[0]
# define VCOLOR vdimss[2]
# define VCURSE vdimss[1]
# define VCURX  vdimss[3]
# define VCURY  vdimss[4]
# define VCUR   vdimss[5]
# define VMODE  vdimss[6]

# define Ax reg.x.ax
# define Bx reg.x.bx
# define Cx reg.x.cx
# define Dx reg.x.dx
# define Es sreg.es
# define int_souris(i)  Ax=i; int86(0x33,&reg,&reg)
# define int_souris_es(i) Ax=i; int86x(0x33,&reg,&reg,&sreg)

union  REGS reg;
struct SREGS sreg;

int	souris_ok() { /* Initialise souris et si bien install return 1 */
	int_souris(0);
	return(-Ax);
	}
	
void	souris_show() { /* Visualise curseur souris */
	int_souris(1);
	}

void souris_hide() { /* Cache curseur souris */
	int_souris(2);
	}
	
int	souris_posx() { /* Donne position curseur x */
	int_souris(3);
	return(Cx);
	}
	
int souris_posy() { /* Donne position curseur y */
	int_souris(3);
	return(Dx);
	}

void	set_pos(x,y) /* Positionne le curseur */
	int x,y; {
	Cx=x;
	Dx=y;
	int_souris(4);
	}
	
void	set_limites(xmin,ymin,xmax,ymax)
	int xmin,xmax,ymin,ymax; { /* Limite le curseur dans une fenetre */
	Cx=xmin;
	Dx=xmax;
     	int_souris(7);
     	Cx=ymin;
        Dx=ymax;
     	int_souris(8);
     }                                      

void change_mire(mire,ptx,pty) /* Change mire du curseur */
     int *mire;
     int ptx,pty; {
	long adr; 
	Bx=ptx;
	Cx=pty;
	adr= (long) mire;
	Dx= adr & 0xFFFF;
	Es= adr >> 16;
	int_souris_es(9);
	}
	
int	bouton(n) /* Bouton n: 1,2 ou 3 presse return 1*/
	int n; {
	int_souris(3);
	return((Bx >> (n-1)) % 2);
	}
	
void	souris_press(infor,bouton)	/* Retourne l'etat de la souris */
	int *infor,bouton; {		/* lors du dernier clic down	  */
	Bx=bouton;
	int_souris(5);
	infor[0]=Ax;
	infor[1]=Bx;
	infor[2]=Cx;
	infor[3]=Dx;
	}
	
void	souris_relach(infor,bouton)	/* Retourne l'etat de la souris */
	int *infor,bouton; {				/* lors du dernier clic up	  */
	Bx=bouton;
	int_souris(6);
	infor[0]=Ax;
	infor[1]=Bx;
	infor[2]=Cx;
	infor[3]=Dx;
	}
	
void info_souris(infor)	/* Retourne l'etat de la souris */
	int *infor; {
	int_souris(3);
	infor[1]=Bx;
	infor[2]=Cx;
	infor[3]=Dx;
	}

void step_souris(x,y)	/* Fixe le nombre de mickey par 8 pixels */
	int *x;
	int *y; {
	Cx=*x;
	Dx=*y;
	int_souris(15);
	}


vdisf_color(handle,cl)
int handle,cl;
	{	
	VCOLOR=cl;
	_setcolor(cl);
	}

vdi_bar(handle,pxy)
cnat handle,*pxy;
	{
	cnat y1,y2;

	_rectangle(VPLEIN,pxy[0],pxy[1],pxy[2],pxy[3]);
	}

vdisf_style(handle,no)
cnat handle,no;
	{
	_setfillmask(patern[no]);
	}

vdis_color()
	{
	}

vdiswr_mode(handle,mode)
cnat handle,mode;
	{
	}

vdisf_interior(handle,style)
cnat handle,style;
	{
	if ((style== SOLID)||(style==PATTERN))
	  VPLEIN= _GFILLINTERIOR;
	else
		VPLEIN= _GBORDER;
	}

gemappl_init()
	{
 	cnat i;
	struct videoconfig vco;

	for(i=0;i<8;i++) patern[DEN00][i]=(i%4)?0x0101:(i%2)?0x1001:0x8008;
	for(i=0;i<8;i++) patern[DEN01][i]=(i%2)?0x55:0xaa;
	for(i=0;i<8;i++) patern[DEN02][i]=(i%2)?0x66:0x99;
	for(i=0;i<8;i++) patern[DEN03][i]=(i%2)?0x3c:0xe7;
	for(i=0;i<8;i++) patern[DEN04][i]=0xff;
	_getvideoconfig(&vco);
	switch (vco.adapter)
	  { case _CGA: _setvideomode(_HRESBW);
		       printf("   CGA\n");
		       break;
	    case _HGC: _setvideomode(_HERCMONO);
		       printf("   HERCULES\n");
		       break;
	    case _EGA: switch (vco.monitor)
			 { case _COLOR   :
 			   case _ENHCOLOR: _setvideomode(_ERESCOLOR); break;
 			   case _ANALOG  : _setvideomode(_ERESCOLOR); break;
			   default       : _setvideomode(_ERESNOCOLOR); break;
        		 }
		       printf("   EGA\n");
		       break;	
 	    case _VGA: switch (vco.monitor)
			 { case _COLOR   :
 			   case _ENHCOLOR:
 			   case _ANALOG  : _setvideomode(_ERESCOLOR); break;
			   default       : _setvideomode(_ERESNOCOLOR); break;
        		 }
		       printf("   VGA\n");
		       break;	
	    default  : _setvideomode(_DEFAULTMODE); break;
	  }
	_getvideoconfig(&vco);

	RESOLX(NORES)=vco.numxpixels;
	RESOLY(NORES)=vco.numypixels;
/*      HTEXT=vco.numypixels/25; LTEXT=vco.numxpixels/80;	*/
	HTEXT=(vco.numypixels/vco.numtextrows)<<1;
	LTEXT=(vco.numxpixels/vco.numtextcols)<<1;
	_setlogorg(0,0);
	VPLEIN= _GFILLINTERIOR;
	_displaycursor(_GCURSOROFF);
	if(!souris_ok()) {printf("Pas de driver souris!\n");exit();}
	set_limites(0,0,RESOLX(NORES)-1,RESOLY(NORES)-1);
	change_mire(CURS_FLECHE);
	VCUR=0;
	get_tab_char(acc_path);
	VMODE=vco.adapter;
	if (vco.adapter & _VGA) VMODE=_EGA; 
	}

gemgraf_mouse(nb,ty)
cnat nb,*ty;
	{
	souris_ok();
	switch(nb)
		{
		case CGRAF:VCURSE=0;change_mire(CURS_CROIX);break;
		case CTEMP:VCURSE=5;change_mire(CURS_SABL);break;
		case CMENU:VCURSE=1;change_mire(CURS_FLECHE);break;
		case CKEYB:VCURSE=4;change_mire(CURS_DOIGT);break;
		default:VCURSE=1;
		}
	VCUR=0;
	}

gemgraf_handle()
	{
	}

gemGetrez()
	{
	return(NORES);
	}


gemappl_exit()
	{
	_setvideomode(_DEFAULTMODE);
	}

vdi_clswk(handle)
cnat handle;
	{
	}

vdist_point()
	{
	}

vdist_color(handle,cl)
int handle,cl;
	{
	VCOLOR=cl;
	_settextcolor(cl);
	}

vdisin_mode()
	{
	}

vdi_gtext(handle,x,y,str)
int handle,x,y;
char *str;
	{
	cnat xt,yt;
 
	if ((VMODE & _EGA)||(VMODE & _CGA))
	grf_text(x,y,VCOLOR,str);
	else
	{
	xt= (cnat)(x/ (LTEXT>>1)) + 1; /* +1 */
	yt= (cnat)(y/ (HTEXT>>1)) + 1; /* +1 */
	_settextposition(yt,xt);
	_outtext(str);
	}
	}

vdi_rfbox(handle,pxy)
int handle,*pxy;
	{
	_setcolor(NOIR);
	_rectangle(_GFILLINTERIOR,pxy[0],pxy[1],pxy[2],pxy[3]);
        _setcolor(VCOLOR);
	_rectangle(_GBORDER,pxy[0],pxy[1],pxy[2],pxy[3]);
	}

vdism_locator(handle,x,y,xa,ya,term)
int handle,x,y,*xa,*ya;
int *term;
	{
	cnat sinfo[4];

	info_souris(sinfo);
	if (sinfo[1]==4) sinfo[1]=3;
	*term=0x1f+sinfo[1];
	*xa=sinfo[2];
	*ya=sinfo[3];
	while(sinfo[1]) info_souris(sinfo);
	}

vdirq_string()
	{
	}

gemCrawcin()
	{
	char c;
	cnat result;

	c=0xff;
	while(kbhit()) c=getch();
	while(1)
	if (result=kbhit())
		{
		c=getch();
		if(!c)
			{
			c=getch();
			if (c==68) c=31;
			break;
			}
		if (c!=0xff) break;
		}
	if (c==0x0d) c='\n';
	if (c>0x7f) c=0x20;
	return(c);
	}

gemgraf_rubbox()
	{
	}

gemCursconf()
	{
	}

vdi_clrwk(handle)
int handle;
	{
	_clearscreen(_GCLEARSCREEN);
	}

vdi_opnwk(wi,handle,wo)
cnat *wi,*handle,*wo;
	{
	}

vdisf_perimeter()
	{
	}

vdisl_color(handle,in)
int handle,in;
	{
	VCOLOR=in;
	_setcolor(in);
	}

vdi_pline(handle,count,pxy)
int handle,count,*pxy;
	{
	cnat i;

	_moveto(pxy[0],pxy[1]);
	for(i=1;i<count;i++)
		_lineto(pxy[2*i],pxy[2*i+1]);
	}

vdi_coul(handle)
cnat handle;
	{
	cnat i,rgb[3];

        _remappalette(JAUNE,_LIGHTYELLOW);
        _remappalette(CROUGE,_LIGHTRED);
        _remappalette(BLEU,_BLUE);
        _remappalette(CBLEU,_LIGHTBLUE);
        _remappalette(CVERT,_LIGHTGREEN);
        _remappalette(ROUGE,_RED);
        _remappalette(VERT,_GREEN);
        _remappalette(GRIS,_WHITE);

        _remappalette(MAGEN,_MAGENTA);
        _remappalette(ROSE,_LIGHTMAGENTA);
        _remappalette(BLANC,_BRIGHTWHITE);
        _remappalette(NOIR,_BLACK);
        _remappalette(FCYAN,_CYAN);
        _remappalette(CYAN,_LIGHTCYAN);
        _remappalette(ORANGE,0x002a3f3f);
        _remappalette(BRUN,0x002a2a3f);

/*	blue[JAUNE]=0;green[JAUNE]=1000;red[JAUNE]=1000;
	blue[CROUGE]=0;green[CROUGE]=0;red[CROUGE]=1000;
	blue[BLEU]=500;green[BLEU]=0;red[BLEU]=0;
	blue[CBLEU]=1000;green[CBLEU]=0;red[CBLEU]=0;
	blue[CVERT]=0;green[CVERT]=1000;red[CVERT]=0;
	blue[VERT]=0;green[VERT]=500;red[VERT]=0;
	blue[ROUGE]=0;green[ROUGE]=0;red[ROUGE]=500;
	blue[GRIS]=500;green[GRIS]=500;red[GRIS]=500;
	blue[MAGEN]=500;green[MAGEN]=0;red[MAGEN]=500;
	blue[ROSE]=1000;green[ROSE]=250;red[ROSE]=1000;
	blue[BLANC]=1000;green[BLANC]=1000;red[BLANC]=1000;
	blue[NOIR]=0;green[NOIR]=0;red[NOIR]=0;
	blue[CYAN]=1000;green[CYAN]=1000;red[CYAN]=0;
	blue[FCYAN]=1000;green[FCYAN]=250;red[FCYAN]=0;
	blue[ORANGE]=0;green[ORANGE]=500;red[ORANGE]=1000;
	blue[BRUN]=0;green[BRUN]=250;red[BRUN]=1000;
	for(i=0;i<16;i++)
		{
		rgb[0]=red[i];rgb[1]=green[i];rgb[2]=blue[i];
		}
*/	}

vdirq_locator(handle,x,y,xf,yf,term)
cnat handle,x,y,*xf,*yf,*term;
	{
	vdi_show_c(handle,x,y);
	*term=0x1f;
	while(*term==0x1f)
	vdism_locator(handle,x,y,xf,yf,term);
	(*yf)+=(HTEXT>>1);
	}

vdi_show_c(handle,x,y)
cnat handle,x,y;
	{
	if (VCUR) souris_hide();
        set_pos(x,y);
	souris_show();
	VCUR=1;
	}

vdi_hide_c(handle)
cnat handle;
	{
	cnat i;
	if (!VCUR) return(0);
	souris_hide();
	VCUR=0;
	}

vdist_alignment(handle,mode1,mode2,t,y)
cnat handle,mode1,mode2,*t,*y;
	{
	}

vdi_get_pixel(handle,x,y)
cnat handle,x,y;
	{
	return(v_pixel(x,y));
	}

vdi_term()
	{
	fin();
	sys_fin();
	}

vdi_grap()
	{
	init();
	daffiche(LNDES(fbuf1),0);
	informe();
	}

