# include "include.h"
# include "edeclar.h"
# include "zeus.h"
# include "ndefine.h"

# include "incvdi.h"


static int	work_in[2][19];
static int	work_out[2][66];

int	contrl[12];
int	intin[128];
int	ptsin[128];
int	intout[128];
int	ptsout[128];

#include "vdix11.c"

/* calcule les deux coordonnees extremes d'un rectangle rentrant dans la fenetre a partir de x, y, dx, dy */
/* resultat dans le tableau pxy */
/* renvoie 1 sur erreur */
lot(x, y, dx, dy, cl, fen, pxy)
lnat x, y, dx, dy;
uchar cl;
fenetre *fen;
cnat *pxy;
{
	lnat tx, ty;
	register lnat temp;

	tx = (lnat)(fen->xo);
	temp = (x - xfen) >> (cnat)(zoom);
	tx += (temp * (lnat)(fen->res)) >> 1;
	if (tx > fen->xo + fen->dx) 
		return(1);
	ty = (lnat)(fen->yo);
	temp = (y - yfen) >> (cnat)(zoom);
	ty -= (temp * (lnat)(fen->res)) >> 1;
	if (ty < fen->yo - fen->dy) 
		return(1);
	temp = (x + dx - xfen) >> (cnat)(zoom);
	dx = (lnat)(fen->xo);
	dx += (temp * (lnat)(fen->res)) >> 1;
	temp = (y + dy - yfen) >> (cnat)(zoom);
	dy = (lnat)(fen->yo);
	dy -= (temp * (lnat)(fen->res)) >> 1;
	if (dx < fen->xo) 
		return(1);
	if (dy > fen->yo) 
		return(1);
	if (dx > fen->xo + fen->dx) 
		dx = (lnat)(fen->xo + fen->dx);
	if (dy < fen->yo - fen->dy) 
		dy = (lnat)(fen->yo - fen->dy);
	if (tx < fen->xo) 
		tx = (lnat)fen->xo;
	if (ty > fen->yo) 
		ty = (lnat)(fen->yo);
	pxy[0] = (int)tx >> 1;
	pxy[1] = (int)ty >> 1;
	pxy[2] = (int)dx >> 1;
	pxy[3] = (int)dy >> 1;
	return(0);
}


/* calcule les deux cordonnees extremes d'un rectangle rentrant dans la fenetre a partir de x, y, l, w, sens */
/* resultat dans le tableau pxy */
/* renvoie 1 sur erreur */
lotsymb(buf, i, cl, fen, pxy)
desc *buf;
cnat i;
uchar cl;
fenetre *fen;
cnat *pxy;
{
	lnat tx, ty, dx, dy;
	lnat x, y, w, l, niv;
	register lnat temp;

	x = LXSMB(buf, i);
	y = LYSMB(buf, i);
	l = LLSMB(buf, i);
	if (config->stick_diagram)
		w = 2;
	else
	 {
		w = LWSMB(buf, i);
	}
	niv = LNIVE(buf, i);
	tx = (lnat)(fen->xo);
	ty = (lnat)(fen->yo);
	dx = (lnat)(fen->xo);
	dy = (lnat)(fen->yo);
	if (TH___(buf, i)) {
		temp = (x - acc_ext(niv) - xfen) >> (cnat)(zoom);
		tx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y - (w >> 1) - yfen) >> (cnat)(zoom);
		ty -= (temp * (lnat)(fen->res)) >> 1;
		temp = (x + l + acc_ext(niv) - xfen) >> (cnat)(zoom);
		dx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y + (w >> 1) - yfen) >> (cnat)(zoom);
		dy -= (temp * (lnat)(fen->res)) >> 1;
	} else
	 {
		temp = (x - (w >> 1) - xfen) >> (cnat)(zoom);
		tx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y - acc_ext(niv) - yfen) >> (cnat)(zoom);
		ty -= (temp * (lnat)(fen->res)) >> 1;
		temp = (x + (w >> 1) - xfen) >> (cnat)(zoom);
		dx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y + l + acc_ext(niv) - yfen) >> (cnat)(zoom);
		dy -= (temp * (lnat)(fen->res)) >> 1;
	}
	if (tx > fen->xo + fen->dx) 
		return(1);
	if (ty < fen->yo - fen->dy) 
		return(1);
	if (dx < fen->xo) 
		return(1);
	if (dy > fen->yo) 
		return(1);
	if (dx > fen->xo + fen->dx) 
		dx = (lnat)(fen->xo + fen->dx);
	if (dy < fen->yo - fen->dy) 
		dy = (lnat)(fen->yo - fen->dy);
	if (tx < fen->xo) 
		tx = (lnat)fen->xo;
	if (ty > fen->yo) 
		ty = (lnat)(fen->yo);
	pxy[0] = (int)tx >> 1;
	pxy[1] = (int)ty >> 1;
	pxy[2] = (int)dx >> 1;
	pxy[3] = (int)dy >> 1;
	return(0);
}


/* calcule les deux cordonnees extremes d'un rectangle rentrant dans la fenetre a partir de x, y, l, w, sens */
/* resultat dans le tableau pxy */
/* renvoie 1 sur erreur */
lotfibre(buf, i, fen, pxy)
desc *buf;
cnat i;
fenetre *fen;
cnat *pxy;
{
	lnat tx, ty, dx, dy;
	lnat x, y, l;
	register lnat temp;

	x = LXSMB(buf, i);
	y = LYSMB(buf, i);
	l = LLSMB(buf, i);
	tx = (lnat)(fen->xo);
	ty = (lnat)(fen->yo);
	dx = (lnat)(fen->xo);
	dy = (lnat)(fen->yo);
	if (TH___(buf, i)) {
		temp = (x - xfen) >> (cnat)(zoom);
		tx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y - yfen) >> (cnat)(zoom);
		ty -= (temp * (lnat)(fen->res)) >> 1;
		temp = (x + l - xfen) >> (cnat)(zoom);
		dx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y - yfen) >> (cnat)(zoom);
		dy -= (temp * (lnat)(fen->res)) >> 1;
	} else
	 {
		temp = (x - xfen) >> (cnat)(zoom);
		tx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y - yfen) >> (cnat)(zoom);
		ty -= (temp * (lnat)(fen->res)) >> 1;
		temp = (x - xfen) >> (cnat)(zoom);
		dx += (temp * (lnat)(fen->res)) >> 1;
		temp = (y + l - yfen) >> (cnat)(zoom);
		dy -= (temp * (lnat)(fen->res)) >> 1;
	}
	if (tx > fen->xo + fen->dx) 
		return(1);
	if (ty < fen->yo - fen->dy) 
		return(1);
	if (dx < fen->xo) 
		return(1);
	if (dy > fen->yo) 
		return(1);
	if (dx > fen->xo + fen->dx) 
		dx = (lnat)(fen->xo + fen->dx);
	if (dy < fen->yo - fen->dy) 
		dy = (lnat)(fen->yo - fen->dy);
	if (tx < fen->xo) 
		tx = (lnat)fen->xo;
	if (ty > fen->yo) 
		ty = (lnat)(fen->yo);
	pxy[0] = (int)tx >> 1;
	pxy[1] = (int)ty >> 1;
	pxy[2] = (int)dx >> 1;
	pxy[3] = (int)dy >> 1;
	return(0);
}


/* calcule les deux coordonnees extremes d'une croix rentrant dans la fenetre a partir de x, y, dx, dy */
/* resultat dans le tableau pxy */
/* renvoie 1 sur erreur */
lotmotif(x, y, dx, dy, cl, fen, pxy)
lnat x, y, dx, dy;
uchar cl;
fenetre *fen;
cnat *pxy;
{
	lnat tx, ty, x1, y1, x2, y2, x3, y3, x4, y4;
	register lnat temp;

	tx = (lnat)(fen->xo);
	temp = (x - xfen) >> (cnat)(zoom);
	tx += (temp * (lnat)(fen->res)) >> 1;
	if (tx > fen->xo + fen->dx) 
		return(1);
	ty = (lnat)(fen->yo);
	temp = (y - yfen) >> (cnat)(zoom);
	ty -= (temp * (lnat)(fen->res)) >> 1;
	if (ty < fen->yo - fen->dy) 
		return(1);
	temp = (x + dx - xfen) >> (cnat)(zoom);
	dx = (lnat)(fen->xo);
	dx += (temp * (lnat)(fen->res)) >> 1;
	temp = (y + dy - yfen) >> (cnat)(zoom);
	dy = (lnat)(fen->yo);
	dy -= (temp * (lnat)(fen->res)) >> 1;
	if (dx < fen->xo) 
		return(1);
	if (dy > fen->yo) 
		return(1);
	x1 = x2 = tx;
	x3 = x4 = dx;
	y1 = y4 = dy;
	y2 = y3 = ty;
	if (dx > fen->xo + fen->dx) {
		temp = dx - fen->xo - fen->dx;
		x3 = x4 = dx - temp;
		y3 = ty - temp;
		y4 = dy + temp;
	}
	if (dy < fen->yo - fen->dy) {
		temp = fen->yo - fen->dy - dy;
		y1 = dy + temp;
		x1 = tx + temp;
		if (dy + temp > y4) {
			y4 = dy + temp;
			x4 = dx - temp;
		}
	}
	if (tx < fen->xo) {
		temp = fen->xo - tx;
		x2 = tx + temp;
		y2 = ty - temp;
		if (tx + temp > x1) {
			x1 = tx + temp;
			y1 = dy + temp;
		}
	}
	if (ty > fen->yo) {
		temp = ty - fen->yo;
		if (tx + temp > x2) {
			x2 = tx + temp;
			y2 = ty - temp;
		}
		if (dx - temp < x3) {
			x3 = dx - temp;
			y3 = ty - temp;
		}
	}
	if (x3 <= x1)
		pxy[0] = -1;
	else
	 {
		pxy[0] = (int)x1 >> 1;
		pxy[1] = (int)y1 >> 1;
		pxy[2] = (int)x3 >> 1;
		pxy[3] = (int)y3 >> 1;
	}
	if (x4 <= x2)
		pxy[4] = -1;
	else
	 {
		pxy[4] = (int)x2 >> 1;
		pxy[5] = (int)y2 >> 1;
		pxy[6] = (int)x4 >> 1;
		pxy[7] = (int)y4 >> 1;
	}
	return(0);
}


plot(x, y, dx, dy, cl, fen)
lnat x, y, dx, dy;
uchar cl;
fenetre *fen;
{
	cnat pxy[4];
	lnat tx, ty;

	if (lot(x, y, dx, dy, cl, fen, pxy)) 
		return(1);
	vdisf_color(fen->handle, (cnat)cl);
	vdi_bar(fen->handle, pxy);
	return(0);
}


plotsymb(buf, i, cl, fen)
desc *buf;
cnat i;
uchar cl;
fenetre *fen;
{
	cnat pxy[4];

	if (lotsymb(buf, i, cl, fen, pxy)) 
		return(1);
	vdisf_color(fen->handle, (cnat)cl);
	vdi_bar(fen->handle, pxy);
	return(0);
}


plotfibre(buf, i, cl, fen)
desc *buf;
cnat i;
uchar cl;
fenetre *fen;
{
	cnat pxy[4];

	if (lotfibre(buf, i, fen, pxy)) 
		return(1);
	vdisf_style(fen->handle, DEN04);
	vdisf_color(fen->handle, cl);
	vdi_pline(fen->handle, 2, pxy);
	return(0);
}


plotmotif(x, y, dx, dy, cl, fen)
lnat x, y, dx, dy;
uchar cl;
fenetre *fen;
{
	cnat pxy[8];

	if (lotmotif(x, y, dx, dy, cl, fen, pxy)) 
		return(1);
	vdisf_color(fen->handle, (cnat)cl);
	if (pxy[0] > -1)
		vdi_pline(fen->handle, 2, pxy);
	if (pxy[4] > -1)
		vdi_pline(fen->handle, 2, pxy + 4);
	return(0);
}


nomme(x, y, dx, dy, str, sens, coul)
lnat x, y, dx, dy;
char	*str;
cnat sens, coul;
{
	cnat pxy[4], pxy2[4], i, j;
	char	chaine[TAILLE_CHAINE];

	if (graph.res < 4) 
		return(1);
	if (lot(x, y, dx, dy, (uchar)0, &graph, pxy)) 
		return(1);
	i = (cnat)(((pxy[2] - pxy[0]) << 1) / LTEXT);
	strcpy(chaine, str);
	i = (i > strlen(chaine)) ? strlen(chaine) : i;
	chaine[i] = '\0';
	i = (pxy[2] - pxy[0] - (strlen(chaine) * (LTEXT >> 1))) >> 1;
	j = (pxy[1] - pxy[3] - (HTEXT >> 1)) >> 1;
	i = (i < 0) ? 0 : i;
	j = (j < 0) ? 0 : j;
	texte2((pxy[0] + i) << 1, graph.yo - ((pxy[1] - j) << 1), coul, chaine, &graph);
}


nommecon(buf, p)
desc *buf;
cnat p;
{
	cnat pxy[4];
	lnat x, y, l, w, xc, yc, dxc, dyc, i, xab, yab, dxab, dyab;
	uchar orient;
	char	nomc[TAILLE_CHAINE];

	if (graph.res < 4) 
		return(1);
	for (i = p; i >= 0; i--)
		if ((TNDES(buf, i)) && (NMOTI(buf, i)) && (NAB__(buf, i)))
			break;
	if ((i > -1) && (TTRAN(buf, i)))
		return(0);
	orient = LORIE(buf, p);
	x = LXSMB(buf, p);
	y = LYSMB(buf, p);
	strcpy(nomc, LNOME(buf, p));
	dxc = (strlen(nomc) * (LTEXT << 1)) / graph.res + 1;
	dyc = (HTEXT << 1) / graph.res + 1;
	if (TLL__(buf, p, 0))
		switch (orient) {
		case SUD :
			xc = x;
			yc = y - 1;
			w = LWSMB(buf, p) >> 1;
			break;
		case EST :
			xc = x + 1;
			yc = y;
			w = acc_ext(LNIVE(buf, p));
			break;
		case NORD :
			xc = x;
			yc = y + 1;
			w = LWSMB(buf, p) >> 1;
			break;
		case OUEST :
			xc = x - 1 - dxc;
			yc = y;

			w = acc_ext(LNIVE(buf, p));
			break;
		}
	else
	 {
		switch (orient) {
		case NORD :
			xc = x;
			yc = y - 1;
			l = acc_ext(LNIVE(buf, p));
			w = LWSMB(buf, p) >> 1;
			break;
		case OUEST :
			xc = x + 1;
			yc = y;
			l = LWSMB(buf, p) >> 1;
			w = acc_ext(LNIVE(buf, p));
			break;
		case SUD :
			xc = x;
			yc = y + 1;
			l = acc_ext(LNIVE(buf, p));
			w = LWSMB(buf, p) >> 1;
			break;
		case EST :
			xc = x - 1 - dxc;
			yc = y;
			l = LWSMB(buf, p) >> 1;
			w = acc_ext(LNIVE(buf, p));
			break;
		}
		if (i > -1) {
			yab = LYSMB(buf, i);
			dyab = LWSMB(buf, i);
			if ((yc < yab) && (y + l > yab))
				yc = yab;
			if ((yc + dyc > yab + dyab) && (y - l < yab + dyab)) {
				yc = yab + dyab - dyc;
				if ((yc < yab) && (y + l > yab)) {
					yc = yab;
				}
			}
			if ((yc >= yab) && (yc <= yab + dyab)) {
				xab = LXSMB(buf, i);
				dxab = LLSMB(buf, i);
				if ((xc < xab) && (x + w > xab))
					xc = xab;
				if ((xc + dxc > xab + dxab) && (x - w < xab + dxab)) {
					xc = xab + dxab - dxc;
					if ((xc < xab) && (x + w > xab) && (dxab > 0)) {
						xc = xab;
						dxc = dxab;
					}
				}
			}
		}
	}
	if (xc < 0)
		xc = 0;
	if (yc < 0)
		yc = 0;
	if (lot(xc, yc, dxc, dyc, (uchar)0, &graph, pxy)) 
		return(1);
	i = (cnat)(((pxy[2] - pxy[0]) << 1) / LTEXT);
	i = (i > strlen(nomc)) ? strlen(nomc) : i;
	nomc[i] = '\0';
	texte2(pxy[0] << 1, graph.yo - (pxy[1] << 1), BLANC, nomc, &graph);
}


interieur(n)
int	n;
{
	if (config->style != PATTERN) 
		n = DEN04;
	vdisf_style(graph.handle, n);
}


f_bloc(x, y, dx, dy, cl)
lnat x, y, dx, dy;
cnat cl;
{
	vdisf_interior(graph.handle, SOLID);
	plot(x, y, dx, dy, (uchar)cl, &graph);
	vdisf_interior(graph.handle, config->style);
}


g_bloc(x, y, dx, dy, cl)
lnat x, y, dx, dy;
cnat cl;
{
	cnat pxy[4];

	if (lot(x, y, dx, dy, (uchar)cl, &graph, pxy)) 
		return(1);
	vdisf_color(graph.handle, cl);
	vdisf_interior(graph.handle, HOLLOW);
	vdiswr_mode(graph.handle, TRANSP);
	vdi_bar(graph.handle, pxy);
	vdiswr_mode(graph.handle, REPLACE);
	vdisf_interior(graph.handle, config->style);
	return(0);
}


efface(x, y, dx, dy)
lnat x, y, dx, dy;
{
	f_bloc(x, y, dx, dy, NOIR);
}


g_init()
{
	cnat tres, d;

	gemappl_init();
	gemgraf_mouse(CGRAF, &d);
	graph.handle = gemgraf_handle(&d, &d, &d, &d);
	gemCursconf(0, 0);
	vdi_opnwk(work_in[0], &(graph.handle), work_out[0]);
# ifndef PC
	menu.handle = graph.handle;
# else
	vdi_opnwk(work_in[1], &(menu.handle), work_out[1]);
# endif
	info.handle = graph.handle;
	if (!graph.handle) { 
		gemappl_exit();
		exit(1);
	}
	vdi_hide_c(graph.handle);
	vdi_clrwk(graph.handle);
	vdi_coul(graph.handle);
	vdisf_interior(graph.handle, config->style);
	vdiswr_mode(graph.handle, REPLACE);
	vdist_alignment(graph.handle, HLEFT, VBOTTOM, &d, &d);
}


init()
{
	cnat tres, d1, d2, d3, d4, d;

	g_init();
	tres = gemGetrez();
	graph.xo = 0;
	graph.yo = ((RESOLY(tres) - 6) << 1) - HTEXT;
	y0ecran = graph.yo;
	graph.dx = (RESOLX(tres) - 1) << 1;
	graph.dy = ((RESOLY(tres) - 1 - 5) << 1) - HTEXT;
	info.xo = 0;
	info.yo = (RESOLY(tres) - 1) << 1;
	info.dx = (RESOLX(tres) - 1) << 1;
	info.dy = HTEXT + 8;
	menu.xo = ((RESOLX(tres) - 1) << 1) - 16 * LTEXT;
	menu.yo = ((RESOLY(tres) - 1 - 5) << 1) - HTEXT;
	menu.dx = 16 * LTEXT;
	menu.dy = ((RESOLY(tres) - 1 - 5) << 1) - HTEXT;
	graph.res = config->reso;
	info.res = config->reso;
	menu.res = config->reso;
	xfen = yfen = 0l;
	xmire = ymire = 2l;
	if (config->grille) grille();
}


cls(cl, fen)
uchar cl;
fenetre *fen;
{
	vdi_clrwk(graph.handle);
}


fin()
{
	int	rgb[3];

	vdi_clrwk(graph.handle);
	vdi_clswk(graph.handle);
	vdi_clswk(menu.handle);
	gemappl_exit();
	sys_fin();
}


texte2(x, y, cl, str, fen)
cnat x, y;
uchar cl;
char	*str;
fenetre *fen;
{
	cnat i = 0;

	while (str[i++] != '\0')
		str[i-1] = ((uchar)str[i-1] < 0x20) ? 0x20 : str[i-1];
	vdist_color(graph.handle, (int)cl);
	vdi_gtext(graph.handle, (fen->xo + x) >> 1, (fen->yo - y) >> 1, str);
}


init_menu()
{
	cnat pxy[4];

	pxy[0] = menu.xo >> 1;
	pxy[1] = menu.yo >> 1;
	pxy[2] = (menu.xo + menu.dx) >> 1;
	pxy[3] = (menu.yo - menu.dy) >> 1;
	cadre(pxy);
	fmenu = 1;
}


init_info()
{
	cnat pxy[4];

	vdi_hide_c(graph.handle);
	pxy[0] = info.xo >> 1;
	pxy[1] = info.yo >> 1;
	pxy[2] = (info.xo + info.dx) >> 1;
	pxy[3] = (info.yo - info.dy) >> 1;
	cadre(pxy);
}



cadre(pxy)
cnat *pxy;
{
	vdisf_interior(graph.handle, HOLLOW);
	vdisf_color(graph.handle, config->teinte[CADRE]);
	vdi_rfbox(graph.handle, pxy);
	vdisf_interior(graph.handle, config->style);
}


close_rect(pxy)
cnat *pxy;
{
	lnat x, y, lx, ly;
	cnat t;
	lnat nbd, xt, yt, xt1, yt1;
	cnat ti;
	cnat * de;
	fenetre g1;

	if (pxy[0] > pxy[2]) {
		t = pxy[0]; 
		pxy[0] = pxy[2]; 
		pxy[2] = t; 
	}
	if (pxy[3] > pxy[1]) {
		t = pxy[1]; 
		pxy[1] = pxy[3]; 
		pxy[3] = t; 
	}
	c_abs(&x, &y, pxy[0] << 1, pxy[1] << 1);
	c_abs(&lx, &ly, (pxy[2] << 1) + graph.res, (pxy[3] << 1) - graph.res);
	/*	y=yfen;*/
	lx = lx - x + 2l;
	ly = ly - y + 2l;
	de = (cnat * )fpil2;
	ti = 1023;
	nbd = LNDES(fbuf1);
	if (dvoisinage(nbd, 0, de, &ti, x, y, lx, ly)) {
		daffiche(nbd, 0);
	} else
	 {
		efface(x, y, lx, ly);
		if (!lot(x, y, lx, ly, (uchar)0, &graph, pxy)) {
			c_abs(&xt1, &yt1, pxy[0] << 1, pxy[1] << 1);
			g1.xo = graph.xo;
			g1.yo = graph.yo;
			g1.dx = graph.dx;
			g1.dy = graph.dy;
			graph.xo = pxy[0] << 1;
			graph.yo = pxy[1] << 1;
			graph.dx = (pxy[2] - pxy[0]) << 1;
			graph.dy = (pxy[1] - pxy[3]) << 1;
			xt = xfen;
			yt = yfen;
			xfen = xt1;
			yfen = yt1;
			laffiche(de, ti);
			xfen = xt;
			yfen = yt;
			graph.dx = g1.dx;
			graph.dy = g1.dy;
			graph.yo = g1.yo;
			graph.xo = g1.xo;
			blaffiche(de, ti);
		}
	}
}


close_menu()
{
	cnat pxy[4];
	lnat x, y, lx, ly;
	/*lnat nbd;*/

	vdi_hide_c(graph.handle);
	if (!fmenu) 
		return(1);
	pxy[0] = menu.xo >> 1;
	pxy[1] = menu.yo >> 1;
	pxy[2] = (menu.xo + menu.dx) >> 1;
	pxy[3] = (menu.yo - menu.dy) >> 1;
	close_rect(pxy);
	fmenu = 0;
	/* LNDES(fbuf1,nbd) chr*/
	/*daffiche(nbd,0);chr*/
}

/*********************************************************************************/
/*                                g2_souris                                      */
/* but : attend qu'un bouton de la souris soit presse, analyse le deplacement    */
/*       identique a g_souris sauf gestion supplementaire d'un cadre flottant    */
/*       (non supporte)                                                          */
/* parametre :                                                                   */
/*   flag : g_souris stocke dans ce parametre la zone de l'ecran cliquee         */
/*   stat : si != 0 indique la deuxieme saisie pour une fonction (permet de      */
/*          remettre a jour les dx et dy de la zone info du bas)                 */
/*   bl   : indique une saisie avec rubbox (cadre pendant le deplacement)        */
/*          ou non (si == SDEP)             */
/*********************************************************************************/
g2_souris(flag, stat, bl, indic)
cnat *flag, stat;
uchar bl;
char	*indic;
{
	cnat x1, x2, y1, y2, term;
	cnat r1, r2;
	uchar flg;

	/*if (bl == SDEP)*/
	return(g_souris(flag, stat, indic));

	/*	gemgraf_mouse(CGRAF,&term);
	term=0;
	*flag=0;
	c_rel(xmire,ymire,&x1,&y1);
	r1=x2=x1;
	r2=y2=y1;
	if (stat)
		{
			gsourisdx=xmire;
			gsourisdy=ymire;
		}
	vdi_show_c(graph.handle,x1,y1);
	while(1)
		{
			flg=0;
			rubbox(menu.handle,r1,r2,&x2,&y2,&term);
			ch=(char)term;
			if ((x1!=x2)||(y1!=y2))
				flg=1;
			x1=x2;
			y1=y2;
			if ((ch==0x20)||(ch==0x21)||(ch==0x22))
				{
					ch+=0x11;
					if (ch=='2') 
						if (y2>graph.yo)
							{
								ch='3';
								return(0);
							}
					if (y2<=graph.yo-graph.dy+2)
						*flag=6;
					else
						if (x2<=graph.xo)
							*flag=4;
						else
							if (x2>=graph.xo+graph.dx)
								*flag=5;
							else
								if (y2>=graph.yo)
									*flag=7; 
								else
									*flag=0;
				}
			if (flg)
				{
					if (!zoom)
						{
							if (x2%graph.res>(graph.res>>1))
								x2+=graph.res;
							if (y2%graph.res>(graph.res>>1))
								y2+=graph.res;
							x2-=x2%graph.res;
							y2-=y2%graph.res;
						}
					xmire=(lnat)((x2-graph.xo)<<zoom)/graph.res+(xfen>>1);
					if (xmire<0l)
						xmire=xfen>>1;
					if (y2<=graph.dy)
						ymire=(lnat)((graph.yo-y2)<<zoom)/graph.res+(yfen>>1);
					else
						ymire=yfen>>1;
					if (ymire<0l)
						ymire=yfen>>1;
					dxinfo(xmire-gsourisdx,ymire-gsourisdy,indic);
					vdi_show_c(graph.handle,x1,y1);
				}
# ifdef TIME
			info_time();
# endif
			if (ch>=0x31)
				{
					vdi_hide_c(graph.handle);
					break;
				}
	}
	return(0);
*/
}


rubbox(handle, x, y, xf, yf, t)
cnat handle, x, y, *xf, *yf, *t;
{
	cnat sinfo[10];
	cnat flg;
	static x1, y1;

	flg = 0;
	if (acc_souris)
		vdism_locator(menu.handle, x, y, xf, yf, t);
	else
		clavier1(*xf, *yf, xf, yf, t);
	if (*xf >= x) {
		sinfo[0] = x + graph.res;
		sinfo[2] = x;
		sinfo[4] = x;
	} else
	 {
		sinfo[0] = x - graph.res;
		sinfo[2] = x;
		sinfo[4] = x;
	}
	if (*yf <= y) {
		sinfo[1] = y;
		sinfo[3] = y;
		sinfo[5] = y - graph.res;
	} else
	 {
		sinfo[1] = y;
		sinfo[3] = y;
		sinfo[5] = y + graph.res;
	}
	if (x1 != sinfo[0]) { 
		x1 = sinfo[0]; 
		flg = 1;
	}
	if (y1 != sinfo[5]) { 
		y1 = sinfo[5]; 
		flg = 1;
	}
	if (*t > 0x1f) {
		sinfo[1] = y + graph.res;
		sinfo[3] = y - graph.res;
		sinfo[0] = x - graph.res;
		sinfo[2] = x + graph.res;
		close_rect(sinfo);
		flg = 0;
	} else
	 {
		if (flg) {
			sinfo[7] = y + graph.res;
			sinfo[9] = y - graph.res;
			sinfo[6] = x - graph.res;
			sinfo[8] = x + graph.res;
			close_rect(sinfo + 6);
			flg = 0;
		}
		vdisl_color(graph.handle, BLANC);
		vdi_pline(graph.handle, 3, sinfo);
	}
}


c_souris(pxy, xl, yl, step, mode)
cnat *pxy;
cnat xl, yl, step, mode;
{
	cnat x1, x2, y1, y2, term, p, q;

	gemgraf_mouse(CMENU, &term);
	term = 0;
	x1 = (pxy[0] << 1) + xl + DECXSOURIS;
	y1 = (pxy[1] << 1) - yl - DECYSOURIS;
	if (acc_souris) {
		vdirq_locator(menu.handle, x1 >> 1, y1 >> 1, &x2, &y2, &term);
		x2 <<= 1;
		y2 <<= 1;
	} else
	 {
		clavier2(x1, y1, &x2, &y2, &term);
		if (mode == FAUX)
			y2 += yl;
	}
	x1 -= DECXSOURIS;
	y1 += DECYSOURIS;
	q = ch = (char)term;
	if ((ch == 0x20) || (ch == 0x21))
		if (mode == VRAI) 
			p = ((y2 - y1) / step);
		else 
			p = ((x2 - x1) / step);
	if (mode == VRAI)
		if ((x2 < (pxy[0] << 1)) || (x2 > (pxy[2] << 1))) {
			ch = -1;
			return(2);
		}
	if (mode == FAUX)
		if ((y2 > (pxy[3] << 1)) || (y2 < (pxy[1] << 1))) {
			ch = -1;
			return(2);
		}
	if (mode) {
		if (y1 > y2) 
			p--;
	} else if (x1 > x2) 
		p--;
	ch = (char)p;
	if (q == 0x20) {
		gemgraf_mouse(CTEMP, &term);
		vdi_show_c(graph.handle, (graph.xo + (graph.dx >> 1)) >> 1, (graph.yo - (graph.dy >> 1)) >> 1);
		return(0);
	} else 
		return(q - 0x20);
}


c_abs(x1, y1, x2, y2)
lnat *x1, *y1;
cnat x2, y2;
{
	*x1 = (lnat)((((x2 - graph.xo) << 1) / graph.res) << zoom) + xfen;
	*y1 = (lnat)((((graph.yo - y2) << 1) / graph.res) << zoom) + yfen;
}


c_rel(x1, y1, x2, y2)
lnat x1, y1;
cnat *x2, *y2;
{
	*x2 = (cnat)((((x1 - xfen) * graph.res) >> zoom + 1) + graph.xo);
	*y2 = (cnat)(graph.yo - (((y1 - yfen) * graph.res) >> zoom + 1));
}



set_mire(xl, yl)
lnat xl, yl;
{
	cnat flag;

	flag = 0;
	if (xl < xfen) 
		flag = 1;
	if (yl < yfen) 
		flag = 2;
	if (xl > xfen + ((graph.dx) / graph.res) << zoom + 1) 
		flag = 4;
	if (yl > yfen + ((graph.dy) / graph.res) << zoom + 1) 
		flag = 3;
	xmire = xl;
	ymire = yl;
	if (flag) {
		xfen = xmire/*-((graph.dx/graph.res)<<zoom+1)*/;
		yfen = ymire/*-((graph.dy/graph.res)<<zoom+1)*/;
		if (xfen < 0l) 
			xfen = 0l;
		if (yfen < 0l) 
			yfen = 0l;
		daffiche(LNDES(fbuf1), 0);
		return(0);
	}
	return(1);
}


more(file)
char	*file;
{
	FILE * fp;
	cnat y, flag;
	char	str[80], mes[TAILLE_CHAINE];

	mes[0] = '\0';
	y = graph.dy - 2 * HTEXT;
	flag = 1;
	if ((fp = fopen(file, LTE)) == 0) 
		return(1);
	vdi_hide_c(graph.handle);
	vdi_clrwk(graph.handle);
	while (fgets(str, 80, fp)) {
		str[strlen(str)] = '\0';
		if (y < 0) {
			y = graph.dy - 2 * HTEXT;
			flag = 1;
			if (m_more(mes)) {
				flag = 0; 
				break;
			}
			vdi_hide_c(graph.handle);
			vdi_clrwk(graph.handle);
		}
		texte2(2 * LTEXT, y, config->teinte[INFO], str, &graph);
		y -= HTEXT; 		
	}
	if (flag)
		m_more(mes);
	vdi_clrwk(graph.handle);
	daffiche(LNDES(fbuf1), 0);
	informe();
	fclose(fp);
}



aff_mire(i)
int	i;
{
}


clavier1(x, y, xf, yf, term)
cnat x, y, *xf, *yf, *term;
{
	static char	old = 0;
	*xf = x;
	*yf = y;
	*term = 0x1f;

	saisie();
	if (ch != acc_rep) {
		if (ch == acc_left) 
			if (*xf >= graph.res) {
				old = ch;
				(*xf) -= graph.res;
			}
		if (ch == acc_right) 
			if (*xf < graph.dx + graph.xo) {
				old = ch;
				(*xf) += graph.res;
			}
		if (ch == acc_down) 
			if (*yf < graph.dy) {
				old = ch;
				(*yf) += graph.res;
			}
		if (ch == acc_up) 
			if (*yf >= graph.yo - graph.dy) {
				old = ch;
				(*yf) -= graph.res;
			}
	} else
	 {
		ch = old;
		if (ch == (acc_left )) 
			if (*xf >= graph.res * 4) 
				(*xf) -= graph.res * 4;
		if (ch == (acc_right)) 
			if (*xf < graph.dx + graph.xo - 4 * graph.res) 
				(*xf) += graph.res * 4;
		if (ch == (acc_down )) 
			if (*yf < graph.dy - 4 * graph.res) 
				(*yf) += graph.res * 4;
		if (ch == (acc_up )) 
			if (*yf >= graph.yo - graph.dy + 4 * graph.res) 
				(*yf) -= graph.res * 4;
	}
	if (ch == acc_c1) 
		(*term)++;
	if (ch == acc_c2) 
		(*term) += 2;
	if (ch == acc_c3) 
		(*term) += 3;
	if (*yf < 0) 
		*yf = 0;
	vdi_hide_c(graph.handle);
}


clavier2(x, y, xf, yf, term)
cnat x, y, *xf, *yf, *term;
{
	cnat pxy[4];

	*term = 0x1f;
	*xf = x;
	*yf = y;
	while (1) {
		vdi_show_c(graph.handle, x >> 1, y >> 1);
		clavier1(x, y, xf, yf, term);
		if (x > *xf) 
			*xf = x - LTEXT;
		if (x < *xf) 
			*xf = x + LTEXT;
		if (y > *yf) 
			*yf = y - HTEXT;
		if (y < *yf) 
			*yf = y + HTEXT;
		x = *xf;
		y = *yf;
		if (*term != 0x1f) 
			break;
	}
	*yf += (HTEXT >> 1);
}



