
# include "include.h" /* fichier d'include, de constantes, et de macros d'acces */
# include "stat.h" /* etat des fichiers */
# include "declar.h" /* variables globales */
# include "zeus.h" /* macros d'acces a la BD */
# include "ndefine.h" /* Constantes pour la netlist */

# include "incvdi.h" /* Constantes pour le graphisme */
# include "setup.c" /* gestionnaire du menu de setup et init du setup et ??? */

#ident "@(#)ap2alx : extracteur de netlist v2.11 19/02/92 by Vincent POUILLEY e-mail : pouilley@masi.ibp.fr"
# define LISA 1

# ifdef RT
# include "sysunix.c"
# endif

# ifdef PC
# include "sysmsdos.c"
# endif

# ifdef ATARI
# include "syscsh.c"
# endif 

# ifdef SUN
# include "sys42.c"
# endif

# ifdef NCR
# include "sysncr.c"
# endif

# ifdef UVAX
# include "sysultri.c"
# endif

# ifdef SM9
# include "sysunix.c"
# endif 


main(argc,argv)
int argc;
char **argv;
{
	char set[TAILLE_CHAINE];
	cnat i, er;
	cnat tempncr1, tempncr2;

# ifdef PC
	static desc s1[TMAX],s4[T2MAX+1];
	static cnat s3[4096];
	static char * s5[100];
	fbuf1= (desc *)s1;
	fbuf2= (char *)s4;
	fpil= (cnat *)s3;
	catal= (char **)s5;
# endif
        
	setup= &setupp;
	config= &(acc_conf);
	sprintf(set,"setupsmb3");
	if (chargir(setup,set))
		csetup();

# ifndef PC
	fbuf1=(desc *)ALLOC((lnat)(TMAX*sizeof(desc))); /* TMAX, T2MAX, LPILE sont definies dans include.h */
	fbuf2=(char *)ALLOC((lnat)(T2MAX*sizeof(desc)+sizeof(lnat)));
	fpil=(cnat *)ALLOC((lnat)(LPILE*sizeof(cnat)));
	catal=(char **)ALLOC((lnat)acc_nbcatal*sizeof(char *));
# endif

	fpil1=fpil+1024;
	fpil2=fpil1+1024;

	if ((fbuf1==NULL)||(fbuf2==NULL)||(fpil==NULL)) {printf("Allocation memoire impossible\n");exit(1);}

	if ( erreur(256,"")) { printf("Pas de fichier .mes\n");exit(1);}
	EABI_(fbuf1,-1);
	EDEBU(fbuf1,-1);
	ENDES(fbuf1,0);
	RSTAT;
	ASTAT(MODI,VRAI);
	puts("Alliance version 2.10 :   Extracteur de netlist externe\n");
	if ((argc < 3) || (strlen(argv[1]) != 1) || ((argv[1][0] != '1') && (argv[1][0] != 'h') && (argv[1][0] != 'f') && (argv[1][0] != 'H') && (argv[1][0] != 'F')))
		{
			usage(argv[0]);
			exit(0);
		}
	for (i = 2; i < argc; i++)
		{
			tempncr1 = strlen(argv[i]);
			tempncr2 = strlen(acc_suffphy);
			if ((strcmp(argv[i] + (tempncr1 - tempncr2),acc_suffphy) == 0) && (argv[i][tempncr1 - tempncr2 - 1] == '.'))
				argv[i][tempncr1 - tempncr2 - 1] = '\0';
			er=charger(fbuf1,argv[i]);
			if (er)
				printf("Erreur de chargement du fichier : %s.%s\n", argv[i], acc_suffphy);
			if (er==NF) printf("%s.%s:  nouveau fichier ??\n",argv[i],acc_suffphy);
			if (er==OVER) printf("Fichier %s.%s: depassement de capacite.\n",argv[i],acc_suffphy);
			if (er==BAD) printf("Fichier %s.%s: mauvais fichier.\n",argv[i],acc_suffphy);
			if (er==STP) printf("Fichier %s.%s: mauvais setup.\n",argv[i],acc_suffphy);
			if (er)
				continue;
			printf("Extraction de la netlist de %s en cours ...\n",argv[i]);
			strcpy(fichier,argv[i]);
			switch(argv[1][0])
				{
					case '1' :
						netlist_1();
						break;
					case 'h' :
					case 'H' :
						netlist_h();
						break;
					case 'f' :
					case 'F' :
						netlist_f();
						break;
				}
		}
	puts("C'est fini !!");
}

usage(nomprg)
char * nomprg;
{
	printf("usage : %s  1|h|f  f1  [f2 ...]\n",nomprg);
	puts ("   1 : pour l'extraction de la netlist d'un niveau hierarchique");
	puts ("   h : pour l'extraction de la netlist de chaque fichier de la hierarchie");
	puts ("   f : pour l'extraction de netlist sur le fichier mis a plat");
}

vu ()
{
}

/* Fonction recsymb */
/* cette fonction ecrit un segment (xs,ys,l,w,H/V) dans la BD symbolique a partir d'un rectangle (x,y,dx,dy) */
recsymb(buf,n,x,y,dx,dy)
desc * buf;
cnat n;
lnat x,y,dx,dy;
{
	lnat ext;

		ext = acc_ext(LNIVE(buf,n));
		if (x == -1)
			x = LX___(buf,n);
		if (y == -1)
			y = LY___(buf,n);
		if (dx == -1)
			dx = LDX__(buf,n);
		if (dy == -1)
			dy = LDY__(buf,n);
		if (dy > dx)
			{ /* sens vertical */
				EV___(buf,n);
				EXSMB(buf,n,(dx>>1)+x);
				EYSMB(buf,n,y+ext);
				EWSMB(buf,n,dx);
				ELSMB(buf,n,dy-(ext<<1));
			}
		else
			{ /* sens horizontal */
				EH___(buf,n);
				EXSMB(buf,n,x+ext);
				EYSMB(buf,n,(dy>>1)+y);
				EWSMB(buf,n,dy);
				ELSMB(buf,n,dx-(ext<<1));
			}
} /* recsymb */

info_time()
{
}
