/************************************************************************/
/* Marc TAMISIER - Gilles LEVEQUE					*/
/* ALLIANCE SYMBOLIQUE							*/
/* module d'extraction de capacites 					*/
/*									*/
/* Specifications							*/
/*	A partir d'un fichier PHYSIQUE (.AP) charge en memoire,ce module*/
/*	extrait pour tous les fichiers physiques de la hierarchie, et	*/
/*	ceci jusqu'aux cellules du catalogue, les fichiers LOGIQUES cor-*/
/*	respondants (.ALX) contenant en outre les capacites des signaux	*/
/*									*/
/* Algorithme general							*/
/*	0/ sauvegarde sur disque (BUFFE) du fichier en memoire		*/
/*	1/ a l'aide de l'extracteur de netlist (flattener), extraction  */
/*	de tous les modeles de la hierarchie jusqu`aux cellules du cata-*/
/*	logue comprises.						*/
/*	2/ pour chaque modele physique extrait:				*/
/*		- chargement du modele					*/
/*		- explicitation partielle du modele			*/
/*		- extraction d'equipotentielles physiques du modele	*/
/*		- extraction des capacites des equips du modele,stockees*/
/*		temporairement dans un fichier capa.tmp			*/
/*		- sauvegarde du fichier LOGIQUE (.ALX), et "append" du  */
/*		fichier capa.tmp au fichier logique.			*/
/*	3/ rechargement du fichier BUFFE				*/
/************************************************************************/

#define EXTERNE 0
#define INTERNE 1
#define VERSION_INTERNE

/*#define DEBUG*/

typedef float FLOTTANT;


#ifdef VERSION_INTERNE

# include "include.h"
# include "edeclar.h"
# include "zeus.h"
# include "stat.h"
# include "ndefine.h"
# include "extrcapa.h"

#define TABNET		((lnat *)fbuf2)
#define AD_RACINE 	TABNET[OFSOFS]
#define CATALOGUE	catal
#define BUFFER_DESC	fbuf1

#endif


#define NB_NIV_MAX	MAXNIV
#define CAPA_UNIT(n)	capa_unit[n]
#define T2MAX_POUR_NET	(lnat)((T2MAX*sizeof(desc))/sizeof(lnat))
#define MAXINST		1000
#define TREE		0
#define TEMPOFICH	"capa.tmp"

cnat	instance_net;
FLOTTANT *capa_unit;


#ifdef DEBUG
#define PRINT2(f,s) fprintf(stderr,f,s)
#else
#define PRINT2(f,s)
#endif

cnat EST_DANS_CATAL();
lnat PREM_INST_NET();
lnat NEXT_INST_NET();
char *LIRE_MODEL_NET();
lnat SURFACE();
lnat nb_equip();

/************************************************************************/
/* initialisation du tableau des capas unitaires			*/
/************************************************************************/
INIT_CAPA_UNIT()
{
	capa_unit=(FLOTTANT *)malloc(sizeof(FLOTTANT)*NB_NIV_MAX);
	CAPA_UNIT(GCONT)    = NONCAPA;
	CAPA_UNIT(GVIA)     = NONCAPA;
	CAPA_UNIT(GALU1)    = CAPA_UNIT_ALU1; /* aluminium 1 */
	CAPA_UNIT(GALU2)    = CAPA_UNIT_ALU2; /* aluminium 2 */
	CAPA_UNIT(GPOLY)    = CAPA_UNIT_POLY; /* polysilicium */
	CAPA_UNIT(GDIFN)    = CAPA_UNIT_DIFN; /* diffusion N */
	CAPA_UNIT(GDIFP)    = CAPA_UNIT_DIFP; /* diffusion P */
	CAPA_UNIT(TRSPPOLY) = NONCAPA;
	CAPA_UNIT(TRSPALU1) = NONCAPA;
	CAPA_UNIT(TRSPALU2) = NONCAPA;
	CAPA_UNIT(GCAISP)   = CAPA_UNIT_CAISP; /* caisson P */
	CAPA_UNIT(GCAISN)   = CAPA_UNIT_CAISN; /* caisson N */
	CAPA_UNIT(GNULL)    = NONCAPA;
}

/************************************************************************/
CHARGER_ALL_PHYS(nom)
char *nom;
{ cnat er;

	if (!(er=charger(BUFFER_DESC,nom))) return(VRAI);
	if (er==NF) PRINT2("%s:  nouveau fichier.\n",nom);
	if (er==OVER) PRINT2("Fichier %s: depassement de capacite.\n",nom);
	if (er==BAD) PRINT2("Fichier %s: mauvais fichier.\n",nom);
	if (er==STP) PRINT2("Fichier %s: mauvais setup.\n",nom);
	return(FAUX);
}

/************************************************************************/
SAUVER_ALL_PHYS(nom)
char *nom;
{
	if (!dstocker(BUFFER_DESC,nom,VRAI)) return(VRAI);
	PRINT2("Erreur a la sauvegarde de %s",nom);
	return(FAUX);
}

/************************************************************************/
SAUVER_ALL_LOG(nom)
char *nom;
{
	if (!dstock_log_capa(BUFFER_DESC,nom)) return(VRAI);
	PRINT2("Erreur a la sauvegarde de %s",nom);
	return(FAUX);
}

/************************************************************************/
CHARGER_CATAL(nom)
char *nom;
{
	if (!charge_catal(nom,CATALOGUE)) return(VRAI);
	PRINT2("Le fichier-catalogue %s n'existe pas.\n",nom);
}
 
/************************************************************************/
cnat EST_DANS_CATAL(nom)
char *nom;
{ cnat i;
	if (verif_transistor(nom,&i,&i))
		return(VRAI);
	for (i=1;i<=(cnat)CATALOGUE[0];i++)
	  if (CATALOGUE[i]==nom) return(VRAI);
	return(FAUX);
}

/************************************************************************/
ZOOM_PARTIEL_PHYS(nom)
char *nom;
{
	zgmmoins();
	zpar();
#ifndef V_EXTERNE
	erreur(12,"");
#endif
}

/************************************************************************/
ZOOM_TOTAL_CATAL_PHYS(nom)
char *nom;
{
	zgmmoins();
	zcatal();
#ifndef V_EXTERNE
	erreur(12,"");
#endif
}

/************************************************************************/
EXTR_PHYSIQUE(nom)
char *nom;
{
	extract();
}

/************************************************************************/
EXTR_LOGIQUE(nom)
char *nom;
{
	extra_logi();
}

/************************************************************************/
EXTR_HIERA()
{
	if (netlist(T2MAX_POUR_NET,(lnat)(TREE),TABNET,BUFFER_DESC))
	  return(FAUX);
	return(VRAI);
}

/************************************************************************/
lnat PREM_INST_NET()
{
	if (AD_RACINE >= TABNET[OFSFIN])
	  return(instance_net= -1l);
	return(instance_net=AD_RACINE);
}

/************************************************************************/
lnat NEXT_INST_NET()
{
	instance_net=instance_net + TABNET[OFSPAS];
	if (instance_net>=TABNET[OFSFIN])
	  return(instance_net = -1l);
	return(instance_net);
}

/************************************************************************/
char *LIRE_MODEL_NET(index1)
lnat index1;
{
	return((char *)TABNET[index1]);
}

/************************************************************************/
/* calcul de surface d'un descripteur					*/
/************************************************************************/
lnat SURFACE(dsc)
lnat dsc;
{ lnat dx,dy;
	dx = LDX__(BUFFER_DESC, dsc);
	dy = LDY__(BUFFER_DESC, dsc);
	return ((lnat)(dx * dy));
}
	
/************************************************************************/
/* denombrement des equipotentielle du modele en memoire		*/
/************************************************************************/
lnat nb_equip()
{ lnat nd, nbequ = 0;
	nd = LDEBU(BUFFER_DESC);
	do
		{
		if (TFEQU(BUFFER_DESC, nd)) 
			nbequ++;
		} while ((nd = LCHAI(BUFFER_DESC, nd)) != -1);
	return(nbequ);
}
	
/************************************************************************/
/* calcul des capacites associees a chaque equipotentielles		*/
/************************************************************************/
CAPALOG(model)
char *model;
{
lnat nd, eq, i;
char niv, flg;
FLOTTANT *tabeq;
char ** tabnomeq;
FILE *pf;
char * nomcon, nomconsauve[TAILLE_CHAINE], mes[TAILLE_MES], * vide;

	vide = (char *)namealloc("*");
	eq = nb_equip();
	tabeq = (FLOTTANT *) malloc(sizeof(FLOTTANT) * eq);
	tabnomeq = (char **) malloc(sizeof(char **) * eq);
	for (nd = 0; nd < eq; nd++)
		{
		tabeq[nd] = 0;
		tabnomeq[nd] = vide;
		}
	nd = LDEBU(BUFFER_DESC);
	flg = 1;
	eq = 0;
	strcpy(nomconsauve,"(%%Nom Vide%%)");
	do
	{
	if (NNDES(BUFFER_DESC, nd))
		{
		niv = LNIVE(BUFFER_DESC, nd);
		tabeq[eq] += SURFACE(nd) * CAPA_UNIT(niv);
		if (flg)
		{
			if (NES__(BUFFER_DESC, nd))
/*			if (TES__(BUFFER_DESC, nd))
			{
				if ((LNOME(BUFFER_DESC, nd)) != vide)
					tabnomeq[eq] = LNOME(BUFFER_DESC, nd);
			}
			else
*/
				if ((LNUEQ(BUFFER_DESC, nd)) != vide)
					tabnomeq[eq] = LNUEQ(BUFFER_DESC, nd);
		}
		if (TES__(BUFFER_DESC, nd))
			{
			if (TLL__(BUFFER_DESC,nd,0))
				{
				nomcon = LNOME(BUFFER_DESC,nd);
				if (flg)
					{
					tabnomeq[eq] = nomcon;
					flg = 0;
					}
				if (strcmp(nomcon,nomconsauve) != 0)
					if (strcmp(nomconsauve,"(%%Nom Vide%%)") == 0)
						strcpy(nomconsauve,nomcon);
					else
						{
						sprintf(mes,"%s & %s",nomcon,nomconsauve);
						erreur(42,mes);
						}
				}
/* Le champ num_equip n'est pas remplit pour les connecteurs. On s'en sert donc pour conserver le numero de l'equipotentielle sur laquelle le connecteur se trouve. */
			EBUEQ(BUFFER_DESC,nd,eq);
			}
		if (TFEQU(BUFFER_DESC, nd))
			{
			if (strcmp(nomconsauve,"(%%Nom Vide%%)") != 0)
				{
				for(i = 0; TES__(BUFFER_DESC,i); i++)
					if ((strcmp(LNOME(BUFFER_DESC,i),nomconsauve) == 0) && (LBUEQ(BUFFER_DESC,i) != eq))
						erreur(43,nomconsauve);
				strcpy(nomconsauve,"(%%Nom Vide%%)");
				}
			eq++;
			flg = 1;
			}
		}
	} while ((nd = LCHAI(BUFFER_DESC, nd)) != -1);
	if (!(pf=fopen(TEMPOFICH,ETE))) return(FAUX);
	for (nd=0;nd<eq;nd++)
		if (tabnomeq[nd] == vide)
			fprintf(pf,"S %d,%f,%d\n",nd,tabeq[nd],nd);
		else
			fprintf(pf,"S %d,%f,%s\n",nd,tabeq[nd],tabnomeq[nd]);
	fclose(pf);
	free (tabeq);
	free (tabnomeq);
}

/************************************************************************/
/* faire un zoom partiel sur toutes les instances n'appartenant pas au	*/
/* catalogue (zoom_partiel fait apparaitre les e/s,extract_phys retablie*/
/* la connectique)							*/
/************************************************************************/
les_zooms_1()
{
cnat i, j, sp;
char *model,flg=0;
char **pile;

	model=fichier;
	ZOOM_PARTIEL_PHYS(model);
	EXTR_PHYSIQUE(model);
	CAPALOG(model);
	SAUVER_ALL_LOG(model);
}

/************************************************************************/
/* faire un zoom partiel sur toutes les instances n'appartenant pas au	*/
/* catalogue (zoom_partiel fait apparaitre les e/s,extract_phys retablie*/
/* la connectique)							*/
/************************************************************************/
les_zooms_h()
{
cnat i, j, sp;
char *model,flg=0;
char **pile;

	pile=(char **)malloc(sizeof(char **)*MAXINST);
	pile[0]="";
	for (i=PREM_INST_NET(), sp=0; i!=-1; i=NEXT_INST_NET())
		{
		if (flg) model = LIRE_MODEL_NET(i);
		else     model = fichier;
		if (!EST_DANS_CATAL(model))
			{
			for (j=0; (j<sp) && (model!=pile[j]); j++);
			if (j==sp)
				{
				pile[sp++] = model;
				if (flg)
					{
					if (CHARGER_ALL_PHYS(model)==VRAI)
						{
						ZOOM_PARTIEL_PHYS(model);
						EXTR_PHYSIQUE(model);
						CAPALOG(model);
						SAUVER_ALL_LOG(model);
						}
					}
				else
					{
					ZOOM_PARTIEL_PHYS(model);
					EXTR_PHYSIQUE(model);
					CAPALOG(model);
					SAUVER_ALL_LOG(model);
					}
				}
			}
		flg=1;
		}
	free(pile);
}

/************************************************************************/
/* faire un zoom partiel sur toutes les instances n'appartenant pas au	*/
/* catalogue (zoom_partiel fait apparaitre les e/s,extract_phys retablie*/
/* la connectique)							*/
/************************************************************************/
les_zooms_f()
{
cnat i, j, sp;
char *model,flg=0;
char **pile;

	model=fichier;
	ZOOM_TOTAL_CATAL_PHYS(model);
	EXTR_PHYSIQUE(model);
	CAPALOG(model);
	SAUVER_ALL_LOG(model);
}

/************************************************************************/
/* extraction de la netlist du model (nom)				*/
/* obtenir un tableau (netlist) de toutes les instances de la hierarchie*/
/************************************************************************/
netlist_physique()
{
	/*if (CHARGER_ALL_PHYS(nom)==FAUX) return(FAUX);*/
	if (EXTR_HIERA()==FAUX) return(FAUX);
	return(VRAI);
}

FREE_CAPA_UNIT()
   {
	free(capa_unit);
   }

/************************************************************************/
/* module general							*/
/* extraction des .ALX recursive			*/
/************************************************************************/
netlist_h()
{
	SAUVER_ALL_PHYS("BUFFE");
	if (netlist_physique()==FAUX) return;
	CHARGER_ALL_PHYS("BUFFE");
	INIT_CAPA_UNIT();
	les_zooms_h();
	FREE_CAPA_UNIT();
#ifndef V_EXTERNE
	CHARGER_ALL_PHYS("BUFFE");
	urefresh();
#endif
}

/************************************************************************/
/* module general							*/
/* extraction du .ALX non recursive			*/
/************************************************************************/
netlist_1()
{
	SAUVER_ALL_PHYS("BUFFE");
	INIT_CAPA_UNIT();
	les_zooms_1();
	FREE_CAPA_UNIT();
#ifndef V_EXTERNE
	CHARGER_ALL_PHYS("BUFFE");
	urefresh();
#endif
}

/************************************************************************/
/* module general							*/
/* extraction du .ALX non recursive avec mise a plat			*/
/************************************************************************/
netlist_f()
{
	SAUVER_ALL_PHYS("BUFFE");
	INIT_CAPA_UNIT();
	les_zooms_f();
	FREE_CAPA_UNIT();
#ifndef V_EXTERNE
	CHARGER_ALL_PHYS("BUFFE");
	urefresh();
#endif
}

dstock_log_capa(buf,nom)
desc *buf;
char *nom  ;
{
	FILE *in,*in2;
	char nomfic[TAILLE_CHAINE];
	char strtmp[80];
	lnat temp=0;
	lnat j,m,a,h,n,s;
	lnat i, inst_avant;
	lnat cpil=0;
	lnat * de;
	
	if (verif_transistor(nom,&j,&j))
		{
		erreur(2,"");
		return(1);
		}
	for(i=0;i < acc_nbmotif;i++)
		if (strcmp(nom,acc_nmotif(i))==0)
			{
			erreur(2,"");
			return(1);
			}
	de=(lnat *)fpil;	
	sprintf(nomfic,"%s%s.%s",acc_pathfile,nom,acc_sufflog);
	if((in=fopen(nomfic,LTE))!= 0l)
		{
			fclose(in);
#ifndef V_EXTERNE
			erreur(55,nomfic);
			if(!(testchar("NNOY")))
				return(1);
#endif
			sprintf(strtmp,"%s%s.b%s",acc_pathfile,nom,acc_sufflog);
			sys_copy(nomfic,strtmp);
		}
	in=fopen(nomfic,ETE);
	if(!in)
		{
		erreur(29,"");
		return(1);
		}
	ENOMP(buf,nom);
	j = LABI_(buf);
	if (j > -1)
		ENOMB(buf,j,nom);
	temp = LNDES(buf);
	for (i=0;i<temp;i++)
		{
			if ((TBLOC(buf,i)) || (TES__(buf,i)) || (TTRAN(buf,i)))
				de[cpil++]=i;
		}
	if (fprintf(in,"V ALLIANCE 2.2 SETUP : %d\n",acc_version) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	sys_time(&j,&m,&a,&h,&n,&s);
	if (fprintf(in,"H %s,L,%2d/%2d/%d,%d\n",nom,j,m,a,cpil) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	inst_avant = -1;
	for(i=0;i<cpil;i++)
		{
			if (TBLOC(buf,de[i]))
				{
				if (fprintf(in,"I %s,%s\n",LNOMB(buf,de[i]),LNOPR(buf,de[i])) == EOF)
					{
					erreur(29,"");
					fclose(in);
					return(1);
					}
				inst_avant = de[i];
				}
			else
				if (TTRAN(buf,de[i]))
					{
					inst_avant = -1;
					verif_transistor(LNOMB(buf,de[i]),&j,&m);
					h = LBUEQ(buf,de[i+1]);
					n = LBUEQ(buf,de[i+2]);
					s = LBUEQ(buf,de[i+3]);
					if (fprintf(in,"T %c,%d,%d,%d,%d,%d\n", (LNOMB(buf,de[i]))[1], j>>1, m>>1, s, n, h) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					i+= 4;
					}
				else
					if (TES__(buf,de[i]))
						{
						m = LBUES(buf,de[i]);
						n = LBUEQ(buf,de[i]);
						for(j = inst_avant+1, h = 0; j < de[i]; j++)
							{
							a = LBUES(buf,j);
							if (a == m)
								{
								if (LBUEQ(buf,j) != n)
									erreur(43,LNOME(buf,de[i]));
								else
									h = 1;
								}
							}
						if (h)
							continue;
						if (fprintf(in,"C %s,",LNOME(buf,de[i])) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						if (TSERV(buf,de[i]))
							{
							if (fputs("INOUT,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							}
						else
							if (TENTR(buf,de[i]))
								{
								if (fputs("IN,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								}
							else
								if (TSORT(buf,de[i]))
									{
									if (fputs("OUT,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									}
								else
									{
									if (fputs("XXX,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									}
						if (fprintf(in,"%d\n",LBUEQ(buf,de[i])) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
		} /* for */
	if (in2=fopen(TEMPOFICH,LTE))
	  { while (!(feof(in2)))
	      { if (fgets(strtmp,80,in2)==NULL) break;
		if (fputs(strtmp,in) == EOF)
			{
			erreur(29,"");
			fclose(in2);
			return(1);
			}
	      }
	    fclose(in2);
	  }
	if (fputs("EOF\n",in) == EOF)
		{
		erreur(29,"");
		fclose(in2);
		return(1);
		}
	fclose(in);
	ASTAT(MODI,VRAI);
	return(0);
}
