# include "include.h"
# include "edeclar.h"
# include "zeus.h"
# include "stat.h"
# include "ndefine.h"

/* fichier de gestion du cache des bounding box et des abutment box des instances */

/* variable de gestion du cache */
lnat maxcache=0;
lnat taillecache=0;

/* constante definissant le pas d'allocation */
#define TAILLEPAS 10

/*********************************************************/
/* Le cache est gere comme un tableau de taille variable */
/* les fonctions suivantes sont fourni pour la gestion : */
/* cherche_bbab : cherche un element                     */
/* ajout_bbab : ajoute un element                        */
/* eff_bbab : efface le cache                            */
/*********************************************************/

/*------------------- cherche bbab -----------------*/
type_bbab * cherche_bbab(nom)
char * nom;
{
	lnat i;

	nom=(char *)namealloc(nom);
	for(i=0;i<maxcache;i++)
		if (cache_bbab[i].nom==nom)
			return(cache_bbab + i);
	return(NULL);
} /* cherche bbab */

/*---------------------- ajout bbab ---------------------*/
ajout_bbab(nom,xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab)
char * nom;
lnat xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab;
{
	if(cherche_bbab(nom)!=NULL)
		return;
	if (cache_bbab == NULL)
		cache_bbab = (type_bbab *)ALLOC(sizeof(type_bbab) * (taillecache = TAILLEPAS));
	else
		if(taillecache <= maxcache)
			cache_bbab = (type_bbab *)realloc(cache_bbab,sizeof(type_bbab) * (taillecache+=TAILLEPAS));
	cache_bbab[maxcache].nom  = (char *)namealloc(nom);
	cache_bbab[maxcache].xbb  = xbb;
	cache_bbab[maxcache].ybb  = ybb;
	cache_bbab[maxcache].dxbb = dxbb;
	cache_bbab[maxcache].dybb = dybb;
	cache_bbab[maxcache].xab  = xab;
	cache_bbab[maxcache].yab  = yab;
	cache_bbab[maxcache].dxab = dxab;
	cache_bbab[maxcache].dyab = dyab;
	maxcache++;
}

/*---------------------- eff_bbab -------------------*/
eff_bbab()
{
	if (cache_bbab != NULL)
		{
		free(cache_bbab);
		cache_bbab=NULL;
		}
	maxcache=0;
	taillecache=0;
}
