
/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur Logique                                       */
/*    Fichier :  sl_main.c                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 08/01/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "mut309.h"
#include "log120.h"
#include "beh104.h"

#include "../menu/sl_corps.h"
#include "../ablorder/sl_order.h"
#include "../param/sl_param.h"
#include "sl_type.h"
#include "sl_system.h"
#include "../compil/sl_util.h"

main(argc,argv)
int argc ;
char *argv[];
{
ptype_list *delayPI;
char *genNAME();
char *name;
int trace;

sl_sys = initializeSystem();

		/* verification de la validite des arguments */

if (!verifArgs(sl_sys,argc,argv)) exit(-1);


initializeBdd(1);
		/* initialisation selon le mode (batch ou non) */

if (!strcmp(argv[1],"-d") || !strcmp(argv[1],"-o") ||
    !strcmp(argv[1],"-m") || !strcmp(argv[1],"-n") || !strcmp(argv[1],"-c"))
   {

		/* initialisation du systeme */

   addInfoSystem(sl_sys,1,argc,argv,"Logic Synthesis - V 2.17");
   saveParam(sl_sys,SL_PARAM);
   displaySystem(sl_sys);
   trace = 1;
   if (SL_TRACE == 2)
      trace = 2;
   if (SL_OPTION == 'm' || SL_OPTION == 'c')
      {
      if (compileVHDL(SL_VHDL,SL_ORDERPI,SL_ORDER,SL_PAR,
                                    SL_AUX,1,1,0,trace,nameInt,SL_LATCHES) == NULL)
         {
         printf("*** Compilation aborted...\n");
         exit(-1);
         }
      }
   else
      {
      if (compileVHDL(SL_VHDL,SL_ORDERPI,SL_ORDER,SL_PAR,
                                    SL_AUX,1,2,1,trace,nameInt,SL_LATCHES) == NULL)
         {
         printf("*** Compilation aborted...\n");
         exit(-1);
         }
      }


   SL_BEH = VHB_HEDFIG;


		/* verification de la coherence */

   verifCohBeh(SL_BEH,SL_DELAYPI,SL_OPTIMPO);

   if (SL_TRACE)
      displayBeh(SL_BEH,1);

   if (SL_OPTION == 'd')
      {
      anealingFOOD(SL_AUX,SL_TRACE);

                                /* sauvegarde du fichier */ 
 
      decompileVHDL(SL_BEH,genNAME("%sd",SL_BEH->NAME),MBK_WORK_LIB,1);
      }
   else
      {
      if (SL_OPTION == 'o' || SL_OPTION == 'n')
 	{
        anealingFOOD(SL_AUX,SL_TRACE);
        if (SL_OPTION == 'o')
           mappingSC();
        else
           mappingC4();

                                /* sauvegarde du fichier */ 
 
        if (SL_OPTION == 'o')
           decompileVHDL(SL_BEH,genNAME("%so",SL_BEH->NAME),MBK_WORK_LIB,0);
        else
           decompileVHDL(SL_BEH,genNAME("%sn",SL_BEH->NAME),MBK_WORK_LIB,0);
        }
      else
        {
		/* elimination des DC */

        removeDCBeh(SL_BEH);
        mapCarExprBeh(SL_BEH,simplif10Expr);

        if (SL_OPTION == 'm')
           mappingSC();
        else
           mappingC4();

                                /* sauvegarde du fichier */ 
 
        if (SL_OPTION == 'm')
           decompileVHDL(SL_BEH,genNAME("%sm",SL_BEH->NAME),MBK_WORK_LIB,0);
        else
           decompileVHDL(SL_BEH,genNAME("%sc",SL_BEH->NAME),MBK_WORK_LIB,0);
        }
      }
   }
else
   {
		/* version interactive */

   if (argc == 2 || (argc == 3 && !strcmp(argv[2],"relax")))
      {
      if (argc == 3 && !strcmp(argv[2],"relax"))
         {
         addInfoSystem(sl_sys,0,argc,argv,
                       "Logic Synthesis Integrator - V 1.00");
         }
      else
         {
         addInfoSystem(sl_sys,0,argc,argv,
                       "Logic Synthesis - V 2.17");
         }
      }
   else
		/* avec fichier de parametres */

      addInfoSystem(sl_sys,2,argc,argv,
                    "Logic Synthesis - V 2.17");

   BVL_LINNUM = 0;
   if (argc == 3 && !strcmp(argv[2],"relax"))
      PRINCIPAL(0);
   else
      PRINCIPAL(1);
   }
printf("\n");
exit(0);
}
