#include "mut309.h"
#include "beh104.h"
#include "../synthe/sl_type.h"
#include "../compil/sl_util.h"
#include "../ablorder/sl_order.h"
#include "../menu/sl_corps.h"
#include "sl_param.h"
#include "string.h"

/*----------------------------------------------------------------------------
verifLoadParam	: verifie l'appartenance des entrees retardees et des sorties 
                  a optimiser dans la befig.
------------------------------------------------------------------------------
retour		: 0 si mauvaises entrees ou sorties
		  1 si OK
------------------------------------------------------------------------------*/

int verifLoadParam(beh,par)
befig_list *beh;
sl_param *par;
{
chain_list *optimPO = par->optimPO;
ptype_list *delayPI = par->delayPI;
berin_list *in = beh->BERIN;

while (optimPO)
   {
   if (!existOutputBeh(beh,optimPO->DATA))
      return(0);
   optimPO = optimPO->NEXT;
   }
while (delayPI)
   {
   if (!existInputBeh(beh,delayPI->DATA))
      return(0);
   delayPI = delayPI->NEXT;
   }

if (delayPI == NULL) 
   return(1);

while (in)
   {
   if (!inChain_list (par->delayPI,in->NAME))
      return(0);
   in = in->NEXT;
   }
return(1);
}

/*----------------------------------------------------------------------------
loadParam	: charge le fichier de parametres dans sa structure de donnees
------------------------------------------------------------------------------
retour		: 2 si mauvais nom de fichier,
		  1 si probleme de fichier, 0 si OK
------------------------------------------------------------------------------*/

int   	       	 loadParam( sl, FileName )
sl_system	*sl;
char		*FileName;

{
FILE	*Pfile;
char	 c;
char     Auxiliaire[ 30 ];
char	*Name;
long	 Delay;
befig_list *beh = sl->beh;

if (( Pfile = fopen(FileName, "rt" )) != NULL ) 
	{
        resetParam(sl->par);

	fscanf( Pfile, "%d", &((sl->par)->optim) );

	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	fscanf( Pfile, "%d", &((sl->par)->aux) );

	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	fscanf( Pfile, "%d", &((sl->par)->auxOF) );

	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	fscanf( Pfile, "%d", &((sl->par)->level) );

	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );                     /* lecture de '\n'         */
	c = fgetc( Pfile );			/* lecture 1er car suivant */
	while ( c != '*' ) {
		ungetc( c, Pfile );
		fscanf( Pfile, "%s%d", Auxiliaire, &Delay );
		Name = namealloc( Auxiliaire);
		(sl->par)->delayPI = addptype((sl->par)->delayPI, Delay, Name );
		c = fgetc( Pfile );		/* lecture de \n           */
		c = fgetc( Pfile );		/* lecture 1er car suivant */
		if ( feof(Pfile)) {
			fclose( Pfile );
			return (1);
			}
		};

	c = fgetc( Pfile );			/* lecture de \n           */
	c = fgetc( Pfile );			/* lecture 1er car suivant */
/*
        printf("sorties a optimiser\n");
*/
	while ( c != '*' ) {
		ungetc( c, Pfile );
		fscanf( Pfile, "%s", Auxiliaire );
		Name = namealloc( Auxiliaire);
/*
                printf("%s ,",Name);
*/
		(sl->par)->optimPO = addchain((sl->par)->optimPO, Name );
		c = fgetc( Pfile );		/* lecture de \n           */
		c = fgetc( Pfile );		/* lecture 1er car suivant */
		if ( feof(Pfile)) {
			fclose( Pfile );
			return (1);
			}
		};


	c = fgetc( Pfile );			/* lecture de \n           */
	fscanf( Pfile, "%d", &((sl->par)->numTransN ));
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );			/* lecture de '*'          */

	c = fgetc( Pfile );			/* lecture de \n           */
	fscanf( Pfile, "%d", &((sl->par)->numTransP ));
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );			/* lecture de \n          */

	c = fgetc( Pfile );			/* lecture de \n           */
	fscanf( Pfile, "%d", &((sl->par)->numCanN ));
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );			/* lecture de '*'          */

	c = fgetc( Pfile );			/* lecture de \n           */
	fscanf( Pfile, "%d", &((sl->par)->numCanP ));
	c = fgetc( Pfile );			/* lecture de '*'          */
	c = fgetc( Pfile );			/* lecture de \n          */

	fclose( Pfile );
	(sl->par)->delayPI = (ptype_list*) reverse((sl->par)->delayPI); 
	(sl->par)->optimPO = reverse((sl->par)->optimPO);

        return(0);
	}
else
   return(2);
}


/*----------------------------------------------------------------------------
saveParam	: enregistre la structure de donnees dans le fichier 
------------------------------------------------------------------------------
retour		: aucun
------------------------------------------------------------------------------*/
void		saveParam( sl1, FileName )
sl_system	*sl1; 
char		*FileName;

{
FILE	*Pfile;
chain_list *optimPO;
ptype_list *delayPI;

Pfile = fopen( FileName,"wt" );

fprintf( Pfile, "%d\n*\n%d\n*\n%d\n*\n%d\n*\n", (sl1->par)->optim,(sl1->par)->aux,(sl1->par)->auxOF,(sl1->par)->level );

delayPI = (sl1->par)->delayPI;
while (delayPI) 
   {
   fprintf( Pfile, "%s %d\n", delayPI->DATA, delayPI->TYPE );
   delayPI = delayPI->NEXT;
   }
fprintf( Pfile, "*\n");

optimPO = (sl1->par)->optimPO ;
while ( optimPO)
	{ 
	fprintf( Pfile, "%s\n", optimPO->DATA );
	optimPO = optimPO->NEXT;
	}
fprintf( Pfile, "*\n");

fprintf( Pfile, "%d\n*\n", (sl1->par)->numTransN );
fprintf( Pfile, "%d\n*\n", (sl1->par)->numTransP );
fprintf( Pfile, "%d\n*\n", (sl1->par)->numCanN );
fprintf( Pfile, "%d\n*\n", (sl1->par)->numCanP );

fclose(Pfile);
}

/*---------------------------------------------------------------------------
listeDe		: fait un "ls" en colonnes des fichiers d'un type donne
-----------------------------------------------------------------------------
retour		: aucun
---------------------------------------------------------------------------*/

void	listeDe( path, typeFic )
char  	*path, *typeFic ;

{
char	*commande = (char*) mbkalloc( 100 );

strcpy( commande, "ls -C ");
if (!strcmp(path,"."))
   strcat(commande,"*.");
else
   {
   strcat(commande,path);
   strcat(commande,"/*.");
   }
printf("List of files '.%s' in '%s' :\n\n", typeFic,path );
system( strcat( commande, typeFic) );
#ifndef LEO
   mbkfree(commande);	/* chaine */
#endif
}

/*-----------------------------------------------------------------------------
ligne1		: renvoie la premiere chaine d'un fichier donne
-------------------------------------------------------------------------------
retour		: un char*  ( NULL si le fichier n'existe pas )
-----------------------------------------------------------------------------*/

char	*ligne1( fileName )
char	*fileName;

{
FILE	*Pfile;
char	*chaine = (char*) mbkalloc ( 30 );

if ( Pfile = fopen( fileName, "rt" ) ) {
	fscanf( Pfile, "%s", chaine );
	fclose( Pfile );
	return ( chaine );
	}
else {
	return ( NULL );
	}
}
	

/*----------------------------------------------------------------------------
afficheIOi	: affiche en colonnes les entrees+index donnees par une LC 
------------------------------------------------------------------------------
retour		: aucun
----------------------------------------------------------------------------*/ 

int		 afficheIOi( IOi, nbCol, nbLig, ligneDepart )
chain_list	*IOi;
int		 nbCol;
int		 nbLig;
int		 ligneDepart;

{
int 		 count = 0;
chain_list	*auxiliaire;
int		 largeurCol;
int		 currentCol = 1;
int		 currentLig = ligneDepart;
 
while ( nbCol*nbLig < countChain_list( IOi ) )  nbCol++;

count = 2;
largeurCol = 80/nbCol;
while ( IOi )  {
	while ( (currentLig<(nbLig+ligneDepart)) && (IOi!=NULL) ) {
		gotolc( currentLig, currentCol );
		printf(" %.2d",count++);
		printf(" %s",IOi->DATA);
		IOi = IOi->NEXT;
		currentLig++;
		}
	currentCol += largeurCol;
	currentLig = ligneDepart;
	};
return ( nbCol );
}


/*-----------------------------------------------------------------------------
tempo 		: boucle de temporisation
-------------------------------------------------------------------------------
retour		: aucun
-----------------------------------------------------------------------------*/
void		tempo( t )
unsigned long	t;
{
unsigned long	i;
for( i=0; i<t; i++ );
}


/*-----------------------------------------------------------------------------
ModifOrder	: Modification de la LC des entrees (ie Modification des index)
-------------------------------------------------------------------------------
retour		: aucun
-----------------------------------------------------------------------------*/
void		  ModifOrder( orderPI, origIndex, destIndex )
chain_list	 *orderPI;
int		  origIndex;
int		  destIndex;

{
chain_list	*pti;
chain_list	*ptj;
chain_list	*ptk;
char		*dataAux = (char*) mbkalloc( 30 );
int 		 count = 2;
char	c;

pti = (chain_list *)mbkalloc(sizeof(chain_list));
ptj = (chain_list *)mbkalloc(sizeof(chain_list));
ptk = (chain_list *)mbkalloc(sizeof(chain_list));

if (destIndex == origIndex ) return;
if (destIndex >  origIndex ) destIndex++;

if (destIndex == 2) {
	ModifOrder( orderPI, origIndex, 3);
	dataAux = (char *)orderPI->DATA;
	orderPI->DATA = orderPI->NEXT->DATA;
	orderPI->NEXT->DATA = (void *)dataAux;
	return;
	}
	
if (origIndex == 2) {
	dataAux = (char *)orderPI->DATA;
	orderPI->DATA = orderPI->NEXT->DATA;
	orderPI->NEXT->DATA = (void *)dataAux;
	ModifOrder( orderPI, 3, destIndex -1);
	return;
	}
	

ptk->NEXT = pti = ptj = orderPI;


while ( count != destIndex ) {
	ptk = ptk->NEXT;
	pti = pti->NEXT;
	count++;
	}
count = 2;
while ( count != origIndex ) {
	ptj = ptj->NEXT;
	count++;
	}

if ( destIndex == 2 ) {
/*	orderPI = addchain( orderPI, ptj->DATA );
	orderPI = delchain( orderPI, ptj );
	return (orderPI );
*/
	}

delchain( orderPI, ptj );

ptj->NEXT = pti;
ptk->NEXT = ptj;
return ;
}

/*-----------------------------------------------------------------------------
addchain_alpha	: Insertion d'un element de LC dans l'ordre alphabetique
-------------------------------------------------------------------------------
retour		: un chain_list*
-----------------------------------------------------------------------------*/
chain_list	*addchain_alpha( LC, data )
chain_list	*LC;
char		*data;
{
chain_list	*LC_aux;
data = namealloc( data );

LC_aux = LC;
 
if ( LC_aux == NULL ) return( addchain( NULL, data));

if (strcmp( data,LC_aux->DATA) < 0 )
	return( addchain( LC_aux, data));
	
while ( LC_aux->NEXT ){
	if ( strcmp(data,LC_aux->NEXT->DATA) < 0 ) {
		LC_aux->NEXT = addchain( LC_aux->NEXT, data);
		return( LC );
		}
	LC_aux = LC_aux->NEXT;
	}

LC_aux->NEXT = addchain( LC_aux->NEXT, data);
return( LC );
}


/*-----------------------------------------------------------------------------
addptype_alpha	: Insertion d'un element de LC typee dans l'ordre alphabetique
-------------------------------------------------------------------------------
retour		: un ptype_list*
-----------------------------------------------------------------------------*/
ptype_list	*addptype_alpha( LC, data, type )
ptype_list	*LC;
char		*data;
long		 type;
{
ptype_list	*LC_aux;
data = namealloc( data );

LC_aux = LC;
 
if ( LC_aux == NULL ) return( addptype( NULL, type, data ));

if (strcmp( data,LC_aux->DATA) < 0 )
	return( addptype( LC_aux, type, data));
	
while ( LC_aux->NEXT ){
	if ( strcmp(data,LC_aux->NEXT->DATA) < 0 ) {
		LC_aux->NEXT = addptype( LC_aux->NEXT, type, data );
		return( LC );
		}
	LC_aux = LC_aux->NEXT;
	}

LC_aux->NEXT = addptype( LC_aux->NEXT, type, data );
 
return( LC );
}
/*--------------------------------------------------------------------------
delMaillon	: detruit un mailon dont la donnee est DATA dans une LC
----------------------------------------------------------------------------
retour		: le pointeur de la LC traitee
--------------------------------------------------------------------------*/
chain_list	*delMaillon( LC, data )
chain_list	*LC;
char		*data;
{
chain_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( strcmp(LC_aux->DATA, data) == 0 ) 
	return( delchain( LC_aux, LC_aux ) );

while (LC_aux) {
	if ( strcmp(LC_aux->DATA, data ) == 0 ) 
		return( delchain( LC, LC_aux ));
	LC_aux = LC_aux->NEXT;
	}

return ( LC );
}	


/*--------------------------------------------------------------------------
delMaillont	: detruit un mailon dont la donnee est DATA dans une LC typee
----------------------------------------------------------------------------
retour		: le pointeur de la LC traitee
--------------------------------------------------------------------------*/
ptype_list	*delMaillont( LC, data )
ptype_list	*LC;
char		*data;
{
ptype_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( strcmp(LC->DATA, data) == 0 ) 
	return( delptype( LC, LC->TYPE ) );

while (LC_aux) {
	if ( strcmp(LC_aux->DATA, data ) == 0 ) {
		return( (ptype_list*) delchain( LC, LC_aux ));
		}
	LC_aux = LC_aux->NEXT;
	}

return ( LC );
}	


/*--------------------------------------------------------------------------
findDatat	: recherche la DATA, dans une LC typee, de position rang
----------------------------------------------------------------------------
retour		: la DATA
--------------------------------------------------------------------------*/
char		*findDatat( LC, rang )
ptype_list	*LC;
int		 rang;
{
int		 i;
ptype_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( rang > countPtype_list( LC ) ) 
	printf("\nrange error !\n");
else 
	for( i = 1; i < rang; i++ ) LC_aux = LC_aux -> NEXT;
return (char *)LC_aux -> DATA;
}


/*--------------------------------------------------------------------------
itoa		: convertit un int en une chaine de caract 
----------------------------------------------------------------------------
retour		: un char *
--------------------------------------------------------------------------*/
char	*itoa( nb )
int 	 nb;
{
char	*p = (char*) mbkalloc( 20 );

if ( nb == 0 ) return("0");

p += 20;
*(--p)= 0;

while ( nb ) {
	*(--p) = ( nb %  10 ) +48;
	nb = nb / 10;
	}

return ( p );
}

/*----------------------------------------------------------------------------
resetParam	: remet a vide la structure param 
------------------------------------------------------------------------------
retour		: rien. 
------------------------------------------------------------------------------*/

void resetParam(par)
sl_param *par;
{
par->optim = 0;
par->level = 0;
par->delayPI = NULL;
par->optimPO = NULL;
par->numTransN = 0;
par->numTransP = 0;
par->numCanN = 0;
par->numCanP = 0;
}
