/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : synthetiseur logique                                        */
/*    Fichier : sl_mbk.c                                                    */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Burgun L. & Allegre P.                le : 29/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/
#include "mut309.h"
#include "mlo402.h"
#include "log120.h"
#include "beh104.h"
#include "../synthe/sl_type.h"
#include "../mapping/types.h"
#include "../mapping/oper.h"
#include "../mapping/util.h"
#include "sl_mbk.h"

int Surface(name)
char *name;
{
cellList *cell;
for(cell = mappSys->ptcell; cell; cell = cell->NEXT)
   if (cell->nom == name)
      if (searchGeneric(cell, name, "area") != 0)
         return searchGeneric(cell, name, "area");
      else
         return searchGeneric(cell, name, "surface");
}

/*-------------------------------------------------------------------------
nameInst        : remplace le blanc par un _ 
---------------------------------------------------------------------------
retour          : un pointeur de chaine de caracteres.
---------------------------------------------------------------------------*/
char *nameInst(name)
char *name;
{
char *name1;
int i;
int length = strlen(name);

name1 = (char *)  mbkalloc (length+2);
strcpy(name1,name);
i = 0;
while (name1[i] != '\0')
   {
   if (name1[i] == ' ')
      name1[i] = '_';
   i++;
   }   
name = namealloc(name1);
#ifndef LEO
   mbkfree((void *)name1);
#endif

return(name);
}

/*------------------------------------------------------------------------------
genMBKBeh	 : genere une lofig a partir d'une befig "structurelle" 
-------------------------------------------------------
parametres 	 : une befig.
-------------------------------------------------------
return 		 : une lofig.
------------------------------------------------------------------------------*/
void genMBKBeh(beh,capa)
befig_list *beh;
short capa;
{
int numberCell, numberCone;
lofig_list *fig = (lofig_list *)NULL;
losig_list *signal = (losig_list *)NULL; 
int index = 1;
bepor_list *bp,*bp2;
beout_list *out;
bereg_list *reg;
beaux_list *aux;
bebus_list *bus;
bebux_list *bux;
cellList *cell;
chain_list *ptChain;
pTH losigHash;
sig *sigAux;
virtuelList *virt;
int erreur = 0;

	/* variables pour les statistiques */
loins_list *inst;
chain_list *mod;
int countMod = 0;
int totalInst = 0;
int totalSurf = 0;
int numberNot = 0;
char *nomFig;

if (SL_NAME_LOG)
   nomFig = beh->NAME;
else
   nomFig = (char *)genNAME("%s%d",beh->NAME,SL_OPTIM);



	/* creation de la table de hashage signal -> losig_list */

losigHash = createTH(500);

		/* creation de la lofig */

fig = addlofig(nomFig);
printf("\n");

		/* creation des connecteurs et des signaux */
		/* les signaux */

   reg = beh->BEREG;
   while (reg)
   {
      sigAux = (sig *)testObj(reg->NAME,'s');
      if (capa && sigAux)
         signal = addlosig(fig,index,addchain((chain_list *)NULL,(void *)gensym("auxreg",index)),
		           'I',(float)sigAux->capa/1000);
      else
         signal = addlosig(fig,index,addchain((chain_list *)NULL,(void *)gensym("auxreg",index)),
		           'I',0.0);
      index++;
      addTH(losigHash,reg->NAME,signal);
      reg = reg->NEXT;
   }
   aux = beh->BEAUX;
   while (aux)
   {
      sigAux = (sig *)testObj(aux->NAME,'s');
      virt = (virtuelList *)testObj(aux->NAME,'v');
      if (ATOM(aux->ABL) &&
       ((signal = (losig_list *)searchTH(losigHash,VALUE_ATOM(aux->ABL)))
                != (losig_list *) VIDETH))
      {
         addTH(losigHash,aux->NAME,signal);
      }
      else
      {
	if (capa && ((int)virt > 1))
	   if (sigAux)
              signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)aux->NAME),'I',(float)sigAux->capa/1000);
	   else
              signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)aux->NAME),'I',(float)virt->capa/1000);
	else
           signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)aux->NAME),'I',0.0);
        addTH(losigHash,aux->NAME,signal);
      }
      aux = aux->NEXT;
   }

   bux = beh->BEBUX;
   while (bux)
   {
      sigAux = (sig *)testObj(bux->NAME,'s');
      virt = (virtuelList *)testObj(bux->NAME,'v');

	if (capa && ((int)virt > 1))
	   if (sigAux)
              signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)bux->NAME),'I',(float)sigAux->capa/1000);
	   else
              signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)bux->NAME),'I',(float)virt->capa/1000);
	else
           signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)bux->NAME),'I',0.0);
        addTH(losigHash,bux->NAME,signal);
      bux = bux->NEXT;
   }

		/* les connecteurs */

   bp = (bepor_list *)reverse((chain_list *)beh->BEPOR);
   beh->BEPOR = bp;
   do
   {
      sigAux = (sig *)testObj(bp->NAME,'s');
      if (bp->DIRECTION == 'O')
      {
      beout_list *bidule;

       /* recherche du signal de sortie dans BEOUT */
       out = beh->BEOUT;
       while (out && (out->NAME != bp->NAME)) out = out->NEXT;
       if (out) bidule = out;

       if (out && ATOM(bidule->ABL))
       {
	  bp2 = beh->BEPOR;
	  while (bp2 && (bp2->NAME != VALUE_ATOM(bidule->ABL))) bp2 = bp2->NEXT;
	  if (bp2 && bp2->DIRECTION == 'I')
	  {
	    printf("\nNetlist generation : Error - output connector connected to input connector\n");
	    printf("                     Connectors : %s - %s\n",bidule->NAME,VALUE_ATOM(bidule->ABL));
	    erreur = 1;
	  }
       }

       /* recherche d'une sortie egale */
       out = beh->BEOUT;
       do
         if (out && ATOM(out->ABL) &&
	     (bidule->NAME != out->NAME) &&
	     (searchTH(losigHash,out->NAME) != VIDETH) &&
             (VALUE_ATOM(bidule->ABL) == VALUE_ATOM(out->ABL)))
         {
	    printf("\nNetlist generation : Error - 2 connectors linked together\n");
	    printf("                     Connectors : %s - %s\n",bidule->NAME,out->NAME);
	    erreur = 1;
         }
       while (out = out->NEXT);

       if (ATOM(bidule->ABL) &&
          ((signal = (losig_list *)searchTH(losigHash,VALUE_ATOM(bidule->ABL)))
                 != (losig_list *) VIDETH))
          signal->TYPE = 'E';
       else
       {
	  if (capa && sigAux)
         signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)bp->NAME),'E',(float)sigAux->capa/1000);
	  else
            signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)bp->NAME),'E',0.0);
       }

      }
      else    /* ce n'est pas une sortie */
      {
	  if (capa && sigAux)
         signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)bp->NAME),'E',(float)sigAux->capa/1000);
	  else
            signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)bp->NAME),'E',0.0);
      }
      addlocon(fig,bp->NAME,signal,bp->DIRECTION);
      addTH(losigHash,bp->NAME,signal);
   }
   while (bp = bp->NEXT);
   beh->BEPOR = (bepor_list *)reverse((chain_list *)beh->BEPOR);


   if (searchTH(losigHash,namealloc("vdd")) == VIDETH)
   {
      signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)namealloc("vdd")),'E',0.0);
      addTH(losigHash,namealloc("vdd"),signal);
      addlocon(fig,namealloc("vdd"),signal,'X');
   }
   if (searchTH(losigHash,namealloc("vss")) == VIDETH)
   {
      signal = addlosig(fig,index++,addchain((chain_list *)NULL,(void *)namealloc("vss")),'E',0.0);
      addTH(losigHash,namealloc("vss"),signal);
      addlocon(fig,namealloc("vss"),signal,'X');
   }

		/* les instances */

   out = beh->BEOUT;
   while (out)
   {
      if (ATOM(out->ABL))		/* cas low ou high */
         cell = (cellList *)testObj(VALUE_ATOM(out->ABL),'c');
      else
         cell = operToCell(out->ABL);
      if (cell)
      {
         ptChain = recupLosig(losigHash,cell,out->NAME,out->ABL);
         if (numberAtomExpr(out->ABL) == 1)
            numberNot++;
         addloins(fig,nameInst(out->NAME),getlofig(cell->nom,'P'),ptChain);
      }
      out = out->NEXT;
   }
   aux = beh->BEAUX;
   while (aux)
   {
      if (ATOM(aux->ABL))
         cell = (cellList *)testObj(VALUE_ATOM(aux->ABL),'c');
      else
         cell = operToCell(aux->ABL);
      if (cell)
      {
         ptChain = recupLosig(losigHash,cell,aux->NAME,aux->ABL);
         if (numberAtomExpr(aux->ABL) == 1)
            numberNot++;
         addloins(fig,nameInst(aux->NAME),getlofig(cell->nom,'P'),ptChain);
      }
       aux = aux->NEXT;
   }

   bus = beh->BEBUS;
   while (bus)
   {
   biabl_list *biabl = bus->BIABL;
   int cpt = 1;

   do
      if (!ATOM(biabl->VALABL))
      {
         cell = operToCell(biabl->VALABL);
         if (cell == NULL)
         {
            printf("genMBKBeh : Error - bad befig : bad operator %s\n",
		   bus->NAME);
            exit(-1);
         }
         ptChain = recupLosig(losigHash,cell,bus->NAME,biabl->VALABL);
         addloins(fig,gensym(nameInst(bus->NAME),cpt++),getlofig(cell->nom,'P'),
			ptChain);
      }
      while (biabl = CDR(biabl));
      bus = bus->NEXT;
   }

   bux = beh->BEBUX;
   while (bux)
   {
   biabl_list *biabl = bux->BIABL;
   int cpt = 1;

   do
      if (!ATOM(biabl->VALABL))
      {
         cell = operToCell(biabl->VALABL);
         if (cell == NULL)
         {
            printf("genMBKBeh : Error - bad befig : bad operator %s\n",
		   bux->NAME);
            exit(-1);
         }
         ptChain = recupLosig(losigHash,cell,bux->NAME,biabl->VALABL);
         addloins(fig,gensym(nameInst(bux->NAME),cpt++),getlofig(cell->nom,'P'),
			ptChain);
      }
      while (biabl = CDR(biabl));
      bux = bux->NEXT;
   }

   reg = beh->BEREG;
   while (reg)
   {
   biabl_list *biabl = reg->BIABL;

      if (!ATOM(biabl->VALABL))
      {
         cell = operToCell(biabl->VALABL);
         if (cell == NULL)
         {
            printf("genMBKBeh : Error - bad befig : bad operator %s\n",
		   reg->NAME);
            exit(-1);
         }
         ptChain = recupLosig(losigHash,cell,reg->NAME,biabl->VALABL);
         addloins(fig,nameInst(reg->NAME),getlofig(cell->nom,'P'),ptChain);
      }
      reg = reg->NEXT;
   }

   if (erreur)
   {
      printf("Mapping aborted\n");
      exit(1);
   }
printf("MBK Driving '%s'.%s...\n",nomFig,MBK_OUT_LO);
savelofig(fig);
printf("...\n");
	/* parcours des modeles */
for(mod = fig->MODELCHAIN; mod; mod = mod->NEXT)
   countMod++;
for(inst = fig->LOINS; inst; inst = inst->NEXT)
   {
   totalInst++;
   totalSurf += Surface((char *)inst->FIGNAME);
   }
maxDepthBst(beh, &numberCell, &numberCone);
printf("\n==========================  RESULTS  =============================\n");
printf("Number of models used            = %d\n",countMod);
printf("Number of cells used             = %d ",totalInst);
printf("(%d inverters)\n",numberNot);
printf("Number of grids                  = %d\n",totalSurf);
printf("Depth maximum (in cells)         = %d ",numberCell);
printf("(%d eq. negative cells)\n",numberCone); 
printf("==================================================================\n");

dellofig(nomFig);
destroyTH(losigHash);
}

chain_list *recupLosig(losigHash,cell,name,abl)
pTH losigHash;
cellList *cell;
char *name;
chain_list *abl;
{
Alist *aux = cell->interface;
chain_list *res = NULL;

   if (cell->entrees)
   {
      initAlist(abl,cell->entrees);
      do
      {
      Alist *val = searchAlist(cell->entrees,aux->name);
   
         if (val)
            aux->ptChain = val->ptChain;
         else
            if (memberChain_list(aux->name,cell->sorties))
               aux->ptChain = createAtom(name);
            else
               aux->ptChain = createAtom(aux->name);
      }
      while (aux = CDR(aux));
   }
   else
   {
      do
      {
            if (memberChain_list(aux->name,cell->sorties))
               aux->ptChain = createAtom(name);
            else
               aux->ptChain = createAtom(aux->name);
      }
      while (aux = CDR(aux));
   }
   aux = cell->interface;
   do
   {
      if (searchTH(losigHash,(char *)CAR(aux->ptChain)) == VIDETH)
      {
	printf("%s --> %s\n",name,CAR(aux->ptChain));
  	displayAlist(cell->interface);
/*
	exit(-1);
*/
      }
      res = addchain(res,(void *)searchTH(losigHash,(char *)CAR(aux->ptChain)));
   }
   while (aux = CDR(aux));
   if (cell->entrees) resetAlist(cell->entrees,0);
   return res;
}
