/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     :                                                             */
/*     Contents :                                                             */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"
#include "scp_gcaph.h"

/********* lecture figure physique implementation ds structure interne ********/

void chargement_preplacement(ptlofig)
lofig_list *ptlofig;
{
	static phfig_list *ptphfig=NULL;
	int PITCH = 6;
	int ind_cell=0;
	int ind_col=0;
	int ind_col2=0;
	int ind_pos=0;
	int ind_row=0;
	int tab_row_col2[NBROWMAX][NBCELLMAX];

	for (ind_row=0;ind_row<NBROWMAX;ind_row++)
	     tabrow[ind_row]=0;

    	/*** lecture des vars d environnement et ouverture figure physique ****/
   
    	ptphfig = getphfig(ptlofig->NAME,'A');

    	/****************** verifications sur le preplacement *****************/

    	if (ptphfig->PHSEG != NULL | ptphfig->PHVIA != NULL) 
    	{	
		printf("fichier deja route !!!\n");
		return;
    	}

	/****** verification sur la  position des cellules pre-placees ********/ 
	for (ind_cell=0;ind_cell<NB_FIX_CELL;ind_cell++)
	{

	    /**************** position des cellules pitchees ******************/

	    if (CELL[ind_cell].pos%PITCH !=0 )
	    {
		 printf("la position de la cellule %s n'est pas pitchee !!\n"
				,CELL_REF[ind_cell].insname);
		 exit(-1);
	    }
	    tab_row_col2[CELL[ind_cell].row][tabrow[CELL[ind_cell].row]]
			= ind_cell;
	    tabrow[CELL[ind_cell].row]++;
	}

	/*********************** classement des cellules **********************/
	
	for (ind_row=0;ind_row<PRE_PLACE_ROW;ind_row++)	
	{
     	    ind_pos=0;	
	    for(ind_col2=0;ind_col2<tabrow[ind_row];ind_col2++)
	    {
	    	for (ind_col=0;ind_col<tabrow[ind_row];ind_col++)
		    if (CELL[tab_row_col2[ind_row][ind_col]].pos==ind_pos)
	    	    {
			ind_cell = tab_row_col2[ind_row][ind_col];
		        break;
	    	    }
	        if (ind_cell == NONE)
	    	{
		     printf("Vide ou recouvrement dans la bande %d !!\n"
				,ind_row);
		     exit(-1);
	    	}	
	    
	    	tab_row_col[ind_row][ind_col2] = ind_cell;
	    	ind_pos += CELL[ind_cell].width;
	    	ind_cell = NONE;
	     }
	}

	/********* initialisations dans le cas de placement de bandes *********/

	if (!FILL)
	{
	     for (ind_row=0;ind_row<PRE_PLACE_ROW;ROW[ind_row++].free = 0);
	     NBCELL_ROW = NB_FREE_CELL / (NBROW - PRE_PLACE_ROW); 
	}

	/*********** effacement de la figure physique (preplacement) **********/

    	delphfig(ptlofig->NAME);
}
