/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     :                                                             */
/*     Contents :                                                             */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

void miseajour_echange();
void memo_echange();

/********* fonction permetant la memorisation de la modification **********/

void memorisation_nouvelle_configuration()
{
	miseajour_echange();
       	memo_echange();
}

/************ mise a jour dans le cas d'un echange de cellules ****************/

void miseajour_echange()
{
	int ind_cell;
	int tmp_pos;

	/****** mise a jour des dernieres cellules / rangee ROW[].last ********/

	if (CELL[MODIF.cell1].next == NONE)
        	ROW[CELL[MODIF.cell1].row].last = MODIF.cell2;
	if (CELL[MODIF.cell2].next == NONE)
        	ROW[CELL[MODIF.cell2].row].last = MODIF.cell1;

	/****** mise a jour des premieres cellules / rangee ROW[].first *******/
	
	if (CELL[MODIF.cell1].last == NONE)
		ROW[CELL[MODIF.cell1].row].first = MODIF.cell2;
	if (CELL[MODIF.cell2].last == NONE)
		ROW[CELL[MODIF.cell2].row].first = MODIF.cell1;
	
	/********* mise a jour des longueurs des rangees  ROW[].length ********/

	ROW[CELL[MODIF.cell1].row].length += MODIF.deltawidth[MODIF.cell1]; 
	ROW[CELL[MODIF.cell2].row].length += MODIF.deltawidth[MODIF.cell2]; 

	/*************** mise a jour des positions de cellules ****************/

    	for(ind_cell=CELL[MODIF.cell1].next;ind_cell!=NONE;ind_cell=CELL[ind_cell].next)
	   	CELL[ind_cell].pos += MODIF.deltawidth[MODIF.cell1];
 
    	for(ind_cell=CELL[MODIF.cell2].next;ind_cell!=NONE;ind_cell=CELL[ind_cell].next)
	   	CELL[ind_cell].pos += MODIF.deltawidth[MODIF.cell2]; 

	tmp_pos = CELL[MODIF.cell2].pos - (MODIF.deltawidth[MODIF.cell1]/2);
	CELL[MODIF.cell2].pos = CELL[MODIF.cell1].pos
					- (MODIF.deltawidth[MODIF.cell2]/2);
	CELL[MODIF.cell1].pos = tmp_pos;
}

/***************** memorisation dans le cas d'un echange *****************/

void memo_echange()
{
	int tmprow, tmplast, tmpnext; /* variables tampon */

       	if (CELL[MODIF.cell1].next == MODIF.cell2)
	{
		tmpnext = CELL[MODIF.cell2].next;
		tmplast = CELL[MODIF.cell1].last;
	 	if (tmpnext != NONE)	
			CELL[tmpnext].last = MODIF.cell1; 
	 	if (tmplast != NONE)	
	 		CELL[tmplast].next = MODIF.cell2; 
		CELL[MODIF.cell1].next = tmpnext;
		CELL[MODIF.cell2].last = tmplast;
		CELL[MODIF.cell2].next = MODIF.cell1;
		CELL[MODIF.cell1].last = MODIF.cell2;
	}
	else if (CELL[MODIF.cell2].next == MODIF.cell1)
	{
		tmpnext = CELL[MODIF.cell1].next; 
                tmplast = CELL[MODIF.cell2].last;
	 	if (tmpnext != NONE)	
                	CELL[tmpnext].last = MODIF.cell2; 
	 	if (tmplast != NONE)	
                	CELL[tmplast].next = MODIF.cell1; 
                CELL[MODIF.cell2].next = tmpnext; 
                CELL[MODIF.cell1].last = tmplast;
                CELL[MODIF.cell1].next = MODIF.cell2;
                CELL[MODIF.cell2].last = MODIF.cell1;
	}
	else
	{
		if (CELL[MODIF.cell1].last != NONE)	
			CELL[CELL[MODIF.cell1].last].next = MODIF.cell2;
         	if (CELL[MODIF.cell1].next != NONE)	
			CELL[CELL[MODIF.cell1].next].last = MODIF.cell2;
		if (CELL[MODIF.cell2].last != NONE)	
         		CELL[CELL[MODIF.cell2].last].next = MODIF.cell1;
         	if (CELL[MODIF.cell2].next != NONE)	
         		CELL[CELL[MODIF.cell2].next].last = MODIF.cell1;

         	tmprow = CELL[MODIF.cell1].row;
         	tmplast = CELL[MODIF.cell1].last;
         	tmpnext = CELL[MODIF.cell1].next;

         	CELL[MODIF.cell1].row = CELL[MODIF.cell2].row;
         	CELL[MODIF.cell1].last = CELL[MODIF.cell2].last;
         	CELL[MODIF.cell1].next = CELL[MODIF.cell2].next;

         	CELL[MODIF.cell2].row = tmprow;
         	CELL[MODIF.cell2].last = tmplast;
	 	CELL[MODIF.cell2].next = tmpnext;
        }
}
