/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_init.c                                                  */
/*     Contents : initialisation des variables                                */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

/**************************** initialisation des donnees **********************/

void initialisation(nbmodif,nbrow,fill)
int nbmodif;
int nbrow; 
int fill;
{
	/************************** TEMPERATURE initiale **********************/

        TEMPERATURE = TEMP_INIT; 

	/********************* nombre de modifications ************************/

	NBMODIF = nbmodif;
	if (!NBMODIF)	  
		NBMODIF = NBMODIF_MIN;

   	/*********************** nombre de bandes  ****************************/

    	IDEAL_NBROW = (int)(sqrt((float)NBCELL)/2.);

	NBROW = nbrow;
    	if (!NBROW)
        	NBROW = IDEAL_NBROW;
    
	/******************* largeur ideale des bandes ************************/

    	IDEAL_ROW_LENGTH = TOTAL_LENGTH / NBROW;

	/******** choix des valeurs en fonction du preplacement ***************/

	if (PRE_PLACE)
		initialisation_preplacement(nbrow,fill);

	/******************** preplacement de connecteurs **********************/ 
	if (NB_PREP_CON)
		initialisation_connecteurs();

	/******* facteur de normalisation en fonction du nb de bandes *********/

    	NORM_NBROW = 1;
    	if (NBROW < IDEAL_NBROW / 2)
        	NORM_NBROW = (-8. * NBROW / IDEAL_NBROW) + 5;

    	if (NBROW > IDEAL_NBROW * 2)
        	NORM_NBROW = (2. * NBROW / IDEAL_NBROW) - 3;

        /** facteur de normalisation en fonction de la taille des circuits ****/

	NORM_NBCELL = 1; 
        if (NBCELL > 100)
                NORM_NBCELL = (NBCELL/350. + 0.71);

	/****** poids des deviations en X et Y pour l'evaluation du cout ******/

	X_WEIGHT = 1;
        Y_WEIGHT = 100; 

}
