/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_cdc.c                                                   */
/*     Contents : function wich computes the difference of cost               */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

/******************* fonction calculant la difference de cout *****************/
/************** pour une modification de position d'une cellule ***************/

float calcul_difference_cout(cell1,cell2)
int cell1;   		   /* numero de la cellule a deplacer  */
int cell2;   	           /* position d'arrivee de la cellule */
{	
	float DELTA_C_NET=0;
	float DELTA_C_1=0;    /*  cout du a la longueur des nets   */
	float DELTA_C_2=0;    /*  cout du aux largeurs des bandes */
	int old_pos;
	int old_row;
	int new_pos;
	int new_row;
	int ind_cell;
	int ind_pos;
	int ind_row;
	struct connect_list_struct *connect;
	struct cell_list_struct *cell;
    	
	old_pos = CELL[cell1].pos;   /* position initiale cellule */
    	old_row = CELL[cell1].row;            /* bande initiale de la cellule */

    	new_pos = MODIF.nextpos[cell1];      /* position finale cellule */
    	new_row = CELL[cell2].row;           /* bande de finale de la cellule */
	
    	/***** calcul de la difference de cout due a la longueur des nets *****/

	for (connect=CELL[cell1].first;connect;connect=connect->next)
    	{
		for(cell=NET[connect->net_number].first;cell;cell=cell->next)
         	{
              		ind_cell = cell->cell_number;
              		ind_pos = CELL[ind_cell].pos;
              		ind_row = CELL[ind_cell].row;
			if ((ind_cell != cell1) && (ind_cell != cell2)) 
       			DELTA_C_NET += X_WEIGHT * (abs(new_pos-ind_pos) 
						-abs(old_pos-ind_pos))
				     + Y_WEIGHT  * (abs(new_row-ind_row)
						-abs(old_row-ind_row));
         	}
		DELTA_C_1 += DELTA_C_NET* NET[connect->net_number].coeff; 
		DELTA_C_NET = 0;
    	}

    	/**** calcul de la difference de cout due a la largeur des bandes ****/

  
	DELTA_C_2 += - abs(ROW[old_row].length - IDEAL_ROW_LENGTH)
		  + abs(ROW[old_row].length + MODIF.deltawidth[cell1] 
			- IDEAL_ROW_LENGTH);

	/******* normalisation en fonction de la taille des circuits *********/

	DELTA_C_1 = DELTA_C_1 / NORM_NBCELL; 

	/******* normalisation en fonction du nombre de bandes ***************/

	DELTA_C_1 = DELTA_C_1 / NORM_NBROW; 

	return (DELTA_C_1/25 + DELTA_C_2/3);
}
