/****************************************************************************/
/*                                                                          */
/*                      ALLIANCE CAO & VLSI CAD                             */
/*                                                                          */
/*    Product : (S)ymbolic (2)to (R)eal translater                          */
/*    File    : main.c                                                      */
/*                                                                          */
/*    (c) copyright 1992 MASI laboratory CAO & VLSI team                    */
/*    All Right Reserved                                                    */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/****************************************************************************/
/*                                                                          */
/*              Main of Symbolic to Real                                    */
/*                                                                          */
/****************************************************************************/

#ident "@(#)s2r 2.1 11/13/92 ALLIANCE (S)ymbolic (2)to (R)eal translater"

#include "generic.h"
#include  MPH_H
#include  MUT_H
#include  RDS_H
#include  RFM_H
#include  RPR_H
#include  RUT_H
#include "rdsacces+.h"
#include "statistics.h"
#include "postrat.h"

void banner()
{
  puts( " ");
  puts( "      +-----+                                    +--------+");
  puts( "      |     |         @@@@@@   @@@@@@  @@@@@@@   |   ++   |");
  puts( "      +-------+      @@    @@ @@    @@ @@    @@  |   ++   |");
  puts( "      +----+  |      @@             @@ @@    @@  +-+    +-+");
  puts( "           |  |       @@@@@@   @@@@@@  @@@@@@@   +-+    +-+");
  puts( "           |  |---+        @@ @@       @@   @@   |   ++   |");
  puts( "           |  |   | @@     @@ @@     @ @@    @@  |   ++   |");
  puts( "           +--+---+  @@@@@@@  @@@@@@@@ @@     @@ +--------+");
  puts( "\n", stdout);
  printf("        Alliance CAD system,                     S2R %s\n",VERSION);
  puts( "        Tool: S2R  S)ymbolic 2)to R)eal layout converter");
  puts( "        (c) copyright 1992-1993      MASI, CAO-VLSI team");
  puts( "        E-mail support:             cao-vlsi@masi.ibp.fr");
  puts( "\n", stdout);
  fflush(stdout);
}

void usage(s)
char *s;
{
  fprintf(stderr, "Usage : %s [-cs1trv] source [result]\n", s);
  EXIT(1);

  fprintf(stderr, "\tsource\t: filename of symbolic layout circuit\n");
  fprintf(stderr, "\t\t  to translate to real layout\n");
  fprintf(stderr, "\tresult\t: result filename of real layout circuit\n");
  fprintf(stderr, "\t\t  source name is used, if result is absent\n\n");
  fprintf(stderr, "\toptionnal options (any order, any occurence) :\n");
  fprintf(stderr, "\t-c\t: deletes top-level (c)onnectors\n");
  fprintf(stderr, "\t-s\t: (s)cotchs are not created\n");
  fprintf(stderr, "\t-1\t: only (1) level is translated, all otherwise.\n");
  fprintf(stderr, "\t-t\t: layout is just (t)ranslated, not post-treated\n");
  fprintf(stderr, "\t-r\t: black boxes are not (r)eplaced\n");
  fprintf(stderr, "\t-v\t: (v)erbose mode armed\n\n");
  exit(1);
}

getarg(argc, argv, source, result, root_conn, scotch_on,
       one_level, do_post_treat, do_replace_cells, verbose)
int      argc;
char  ** argv;
char  ** source;
char  ** result;
int    * root_conn;
int    * scotch_on;
int    * one_level; 
int    * do_post_treat; 
int    * do_replace_cells;
int    * verbose;
{
int shift = 1;

  *source           = NULL; /* need default values */
  *result           = NULL; /* need default values */
  *root_conn        = 1;    /* keep top-level figure connectors by default */
  *scotch_on        = 1;    /* scotchs are not created by default */
  *one_level        = 0;    /* all hierarchy level translated by default */
  *do_post_treat    = 1;    /* post-treatment is done by default */
  *do_replace_cells = 1;    /* cells_replacement is done by default */
  *verbose          = 0;    /* verbose mode desarmed by default */

  /* checking and getting arguments */
  if(argc < 2)
    usage(argv[0]);
  for (shift = 1; shift < argc; shift++) {
    char *arg = argv[shift];
    if (*arg == '-') {
      while (*++arg) {
        switch (*arg) {
          case 'c': *root_conn        = 0; break;
          case 's': *scotch_on        = 0; break;
          case '1': *one_level        = 1; break;
          case 't': *do_post_treat    = 0; break;
          case 'r': *do_replace_cells = 0; break;
          case 'v': *verbose          = 1; break;
          default : usage(argv[0]);
        }
      }
    } else {
      if (*source == NULL)
        *source = namealloc(argv[shift]);
      else if (*result == NULL)
        *result = namealloc(argv[shift]);
      else
        usage(argv[0]);
      continue;
    }
  }
  if (*result == NULL)
     *result = *source;
}


main(argc, argv)
int  argc;
char  **argv;
{
  rds_fig    * rds_model;
  phfig_list * mbk_model;
  char       * source_name;
  char       * result_name;
  int          root_conn; 
  int          scotch_on;
  int          one_level; 
  int          do_post_treat; 
  int          do_replace_cells;
  int          verbose;

  /**** banner and parameters ****/
  getarg( argc, argv, &source_name, &result_name, &root_conn, &scotch_on,
                      &one_level, &do_post_treat, &do_replace_cells, &verbose);
  banner();

/*\
 * setting environement 
 * MBK_CATAL_NAME    : file where file name to be replaced are put
 * MBK_CATA_LIB      : where cells, catal file and techno file are
 * MBK_WORK_LIB      : where result file is written or where techno file is
 *                     WORK_LIB is watched before CATA_LIB
 * MBK_WORK_LIB      : where result file is placed
 * MBK_IN_PH         : file format of symbolic figure
 * RDS_TECHNO_NAME   : techno file name
 * RDS_IN            : file format of real figures to replace
 * RDS_OUT           : file format of result file
\*/
  mbkenv();
  RdsEnv();

/*\
 * Read the techno file 
\*/
  printf("\n\to loading technology file : %s\n", RDS_TECHNO_NAME);
  LoadParam();

/*\
 * Read Symbolic format and create rds from mbk 
\*/
  printf("\to loading %s level of symbolic layout : %s\n", 
         one_level ? "one" : "all", source_name);
  mbk_model = getphfig(source_name, 'A');
  if(!root_conn)
    mbk_model->PHCON = NULL;
  TransMbkRds( mbk_model, one_level ? 0 : RDS_MODE_ALL);
/*\
  printf("\to removing symbolic data structure \n");
  rds_mbk_kill();
\*/

/*\
 * post treatement 
\*/
  rds_model = rds_model_out( source_name);
  if(do_post_treat) {
    printf("\to layout post-treating ");
    if( root_conn) printf("with connectors, ");
    else           printf("without connector, ");
    if( scotch_on) printf("with scotchs.\n");
    else           printf("without scotch.\n");
    post_treat( rds_model, scotch_on, verbose);
  } 

/*\
 * Replace cells 
\*/
  if(do_replace_cells) {
    printf("\to replacing black boxes\n");
    replace_cells(verbose);
  }

/*\
 * save file 
\*/
  printf("\to saving %s.%s\n", result_name,RDS_OUT);
  rds_model->name = result_name;
  SaveRdsFig(result_name);

  if( verbose)
    print_statistics(scotch_on); 

  return(0);
}


