/*
 *
 *	PARSE_CIF.c
 *
 *	Parser CIF -> RDS
 *
 */
#include <stdio.h>
#include <ctype.h>
#include <memory.h>
#include MUT_H
#include RDS_H
#include RPR_H
#include RUT_H
#define PARSECIF_C
#include "parse_cif.h"
#include "cif.h"

#define peek() nextchar
#define endoffile() (nextchar == (char)EOF)
/* coordinates transformation :
   this macro computes the value of an rds internal coordinate, in 1/RDS_UNIT
   of a micron, from a cif coordinate.
   See comment on ds_a, ds_b for more. */

#define CIF2RDS_UNIT(x) (((x) * ds_a * RDS_UNIT_PARAM) / (ds_b * CIF_UNIT))

#define BIGUNSIGNED ((0XFFFFFFFF-9)/10)
#define BIGSIGNED ((0X7FFFFFFF-9)/10)

#define	MAXCOORD	1000

PTNODE	node, head_node, pt1, pt2;
PT_INST_GEO ancre_trans, pt_trans;
static bool definprog;
/* cif naming convention :
   each coordinate in the cif file, for a given symbol, is multiplied by
   ds_a and then divided by ds_b to give a 1/100th of a micron precision. */
static long ds_a, ds_b;

int	rds_layer;
static int	
	corresp(cif_layer)
char	*cif_layer;
{
register int	i;

	for (i = 0; i < RDS_MAX_LAYER; i++)
		if (!strcmp(GET_CIF_LAYER(GetCifLayerParam(i)), cif_layer))
			return i;
	return - 1;
}

/**********************************************************************/
/*                                                                    */
/* calcul_coord : calcule les coordonnees et les dimensions d'un      */
/*                descripteur en fonction de celles du bloc auquel il */
/*                appartient,compte tenu de l'operation geometrique   */
/*                effectuee sur instancie.                            */
/*								      */
/*		   La philosophie d'instanciation et manipulation glo */
/*		  bale de blocs est celle de CIF.		      */
/*			(i) la position d'instanciation est celle du  */
/*		  repere de definition du bloc instancie.	      */
/*		 	(ii)les operations geometriques se font par ra*/
/*		  pport aux axes du repere de definition.	      */
/*                                                                    */
/*		   Ainsi, si les origines des reperes de definition et*/
/*		  d'instanciation(de reception) sont respectivement A,*/
/*		  B, un rectangle quelconque se caracterisant par deux*/
/*		  point M1(x1,y1), M2(x2,y2) dans le repere A et      */
/*		  M(x,y) dans B alors:				      */
/*								      */
/*			BM=BA+OPGEO_A(M1M2), avec BA(X,Y)	      */
/*		  d'ou, x=X+x_op				      */
/*		        y=Y+y_op				      */
/*			avec OPGEO_A(M1M2)=(x_op,y_op)		      */
/*								      */
/*		   Dans la fonction definie cidessous,		      */
/*			X=xcl et Y=ycl, x1,y1,x2,y2 etant respective  */
/*		  egaux a ax,ay,ax+adx,ay+ady.			      */
/*						   		      */
/**********************************************************************/
static void
	calcul_coord(nivb, xcl, ycl, ax, ay, adx, ady)
uchar nivb;
lnat xcl, ycl;
lnat *ax, *ay, *adx, *ady; /* nouvelles coordonnees du desc */
{
lnat tamp;

	switch (nivb) {
	case 2 : /* pas d'operation geometrique */
		break;
	case 3 : /*rotation plus 90 */
			tamp = (*ax);
			*ax = -(*ay) - (*ady) + represen;
			*ay = tamp;
			tamp = (*adx);
			*adx = (*ady);
			*ady = tamp;
			break;
	case 4 : /* rotation moins 90 # rotation plus 270 */
			tamp = (*ay);
			*ay = -(*ax) - (*adx) + represen;
			*ax = tamp;
			tamp = (*adx);
			*adx = (*ady);
			*ady = tamp;
			break;
	case 5 : /* symetrie pa rapport l'axe des x (les x changent) */
			*ax = -(*ax) - (*adx) + represen;
			break;
	case 6 : /* symetrie par rapport a l'axe des y */
			*ay = -(*ay) - (*ady) + represen;
			break;
	case 7 : /* symetrie par rapport a l'origine */
			*ay = -(*ay) - (*ady) + represen;
			*ax = -(*ax) - (*adx) + represen;
			break;
	case 8 : /* rotation plus 90 et symetrie par rapport a y */
			tamp = (*ax);
			*ax = (*ay) + (*ady);
			*ay = (tamp) + (*adx);
			tamp = (*adx);
			*adx = (*ady);
			*ady = tamp;
			break;
	case 9 : /* rotation moins 90 et symetrie y */
			tamp = (*ax);
			*ax = (*ay) + represen;
			*ay = tamp + represen;
			tamp = (*adx);
			*adx = (*ady);
			*ady = tamp;
			break;
	default : 
		break;
	}
	*ax = (*ax) + xcl;
	*ay = (*ay) + ycl;
}

static void
	fill_rect_with_node(node)
PTNODE	node;
{
PTNODE	pt;
rds_rec	 * rect;

	for (pt = node; pt; pt = pt ->next) {
		rect = MyGetRectangleByPoint(GetFigureRds(ad_dsym_cur),
												pt ->xcoord, pt ->ycoord, pt ->layer);
		if (rect == NULL) {
			fprintf(stderr, "Unconnected node %s in (%d, %d)\n",
									pt->name, pt->xcoord, pt->ycoord);
			error(BADNODE);
		}
		rect ->u_rec.name =  pt ->name;
	}
}

static void build_figure_rds(trans)
PT_INST_GEO trans;
{
rds_fig * Model;
rds_ins * Instance;
rds_rec * Rectangle;
char	Layer;
POINT rect_pos;
int	geop, x_rect, y_rect, sauvx, sauvy, recx, recy, recdx, recdy;

	for (Instance = HeadFigureRds->instance; Instance != (rds_ins * )NULL;  Instance = Instance->next) {
		for (Model = HeadFigureRds->next; Model != (rds_fig * )NULL;  Model = Model->next)
			if (Model->name == Instance->mod_name)
				break;
		if (Model == NULL) {
			fprintf(stderr, "Model %s non trouve\n\n", Instance->mod_name);
			EXIT(0);
		}
		for (Layer = RDS_NWELL;  Layer < RDS_MAX_LAYER;  Layer++)
			for (Rectangle  = Model->layertab[ Layer ];  Rectangle != (rds_rec * )NULL;  Rectangle  = Rectangle->next) {
				for (; ((trans) && (trans->name_isym != Instance->ins_name)); trans = trans->next);
				sauvx = recx = Rectangle->x;
				sauvy = recy = Rectangle->y;
				recdx = Rectangle->dx;
				recdy = Rectangle->dy;
				get_i_pos_geop(&rect_pos, &geop, &trans->pt_trans);
				switch (geop) {
				case 2 : 
					Instance->transf = RDS_NOSYM;
					break;
				case 3 : 
					Instance->transf = RDS_ROT_P;
					break;
				case 4 : 
					Instance->transf = RDS_ROT_M;
					break;
				case 5 : 
					Instance->transf = RDS_SYM_X;
					break;
				case 6 : 
					Instance->transf = RDS_SYM_Y;
					break;
				case 7 : 
					Instance->transf = RDS_SYMXY;
					break;
				case 8 : 
					Instance->transf = RDS_SY_RP;
					break;
				case 9 : 
					Instance->transf = RDS_SY_RM;
					break;
				}
				x_rect = rect_pos.p_xcoord;
				y_rect = rect_pos.p_ycoord;
				calcul_coord(geop, x_rect, y_rect, &recx, &recy, &recdx, &recdy);
				recx += Instance->x;
				recy += Instance->y;
				if ((Rectangle->layer == RDS_TALU1) ||  (Rectangle->layer == RDS_TALU2) ||  (Rectangle->layer ==
				    RDS_TALU3) ||  (Rectangle->layer == RDS_TPOLY) ||  (Rectangle->layer == RDS_ABOX) ||  (Rectangle->mbk_type ==
				    MBK_CONNECTOR) ||  (Rectangle->mbk_type == MBK_REFERENCE))
					AddRectangleInsRds ( Instance, Rectangle->u_rec.name, recx, recy, recdx,  recdy,
					    Layer, Rectangle->mbk_type, Rectangle->extract_type, Rectangle->mbk );
			}
	}
}

static rds_rec *MyGetRectangleByPoint(ptfig, X, Y, Layer)
rds_fig	*ptfig;
long	X;
long	Y;
char	Layer;
{
rds_rec * Index;

	for (Index  = ptfig->layertab[ Layer ];  Index != (rds_rec * )NULL;  Index  = Index->next)
		if ((X >= Index->x)
				&&  (Y >= Index->y)
				&&  (X <= Index->x + Index->dx)
				&&  (Y <= Index->y + Index->dy))
			return Index;
	return (rds_rec * )NULL;
}

rds_fig *loadcif(name)
char	*name;
{
	if ((infile = mbkfopen(name, "cif", "r")) == NULL)
		error(NOFILEIN);
	init_emi();
	/* ciffilename :
     global variable containing the name of the file beeing parsed for
     error messages purposes. */
	sprintf(ciffilename, "%s.cif", name);
	while (parsecommand() != COM_END);
	fflush(stdout);
	fclose(infile);
	return HeadFigureRds;
}

/**************************************************************************/
/* write_mask(). this procedure writes a Polygon or a Box in a descriptor */
/* list.                                                                  */
/**************************************************************************/
static void write_mask(descrtype)
int	descrtype;
{
int	locdx, locdy, x_desc, y_desc;

	if (descrcount > MAXDESCR) 
		error(MAXDESOVER);
	switch (descrtype) {
	case D_POLYGON:
		break;
	case D_BOX:
	case D_XCTOR:
		if (boxdirection.p_xcoord != 0 && boxdirection.p_ycoord == 0) {
			locdx = boxdim.p_xcoord;
			locdy = boxdim.p_ycoord;
		} else {
			locdx = boxdim.p_ycoord;
			locdy = boxdim.p_xcoord;
		}
		x_desc = boxcenter.p_xcoord - (locdx / 2);
		y_desc = boxcenter.p_ycoord - (locdy / 2);
		if (!INITENV) {
			cenvx_min = x_desc;
			cenvx_max = x_desc + locdx;
			cenvy_min = y_desc;
			cenvy_max = y_desc + locdy;
			INITENV = 1;
		} else {
			if (x_desc < cenvx_min)
				cenvx_min = x_desc;
			if (x_desc + locdx > cenvx_max)
				cenvx_max = x_desc + locdx;
			if (y_desc < cenvy_min)
				cenvy_min = y_desc;
			if (y_desc + locdy > cenvy_max)
				cenvy_max = y_desc + locdy;
		}
		if (descrtype == D_BOX) {
			x_desc = CIF2RDS_UNIT(x_desc);
			y_desc = CIF2RDS_UNIT(y_desc);
			locdx = CIF2RDS_UNIT(locdx);
			locdy = CIF2RDS_UNIT(locdy);
			if ((CheckPhysicalGridAligned(x_desc)
					| CheckPhysicalGridAligned(y_desc)
					| CheckPhysicalGridAligned(locdx)
			    	| CheckPhysicalGridAligned(locdy)) != 0) {
				warning(NOTALIGNED);
				RoundRectangleRds(AddRectangleFigRds(HeadFigureRds, NULL,
											x_desc, y_desc, locdx, locdy, rds_layer,
											MBK_UNKNOWN, RDS_NONE, NULL));
			} else
				AddRectangleFigRds(HeadFigureRds, NULL,
									x_desc, y_desc, locdx, locdy, rds_layer, MBK_UNKNOWN,
									RDS_NONE, NULL);
		} else { /** D_XCTOR **/
			x_desc = CIF2RDS_UNIT(x_desc);
			y_desc = CIF2RDS_UNIT(y_desc);
			locdx = CIF2RDS_UNIT(locdx);
			locdy = CIF2RDS_UNIT(locdy);
			if ((CheckPhysicalGridAligned(x_desc)
					| CheckPhysicalGridAligned(y_desc)
					| CheckPhysicalGridAligned(locdx)
			    	| CheckPhysicalGridAligned(locdy)) != 0) {
				warning(NOTALIGNED);
				RoundRectangleRds(AddRectangleFigRds(HeadFigureRds, ad_cntno,
											x_desc, y_desc, locdx, locdy,
											rds_layer,
											MBK_CONNECTOR, RDS_CON_EXTER, NULL));
			} else
				AddRectangleFigRds(HeadFigureRds, ad_cntno,
											x_desc, y_desc, locdx, locdy,
											rds_layer, MBK_CONNECTOR,
											RDS_CON_EXTER, NULL);
		}
		descrcount++;
		break;
	case D_ABBOX:
		descrcount++;
		break;
	default: 
		;
	}
}

/***************************************************************************/
/* write_bloc(). writes a bloc in the current descr list.                  */ 
/*		the position of the symbol instance is not the one of      */
/*		the symbol bounding box, but the define symbol referential */ 
/***************************************************************************/
static void write_bloc(wad_isym, tlist)
char	*wad_isym;
TRANSFORM **tlist;
{
	int	geop = GNOP, id_isym; /* no geometrical operation */
	POINT inst_pos;
	lnat dsym_xenv, dsym_yenv, dsym_dxenv, dsym_dyenv, x_inst, y_inst;


	if (descrcount > MAXDESCR) 
		error(MAXDESOVER);

	/* geting the instance position of the definition referencial */
	get_i_pos_geop(&inst_pos, &geop, tlist);
	x_inst = inst_pos.p_xcoord;
	y_inst = inst_pos.p_ycoord;

	/* geting the position and size of the bounding box of the definition symbol */
	get_dsym_env(wad_isym, &dsym_xenv, &dsym_yenv, &dsym_dxenv, &dsym_dyenv);

	calcul_coord(geop, x_inst, y_inst, &dsym_xenv, &dsym_yenv, &dsym_dxenv, &dsym_dyenv);

	if (!INITENV) {
		cenvx_min = dsym_xenv;
		cenvx_max = dsym_xenv + dsym_dxenv;
		cenvy_min = dsym_yenv;
		cenvy_max = dsym_yenv + dsym_dyenv;
		INITENV = 1;
	} else {
		if (dsym_xenv < cenvx_min) 
			cenvx_min = dsym_xenv;
		if (dsym_xenv + dsym_dxenv > cenvx_max) 
			cenvx_max = dsym_xenv + dsym_dxenv;
		if (dsym_yenv < cenvy_min) 
			cenvy_min = dsym_yenv;
		if (dsym_yenv + dsym_dyenv > cenvy_max) 
			cenvy_max = dsym_yenv + dsym_dyenv;
	}

	id_isym = get_id_isym(wad_isym);
	descrcount++;

	x_inst = CIF2RDS_UNIT(x_inst);
	y_inst = CIF2RDS_UNIT(y_inst);
	if ((CheckPhysicalGridAligned(x_inst) | CheckPhysicalGridAligned(y_inst)) != 0) {
		warning(NOTALIGNED);
		AddInstanceRds(HeadFigureRds, ad_csym_cur, ad_isym, RoundInf(x_inst), RoundInf(y_inst), RDS_NOSYM, NULL);
	} else
		AddInstanceRds(HeadFigureRds, ad_csym_cur, ad_isym, x_inst, y_inst, RDS_NOSYM, NULL);
}

/**********************************************************************
 * get_dsym_env(). gives the position and the size of the bounding box*
 * 		   of the define symbol. TAB_ENV[] is readed.	      *
 **********************************************************************/
static void get_dsym_env(bname, lx_env, ly_env, ldx_env, ldy_env)
char	*bname;
lnat *lx_env, *ly_env, *ldx_env, *ldy_env;
{
	int	i;

	for (i = 0; i < cpt_dsym; i++)
		if (strcmp(bname, TAB_DSYM[i].ad_symbname) == 0) {
			*lx_env = TAB_DSYM[i].x_env;
			*ly_env = TAB_DSYM[i].y_env;
			*ldx_env = TAB_DSYM[i].dx_env;
			*ldy_env = TAB_DSYM[i].dy_env;
			return;
		}
}

/*********************************************************************
 * get_i_pos_geop(). gives the position of the instanciated defined  *
 *		    referencial and the geometrical operation to be  *
 *		    applied.					     *
 *********************************************************************/
static void get_i_pos_geop(ori, geo, tlis)
POINT *ori;
int	*geo;
TRANSFORM **tlis;
{
	TRANSFORM * locp;
	cnat locgeop1 = GNOP, locgeop2 = GNOP;

	locp = *tlis;
	ori->p_xcoord = 0;
	ori->p_ycoord = 0;

	while (locp != NULL) {
		switch (locp->t_type) {
		case TRANSLATE:
			ori->p_xcoord = ori->p_xcoord + locp->u.t_pt.p_xcoord;
			ori->p_ycoord = ori->p_ycoord + locp->u.t_pt.p_ycoord;
			break;
		case MIRROR:
			locgeop2 = locp->u.t_dir;
			switch (locgeop2) {
			case XDIRECTION:
				locgeop1 = comp_geop(locgeop1, GSYMX); /* les X changent */
				break;
			case YDIRECTION:
				locgeop1 = comp_geop(locgeop1, GSYMY); /* les Y changent */
				break;
			}/* END switch(locgeop2) */
			break;
		case ROTATE:
			locgeop2 = locp->u.t_pt.p_ycoord;
			if (locgeop2 > 0)
				if ((locgeop1 != GSYMX) && (locgeop1 != GSYMY))
					locgeop1 = comp_geop(locgeop1, GRPLUS);
				else
					locgeop1 = comp_geop(locgeop1, GRMOINS);
			else {
				if (locgeop2 < 0)
					if (locgeop1 == GNOP)
						locgeop1 = comp_geop(locgeop1, GRPLUS);
					else
						locgeop1 = comp_geop(locgeop1, GRMOINS);
				locgeop1 = comp_geop(locgeop1, GSYMO);
			}
			break;
		}
		locp = locp->t_next;
	}
	/* by now, we have the right, UNIQUE, geometrical operation in locgeop1 */
	*geo = locgeop1;
}

/**********************************************************************/
/*  This procedure computes the result of two geometrical operations  */
/*         as input : 2 geometrical operations (rot1 et rot2)        */
/*         as output: the resulting geometrical operation             */
/*  Allowed geometrical operations                                    */
/*      - 2 : pas d'o.g.                                              */
/*      - 3 : rotation + 90                                           */
/*      - 4 : rotation - 90  (+ 270)                                 */
/*      - 5 : symetrie / axe des x                                    */
/*      - 6 : symetrie / axe des y                                    */
/*      - 7 : symetrie / O                                            */
/*      - 8 : rotation + 90 et symetrie / axe des y                   */
/*      - 9 : rotation - 90 et symetrie / axe des y                   */
/*  Ces operations geometriques permettent d'obtenir toutes les       */
/*  configurations possibles.La composition de 2 d'entre elles rend   */
/*  une de ces configurations,d'ou l'operation geometrique resultante */
/*                                                                    */
/*                    rot2                                            */
/*                       | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 |            */
/*               rot1 ---|---|---|---|---|---|---|---|---|            */
/*                     2 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 |            */
/*                    ---|---|---|---|---|---|---|---|---|            */
/*                     3 | 3 | 7 | 2 | 9 | 8 | 4 | 5 | 6 |            */
/*                    ---|---|---|---|---|---|---|---|---|            */
/*                     4 | 4 | 2 | 7 | 8 | 9 | 3 | 5 | 6 |            */
/*                    ---|---|---|---|---|---|---|---|---|            */
/*                     5 | 5 | 8 | 9 | 2 | 7 | 6 | 3 | 4 |            */
/*                    ---|---|---|---|---|---|---|---|---|            */
/*                     6 | 6 | 9 | 8 | 7 | 2 | 5 | 4 | 3 |            */
/*                    ---|---|---|---|---|---|---|---|---|            */
/*                     7 | 7 | 4 | 3 | 6 | 5 | 2 | 9 | 8 |            */
/*                    ---|---|---|---|---|---|---|---|---|            */
/*                     8 | 8 | 6 | 5 | 4 | 3 | 9 | 2 | 7 |            */
/*                    ---|---|---|---|---|---|---|---|---|            */
/*                     9 | 9 | 5 | 6 | 3 | 4 | 8 | 7 | 2 |            */
/*                    ------------------------------------            */
/**********************************************************************/
static cnat comp_geop(rot1, rot2)
cnat rot1, rot2;
{
	cnat ogr;      /* resulting geometrical operation */
	switch (rot1) { 
	case 2 : 
		 { 
			ogr = rot2;
			break;
		}
	case 3 : 
		 { 
			switch (rot2) { 
			case 2 : 
				 { 
					ogr = 3;
					break; 
				}
			case 3 : 
				 { 
					ogr = 7;
					break; 
				}
			case 4 : 
				 { 
					ogr = 2;
					break; 
				}
			case 5 : 
				 { 
					ogr = 9;
					break; 
				}
			case 6 : 
				 { 
					ogr = 8;
					break; 
				}
			case 7 : 
				 { 
					ogr = 4;
					break; 
				}
			case 8 : 
				 { 
					ogr = 5;
					break; 
				}
			case 9 : 
				 { 
					ogr = 6;
					break; 
				}
			}
			break;
		}
	case 4 : 
		 { 
			switch (rot2) { 
			case 2 : 
				 { 
					ogr = 4;
					break; 
				}
			case 3 : 
				 { 
					ogr = 2;
					break; 
				}
			case 4 : 
				 { 
					ogr = 7;
					break; 
				}
			case 5 : 
				 { 
					ogr = 8;
					break; 
				}
			case 6 : 
				 { 
					ogr = 9;
					break; 
				}
			case 7 : 
				 { 
					ogr = 3;
					break; 
				}
			case 8 : 
				 { 
					ogr = 5;
					break; 
				}
			case 9 : 
				 { 
					ogr = 6;
					break; 
				}
			}
			break;
		}
	case 5 : 
		 { 
			switch (rot2) { 
			case 2 : 
				 { 
					ogr = 5;
					break; 
				}
			case 3 : 
				 { 
					ogr = 8;
					break; 
				}
			case 4 : 
				 { 
					ogr = 9;
					break; 
				}
			case 5 : 
				 { 
					ogr = 2;
					break; 
				}
			case 6 : 
				 { 
					ogr = 7;
					break; 
				}
			case 7 : 
				 { 
					ogr = 6;
					break; 
				}
			case 8 : 
				 { 
					ogr = 3;
					break; 
				}
			case 9 : 
				 { 
					ogr = 4;
					break; 
				}
			}
			break;
		}
	case 6 : 
		 { 
			switch (rot2) { 
			case 2 : 
				 { 
					ogr = 6;
					break; 
				}
			case 3 : 
				 { 
					ogr = 9;
					break; 
				}
			case 4 : 
				 { 
					ogr = 8;
					break; 
				}
			case 5 : 
				 { 
					ogr = 7;
					break; 
				}
			case 6 : 
				 { 
					ogr = 2;
					break; 
				}
			case 7 : 
				 { 
					ogr = 5;
					break; 
				}
			case 8 : 
				 { 
					ogr = 4;
					break; 
				}
			case 9 : 
				 { 
					ogr = 3;
					break; 
				}
			}
			break;
		}
	case 7 : 
		 { 
			switch (rot2) { 
			case 2 : 
				 { 
					ogr = 7;
					break; 
				}
			case 3 : 
				 { 
					ogr = 4;
					break; 
				}
			case 4 : 
				 { 
					ogr = 3;
					break; 
				}
			case 5 : 
				 { 
					ogr = 6;
					break; 
				}
			case 6 : 
				 { 
					ogr = 5;
					break; 
				}
			case 7 : 
				 { 
					ogr = 2;
					break; 
				}
			case 8 : 
				 { 
					ogr = 9;
					break; 
				}
			case 9 : 
				 { 
					ogr = 8;
					break; 
				}
			}
			break;
		}
	case 8 : 
		 { 
			switch (rot2) { 
			case 2 : 
				 { 
					ogr = 8;
					break; 
				}
			case 3 : 
				 { 
					ogr = 6;
					break; 
				}
			case 4 : 
				 { 
					ogr = 5;
					break; 
				}
			case 5 : 
				 { 
					ogr = 4;
					break; 
				}
			case 6 : 
				 { 
					ogr = 3;
					break; 
				}
			case 7 : 
				 { 
					ogr = 9;
					break; 
				}
			case 8 : 
				 { 
					ogr = 2;
					break; 
				}
			case 9 : 
				 { 
					ogr = 7;
					break; 
				}
			}
			break;
		}
	case 9 : 
		 { 
			switch (rot2) { 
			case 2 : 
				 { 
					ogr = 9;
					break; 
				}
			case 3 : 
				 { 
					ogr = 5;
					break; 
				}
			case 4 : 
				 { 
					ogr = 6;
					break; 
				}
			case 5 : 
				 { 
					ogr = 3;
					break; 
				}
			case 6 : 
				 { 
					ogr = 4;
					break; 
				}
			case 7 : 
				 { 
					ogr = 8;
					break; 
				}
			case 8 : 
				 { 
					ogr = 7;
					break; 
				}
			case 9 : 
				 { 
					ogr = 2;
					break; 
				}
			}
			break;
		}
	}
	return ogr;
}


/*****************************************************************/
/* write_emi(). this procedure creates an emilie file and writes */
/*		the define symbol bounding box in TAB_DFSYM[].   */
/*****************************************************************/
static void write_emi()
{
	int	lcpt_dsym;

	if (descrcount == 0)
		cenvx_max = cenvy_min = 0;

	lcpt_dsym = cpt_dsym - 1;
	TAB_DSYM[lcpt_dsym].x_env = CIF2RDS_UNIT(cenvx_min);
	TAB_DSYM[lcpt_dsym].y_env = CIF2RDS_UNIT(cenvy_min);
	TAB_DSYM[lcpt_dsym].dx_env = CIF2RDS_UNIT(ABS(cenvx_max - cenvx_min));
	TAB_DSYM[lcpt_dsym].dy_env = CIF2RDS_UNIT(ABS(cenvy_max - cenvy_min));
}


/***************************************************************************/
/* get_id_isym().  this procedure gives the id of a symbol.		   */
/***************************************************************************/
static uchar get_id_isym(lad_isymb)
char	*lad_isymb;
{
	int	i;
	uchar loc_blockid;

	for (i = 0; i < NBMAXBLOC; i++) {
		if (strcmp(lad_isymb, TAB_BLOCID[i].block_name) == 0) {
			loc_blockid = TAB_BLOCID[i].block_id;
			return loc_blockid;
		}
	}
	return 0;
}


/**********************************************************
 * get_inst_ad(). Returns the adress of the instance name *
 **********************************************************/
static char	*get_inst_ad(lnro_inst)
int	lnro_inst;
{
	int	i;

	for (i = 0; i < cpt_dsym; i++)
		if (lnro_inst == TAB_DSYM[i].nro)
			return(TAB_DSYM[i].ad_symbname);
	error(SYMNUMERR);
}


/***********************************************************
 * put_inst_id_ad().Stores the defined symbole id with its *
 *		 name adress.				   *
 ***********************************************************/
static void put_inst_id_ad(lnro_ds, lad_ds)
char	*lad_ds;
int	lnro_ds;
{
	int	i;

	for (i = 0; i < cpt_dsym; i++) {
		if (strcmp(TAB_DSYM[i].ad_symbname, lad_ds) == 0) {
			warning(SYMBEXIST);
			TAB_DSYM[i].nro = lnro_ds;
			return;
		}
	}
	if (cpt_dsym > MAXDSYM)
		error(OVERMAXDSYM);
	else {
		TAB_DSYM[cpt_dsym].nro = lnro_ds;
		TAB_DSYM[cpt_dsym].ad_symbname = lad_ds;
		cpt_dsym++;
		return;
	}
}


/***********************************************************
 * int_emi(). initializes emilie structures                *
 ***********************************************************/
static void init_emi()
{
	ds_a = ds_b = 1;
	boxdirection.p_xcoord = boxdirection.p_ycoord = 0;
	root_flatnbdesc = 0;
	head_node = NULL;
	pt_trans = NULL;
	definprog = 0;
	nextchar = '\0';
	linecount = 1;
	memset((char *)TAB_DSYM, 0, sizeof(TYP_DSYM) * MAXDSYM);
	memset((char *)TAB_BLOCID, 0, sizeof(TYP_BLOCID) * NBMAXBLOC);
	cpt_dsym = 0;
}


static void error(errortype)
int	errortype;
{

	(void)fflush(stdout);

	fprintf(stderr, " loadcif : ");
	switch (errortype) {
	case STOCKHR:
		fprintf(stderr, "  unable to generate a .emi file\n\n");
		EXIT(1);
	case NOFILEIN:
		fprintf(stderr, "  no CIF inputfile\n\n");
		EXIT(1);
	default: 
		;
	}

	fprintf(stderr, "error line %d of file <%s> , before '%c' : ", linecount, ciffilename, nextchar);

	switch (errortype) {
	case NUMTOOBIG:
		fprintf(stderr, "number too large\n");
		break;
	case NOUNSIGNED:
		fprintf(stderr, "unsigned integer expected\n");
		break;
	case NOSIGNED:
		fprintf(stderr, "signed integer expected\n");
		break;
	case NOSEMI:
		fprintf(stderr, "missing ';' inserted\n");
		break;
	case NOPATH:
		fprintf(stderr, "no points in path\n");
		break;
	case BADTRANS:
		fprintf(stderr, "no such transformation command\n");
		break;
	case BADUSER:
		fprintf(stderr, "end of file inside user command\n");
		break;
	case BADCOMMAND:
		fprintf(stderr, "unknown command encountered\n");
		break;
	case INTERNAL:
		fprintf(stderr, "parser can't find routine\n");
		break;
	case NOLAYERNAME:
		fprintf(stderr, "layer name expected\n");
		break;
	case NOLAYERINRDS:
		fprintf(stderr, "layer CIF (%s) unknown in RDS\n", ad_lyrn_cur);
		break;
	case NESTDEF:
		fprintf(stderr, "symbol definitions can't nest\n");
		break;
	case NODEFSTART:
		fprintf(stderr, "DF without DS\n");
		break;
	case NESTDD:
		fprintf(stderr, "DD can't appear inside symbol definition\n");
		break;
	case NOSPACE:
		fprintf(stderr, "missing space in name command\n");
		break;
	case NONAME:
		fprintf(stderr, "no name in name command\n");
		break;
	case NOABBOX:
		fprintf(stderr, "symbol %s has no ABUTMENT BOX\n", ad_dsym_cur);
		break;
	case NESTEND:
		fprintf(stderr, "End command inside symbol definition\n");
		break;
	case BADMIRRORTYPE:
		fprintf(stderr, "in translation mirror type must be 'X' or 'Y'\n");
		break;
	case RLABEL_ERR:
		fprintf(stderr, "ring label defined outside symbol definition\n");
		break;
	case REDEFINE_LL:
		fprintf(stderr, "multiple definitions of ring_ll in symbol\n");
		break;
	case REDEFINE_UR:
		fprintf(stderr, "multiple definitions of ring_ur in symbol\n");
		break;
	case SYMNUMERR:
		fprintf(stderr, "Can't find symbol number in symbol table\n");
		break;
	case BADDIRECTION:
		fprintf(stderr, "bad direction specified for mirror\n");
		break;
	case BASELENGTH:
		fprintf(stderr, "basename too long\n");
		break;
	case OPENFILE:
		fprintf(stderr, "unable to open cif file\n");
		break;
	case NOMEMORY:
		fprintf(stderr, "no more memory space\n");
		break;
	case NON_MANHATTAN:
		fprintf(stderr, "non_manhattan box encountered\n");
		break;
	case MAXDESOVER:
		fprintf(stderr, "increase MAXDESCR size in file parse_cif.h\n");
		break;
	case NON_NIV:
		fprintf(stderr, "unknown mask level encountered\n");
		break;
	case XCTOR:
		fprintf(stderr, "bad connector specification\n");
		break;
	case OVERMAXDSYM:
		fprintf(stderr, "the number of symbols defined is too larger\n");
		fprintf(stderr, " >> curent value is %d increase it in file\n", MAXDSYM);
		fprintf(stderr, "		parse_cif.h\n");
		break;
	case NAMEALLOC:
		fprintf(stderr, "memory allocation problem in the name dictionary\n");
		break;
	case BADNODE:
		fprintf(stderr, "node is not in a rectangle \n");
		break;
	case COORDBIG:
		fprintf(stderr, "Path too long\n");
		break;
	case POLREC:
		fprintf(stderr, "Path doesn't represent a good polygon\n");
		break;
	case ENDOFILE:
		fprintf(stderr, "Prematurate end of file\n");
		break;
	default:
		fprintf(stderr, "uncaught error\n");

	}
	fprintf(stderr, "\n");
	EXIT(1);
}


static void warning(warningtype)
int	warningtype;
{
	fprintf(stdout, "\n\n_line %d (or line before newline) of file <%s>:\n", linecount, ciffilename);
	fprintf(stdout, "  WARNING...\n");
	switch (warningtype) {
	case MRTXTFLWEC:
		fprintf(stdout, "some more text follows the cif END command\n");
		break;
	case SYMBEXIST:
		fprintf(stdout, "duplicate symbol number : the first will be lost\n");
		break;
	case NOTALIGNED:
		fprintf(stdout, "cif object not aligned on physical grid\n");
		break;
	default:
		;
	}
	fflush(stdout);
}


/****************************************************************************/
/*  parsecommand - parses a single command                                  */
/****************************************************************************/
static unsigned int	parsecommand()
{
	char	curchar;
	bool semi();
	char	label[80];			/* used for holding the label names */
	int	x, y;				/* used for label coordinates */
	unsigned int	command = COM_NULL;
	long	j, k;
	unsigned int	symbolnumber;
	TRANSFORM * tlist = NULL;		/* holds transform list for each call */
	int	do_write_bloc = 1;

	blank();		/* flush initial junk */

	switch (curchar = getch()) {
	case 'P':
		command = COM_POLYGON;
		getpath(); 	/* no need to save the path here */
		break;

	case 'B':
		command = COM_BOX;
		boxdim.p_xcoord = cardinal(); 	/* check for length */
		boxdim.p_ycoord = cardinal(); 	/* check for width */
		getpoint(); 	/* check for center */
		boxcenter.p_xcoord = curpoint.p_xcoord;
		boxcenter.p_ycoord = curpoint.p_ycoord;
		sep();
		/* check for optional rotation */
		if (((curchar = peek()) >= '0' && curchar <= '9') || curchar == '-') {
			boxdirection.p_xcoord = vers_signed(); 	/* x rotation */
			boxdirection.p_ycoord = vers_signed(); 	/* y rotation */
			if ((boxdirection.p_xcoord != 0) && (boxdirection.p_ycoord != 0))
				error(NON_MANHATTAN);
		}

		if ((boxdirection.p_xcoord == 0) && (boxdirection.p_ycoord == 0)) {
			boxdirection.p_xcoord = 1;
			boxdirection.p_ycoord = 0;
		}

		break;

	case 'R':
		command = COM_ROUNDFLASH;
		cardinal(); 	/* check for diameter */
		getpoint(); 	/* check for center */
		break;

	case 'W':
		command = COM_WIRE;
		cardinal(); 	/* check for width */
		getpath(); 		/* check for path */
		break;

	case 'L':
		 {
			int	endname = 0;
			char	lcurchar[SZ_NAME_MAX];
			command = COM_LAYER;
			blank();
			while (((curchar = peek()) >= 'A' && curchar <= 'Z') || isdigit(curchar)) {
				getch();
				lcurchar[endname] = curchar;
				endname++;
			}
			if (endname == 0) 
				error(NOLAYERNAME);
			sprintf(curname, "%s", lcurchar);
			curname[endname] = '\0';
			/* namealloc neither needed nor wanted :
	   the cif user defines its layers with the case he wants.
	   we shall not modify them. */
			ad_lyrn_cur = curname;
		}
		break;

	case 'D':		/* DATA IS ACTUALLY USED !!! */
		blank();
		switch (getch()) {
		case 'S':	/* define start of symbol */
			 {
				command = COM_DEFSTART;
				nro_dsym_cur = cardinal();

				sep();
				if (isdigit(peek())) {
					ds_a = cardinal();
					ds_b = cardinal();
				} else
					ds_a = ds_b = 1;
				if (definprog) 
					error(NESTDEF);
				definprog = 1;
			}
			break;
		case 'F':
			command = COM_DEFFINISH;
			if (!definprog) 
				error(NODEFSTART);
			definprog = 0;
			break;
		case 'D':
			command = COM_DEFDELETE;
			symbolnumber = cardinal();
			if (definprog) 
				error(NESTDD);
			break;
		default:
			error(BADDEF);
		}
		break;

	case 'C': 	/* command is actually used ! */
		 {
			command = COM_CALL;
			symbolnumber = cardinal();
			ad_csym_cur = get_inst_ad(symbolnumber);
			do_write_bloc = (nextchar != ';');
			blank();
			gettransform(&tlist);
			if (do_write_bloc) {
				ancre_trans = (PT_INST_GEO)malloc(sizeof(INST_GEO));
				ancre_trans ->name_isym = ad_isym;
				ancre_trans ->ad_csym_cur = ad_csym_cur;
				ancre_trans ->pt_trans = tlist;
				ancre_trans ->next = pt_trans;
				pt_trans = ancre_trans;
			}
		}
		break;

	case '(':
		 {
			unsigned int	level = 1;

			command = COM_COMMENT;
			while (level) {
				switch (curchar = getch()) {
				case '(':
					level++;
					break;
				case ')':
					level--;
					break;
				case (char)
EOF:
						error(BADCOMMENT);
					break;
				default: 
					; /* not saving comment characters */
				}
			}
		}
		break;

	case 'E':
		command = COM_END;
		blank();
		if (definprog) 
			error(NESTEND);
		if (!endoffile())
			warning(MRTXFLWEC);


		break;

	case ';':
		command = COM_NULL;
		break;

	case (char)
EOF:
			command = COM_EOF;
		break;

	default:
		if (isdigit(curchar)) { /* user defined commands */
			if (curchar - '0' == 9) {
				if (!sp()) 
					error(NOSPACE);
				command = COM_U9SYMBN;
				getname(curname);
				ad_dsym_cur = namealloc(curname);

				break;
			}  else if (curchar - '0' == 4) {
				curchar = peek();
				switch (toupper(curchar)) {

				case 'I':
					command = COM_U4INSTN;
					getch();
					if (!sp()) 
						error(NOSPACE);
					getname(curname);
					ad_isym = namealloc(curname);
					break;

				case 'N':
					command = COM_U4NODE;
					getch();
					if (!sp()) 
						error(NOSPACE);
					getname(curname);
					ad_node = namealloc(curname);
					if (!sp()) 
						error(NOSPACE);
					getpoint();
					break; /* nothing to do now */

				case 'A':
					command = COM_U4ABBOX;
					getch();
					if (!sp()) 
						error(NOSPACE);
					getpoint();
					x_abbox = curpoint.p_xcoord;
					y_abbox = curpoint.p_ycoord;

					getpoint();
					dx_abbox = curpoint.p_xcoord - x_abbox;
					dy_abbox = curpoint.p_ycoord - y_abbox;
					/* a MASK will be generated by the command */
					break;

				case 'X':
					command = COM_U4XCTOR;
					getch();
					if (!sp()) 
						error(NOSPACE);
					getname(curname);
					ad_cntno = namealloc(curname);
					if (!sp()) 
						error(NOSPACE);
					cardinal();
					if (!sp()) 
						error(NOSPACE);
					getpoint();
					x_cnctor = curpoint.p_xcoord;
					y_cnctor = curpoint.p_ycoord;

					ad_cntly = ad_lyrn_cur;

					if (!sp()) 
						error(NOSPACE);
					cnctorwi = cardinal();
					sp();
					if ((curchar = peek()) == ';') {
						boxdirection.p_xcoord = 1;
						boxdirection.p_ycoord = 0;
					} else {
						curchar = peek();
						if (isalnum(curchar)) {
							getname(curname);
							ad_cntna = namealloc(curname);
							sp();
							if ((curchar = peek()) == ';') {
								boxdirection.p_xcoord = 1;
								boxdirection.p_ycoord = 0;
							} else {
								curchar = peek();
								if (isalnum(curchar)) {
/* code folded from here */
	getname(curname);
	ad_cntty = namealloc(curname);
	sp();
	if ((curchar = peek()) == ';') {
		boxdirection.p_xcoord = 1;
		boxdirection.p_ycoord = 0;
	} else {
		curchar = peek();
		if (isalnum(curchar)) {
			getname(curname);
			ad_cntly = namealloc(curname);
			sp();
			if ((curchar = peek()) == ';') {
				boxdirection.p_xcoord = 1;
				boxdirection.p_ycoord = 0;
			} else {
				boxdirection.p_xcoord = vers_signed();
				boxdirection.p_ycoord = vers_signed();
			}
		} else 
			error(XCTOR);
	}
/* unfolding */
								} else 
/* code folded from here */
	error(XCTOR);
/* unfolding */
							}
						} else 
							error(XCTOR);
					}

					if (!endoffile() && !semi()) 
						error(NOSEMI);
					if (getch() == 'B') { /* get box dimensions for connector */
						boxdim.p_xcoord = cardinal();
						boxdim.p_ycoord = cardinal();
						getpoint(); 	/* check for center */
						boxcenter.p_xcoord = curpoint.p_xcoord;
						boxcenter.p_ycoord = curpoint.p_ycoord;
						sep();
						/* check for optional rotation */
						if (((curchar = peek()) >= '0' && curchar <= '9') || curchar == '-') {
							boxdirection.p_xcoord = vers_signed(); 	/* x rotation */
							boxdirection.p_ycoord = vers_signed(); 	/* y rotation */
							if ((boxdirection.p_xcoord != 0) && (boxdirection.p_ycoord != 0))
								error(NON_MANHATTAN);
						}

						if ((boxdirection.p_xcoord == 0) && (boxdirection.p_ycoord == 0)) {
							boxdirection.p_xcoord = 1;
							boxdirection.p_ycoord = 0;
						}
					} else 
						error(XCTOR);

					/* a MASK will be generated by the command */
					break;
				}
			}/* END if(== 4 */  else if (curchar - '0' == 9 &&  (curchar = peek()) == ' ' || curchar == '	' ||
			    curchar == '1' || curchar == '2' || curchar == '3' ||  curchar == '4')
				switch (getch()) {
				case ' ':
				case '	':	/* tab */
					sp();
					name();
					command = COM_USR9;
					break;
				case '1':
				case '2':
				case '3':
					if (!sp()) 
						error(NOSPACE);
					name();
					switch (curchar) {
					case '1':
						command = COM_USR91;
						break;
					case '2':
						 {
							int	i;
							command = COM_USR92;
							getpoint();
							blank();
							for (i = 0; i < 4; i++)
								if (((curchar = peek()) >= 'A' && curchar <= 'Z') || isdigit(curchar))
/* code folded from here */
	getch(); /* layer name */
/* unfolding */
								else 
/* code folded from here */
	break;
/* unfolding */
							break;
						}
					case '3':
						command = COM_USR93;
						getpoint();
						break;
					}
					break;
				case '4':	/* command used! */
					if (!sp()) 
						error(NOSPACE);
					command = COM_USRLABEL;
					getname(label);	/* get label name */
					x = vers_signed();  /* get the position of the label */
					y = vers_signed();
					utext();	   /* skip over optional layer info */
				}
			else
			 {
				command = COM_USER;
				utext();
				if (endoffile()) 
					error(BADUSER);
			}
		} else
			error(BADCOMMAND);
	}


	/* by now we have a syntactically valid command */
	/* although it might be missing a semi-colon    */
	switch (command) {


	case COM_DEFSTART:
		descrcount = 0;
		call_nbr_in_cur_dsym = 0;
		INITENV = DSNAMEXIST = 0;
		boxdirection.p_xcoord = 1;
		boxdirection.p_ycoord = 0;
		break;

	case COM_DEFFINISH:
		if (DSNAMEXIST) {
			write_emi();
		} else
			error(NODSNAME);

		ds_a = ds_b = 1;
		call_nbr_in_cur_dsym = 0;
		fill_rect_with_node(head_node);
		if (head_node) {
			for (pt1 = head_node->next, pt2 = head_node; pt1; pt2 = pt1, pt1 = pt1->next)
				free(pt2);
			free(pt2);
			head_node = NULL;
		}
		break;

	case COM_DEFDELETE:

	case COM_CALL:
		call_nbr_in_cur_dsym++;
		if (do_write_bloc)
			write_bloc(ad_csym_cur, &tlist);
		break;

	case COM_USRLABEL:

	case COM_LAYER:
		rds_layer = corresp(ad_lyrn_cur);
		if (rds_layer == -1)
			error(NOLAYERINRDS);
		/* ; no action here, the layer name is already saved */
		break;

	case COM_ROUNDFLASH:
	case COM_NULL:
	case COM_WIRE:
	case COM_POLYGON:
		write_mask(D_POLYGON);
		break;

	case COM_BOX:
		write_mask(D_BOX);
		boxdirection.p_xcoord = 1;
		boxdirection.p_ycoord = 0;
		break;

	case COM_COMMENT:
		; /* there is nothing to do */
		break;

	case COM_U9SYMBN:
		put_inst_id_ad(nro_dsym_cur, ad_dsym_cur);
		DSNAMEXIST = 1;
/*
		AddFigureRds(TAB_DSYM[nro_dsym_cur-1].ad_symbname, NULL);
*/
		AddFigureRds(get_inst_ad(nro_dsym_cur), NULL);

		break;

	case COM_U4INSTN:
		/* the instance name is disgarded because there is no */
		/* physical contents associated to this name          */
		break;

	case COM_U4NODE:
		/* nothing to do today!				*/
		boxdirection.p_xcoord = 1;
		boxdirection.p_ycoord = 0;
		node = head_node;
		head_node = (PTNODE) malloc(sizeof(NODE));
		head_node ->name = ad_node;
		head_node ->xcoord = CIF2RDS_UNIT(curpoint.p_xcoord);
		head_node ->ycoord = CIF2RDS_UNIT(curpoint.p_ycoord);
		head_node ->layer = rds_layer;
		head_node ->next = node;
		break;

	case COM_U4ABBOX:
		write_mask(D_ABBOX);
		x_abbox = CIF2RDS_UNIT(x_abbox);
		y_abbox = CIF2RDS_UNIT(y_abbox);
		dx_abbox = CIF2RDS_UNIT(dx_abbox);
		dy_abbox = CIF2RDS_UNIT(dy_abbox);
		if ((CheckPhysicalGridAligned(x_abbox)
				| CheckPhysicalGridAligned(y_abbox)
				| CheckPhysicalGridAligned(dx_abbox)
				| CheckPhysicalGridAligned(dy_abbox)) != 0) {
			warning(NOTALIGNED);
			RoundRectangleRds(AddRectangleFigRds(HeadFigureRds, NULL,
                                x_abbox, y_abbox, dx_abbox, dy_abbox, RDS_ABOX,
			     					     MBK_UNKNOWN, RDS_NONE, NULL));
		} else
			AddRectangleFigRds(HeadFigureRds, NULL, x_abbox, y_abbox,
										dx_abbox, dy_abbox, RDS_ABOX, MBK_UNKNOWN,
										RDS_NONE, NULL);
		break;

	case COM_U4XCTOR:
		write_mask(D_XCTOR);
		boxdirection.p_xcoord = 1;
		boxdirection.p_ycoord = 0;
		break;

	case COM_USER:
	case COM_END:
	/* End of parsing :
	   Symbol definitions can't nest! So at the end of parsing,
	   there is no more job to do. That means, all the symbols encountered are
	   already saved.    				26.9.90 JAMES
	   But we need to known the name of the root cell. Its adress name is the
	   adress of the last CALL symbol in the analyzed cif text. This is the BAD
	   way choosen by the VTI cif parser to recognize the root cell ! We just
	   to deal whith that. Because the CALL command writes a bloc in the
	   descrlist, the called symbol will be writen with the last right attributs
	   of a called symbol in the current text. */
		ad_root_sym = ad_csym_cur;
		build_figure_rds(ancre_trans);
		break;

	case COM_EOF:
		error(ENDOFILE);
	case COM_USR9:
	case COM_USR91:
	case COM_USR92:
	case COM_USR93:
		break;
	default: 
		error(INTERNAL);
	}
	if (!endoffile() && !semi()) 
		error(NOSEMI);
	return(command);
}


/**********************************************************************/
/* gettransform - parses the transformation information               */
/**********************************************************************/
static void gettransform(ptlist)
TRANSFORM **ptlist;
{
	TRANSFORM trans;
	bool endofcommand = FALSE;
	int	val;

	trans.t_next = NULL;/* to avoid core dump on some machines */

	/* initilisation */
	trans.u.t_dir = NODIRECTION;
	trans.u.t_pt.p_xcoord = ONLYMIRROR;
	trans.u.t_pt.p_ycoord = ONLYMIRROR;

	while (!endofcommand) {
		blank();		/* between transformation commands */
		switch (peek()) {
		case 'T': 
			getch();
			trans.t_type = TRANSLATE;
			trans.u.t_pt.p_xcoord = vers_signed();
			trans.u.t_pt.p_ycoord = vers_signed();
			break;
		case 'M':
			/* 20.12.90 ne pas ecraser le type de la transformation qui est mis a jour 
	     seulement lorsqu'on reconnait le mot cle d'instanciation du symbole TRANSLATE ... NON!
	     */
			trans.t_type = MIRROR;
			getch(); 
			blank();
			switch (getch()) {
			case 'X': 
				trans.u.t_dir = XDIRECTION; 
				break;
			case 'Y': 
				trans.u.t_dir = YDIRECTION; 
				break;
			default: 
				error(BADMIRRORTYPE);
			}
			break;
		case 'R':
			/* 20.12.90
	     NON! */
			trans.t_type = ROTATE;
			getch();
			trans.u.t_pt.p_xcoord = (val = vers_signed()) == 0 ? 0 : (val < 0) ? -1 : 1;
			trans.u.t_pt.p_ycoord = (val = vers_signed()) == 0 ? 0 : (val < 0) ? -1 : 1;
			break;
		case ';': 
			endofcommand = TRUE; 
			break;
		default:
			error(BADTRANS);
		}
		if (!endofcommand) 
			appendtrans(trans, ptlist);
	}
}


/*****************************************************************
 *								 *
 * appendtrans - append the new transformation to the specified  *
 * transformation list.  Be sure it is appended at the END of the*
 * list, because the order of transformations is important.      *
 *								 *
 *****************************************************************/
static void appendtrans(trans, ptlist)
TRANSFORM trans, **ptlist;
{
	TRANSFORM * newtrans, *p;

	newtrans = (TRANSFORM * ) malloc(sizeof(struct transform ));
	newtrans->t_type = trans.t_type;	/* copy trans to *newtrans */
	newtrans->t_next = trans.t_next;
	if (trans.t_type == MIRROR) 
		newtrans->u.t_dir = trans.u.t_dir;
	else if (trans.t_type == TRANSLATE || trans.t_type == ROTATE) {
		newtrans->u.t_pt.p_xcoord = trans.u.t_pt.p_xcoord;
		newtrans->u.t_pt.p_ycoord = trans.u.t_pt.p_ycoord;
	}
	if (*ptlist == NULL) 
		*ptlist = newtrans;	/* first transformation*/
	else
	 {
		p = *ptlist;
		while (p->t_next != NULL) 
			p = p->t_next;
		p->t_next = newtrans;	/* add at END of the list */
	}
}


/*************************************************************************/
/* getch - gets the next character.  Returns "nextchar" and gets another */
/* character for peek()                                                  */
/*************************************************************************/
static char	getch()
{
	register char	c;

	if ((c = nextchar) != (char)EOF) {
		nextchar = fgetc(infile);
		if (nextchar == '\n')
			linecount++;
	}
	return(c);
}


/*************************************************************************/
/* blank - skips over "blanks".  Note blanks are anything except digits, */
/* capital letters, '-','(',')' or ';'.                                  */
/*************************************************************************/
static void blank()
{
	register char	c;
	unsigned char	find = 0;

	while (!find)
		switch (c = peek()) {
		case '(' :
		case ')' :
		case ';' :
		case '-' :
		case (char)
EOF: 
				find = 1;
			break;
		default:
			if (isdigit(c) || isupper(c)) 
				find = 1;
			else 
				getch();
		}
}


/****************************************************************************/
/* sep - skips over separators.  Separators are capital letters or "blanks".*/
/* look above to see the definition of "blank".                             */
/****************************************************************************/
static void sep()
{
	register char	c;
	unsigned char	find = 0;

	while (!find)
		switch (c = peek()) {
		case '(' :
		case ')' :
		case ';' :
		case '-' :
		case (char)
EOF: 
				find = 1;
			break;
		default:
			if (isdigit(c)) 
				find = 1;
			else 
				getch();
		}
}


/****************************************************************************/
/* semi - looks for a semicolon.  Note that it will skip over "blanks" both */
/* befor and after the semicolon.                                           */
/* Returns TRUE if finds one, and FALSE otherwise.                          */
/****************************************************************************/
static bool semi()
{
	bool ans = FALSE;

	blank();
	if (peek() == ';') {
		getch();
		ans = TRUE;
		blank();
	}
	return (ans);
}


/*****************************************************************************/
/* sp - skips over spaces. Returns TRUE if finds a space and FALSE otherwise */
/*****************************************************************************/
static bool sp()
{
	bool ans = FALSE;
	char	c;

	while ((c = peek()) == ' ' || c == '	') {
		getch(); 
		ans = TRUE;
	}
	return(ans);
}


/****************************************************************************/
/* utext - skip over user text in user-defined commands                     */
/****************************************************************************/
static void utext()
{
	while (!endoffile() && peek() != ';') 
		getch();
}


/****************************************************************************/
/* name - parse name but don't return one                                   */
/****************************************************************************/
static void name()
{
	char	c;
	bool charseen = FALSE;

	while (!endoffile() && (c = peek()) != ';' &&  c != ' ' && c != '	' && c != '{' && c != '}') {
		charseen = TRUE;
		getch();
	}
	if (!charseen) 
		error(NONAME);
}


/****************************************************************************/
/* getname - parse name and return result                                   */
/****************************************************************************/
static void getname(pname)
char	*pname;		/* for holding the name */
{
	char	c;
	bool charseen = FALSE;

	while (!endoffile() && (c = peek()) != ';' &&  c != ' ' && c != '	' && c != '{' && c != '}') {
		charseen = TRUE;
		*pname++ = getch();
	}
	*pname = '\0';
	if (!charseen) 
		error(NONAME);
}


/**************************************************************************/
/* parse cardinal numbers. Returns an unsigned int.                       */
/**************************************************************************/
static unsigned int	cardinal()
{
	bool somedigit = FALSE;
	register unsigned int	ans = 0;
	char	c;

	sep();
	while (ans < (unsigned int)BIGUNSIGNED && (c = peek()) >= '0' && c <= '9') {
		ans *= 10;
		ans += getch() - '0';
		somedigit = TRUE;
	}
	if (!somedigit) 
		error(NOUNSIGNED);
	if ((c = peek()) >= '0' && c <= '9') 
		error(NUMTOOBIG);
	return(ans);
}


/**************************************************************************/
/* signed - parse signed integers. Returns the integer                    */
/**************************************************************************/
static int	vers_signed()
{
	bool somedigit = FALSE;
	bool sign = POS;
	register int	ans = 0;
	char	c;

	sep();
	if (peek() == '-') {
		sign = NEG; 
		getch();
	}
	while (ans < BIGSIGNED && (c = peek()) >= '0' && c <= '9') {
		ans *= 10;
		ans += getch() - '0';
		somedigit = TRUE;
	}
	if (!somedigit) 
		error(NOSIGNED);
	if ((c = peek()) >= '0' && c <= '9') 
		error(NUMTOOBIG);
	return((sign == POS) ? ans : -ans);
}


/************************************************************************/
/* parse over points.                                                   */
/************************************************************************/
static void getpoint()
{
	curpoint.p_xcoord = vers_signed();
	curpoint.p_ycoord = vers_signed();
}


/************************************************************************/
/* parse a path.                                                        */
/************************************************************************/
static void getpath()
{
	char	c;
	bool foundpath = FALSE;
	int	cpt = 0, new_cpt, sauvx, sauvy;
	coor_t	tab[ MAXCOORD ], *new_tab;

	sep();
	while (((c = peek()) >= '0' && c <= '9') || c == '-') {
		foundpath = TRUE;
		getpoint();	/* hack because of compiler error */
		curpath++;
		curpathl++;
		tab[ cpt ].x = curpoint.p_xcoord;
		tab[ cpt ].y = curpoint.p_ycoord;
		cpt++;
		if (cpt == 1) /* on garde les coordonnees du premier point pour les */ {	      /* mettre en dernier, ceci pour la fonction pv_p2d    */
			sauvx = curpoint.p_xcoord;
			sauvy = curpoint.p_ycoord;
		}
		if (cpt >= MAXCOORD)
			error(COORDBIG);
		sep();
	}
	/* on rajoute un point a la fin, avec les coordonnees du premier */
	tab[ cpt ].x = sauvx;
	tab[ cpt ].y = sauvy;
	cpt++;
	if (!foundpath) 
		error(NOPATH);
	else
	 {
		if (pv_ispolrec(tab, cpt) == 0)
			error(POLREC);
		/* scaling :
	 the p2d function needs some scaling factor, that is a double,
	 since it was first designed for gds files.
	 Hope it's ok for cif. */
		pv_p2d(tab, cpt, (double)(ds_a / ds_b), &new_tab, &new_cpt);
		pv_d2rds(rds_layer, new_tab, new_cpt);
	}
}

