/***************************************************************************
 *                                                                         *
 *           Reads the tecno. and the defaults files to construct          *
 *           the tecno. tables and vaiables.                               * 
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include "rdsneric.h"
#include "rprparse.h"
#include MUT_H
#include MPH_H
#include RPR_H
#include RDS_H

/***************************************************************************
 * global variables for all files
 ***************************************************************************/

/* program vaiables */

long   PHYSICAL_GRID_PARAM;
long   RDS_UNIT_PARAM = -1; /* value before to be user defined */
long   LAMBDA_PARAM;
char  *RDS_TECHNO_NAME;

/* tabs */

post_record       *post_tab       = (post_record *) NULL;
seg_record        *seg_tab        = (seg_record *) NULL;
via_record        *via_tab        = (via_record *) NULL;
con_record        *con_tab        = (con_record *) NULL;
cif_lay_record    *cif_lay_tab    = (cif_lay_record *) NULL;
gds_lay_record    *gds_lay_tab    = (gds_lay_record *) NULL;
oversize_record   *oversize_tab   = (oversize_record *) NULL;
ringwidth_record  *ringwidth_tab  = (ringwidth_record *) NULL;
layerwidth_record *layerwidth_tab = (layerwidth_record *) NULL;

/***************************************************************************
 * global variables for this file
 **************************************************************************/

static unsigned char   var_defined  = 0;/* flags indicating the var def  */
static unsigned short  table_defined = 0;/* flags indicating the tabs def*/
static FILE *file;                    /* a pointer to the opened file    */
static unsigned long   current_line;  /* the current line of opened file */
static char           *Buffer;        /* a line buffer                   */
static char           *Word1;         /* a general purpose ptr to a word */
static char           *Word2;         /* a general purpose ptr to a word */

/* pointers to strings */

static char   *define_S;
static char   *tab_S;
static char   *end_record_S;
static char   *end_table_S;

static char   *lambda_S;
static char   *phys_grid_S;

static char   *post_S;
static char   *seg_S;
static char   *via_S;
static char   *con_S;
static char   *cif_layer_S;
static char   *gds_layer_S;
static char   *oversize_S;
static char   *ringwidth_S;
static char   *layerwidth_S;

/****************************************************************************
 * prepare: allocates memory to the line buffer and to the strings of the
 *          tec language keywords( includig prog. variables and tabs names)
 ***************************************************************************/

static void prepare()
{
   Buffer = (char *) mbkalloc( BUFFER_SIZE);

   define_S =        namealloc(DEFINE);
   tab_S =           namealloc(TABLE);
   end_table_S =     namealloc(END_TABLE);
   end_record_S =    namealloc(END_RECORD);

   lambda_S =        namealloc(LAMBDA);
   phys_grid_S =     namealloc(PHYS_GRID);

   post_S =          namealloc(POST);
   seg_S =           namealloc(RFM_SEG);
   via_S =           namealloc(RFM_VIA);
   con_S =           namealloc(RFM_CON);
   cif_layer_S =     namealloc(CIF_LAYER);
   gds_layer_S =     namealloc(GDS_LAYER);
   oversize_S =      namealloc(OVERSIZE);
   ringwidth_S =     namealloc(RINGWIDTH);
   layerwidth_S =    namealloc(LAYERWIDTH);
}

/*****************************************************************************
 * syntax_eror: given the error type and eventually a string argument, it
 *              prints the appropriate error message and terminates the program
 *****************************************************************************/

static void syntax_error( error_type, arg_msg)
char   error_type;
char   *arg_msg;
{
	fflush(stdout);
   switch ( error_type) {
   case 1 :
      (void) fprintf(stderr, "*** rpr error *** : Some defines missing\n");
      exit(1);
   case 2 :
      (void) fprintf(stderr, "*** rpr error *** : Some tables missing\n");
      exit(1);
   case 3 :
      (void) fprintf(stderr, "*** rpr error *** : %s expected - line:%lu\n", 
             arg_msg, current_line);
      exit(1);
   case 4 :
      (void) fprintf(stderr,
             "*** rpr error *** : unknown define - line:%lu : %s\n",
             current_line, arg_msg);
      exit(1);
   case 5 :
      (void) fprintf(stderr,
             "*** rpr error *** : %s not defined - line:%lu\n",
             arg_msg, current_line);
      exit(1);
   case 6 :
      (void) fprintf(stderr,
            "*** rpr error *** : %s not multiple of physical grid - line:%lu\n",
             arg_msg, current_line );
      exit(1);
   case 7 :
      (void) fprintf(stderr,
             "*** rpr error *** : %s too smal - line:%lu\n",
              PHYS_GRID, current_line );
      exit( 1 );
   case 8 :
      (void) fprintf(stderr,
             "*** rpr error *** : missing value at %s - line:%lu\n",
             arg_msg, current_line);
      exit(1);
   case 9 :
      (void) fprintf(stderr,
             "*** rpr error *** : missing name of %s - line:%lu\n",
             arg_msg, current_line);
      exit(1);
   case 10 :
      (void) fprintf(stderr,
         "*** rpr error *** : illegal floating point number %s - line:%lu :%s\n",
              arg_msg, current_line );
      exit( 1 );
   case 11 :
      (void) fprintf(stderr,
             "*** rpr error *** : %s unexpected - line:%lu\n",
              arg_msg, current_line);
      exit(1);
   case 12 :
      (void) fprintf(stderr,
            "*** rpr error *** : unexpected end of file, missing definitions\n");
      exit(1);
   case 13 :
      (void) fprintf(stderr,
             "*** rpr error *** : too many words %s unexpected - line:%lu\n",
             arg_msg, current_line);
      exit(1);
   case 14 :
      (void) fprintf(stderr,
             "*** rpr error *** : missing value in %s table  - line:%lu\n",
             arg_msg, current_line);
      exit(1);
      break;
   case 15 :
      (void) fprintf(stderr,
             "*** rpr error *** : technological file %s can't be opened\n", arg_msg);
      exit(1);
   case 16 :
      (void) fprintf(stderr,
         "*** rpr error *** : Missing %s value in postreat table - line:%lu\n",
             "TREAT ot NOTREAT", current_line);
      exit(1);
      break;
   case 17 :
      (void) fprintf(stderr,
             "*** rpr error *** : unknown table - line:%lu : %s\n",
             current_line, arg_msg);
      exit(1);
      break;
   default:
      (void) fprintf(stderr, 
             "*** rpr error *** : Syntax Error at line:%lu %s unexpected\n", 
             current_line, arg_msg);
      exit(1);
   }
}

/******************************************************************************
 * vfgets: read a line of a file to a buffer, the line beeing size max or end   
 * with a \n. In order to properly treat line breaks, the \\\n pattern is       
 * recognized and replaced by blank space                                       
 ******************************************************************************/
static char   *vfgets(str, size, iob)
char   *str;
int   size;
FILE *iob;
{
   register char   *cs;
   register c;

   cs = str;
   while (--size > 0 && (c = getc(iob)) != EOF) {
      if ((*cs++ = c) == '\\') {
         if ((c = getc(iob)) == '\n') {
            *(cs - 1) = ' ';
         } else
            (void)ungetc(c , iob);
      } else if (c == '\n')
         break;
   }
   *cs = '\0';
   return (c == EOF && cs == str) ? (char *)NULL : str;
}

/******************************************************************************
 * get_line: reads a line from the opened file ( pointed by the global variable
 *           file) and puts it in the given buffer.
 *****************************************************************************/
static void get_line( buffer, file)
char   *buffer;
FILE *file;
{
   char   *check;
   char   *temp;
   char   neglected;

   do {
      neglected = 0;
      check = vfgets( buffer, BUFFER_SIZE, file);
      if ( check)
         current_line++;
      else
         syntax_error(12, (char *)NULL);
      if ( temp = strchr( buffer, COMMENT_CAR)) /* if there is a comment */
         if ( temp == buffer)
            neglected = 1;/* if line conains only a comment*/
         else
            *(temp - 1) = '\0'; /* terminates line before comment */

      while (strchr(SEPARATORS_STRING, *buffer) && *buffer != '\0')
         buffer++;
      if (*buffer == '\0') /* lines that are make of separators */
         neglected = 1;
   } while ( neglected == 1);
}

/*****************************************************************************
 * check_key_word: checks if the given word is a key word.
 *                 If it is, it returns 1; if not it returns 0.
 *****************************************************************************/

static char   check_key_word( WorD)
char   *WorD;
{
   if ( WorD == define_S)
      return 1;
   if ( WorD == tab_S)
      return 1;
   return 0;
}

/*****************************************************************************
 * get_fst_word: gets the first word from the given buffer.
 *               If is_key_word is not null, it checks if the word is a key word
 *               and gives an error if it is the case.
 ******************************************************************************/

static char   *get_fst_word( buffer, is_key_word)
char   *buffer;
char   is_key_word; /* if 1 check if it is a keyword */
{
   char   *temp;

   if ( temp = (char *)strtok( buffer, SEPARATORS_STRING)) {
      temp = namealloc( temp);
      if ( is_key_word)
         if ( check_key_word( temp))
            syntax_error(11, temp);
   }
   return(temp);
}

/*****************************************************************************
 * get_nxt_word: gets the next word from the buffer read by the last 
 *               get_fst_word.
 *               If is_key_word is not null, it checks if the word is a key word
 *               and gives an error if it is the case.
 ******************************************************************************/

static char   *get_nxt_word( is_key_word)
char   is_key_word; /* if 1 check if it is a keyword */
{
   char   *temp;

   if ( temp = (char *)strtok( (char *)NULL, SEPARATORS_STRING)) {
      temp = namealloc( temp);
      if ( is_key_word)
         if ( check_key_word( temp))
            syntax_error(11, temp);
   }
   return(temp);
}

/*****************************************************************************
 * get_nxt_word_s: gets the next string from the buffer read by the last 
 *                 get_fst_word.
 ******************************************************************************/

static char   *get_nxt_word_s()
{
   char   *temp, *st;

   if ( temp = (char *)strtok( (char *)NULL, SEPARATORS_STRING)) {
      st = (char *) mbkalloc(MAX_STRING_SIZE);
      strcpy( st, temp);
      return(st);
   } else
      return((char *)NULL);
}

/***************************************************************************
 * TranslateParam : Translate double param 
 *****************************************************************************/
#define EPSILON      ((double)0.001)
#define EQUAL(a,b)	((((a)-EPSILON) <= (b)) && (((b)) <= (a)+EPSILON))
/*
int EQUAL(a,b)	double a,b;{ int c;
printf("%g, %g\n",a,b);
c= ((((a)-(b)) <= EPSILON) || (((b)-(a)) <= EPSILON) );
c= ((((a)-EPSILON) <= (b)) || (((b)) <= (a)+EPSILON) );
return c;}
*/

static long   TranslateParam( Param )
double   Param;
{
   char   buffer[50];
   double Multiple; /* if interger indicates a multiple of the phys_grid */

   Param = Param * RDS_UNIT_PARAM;
   Multiple = Param / PHYSICAL_GRID_PARAM;

   if ( RDS_UNIT_PARAM == -1)
      syntax_error(5, phys_grid_S);

	/* anint :
	   the mathematical library function anint(x) works like floor(x + .5)
	   and thus is nicer, but some os library do not have it (pc). */
   if( (Multiple < (floor(Multiple + (double).5) - EPSILON))
   ||  (Multiple > (floor(Multiple + (double).5) + EPSILON)) ) {
      sprintf( buffer, "%g", Param / RDS_UNIT_PARAM);
      syntax_error(6, buffer);
   }
   return( ( long )Param );
}

/***************************************************************************
 * ComputeRdsUnit : Compute RDS_UNIT_PARAM from PHYS_GRID_PARAM
 * it is necessary to have even unity, because some operations divides
 * numeric values by 2, and we want to correct them if the result is not
 * a multiple of the physical grid but, the operation must not lose information  
 *****************************************************************************/

static void ComputeRdsUnit( phys_grid )
double   phys_grid;
{
   long   n;
   long   RdsUnit;

   for (n = 1, RdsUnit = 1; !EQUAL(phys_grid*(double)RdsUnit, (double)n); n++){
      if (RdsUnit > MAX_RDS_UNIT)
         syntax_error(7, (char *)NULL);
      for ( RdsUnit--; phys_grid * (double)RdsUnit <  (double)n; RdsUnit++);
		if (EQUAL(phys_grid*(double)RdsUnit, (double)n))
         break;
   }
   RDS_UNIT_PARAM      = 2L * RdsUnit;
   PHYSICAL_GRID_PARAM = 2L * n;
}
#undef EQUAL
#undef EPSILON

/*****************************************************************************
 * get_string_value: returns the numerical value of the given string; if it 
 *                   does not have it gives an error.
 * a little complicated, but reduces the complexity by far.
 *****************************************************************************/
static struct keywords {
   char   *string;
   long   val;
};

static int   keycmp(k, w)
struct keywords *k, *w;
{
   return strcmp(k->string, w->string);
}

long   get_string_value( st)
char   *st;
{
#define N_KEYWORDS 54
   /* !!!!!!!!!!!! THIS MUST BE SORTED BY ALPHABETICAL ORDER */
   static struct keywords define[N_KEYWORDS] = {
      { "alu1",       9, },
      { "alu2",       10, },
      { "alu3",       11, },
      { "c_x_n",       6, },
      { "c_x_p",       7, },
      { "cont_body_n",    4, },
      { "cont_body_p",    5, },
      { "cont_dif_n",    2, },
      { "cont_dif_p",    3, },
      { "cont_poly",    0, },
      { "cont_via",    1, },
      { "cont_via2",    8, },
      { "ndif",       4, },
      { "notreat",       0, },
      { "ntie",       2, },
      { "ntrans",       6, },
      { "null",       -1, },
      { "nwell",       0, },
      { "pdif",       5, },
      { "poly",       8, },
      { "ptie",       3, },
      { "ptrans",       7, },
      { "pwell",       1, },
      { "rds_abox",    24, },
      { "rds_activ",    18, },
      { "rds_alu1",    10, },
      { "rds_alu2",    13, },
      { "rds_alu3",    16, },
      { "rds_cont",    9, },
      { "rds_cpas",    21, },
      { "rds_default",    25, },
      { "rds_gate",    7, },
      { "rds_ndif",    2, },
      { "rds_nimp",    19, },
      { "rds_ntie",    4, },
      { "rds_nwell",    0, },
      { "rds_pdif",    3, },
      { "rds_pimp",    20, },
      { "rds_poly",    6, },
      { "rds_ppol",    22, },
      { "rds_ptie",    5, },
      { "rds_pwell",    1, },
      { "rds_ref",       23, },
      { "rds_talu1",    11, },
      { "rds_talu2",    14, },
      { "rds_talu3",    17, },
      { "rds_tpoly",    8, },
      { "rds_via1",    12, },
      { "rds_via2",    15, },
      { "talu1",       13, },
      { "talu2",       14, },
      { "talu3",       15, },
      { "tpoly",       12, },
      { "treat",       1, }
   };   

   double   float_val;
   long   val;
   struct keywords *key, entry;

   if ( strchr( st, '.' )) {
      if (sscanf(st, "%g", &float_val)) /* sscanf doesn't recognize 0.0 */
         return TranslateParam( atof(st));
      syntax_error(10, st);
   } else if (sscanf(st, "%d", &val))
      return TranslateParam((double)val);

   entry.string = st;
   if ((key = (struct keywords *)bsearch((char *)(&entry), (char *)define, N_KEYWORDS, sizeof(struct keywords ), keycmp)) !=
       NULL )
      return key->val;

   syntax_error( 11, st);
#undef N_KEYWORDS
}

long get_number(st)
char *st;
{
long val;
  if (sscanf(st, "%d", &val))
    return val;
  syntax_error( 11, "number");
}

/*****************************************************************************
 * read_post: reads from the opened file the post tab values and 
 *                post the seg internal - memory - tab structure.
 *****************************************************************************/

static void read_post()
{
   post_record * pt;
   char   index, count;
   char   found;
   char   key_read;

   for ( count = 0; count < RDS_MAX_LAYER; count++) {
      pt = (post_record * ) mbkalloc( sizeof( post_record));
      index = 0;
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      do {
         Word1 = get_nxt_word(1);
         if ( Word1 == end_record_S ) {
            if (index == 0)
               syntax_error(16, (char *)NULL);
            else
               break;
         }
         if ( Word1) {
            pt->post_rec_val[index] = (char) get_string_value( Word1);
            index++;
         }
      } while (( Word1) && (index < N_POST_FIELDS));
      pt->NEXT = post_tab;
      post_tab = pt;
      if (index == N_POST_FIELDS) {
         Word1 = get_nxt_word(0);
         if ( Word1 != end_record_S)
            syntax_error(13, Word1);
      } else
         for (; index < N_POST_FIELDS; index++)
            pt->post_rec_val[index] = get_string_value("null");
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_seg : reads from the opened file the segment tab values 
 *                    and constructs the segment internal - memory - tab 
 *                    structure.
 *****************************************************************************/

static void read_seg()
{
   seg_record * pt;
   char   index, count;
   char   found;
   char   key_read;

   for ( count = 0; count < (LAST_LAYER + 1); count++) {
      pt = (seg_record * ) mbkalloc( sizeof( seg_record));
      index = 0;
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      do {
         Word1 = get_nxt_word(1);
         if ( Word1 == end_record_S) {
            if (index % 3 != 0 )
               syntax_error(14, seg_S);
            else
               break;
         }
         if ( Word1) {
            pt->seg_rec_val[index] = get_string_value( Word1);
            index++;
         }
      } while (( Word1) && ( index < N_SEG_FIELDS));
      pt->NEXT = seg_tab;
      seg_tab = pt;
      if (index == N_SEG_FIELDS) {
         Word1 = get_nxt_word(0);
         if ( Word1 != end_record_S)
            syntax_error(13, Word1);
      } else
         for (; index < N_SEG_FIELDS; index++)
            pt->seg_rec_val[index] = index % 3 ? 0 : get_string_value("null");
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_con: reads from the opened file the con tab values and 
 *           constructs the con internal - memory - tab structure.
 *****************************************************************************/

static void read_con()
{
   con_record * pt;
   char   index, count;
   char   found;
   char   key_read;

   for ( count = 0; count < (LAST_LAYER + 1); count++) {
      pt = (con_record * ) mbkalloc( sizeof( con_record));
      index = 0;
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      Word1 = get_nxt_word(1);
      if ( Word1 == end_record_S) { /* No rds layers defined for an mbk layer */
         pt->con_rec_val[0] = get_string_value( "null");
         pt->con_rec_val[1] = 0;
         pt->con_rec_val[2] = 0;
      } else { /* One rds layers is defined for one mbk layer */
         pt->con_rec_val[0] = get_string_value( Word1);
         pt->con_rec_val[1] = get_string_value(get_nxt_word(1));
         pt->con_rec_val[2] = get_string_value(get_nxt_word(1));
         Word1 = get_nxt_word(0);
         if ( Word1 != end_record_S)
            syntax_error(13, Word1);
      }
      pt->NEXT = con_tab;
      con_tab = pt;
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_via: reads from the opened file the via tab values and 
 *           constructs the via internal - memory - tab structure.
 *****************************************************************************/

static void read_via()
{
   via_record * pt;
   char   index, count;
   char   found;
   char   key_read;

   for ( count = 0; count < (LAST_CONTACT + 1); count++) {
      pt = (via_record * ) mbkalloc( sizeof( via_record));
      index = 0;
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      do {
         Word1 = get_nxt_word(1);
         if ( Word1 == end_record_S) {
            if (index % 2 != 0 )
               syntax_error(15, via_S);
            else
               break;
         }
         if ( Word1) {
            pt->via_rec_val[index] = get_string_value( Word1);
            index++;
         }
      } while ( ( Word1) && ( index < N_VIA_FIELDS));
      pt->NEXT = via_tab;
      via_tab = pt;
      if (index == N_VIA_FIELDS) {
         Word1 = get_nxt_word(0);
         if ( Word1 != end_record_S)
            syntax_error(13, Word1);
      } else
         for (; index < N_VIA_FIELDS; index++)
            pt->via_rec_val[index] = index % 2 ? 0 : get_string_value("null");
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_cif_layer: reads from the opened file the cif_layer tab values and 
 *                 constructs the cif_layer internal - memory - tab structure.
 *****************************************************************************/

static void read_cif_layer()
{
   cif_lay_record * pt;
   char   count;
   char   found;

   for ( count = 0; count < RDS_MAX_LAYER; count++) {
      pt = (cif_lay_record * ) mbkalloc( sizeof( cif_lay_record));
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      Word1 = get_nxt_word_s();
      if ( !Word1)
         syntax_error(14, cif_layer_S);
      pt->cif_lay_rec_val =  Word1;
      pt->NEXT = cif_lay_tab;
      cif_lay_tab = pt;
      Word1 = get_nxt_word(0);
      if ( Word1 != end_record_S)
         syntax_error(13, Word1);
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_gds_layer: reads from the opened file the gds_layer tab values and 
 *                constructs the gds_layer internal - memory - tab structure.
 *****************************************************************************/

static void read_gds_layer()
{
   gds_lay_record * pt;
   char   count;
   char   found;

   for ( count = 0; count < RDS_MAX_LAYER; count++) {
      pt = (gds_lay_record * ) mbkalloc( sizeof( gds_lay_record));
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      Word1 = get_nxt_word(1);
      if ( !Word1)
         syntax_error(14, gds_layer_S);
      pt->gds_lay_rec_val = (char) get_number(Word1);
      pt->NEXT = gds_lay_tab;
      gds_lay_tab = pt;
      Word1 = get_nxt_word(0);
      if ( Word1 != end_record_S)
         syntax_error(13, Word1);
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_oversize: reads from the opened file the oversize tab values and 
 *             constructs the oversize internal - memory - tab structure.
 *****************************************************************************/

static void read_oversize()
{
   oversize_record * pt;
   char   count;
   char   found;

   for ( count = 0; count < RDS_MAX_LAYER; count++) {
      pt = (oversize_record * ) mbkalloc( sizeof( oversize_record));
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      Word1 = get_nxt_word(1);
      if ( !Word1)
         syntax_error(14, oversize_S);
      pt->oversize_rec_val = get_string_value( Word1);
      pt->NEXT = oversize_tab;
      oversize_tab = pt;
      Word1 = get_nxt_word(0);
      if ( Word1 != end_record_S)
         syntax_error(13, Word1);
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_ringwidth: reads from the opened file the ringwidth tab values and 
 *                constructs the ringwidth internal - memory - tab structure.
 *****************************************************************************/

static void read_ringwidth()
{
   ringwidth_record * pt;
   char   count;
   char   found;

   for ( count = 0; count < RDS_MAX_LAYER; count++) {
      pt = (ringwidth_record * ) mbkalloc( sizeof( ringwidth_record));
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      Word1 = get_nxt_word(1);
      if ( !Word1)
         syntax_error(14, ringwidth_S);
      pt->ringwidth_rec_val = get_string_value( Word1);
      pt->NEXT = ringwidth_tab;
      ringwidth_tab = pt;
      Word1 = get_nxt_word(0);
      if ( Word1 != end_record_S)
         syntax_error(13, Word1);
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/*****************************************************************************
 * read_layerwidth: reads from the opened file the layerwidth tab values and 
 *                constructs the layerwidth internal - memory - tab structure.
 *****************************************************************************/

static void read_layerwidth()
{
   layerwidth_record * pt;
   char   count;
   char   found;

   for ( count = 0; count < RDS_MAX_LAYER; count++) {
      pt = (layerwidth_record * ) mbkalloc( sizeof( layerwidth_record));
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 1);
      pt->key = (char) get_string_value( Word1);
      Word1 = get_nxt_word(1);
      if ( !Word1)
         syntax_error(14, layerwidth_S);
      pt->layerwidth_rec_val = get_string_value( Word1);
      pt->NEXT = layerwidth_tab;
      layerwidth_tab = pt;
      Word1 = get_nxt_word(0);
      if ( Word1 != end_record_S)
         syntax_error(13, Word1);
   }
   get_line( Buffer, file);
   Word1 = get_fst_word( Buffer, 0);
   if( Word1 != end_table_S )
      syntax_error(3,end_table_S);
}

/***************************************************************************
 * read_param : reads from the opened file the variable definitions and 
 *              affects them to the (global) variables.
 *              it checks if all program varables are defined and gives
 *              an error if they are not
 *        and   reads from the opened file the tabs values and constructs
 *              the internal - memory - tabs structures. 
 *              It checks if all tabs are defined and gives an error if 
 *              they are not.
 *****************************************************************************/

static void read_param()
{
   for (; ; ) {
      if ( is_all_table_defined && is_all_var_defined )
         return;
      get_line( Buffer, file);
      Word1 = get_fst_word( Buffer, 0);
      if ( Word1 == define_S ) {
         if (!(Word1 = get_nxt_word(1)))
            syntax_error(9, define_S);
         if (!(Word2 = get_nxt_word(1)))
            syntax_error(8, Word2);
         if ( Word1 == phys_grid_S) {
            ComputeRdsUnit( atof( Word2 ));
            mark_phys_grid;
            continue;
         }
         if ( Word1 == lambda_S) {
            LAMBDA_PARAM = TranslateParam( atof( Word2) );
            mark_lambda;
            continue;
         }
         syntax_error(4, Word1);
      } else if (Word1 == tab_S) {
         if (!(Word1 = get_nxt_word(1)))
            syntax_error(9, tab_S);
         if ( Word1 == post_S) {
            read_post();
            mark_post;
            continue;
         }
         if ( Word1 == seg_S)  {
            read_seg();
            mark_rfm_seg;
            continue;
         }
         if ( Word1 == con_S)  {
            read_con();
            mark_rfm_con;
            continue;
         }
         if ( Word1 == via_S)  {
            read_via();
            mark_rfm_via;
            continue;
         }
         if ( Word1 == cif_layer_S)  {
            read_cif_layer();
            mark_cif_layer;
            continue;
         }
         if ( Word1 == gds_layer_S)  {
            read_gds_layer();
            mark_gds_layer;
            continue;
         }
         if ( Word1 == oversize_S)  {
            read_oversize();
            mark_oversize;
            continue;
         }
         if ( Word1 == ringwidth_S)  {
            read_ringwidth();
            mark_ringwidth;
            continue;
         }
         if ( Word1 == layerwidth_S)  {
            read_layerwidth();
            mark_layerwidth;
            continue;
         }
         syntax_error(17, Word1);
      } else
         syntax_error(0, Word1);
   }
}

/*****************************************************************************
 * open_param: opens the given technological file and gives an error if not
 *                found.
 ****************************************************************************/

static void open_param()
{
   if( !( file = fopen( RDS_TECHNO_NAME, "r")))
      syntax_error( 15, RDS_TECHNO_NAME);
}

/******************************************************************************
 * LoadParam: loads from the given conlogical file the data necessary to
 *              construct the internal - memory - technological varaibles and
 *              tabs.
 *****************************************************************************/

void LoadParam()
{
   prepare();
   open_param();
   read_param();
   fclose( file);
}

/************************
 *
 * Static tables for grale usage.
 ************************************/
long MBK_VIA_TO_LAYER_RDS[][3] = {
  {15, 05, 10}, /* CONT_POLY */
  {10, 05, 15}, /* CONT_VIA  */
  {15, 05, 10}, /* CONT_DIFN */
  {15, 05, 10}, /* CONT_DIFP */
  {15, 05, 10}, /* CONT_BODYN */
  {15, 05, 10}, /* CONT_BODYP */
  {25, 05, 00}, /* C_X_N   */
  {25, 05, 00}, /* C_X_P   */
  {15, 05, 25} /* CONT_VIA2 */
};

long SEGMENT_EXTENTION[] = {
     00,   /* NWELL             */
     00,   /* PWELL    SEGMENT  */
     05,   /* NDIF              */
     05,   /* PDIF              */
     05,   /* NTIE    /-----\   */
     05,   /* PTIE    |     |   */
     05,   /* POLY    |  X  |   */
     00,   /* GATE    |  |  |   */
     05,   /* TPOLY   |  |  |   */
     00,   /* CONT    |  |  |   */
     05,   /* ALU1    |  |  |   */
     05,   /* TALU1   |  |  |   */
     00,   /* VIA1  ^ |  X  |   */
     10,   /* ALU2  | |     |   */
     10,   /* TALU2 v \-----/   */
     00,   /* VIA2              */
     20,   /* ALU3              */
     20,   /* TALU3             */
     00,   /* REF               */
     00,   /* ABOX              */
     00    /* DEFAULT           */
};

long SEGMENT_WIDTH[] = {
     00,   /* NWELL             */
     40,   /* PWELL    SEGMENT  */
     20,   /* NDIF              */
     20,   /* PDIF              */
     20,   /* NTIE    /-----\   */
     20,   /* PTIE    |     |   */
     10,   /* POLY    |  X  |   */
     10,   /* GATE    |  |  |   */
     10,   /* TPOLY   |  |  |   */
     10,   /* CONT    |  |  |   */
     10,   /* ALU1    |  |  |   */
     10,   /* TALU1   |  |  |   */
     10,   /* VIA1    |  X  |   */
     20,   /* ALU2    |     |   */
     20,   /* TALU2   \-----/   */
     10,   /* VIA2    :     :   */
     40,   /* ALU3    <----->   */
     40,   /* TALU3             */
     10,   /* REF               */
     00,   /* ABOX              */
     00    /* DEFAULT           */
};
 
long TRANSISTOR_WIDTH = 20;
long TRANSISTOR_EXTENTION = 15;
long REFERENCE_SIZE = 10;
