/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : synthetiseur logique                                        */
/*    Fichier : prep.c                                                      */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : L. Burgun                             le : 31/01/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "mut309.h"
#include "log120.h"
#include "beh104.h"
#include "carac.h"

/*-------------------------------------------------------------------------
memberPType	: renvoie 1 si le signal doit etre elimine 
---------------------------------------------------------------------------
retour		: un int.
---------------------------------------------------------------------------*/
short memberPType(name,ptl)
char *name;
ptype_list *ptl;
 
{
ptype_list *l;
 
for(l = ptl;l;l = l->NEXT)
        if (strcmp((char *)l->DATA,name) == 0) return 1;
return 0;
}

/*-------------------------------------------------------------------------
memberChain	: renvoie 1 si name appartient a liste 
---------------------------------------------------------------------------
retour		: un int.
---------------------------------------------------------------------------*/
short memberChain(name,cl)
char *name;
chain_list *cl;
 
{
chain_list *l;
 
for(l = cl;l;l = l->NEXT)
        if (strcmp((char *)l->DATA,name) == 0) return 1;
return 0;
}

/*-------------------------------------------------------------------------
elimSignal	: renvoie 1 si le signal doit etre elimine 
---------------------------------------------------------------------------
retour		: un int.
---------------------------------------------------------------------------*/
int elimSignal(occ,num,optim,numpere)
int occ,num;
int optim;
int numpere;
{
if (optim == 1)		/* optimisation delais */
   {
   if ( occ == 1 || 
       (occ == 2 && num <= 3) || 
       (occ == 3 && num <= 2) || 
        num == 1)
      return(1);
   else
      return(0);
   }
else
   if ( occ == 1 ||
       (occ == 2 && num == 2 && numpere < 4) || 
        num == 1)
      return(1);
   else
      return(0);
}

/*-------------------------------------------------------------------------
searchNameBeh 	: renvoie 1 si name est dans une expression de beh. 
---------------------------------------------------------------------------
retour		: un int.
---------------------------------------------------------------------------*/
int searchNameBeh(beh,name)

befig_list *beh;
char *name;
{
beout_list *out;
bereg_list *reg;
biabl_list *biabl;
bebus_list *bus;
bebux_list *bux;
beaux_list *aux;
chain_list *expr;


aux = beh->BEAUX;
while (aux) 
   {
   if (aux->ABL)
      {
      if (searchExpr(aux->ABL,name))
         return(1);
      }
   aux = aux->NEXT;
   }

out = beh->BEOUT;
while (out) 
   {
   if (out->ABL)
      {
      if (searchExpr(out->ABL,name))
         return(1);
      }
   out = out->NEXT;
   }

reg = beh->BEREG;
while (reg) 
   {
   biabl = reg->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         if (searchExpr(biabl->VALABL,name))
            return(1);
         if (searchExpr(biabl->CNDABL,name))
            return(1);
         }
      biabl = biabl->NEXT;
      }
   reg = reg->NEXT;
   }


bus = beh->BEBUS;
while (bus) 
   {
   biabl = bus->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         if (searchExpr(biabl->VALABL,name))
            return(1);
         if (searchExpr(biabl->CNDABL,name))
            return(1);
         }
      biabl = biabl->NEXT;
      }
   bus = bus->NEXT;
   }

bux = beh->BEBUX;
while (bux) 
   {
   biabl = bux->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         if (searchExpr(biabl->VALABL,name))
            return(1);
         if (searchExpr(biabl->CNDABL,name))
            return(1);
         }
      biabl = biabl->NEXT;
      }
   bux = bux->NEXT;
   }

return 0;
}
/*-------------------------------------------------------------------------
mapCarExprBeh	: applique une fonction de conversion sur chaque expression
                  d'une befig 
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/
void mapCarExprBeh(beh,func)

befig_list *beh;
chain_list *(*func)();
{
beout_list *out;
bereg_list *reg;
bebus_list *bus;
bebux_list *bux;
biabl_list *biabl;
beaux_list *aux;
chain_list *expr;


aux = beh->BEAUX;
while (aux) 
   {
   if (aux->ABL)
      {
      expr = (*func)(aux->ABL);
      freeExpr(aux->ABL); 
      aux->ABL = expr;
      }
   aux = aux->NEXT;
   }

out = beh->BEOUT;
while (out) 
   {
   if (out->ABL)
      {
      expr = (*func)(out->ABL);
      freeExpr(out->ABL);
      out->ABL = expr;
      }
   out = out->NEXT;
   }

reg = beh->BEREG;
while (reg) 
   {
   biabl = reg->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         expr = (*func)(biabl->CNDABL);
         freeExpr(biabl->CNDABL);
         biabl->CNDABL = expr;
         expr = (*func)(biabl->VALABL);
         freeExpr(biabl->VALABL);
         biabl->VALABL = expr;
         }
      biabl = biabl->NEXT;
      }
   reg = reg->NEXT;
   }

bus = beh->BEBUS;
while (bus) 
   {
   biabl = bus->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         expr = (*func)(biabl->CNDABL);
         freeExpr(biabl->CNDABL);
         biabl->CNDABL = expr;
         expr = (*func)(biabl->VALABL);
         freeExpr(biabl->VALABL);
         biabl->VALABL = expr;
         }
      biabl = biabl->NEXT;
      }
   bus = bus->NEXT;
   }

bux = beh->BEBUX;
while (bux) 
   {
   biabl = bux->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         expr = (*func)(biabl->CNDABL);
         freeExpr(biabl->CNDABL);
         biabl->CNDABL = expr;
         expr = (*func)(biabl->VALABL);
         freeExpr(biabl->VALABL);
         biabl->VALABL = expr;
         }
      biabl = biabl->NEXT;
      }
   bux = bux->NEXT;
   }
}
/*-------------------------------------------------------------------------
mapExprBeh	: applique une procedure sur chaque expression d'une befig 
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/
void mapExprBeh(beh,func)
befig_list *beh;
void (*func)();
{
beout_list *out;
bereg_list *reg;
bebus_list *bus;
bebux_list *bux;
biabl_list *biabl;
beaux_list *aux;

	/* parcours de la befig avec remplissage de pTHOcc */

aux = beh->BEAUX;
while (aux) 
   {
   if (aux->ABL)
      {
      (*func)(aux->ABL);
      }
   aux = aux->NEXT;
   }

out = beh->BEOUT;
while (out) 
   {
   if (out->ABL)
      {
      (*func)(out->ABL);
      }
   out = out->NEXT;
   }

reg = beh->BEREG;
while (reg) 
   {
   biabl = reg->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         (*func)(biabl->CNDABL);
         (*func)(biabl->VALABL);
         }
      biabl = biabl->NEXT;
      }
   reg = reg->NEXT;
   }

bus = beh->BEBUS;
while (bus) 
   {
   biabl = bus->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         (*func)(biabl->CNDABL);
         (*func)(biabl->VALABL);
         }
      biabl = biabl->NEXT;
      }
   bus = bus->NEXT;
   }

bux = beh->BEBUX;
while (bux) 
   {
   biabl = bux->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         (*func)(biabl->CNDABL);
         (*func)(biabl->VALABL);
         }
      biabl = biabl->NEXT;
      }
   bux = bux->NEXT;
   }
}
/*-------------------------------------------------------------------------
substTHOccExpr : susbtitue les auxiliaires  de trop petite granularite
                 par leurs expressions associes. 
---------------------------------------------------------------------------
retour		: une expression.
---------------------------------------------------------------------------*/
chain_list *substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,expr,optim,dejaTraite,numpere)
befig_list *beh;
pTH pTHOcc;
pTH pTHNum;
pTH pTHAux;
chain_list *expr;
int optim;
pTH dejaTraite;
int numpere;		/* nombre de litteraux du pere
                           si 0 on ne s'en occupe pas */
{
if (expr == NULL)
   {
   printf("substTHOccExpr : error - expression = NULL\n");
   exit(-1);
   }

if (ATOM(expr))
   {
   int num,occ;

   if (!strcmp(VALUE_ATOM(expr),"'0'") ||
       !strcmp(VALUE_ATOM(expr),"'1'") ||
       !strcmp(VALUE_ATOM(expr),"'d'"))
      return(copyExpr(expr));


		/* c'est un signal auxiliaire */

   if ((occ = searchTH(pTHOcc,VALUE_ATOM(expr))) != EMPTYTH)
      {
      beaux_list *aux;

      num = searchTH(pTHNum,VALUE_ATOM(expr));

      aux = (beaux_list *) searchTH(pTHAux,VALUE_ATOM(expr));
      if (aux == (beaux_list *) EMPTYTH)
         {
         printf("substTHOccExpr : error auxiliary signal doesn't exist %s\n",aux->NAME);
         exit(-1);
         }

      if (elimSignal(occ,num,optim,numpere))
         {
         chain_list *support;

         	/* substitution du signal */

		/* si le signal a deja ete traite */

         if (searchTH(dejaTraite,VALUE_ATOM(expr)) != EMPTYTH)
            return(copyExpr(aux->ABL));

         addTH(dejaTraite,VALUE_ATOM(expr),1);

		/* on recupere le support et on incremente le nombre
                   d'occurence de chaque aux avec occ-1 */

         support = supportChain_listExpr(aux->ABL);
         while (support)
            {
            int occaux;
			/* c'est une aux. */

            occaux =  searchTH(pTHOcc,(char *) support->DATA);
            if (occaux != EMPTYTH)
               {
               addTH(pTHOcc,(char *) support->DATA,occaux + occ -1);
               }
            support=support->NEXT;
            }

         freechain(support);

		/* on decremente le nombre d'occurence de aux */

         addTH(pTHOcc,aux->NAME,occ -1);

                /* descente recursive dans la befig */

         if (numpere == 0)
            aux->ABL = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,aux->ABL,optim,dejaTraite,0);
         else
            aux->ABL = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,aux->ABL,optim,dejaTraite,numberAtomExpr(aux->ABL));
         return(copyExpr(aux->ABL));
         }
      else
         {	/* pas de substitution */

         if (searchTH(dejaTraite,VALUE_ATOM(expr)) != EMPTYTH)
            return copyExpr(expr);

                /* descente recursive dans la befig */

         addTH(dejaTraite,VALUE_ATOM(expr),1);
         if (numpere == 0)
            aux->ABL = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,aux->ABL,optim,dejaTraite,0);
         else
            aux->ABL = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,aux->ABL,optim,dejaTraite,numberAtomExpr(aux->ABL));
         return(copyExpr(expr));
         }
      }
		/* ce n'est pas une variable aux. */

   return (copyExpr(expr));
   }
else
   {
   chain_list *ret;

   ret = createExpr(OPER(expr));
   while (expr = CDR(expr))
      {
      addQExpr(ret,substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,CAR(expr),optim,dejaTraite,numpere));
      }
   return(ret);
   }
}

/*-------------------------------------------------------------------------
compactExprBeh	: changement de la granularite des equations par elimination
		selective des signaux intermediaires. 
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/
void compactExprBeh(beh,optim,delais,optimPO,numpere)
befig_list *beh;
int optim;
ptype_list *delais;
chain_list *optimPO;
int numpere;		/* si 0, pas de calcul des litteraux du pere */
{
beout_list *out;
bereg_list *reg;
bebus_list *bus;
bebux_list *bux;
biabl_list *biabl;
beaux_list *aux,*auxp;
chain_list *expr;

pTH pTHOcc,pTHNum,pTHAux;
pTH caracTH,dejaTraite;
int delaisMoyen;

		/* elimination des 1 et 0 */

mapCarExprBeh(beh,simplif10Expr);



pTHNum = createTH(100);	/* table des auxiliaires/nombre de litteraux */
pTHOcc = createTH(100); /* table des auxiliaires/nombre d'occurences */
pTHAux = createTH(100); /* table des auxiliaires/expression */

dejaTraite = createTH(100);

	/* parcours des auxiliaires avec remplissage des tables de hachage */

aux = beh->BEAUX;
while (aux) 
   {
   		    /* variables aux que l'on peut eliminer */
   if (!memberPType(aux->NAME,delais))
      addTH(pTHOcc,aux->NAME,0);
   if (aux->ABL)
      {
      addTH(pTHNum,aux->NAME,numberAtomExpr(aux->ABL));
      addTH(pTHAux,aux->NAME,(int) aux);
      }
   aux = aux->NEXT;
   }
	/* remplissage de la table pTHOcc */

remplTHOccBeh(beh,pTHOcc);

                /* caracterisation */
 
caracTH = caracBeh(beh,delais,0);
 
                /* ----- a correler avec le mode d'optimisation */
 
delaisMoyen = delaisCarac(caracTH,optim);

 
		/* substitution des signaux auxiliaires inutiles */

	/* on commence par les cones a optimiser en delais */

out = beh->BEOUT;
while (out) 
   {
   int del;

   if (out->ABL)
      if ((del = searchTH(caracTH,out->ABL)) > delaisMoyen ||
          memberChain(out->NAME,optimPO))
         {
         if (numpere)
            expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,out->ABL,1,dejaTraite,numberAtomExpr(out->ABL));
          else
            expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,out->ABL,1,dejaTraite,0);

	/* remise a jour de caracTH avec le nouvel ABL */

         addTH(caracTH,expr,del);

         freeExpr(out->ABL);
         out->ABL = expr;
         }
   out = out->NEXT;
   }

reg = beh->BEREG;
while (reg) 
   {
   biabl = reg->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
	 int del;

         if ((del = searchTH(caracTH,biabl->CNDABL)) > delaisMoyen ||
             memberChain(reg->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,1,dejaTraite,numberAtomExpr(biabl->CNDABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,1,dejaTraite,0);

  	    /* remise a jour de caracTH avec le nouvel ABL */
            addTH(caracTH,expr,del);

            freeExpr(biabl->CNDABL);
            biabl->CNDABL = expr;
            }
         if ((del = searchTH(caracTH,biabl->VALABL)) > delaisMoyen ||
             memberChain(reg->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,numberAtomExpr(biabl->VALABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,0);

     	    /* remise a jour de caracTH avec le nouvel ABL */
            addTH(caracTH,expr,del);

            freeExpr(biabl->VALABL);
            biabl->VALABL = expr;
            }
         }
      biabl = biabl->NEXT;
      }
   reg = reg->NEXT;
   }

bus = beh->BEBUS;
while (bus) 
   {
   biabl = bus->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
	 int del;

         if ((del = searchTH(caracTH,biabl->CNDABL)) > delaisMoyen ||
             memberChain(bus->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,1,dejaTraite,numberAtomExpr(biabl->CNDABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,1,dejaTraite,0);

	    /* remise a jour de caracTH avec le nouvel ABL */
            addTH(caracTH,expr,del);

            freeExpr(biabl->CNDABL);
            biabl->CNDABL = expr;
            }
         if ((del = searchTH(caracTH,biabl->VALABL)) > delaisMoyen ||
             memberChain(bus->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,numberAtomExpr(biabl->VALABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,0);

	    /* remise a jour de caracTH avec le nouvel ABL */
            addTH(caracTH,expr,del);

            freeExpr(biabl->VALABL);
            biabl->VALABL = expr;
            }
         }
      biabl = biabl->NEXT;
      }
   bus = bus->NEXT;
   }

bux = beh->BEBUX;
while (bux) 
   {
   biabl = bux->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
	 int del;

         if ((del = searchTH(caracTH,biabl->CNDABL)) > delaisMoyen ||
             memberChain(bux->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,1,dejaTraite,numberAtomExpr(biabl->CNDABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,1,dejaTraite,0);

	    /* remise a jour de caracTH avec le nouvel ABL */
            addTH(caracTH,expr,del);

            freeExpr(biabl->CNDABL);
            biabl->CNDABL = expr;
            }
         if ((del = searchTH(caracTH,biabl->VALABL)) > delaisMoyen ||
             memberChain(bux->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,numberAtomExpr(biabl->VALABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,0);

	    /* remise a jour de caracTH avec le nouvel ABL */
            addTH(caracTH,expr,del);

            freeExpr(biabl->VALABL);
            biabl->VALABL = expr;
            }
         }
      biabl = biabl->NEXT;
      }
   bux = bux->NEXT;
   }


	/* on recalcule pTHOcc avant les cones non-optimises en delais */

destroyTH(pTHOcc);
pTHOcc = createTH(100);

aux = beh->BEAUX;
while (aux) 
   {
   if (!memberPType(aux->NAME,delais))
      addTH(pTHOcc,aux->NAME,0);
   aux = aux->NEXT;
   }
	/* remplissage de la table pTHOcc */

remplTHOccBeh(beh,pTHOcc);

	/* calcul des cones non optimise en delais */
	/* optimisatiom en surface */

out = beh->BEOUT;
while (out) 
   {
   if (out->ABL)
      if (searchTH(caracTH,out->ABL) <= delaisMoyen &&
          !memberChain(out->NAME,optimPO))
         {
         if (numpere)
            expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,out->ABL,0,dejaTraite,numberAtomExpr(out->ABL));
          else
            expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,out->ABL,0,dejaTraite,0);

         freeExpr(out->ABL);
         out->ABL = expr;
         }
   out = out->NEXT;
   }

reg = beh->BEREG;
while (reg) 
   {
   biabl = reg->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         if (searchTH(caracTH,biabl->CNDABL) > delaisMoyen &&
             !memberChain(reg->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,0,dejaTraite,numberAtomExpr(biabl->CNDABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,0,dejaTraite,0);
            freeExpr(biabl->CNDABL);
            biabl->CNDABL = expr;
            }
         if (searchTH(caracTH,biabl->VALABL) > delaisMoyen &&
             !memberChain(reg->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,numberAtomExpr(biabl->VALABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,0);
            freeExpr(biabl->VALABL);
            biabl->VALABL = expr;
            }
         }
      biabl = biabl->NEXT;
      }
   reg = reg->NEXT;
   }

bus = beh->BEBUS;
while (bus) 
   {
   biabl = bus->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         if (searchTH(caracTH,biabl->CNDABL) > delaisMoyen &&
             !memberChain(bus->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,0,dejaTraite,numberAtomExpr(biabl->CNDABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,0,dejaTraite,0);
            freeExpr(biabl->CNDABL);
            biabl->CNDABL = expr;
            }
         if (searchTH(caracTH,biabl->VALABL) > delaisMoyen &&
             !memberChain(bus->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,numberAtomExpr(biabl->VALABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,0);
            freeExpr(biabl->VALABL);
            biabl->VALABL = expr;
            }
         }
      biabl = biabl->NEXT;
      }
   bus = bus->NEXT;
   }

bux = beh->BEBUX;
while (bux) 
   {
   biabl = bux->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         if (searchTH(caracTH,biabl->CNDABL) > delaisMoyen &&
             !memberChain(bux->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,0,dejaTraite,numberAtomExpr(biabl->CNDABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->CNDABL,0,dejaTraite,0);
            freeExpr(biabl->CNDABL);
            biabl->CNDABL = expr;
            }
         if (searchTH(caracTH,biabl->VALABL) > delaisMoyen &&
             !memberChain(bux->NAME,optimPO))
            {
            if (numpere)
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,numberAtomExpr(biabl->VALABL));
            else
               expr = substTHOccExpr(beh,pTHOcc,pTHNum,pTHAux,biabl->VALABL,0,dejaTraite,0);
            freeExpr(biabl->VALABL);
            biabl->VALABL = expr;
            }
         }
      biabl = biabl->NEXT;
      }
   bux = bux->NEXT;
   }
	/* elimination des signaux auxiliaires expanses */ 

	/* on re-re-calcule le fanout des variables auxiliaires */

destroyTH(pTHOcc);
pTHOcc = createTH(100);

aux = beh->BEAUX;
while (aux) 
   {
   if (!memberPType(aux->NAME,delais))
      addTH(pTHOcc,aux->NAME,0);
   aux = aux->NEXT;
   }
	/* remplissage de la table pTHOcc */

remplTHOccBeh(beh,pTHOcc);
 

	/* on elimine les signaux de fanout 0 */

aux = beh->BEAUX;
auxp = NULL;
while (aux) 
   {
   int occ;

   occ = searchTH(pTHOcc,aux->NAME);

   if (occ != 0)
      {
      auxp = beh_addbeaux(auxp,aux->NAME,aux->ABL,NULL);
      auxp->NODE = aux->NODE;
      } 
   aux = aux->NEXT;
   }
beh->BEAUX = auxp;


		/* simplification des not */

mapCarExprBeh(beh,simplifNotExpr);

mapExprBeh(beh,flatArityExpr);

destroyTH(caracTH);
destroyTH(dejaTraite);
destroyTH(pTHOcc);
destroyTH(pTHNum);
destroyTH(pTHAux);
}
