/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpaiol.c					*/
/* date		: Sep  8 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a PAT	*/
/*		  data structure					*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include <pat103.h>

/* ###--------------------------------------------------------------### */
/* function	: pat_addpaiol						*/
/* description	: create an empty PAIOL structure at the top of a list	*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct paiol *pat_addpaiol (lastpaiol, name, format, mode, blank)

struct paiol  *lastpaiol;	/* pointer on the last paiol structure	*/
char          *name;		/* input-output's name			*/
char           format;		/* input-output format			*/
char           mode;		/* input-output mode			*/
unsigned char  blank;		/* nbr of blank column to be printed	*/
				/* after the input-output value		*/

  {
  struct paiol *ptiol;

  name          = namealloc (name);

  ptiol         = (struct paiol *) mbkalloc (sizeof(struct paiol));
  ptiol->NAME   = name;
  ptiol->FORMAT = format;
  ptiol->MODE   = mode;
  ptiol->BLANK  = blank;
  ptiol->VALUE  = '*';
  ptiol->SIG    = NULL;
  ptiol->NEXT   = lastpaiol;

  return (ptiol);
  }
