%{
/*###----------------------------------------------------------------###*/
/*									*/
/*             Filename : mvl_scomp.lex					*/
/*             Authors  : L.A. TABUSSE                     		*/
/*			  VUONG H.N.					*/
/*             Date     : Jan 29 1992					*/
/*             Contents : Lexical VHDL Analyser				*/
/*                          For any details refer to the IEEE Standard  */
/*                          VHDL LRM Chapter 13 : Lexical Elements      */
/*             Called func. : namealloc <mbk.h>, mbkalloc <mbk>, find_mc*/
/*									*/
/*###----------------------------------------------------------------###*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <search.h>
#include "../mvl_include.h"
#include "mvl_stype.h"
#include "y.tab.h"
#include "mvl_slex.h"
#include "mvl_stdef.h"

static el_mc tab_mc []=
  {
    {"abs"		,ABS},
    {"access"		,ACCESS},
    {"after"		,AFTER},
    {"alias"		,ALIAS},
    {"all"		,ALL},
    {"and"		,_AND},
    {"architecture"	,ARCHITECTURE},
    {"array"		,ARRAY},
    {"assert"		,ASSERT},
    {"attribute"	,ATTRIBUTE},
    {"begin"		,BEGIN_},
    {"bit"		,BIT},
    {"bit_vector"	,BIT_VECTOR},
    {"block"		,BLOCK},
    {"body"		,BODY},
    {"buffer"		,BUFFER},
    {"bus"		,BUS},
    {"case"		,CASE},
    {"component"	,COMPONENT},
    {"configuration"	,CONFIGURATION},
    {"constant"		,CONSTANT},
    {"convert"		,CONVERT},
    {"disconnect"	,DISCONNECT},
    {"downto"		,DOWNTO},
    {"else"		,ELSE},
    {"elsif"		,ELSIF},
    {"end"		,END_},
    {"entity"		,ENTITY},
    {"error"		,ERROR},
    {"exit"		,_EXIT},
    {"file"		,FILE_},
    {"for"		,FOR},
    {"function"		,FUNCTION},
    {"generate"		,GENERATE},
    {"generic"		,GENERIC},
    {"guarded"		,GUARDED},
    {"if"		,IF},
    {"in"		,_IN},
    {"inout"		,_INOUT},
    {"is"		,IS},
    {"label"		,_LABEL},
    {"library"		,LIBRARY},
    {"linkage"		,_LINKAGE},
    {"loop"		,LOOP},
    {"map"		,MAP},
    {"mod"		,MOD},
    {"mux_bit"		,MUX_BIT},
    {"mux_vector"	,MUX_VECTOR},
    {"nand"		,_NAND},
    {"natural"		,NATURAL},
    {"natural_vector"   ,NATURAL_VECTOR},
    {"new"		,NEW},
    {"next"		,_NEXT},
    {"nor"		,_NOR},
    {"not"		,_NOT},
    {"null"		,NULL_},
    {"of"		,OF},
    {"on"		,ON},
    {"open"		,OPEN},
    {"or"		,_OR},
    {"others"		,OTHERS},
    {"out"		,_OUT},
    {"package"		,PACKAGE},
    {"port"		,PORT},
    {"procedure"	,PROCEDURE},
    {"process"		,PROCESS},
    {"range"		,RANGE},
    {"record"		,RECORD},
    {"reg_bit"		,REG_BIT},
    {"reg_vector"	,REG_VECTOR},
    {"register"		,REGISTER},
    {"rem"		,REM},
    {"report"		,REPORT},
    {"return"		,RETURN},
    {"select"		,SELECT},
    {"severity"		,SEVERITY},
    {"signal"		,SIGNAL},
    {"subtype"		,SUBTYPE},
    {"then"		,THEN},
    {"to"		,TO},
    {"transport"	,TRANSPORT},
    {"type"		,TYPE},
    {"units"		,UNITS},
    {"until"		,UNTIL},
    {"use"		,USE},
    {"variable"		,VARIABLE},
    {"wait"		,WAIT},
    {"warning"		,WARNING},
    {"when"		,WHEN},
    {"while"		,WHILE},
    {"with"		,WITH},
    {"wor_bit"		,WOR_BIT},
    {"wor_vector"	,WOR_VECTOR},
    {"xor"		,_XOR}
  };

static int find_mc(s)

  char *s;
  {
  char  loc[YYLMAX];
  int   l;
  el_mc *pt;

  l=strlen(s);
  strcpy(loc,s);
  while(l--) loc[l]=tolower(loc[l]);	/* conversion en minuscules */
  pt= (el_mc *) bsearch(loc, (char *)tab_mc,MVL_NB_MC,sizeof(el_mc),strcmp);
  if (pt==NULL) return(-1);
  else return(pt->kval);
  }
%}

upper_case_letter 	  [A-Z]
digit 			  [0-9]
special_character   	  [\#\&\'\(\)\*\+\,\-\.\/\:\;\<\=\>\_\|]
space_character 	  [ \t]
format_effector		  [\t\v\r\l\f]
end_of_line		  \n
lower_case_letter 	  [a-z]
other_special_character   [\!\$\@\?\[\\\]\^\`\{\}\~]

graphic_character	  ({basic_graphic_character}|{lower_case_letter}|{other_special_character})
basic_graphic_character	  ({upper_case_letter}|{digit}|{special_character}|{space_character})
letter		   	  ({upper_case_letter}|{lower_case_letter})
letter_or_digit	   	  ({letter}|{digit})
decimal_literal	   	  {integer}(\.{integer})?({exponent})?
integer		   	  {digit}(_?{digit})*
exponent	   	  ([eE][-+]?{integer})
base		   	  {integer}
based_integer	   	  {extended_digit}(_?{extended_digit})*
extended_digit	   	  ({digit}|[a-fA-F])
base_specifier	  	  (B|b|O|o|X|x)
%%
{space_character}	{
			/* nothing */
			/* separators */
			}
\&									{
			return(Ampersand);
									}
\'									{
			return(Apostrophe);
									}
\(									{
			return(LeftParen);
									}
\)									{
			return(RightParen);
									}
"**"									{
			return(DoubleStar);
									}
\*									{
			return(Star);
									}
\+									{
			return(Plus);
									}
\,									{
			return(Comma);
									}
\-									{
			return(Minus);
									}
":="									{
			return(VarAsgn);
									}
\:									{
			return(Colon);
									}
\;									{
			return(Semicolon);
									}
"<="									{
			return(_LESym);
									}
">="									{
			return(_GESym);
									}
\<									{
			return(_LTSym);
									}
\>									{
			return(_GTSym);
									}
=									{
			return(_EQSym);
									}
\/=									{
			return(_NESym);
									}
"=>"									{
			return(Arrow);
									}
"<>"									{
			return(Box);
									}
\|									{
			return(Bar);
									}
!									{
			return(Bar);
									}
\.									{
			return(Dot);
									}
\/									{
			return(Slash);
									}
{letter}(_?{letter_or_digit})* 						{
			int itoken;
			itoken=find_mc(yytext);
			if (itoken== -1) 
			  {
			  yylval.text = namealloc(yytext);
			  return ( Identifier );
			  }
			else
			  {
			  return ( itoken );
			  }
									}
({decimal_literal})|({base}#{based_integer}(\.{based_integer})?#({exponent})?)|({base}:{based_integer}(\.{based_integer})?:({exponent})?)		{
			yylval.text = mbkalloc((unsigned int)strlen(yytext)+1);
	 		strcpy(yylval.text,yytext);
			return ( AbstractLit );
									}
'({graphic_character}|\"|\%)' 						{
			yylval.text = mbkalloc((unsigned int)strlen(yytext)+1);
	 		strcpy(yylval.text,yytext);
			return ( CharacterLit );
									}
(\"({graphic_character}|(\"\")|\%)*\")|(\%({graphic_character}|(\%\%)|\")*\%) {
			yylval.text = mbkalloc((unsigned int)strlen(yytext)+1);
	 		strcpy(yylval.text,yytext);
			return ( StringLit );
									}
{base_specifier}(\"{extended_digit}(_?{extended_digit})*\"|\%{extended_digit}(_?{extended_digit})*\%) 							{
			yylval.text = mbkalloc((unsigned int)strlen(yytext)+1);
	 		strcpy(yylval.text,yytext);
			return ( BitStringLit );
									}
\n									{
			/* end of line */
			MVL_LINNUM++;
									}
\-\-.*$ 								{
			/* comment */
			/* nothing */
									}
.									{
			return (*yytext);
									}
%%
