#include <stdio.h>
#include MUT_H
#include MPH_H

void make_seed_placement();

main(argc, argv)
int argc;
char **argv;
{
  phfig_list *pf;
  
  if(argc != 2) {
    fprintf(stdout,"usage : %s <phFileName>\n", argv[0]);
    exit(1);
  }

  mbkenv() ;

  pf = getphfig(argv[1],'A');
  make_seed_placement(pf,"txt",'f');
  return 0;
}

/************************************************************************
*   	Seed placement for chipcompiler                                 * 
*	version : 2.8							*
*	date	: 07/02/91						*
************************************************************************/
#define        lnat      long
#define        unat      unsigned int
#define        snat      int
#define        ucar      unsigned char
#define        car       char
#define        RB        "rb"                /* lecture fichier binaire  */
#define        WB        "wb"                /* ecriture fichier binaire */
#define        RT        "rt"                /* lecture fichier ascii    */
#define        WT        "wt"                /* ecriture fichier ascii   */

#define MIN(a,b)	((a)<(b)?(a):(b))
#define INF(a,b)	((a)>(b)?(a):(b))
#define MAX(a,b)	((a)>(b)?(a):(b))
#define SUP(a,b)	((a)>(b)?(a):(b))
#define ABS(a)		valeur_absolue(a)
#define ALLOUER(n)      allouer_memoire((lnat)(n))
#define LIBERER(p)      liberer_memoire(p)
extern car 		*allouer_memoire();

typedef struct st_bande { 
	snat o, l; 
} BANDE ;
#define NB_BANDES	200
#define INFINI		32000
#define ANNUL		32000
BANDE *tab_col;


/************************************************************************/
/* MAKE_SEED_PLACEMENT:							*/
/*   creation du fichier de placement pour Chip Compiler (VTI)a partir  */
/* du format MBK.							*/
/************************************************************************/
void make_seed_placement(pt_figure, extension, flat)
phfig_list *pt_figure;
char	*extension, flat;
{ 
	unat i, topologie();
	struct phins *p;
	if ((flat == 'F') || (flat == 'f')) 
		rflattenphfig(pt_figure, ' ', 'Y');
/*
	for (p = pt_figure->PHINS; p != NULL; p = p->NEXT)
		printf("%s (%ld,%ld)\n", p->FIGNAME, p->XINS, p->YINS);
*/
	i = topologie(pt_figure->PHINS);
	mk_seed(pt_figure, extension);
	LIBERER(tab_col);
}


/************************************************************************/
mk_seed(pfig, ext)
phfig_list *pfig;
char	*ext;
{ 
	FILE * fp;
	char	*nom;
	struct phins *p, *q;
	unat i, j, k;
	nom = (char *)ALLOUER(strlen(pfig->NAME) + strlen(ext) + 2);
	sprintf(nom, "%s.%s", pfig->NAME, ext);
	if (!(fp = fopen(nom, WT))) { 
		printf("err ouverture %s\n", nom); 
		EXIT(); 
	}
	for (p = pfig->PHINS; p != NULL; p = p->NEXT) { 
		j = bloc_est_dans_bande(p);
		k = 1;
		for (q = pfig->PHINS; q != NULL; q = q->NEXT)
			if (q != p)
				if (j == bloc_est_dans_bande(q))
					if (q->XINS < p->XINS)
						k++;
		if (p->TRANSF != SYM_X)
			fprintf(fp, "SEED %s %d %d ORIENTATION STANDARD\n", p->INSNAME, j, k);
		else
			fprintf(fp, "SEED %s %d %d ORIENTATION MX\n", p->INSNAME, j, k);
	}
	fclose(fp);
	LIBERER(nom);
}


bloc_est_dans_bande(p)
struct phins *p;
{ 
	unat i;
	for (i = tab_col[0].o; i > 0; i--)
		if (tab_col[i].o <= (unat)p->YINS) 
			return(i);
	return(1);
}


/**************************************************************************/
/* fonctions de creation des bandes					  */
/**************************************************************************/
/**************************************************************************/
/* reconnaissance des colonnes ASR.					  */
/*   renvoie le nombre de colonnes de cellules detectees                  */
/*   sortie: tab_col contient les abscisses et dimensions des colonnes    */
/**************************************************************************/
unat topologie(blocs)
struct phins *blocs;
{
	tab_col = (BANDE * )ALLOUER(sizeof(BANDE) * NB_BANDES);
	tab_col[0].o = 0;
	while (blocs != NULL) { 
		in_tab(blocs); 
		blocs = blocs->NEXT; 
	}
	trier(); 
	fuse();
	return(tab_col[0].o);
}


/**************************************************************************/
/* teste si le bloc bloc appartient a une colonne.                        */
/*   si oui, rien. sinon, cree un nouvel element dans tab_col             */
/**************************************************************************/
in_tab(bloc)
struct phins *bloc;
{ 
	unat i, y, dy;
	y = (unat)(bloc->YINS); 
	dy = 1;
	for (i = 1; i <= tab_col[0].o; i++)
		if ((y >= tab_col[i].o) && (y + dy <= tab_col[i].o + tab_col[i].l))
			return;
	i = (++(tab_col[0].o));
	if (i >= NB_BANDES) { 
		printf("Trop de bandes.") ; 
		EXIT(1); 
	}
	tab_col[i].o = (snat)y; 
	tab_col[i].l = (snat)dy;
}


/**************************************************************************/
/* trie les elements de tab_col en ordre croissant des ordonnees          */
/*   les elements d'ordonne ANNUL sont supprimes                          */
/**************************************************************************/
trier()
{ 
	snat i, j, t ;
	for (i = 1; i <= tab_col[0].o; i++)
		for (j = i; j <= tab_col[0].o; j++)
			if (tab_col[j].o < tab_col[i].o) { 
				t = tab_col[i].o; 
				tab_col[i].o = tab_col[j].o; 
				tab_col[j].o = t;
				t = tab_col[i].l; 
				tab_col[i].l = tab_col[j].l; 
				tab_col[j].l = t;
			}
	for (i = tab_col[0].o; i > 0; i--) 
		if (tab_col[i].o == ANNUL) 
			(tab_col[0].o)--;
}


/**************************************************************************/
/* recherche des cas de fusion de 2 bandes                                */
/**************************************************************************/
fuse()
{ 
	snat i, f = 0;
	while (!f) { 
		f = 1; 
		for (i = 1; i <= tab_col[0].o; i++) 
			f &= fuse_bande(i); 
	}
}



/**************************************************************************/
/* controle de la fusion de deux bande                                    */
/**************************************************************************/
fuse_bande(b)
snat b;
{ 
	snat i, y = tab_col[b].o, dy = tab_col[b].l, o, l;
	for (i = 1; i <= tab_col[0].o; i++) { 
		if (i == b) 
			continue;
		o = tab_col[i].o; 
		l = tab_col[i].l;
		if (o >= y)
			if (o + l <= y + dy)           {
				maj_bande(i, y, dy, b);
				return(0);
			}
		if (o <= y)
			if (o + l <= y + dy)
				if (o + l > y)  {
					maj_bande(i, o, dy + y - o, b);
					return(0);
				}
		if (o + l >= y + dy)
			if (o >= y)
				if (o < y + dy) {
					maj_bande(i, y, l + o - y, b);
					return(0);
				}
		if (o <= y)
			if (o + l >= y + dy)           {
				maj_bande(i, o, l, b);
				return(0);
			}
	}
	return(1) ;
}


/**************************************************************************/
/* fusion de deux bandes                                                  */
/**************************************************************************/
maj_bande(i, o, l, b)
snat i, o, l, b ;
{
	tab_col[b].o = tab_col[b].l = ANNUL;
	tab_col[i].o = o; 
	tab_col[i].l = l; 
	trier() ;
}


/**************************************************************************/
/* allocation memoire de noctets octets.                                  */
/*   renvoie le pointeur sur la zone allouee.                             */
/*   renvoie NULL si l'allocation echoue.                                 */
/**************************************************************************/
car *allouer_memoire(noctets)
lnat noctets;
{ 
	car * p;
	if ((p = (car * )malloc(noctets)) != NULL) 
		return(p);
	printf("Erreur interne: - allouer_memoire(%ld) - Memoire saturee!\n", noctets);
	EXIT(1);
}


/**************************************************************************/
/* liberation memoire de la zone pointee par p.                           */
/**************************************************************************/
liberer_memoire(p)
char	*p;
{
	if (p != NULL) { 
		free(p); 
		return; 
	}
	printf("Erreur interne:  - liberer_memoire(null) -\n");
	EXIT(1);
}


