/*------------------------------------------------------------------------------*/
/*	    			@(#) MBK TO EDIF Driver                       	*/
/*------------------------------------------------------------------------------*/
/*		version 1.0 : Implemented by Fred Petrot			*/
/*		version 1.1 : Extended by Mokhtar Hirech (January, 92)		*/
/*------------------------------------------------------------------------------*/

#include MUT_H 
#include MLO_H 
#include <ctype.h>
#include <string.h>


/* Global variables								*/

static 	FILE    	*edif_file;
static 	char 		filename [120];
static 	char		*all 	 = "schematic";
static  char 		*outline = "symbol";
static  char		*dist_ext= "edi";
static  chain_list 	*already_drived = NULL;


/* Global Functions								*/

static 	void		port_ext();
static 	void 		edit_sig();
static 	void 		edit_leaf_sig();
static 	void 		edit_ins();
static 	void 		edit_con();
static 	void		connect();
static 	void 		view();
static 	void 		drive_cell();
static 	void 		r_drive_cell();
extern  char 		*edif_busname();
static	void		bus_port_ext();
static	void		bus_connect();
static 	losig_list	*bus_sig_def();
static  char 		same_bus_rank(); 
static  char 		bus_sig_con(); 



/*------------------------------------------------------------------------------*/
/*  The driving function: the only function that can be called from MBK env.	*/
/*------------------------------------------------------------------------------*/

void edifsavelofig(firstlofig)
lofig_list *firstlofig;  
{

	if (firstlofig == NULL) {
		printf("--- mbk error --- : edif shall not drive a NULL figure\n");
		exit(1);
	}

	sprintf(filename,"%s/%s.%s", WORK_LIB, firstlofig->NAME, dist_ext);
	if ((edif_file= mbkfopen(firstlofig->NAME, OUT_LO, WRITE_TEXT)) == NULL) {
		printf("--- mbk error --- : %s cannot be opened\n", filename);
		exit(1);
	}
	else if (TRACE_MODE == 'Y')
		printf("\n--- mbk --- writing the file %s\n",filename);

	fprintf(edif_file, "(edif %s\n", firstlofig -> NAME);
	fprintf(edif_file, " (edifversion 2 0 0)\n");
	fprintf(edif_file, " (ediflevel 0)\n");
	fprintf(edif_file, " (keywordMap (keywordLevel 0))\n");
	fprintf(edif_file, " (status\n");
	fprintf(edif_file, "  (written\n");
	fprintf(edif_file, "   (timeStamp %s)\n",EdifTime());
	fprintf(edif_file, "   (program \"Driver mbk2edif\")\n");
	fprintf(edif_file, "   (author \"FP & HM for : %s\")\n",getenv("USER"));
	fprintf(edif_file, "   (dataOrigin \"VLSI-CAD : Masi Lab. UPMC\")))\n");
	fprintf(edif_file, " (library %s\n", firstlofig -> NAME); 
	fprintf(edif_file, "  (ediflevel 0)\n");
	fprintf(edif_file, "  (technology (numberDefinition))");

	r_drive_cell(firstlofig);

	fprintf(edif_file, "\n))\n");    /* library */
	/* no (design ...) construct at the end of edif file. Not supported by CADENCE package */

	/*
	fprintf(edif_file, "\t(design %s (cellref %s (libraryref %s)))",
	   firstlofig -> NAME, firstlofig -> NAME, lib_name);
	fprintf(edif_file, ")\n");
	*/	

	if (fclose(edif_file)!=0) {	
		printf("/n--- mbk_edif --- Cannot close file '%s'\n",filename);
		exit(1);
	}
	
	/* freechain of already_drived list */
	freechain(already_drived);
	already_drived = (chain_list *)NULL;
}


/*------------------------------------------------------------------------------*/
/* 		Returns 0 if a cell has not already been written. 		*/
/*------------------------------------------------------------------------------*/

static char drived_cell(ptchain, cell_name)
chain_list *ptchain;
char       *cell_name;
{
	chain_list *chainp;

	for(chainp = ptchain; chainp; chainp = chainp->NEXT)
                if ((char *)chainp->DATA == cell_name) return 1;

	return 0;
}


/*------------------------------------------------------------------------------*/
/*	recursive function. At first, it begins with writing leaves,		*/
/*------------------------------------------------------------------------------*/

static void r_drive_cell(ptlofig)
lofig_list *ptlofig;
{
	chain_list *ptchain;
	lofig_list *ptlfig;
	char	   drived_cell();

	ptlofig->MODELCHAIN = (chain_list *)reverse((chain_list *)ptlofig->MODELCHAIN);

	drive_basic_cells(ptlofig); 

	for (ptchain = ptlofig->MODELCHAIN; ptchain; ptchain = ptchain->NEXT)
        {
		if (!drived_cell(already_drived, namealloc((char*)ptchain->DATA))) {
			ptlfig = getlofig((char *)ptchain->DATA, 'A');
                	r_drive_cell(ptlfig);
		}
		
       	} 

	ptlofig->MODELCHAIN = (chain_list *)reverse((chain_list *)ptlofig->MODELCHAIN);
	drive_cell(ptlofig->NAME, 'C');

	return;
}


/*------------------------------------------------------------------------------*/
/* 	Driving of basic cells (leaves) available in figure "ptlofig".		*/
/*------------------------------------------------------------------------------*/

static int drive_basic_cells(ptlofig)
lofig_list *ptlofig;
{
	chain_list *ptchain;
	lofig_list *ptlfig;
	void 	   drive_cell();
	char 	   *cell_model_name;

	for (ptchain = ptlofig->MODELCHAIN; ptchain; ptchain = ptchain->NEXT)
        {
		/*ptlfig = getlofig((char *)ptchain->DATA, 'P'); 29-01-92
		if (ptlfig->MODELCHAIN == (chain_list *) NULL) drive_cell(ptlfig, 'I');	*/
		cell_model_name = namealloc((char *)ptchain->DATA);
		if (incatalog(cell_model_name))
			drive_cell(cell_model_name, 'I');	
	}
}


/*------------------------------------------------------------------------------*/
/*		Processing of instances according to their order. 		*/
/*------------------------------------------------------------------------------*/

static void drive_cell(figname, c)
char *figname;
char c;
{
	chain_list *ptchain;
	char drived_cell();
	lofig_list *ptlofig;


	if (drived_cell(already_drived, figname)) return;
	already_drived = addchain(already_drived, figname);
	fprintf(edif_file, "\n   (cell %s (cellType GENERIC)", figname);

	if (c == 'C') view(figname, 'A'); else view(figname, 'I');

	fprintf(edif_file, ")");      /* cell */
}

/*------------------------------------------------------------------------------*/
/*			Writing of Edif's "View" construct.			*/
/*------------------------------------------------------------------------------*/

static void view(figname, viewtype)
char 	*figname;
char 	viewtype;
{
	lofig_list	*ptlofig;
	char 		view[20];

	strcpy(&view[0], (viewtype == 'A') ? all: outline);
	fprintf(edif_file, "\n    (view %s (viewType NETLIST)", view);
	fprintf(edif_file, "\n     (interface");
	
	ptlofig = getlofig(figname, 'P');
	ptlofig->LOCON = (locon_list *)reverse((locon_list *)ptlofig->LOCON);
	edit_con(ptlofig->LOCON);
	if (viewtype == 'A' && ptlofig->LOSIG) {
		fprintf(edif_file, "\n     (contents");
		ptlofig->LOINS = (loins_list *)reverse((loins_list *)ptlofig->LOINS);
		edit_ins(ptlofig->LOINS);
		ptlofig->LOINS = (loins_list *)reverse((loins_list *)ptlofig->LOINS);
		ptlofig->LOSIG = (losig_list *)reverse((losig_list *)ptlofig->LOSIG);
		edit_sig(ptlofig);
		ptlofig->LOSIG = (losig_list *)reverse((losig_list *)ptlofig->LOSIG);
		fprintf(edif_file, ")");     /* contents */
	}

/* not definitely discarded
	else {
		edit_leaf_sig(ptlofig);
	}
*/

	fprintf(edif_file, ")");     /* view */
	ptlofig->LOCON = (locon_list *)reverse((locon_list *)ptlofig->LOCON);
	
	return;
}

/*------------------------------------------------------------------------------*/
/*		    Scan of Instance's "Ports" (connectors).			*/
/*------------------------------------------------------------------------------*/

static void connect(conn, index, name)
locon_list *conn;
int index;
char *name;
{
losig_list *sig;

	if (conn != (locon_list *) NULL) {
		for(; conn != (locon_list *) NULL; conn = conn -> NEXT) 
		{	
			sig = conn->SIG;
			if (sig->INDEX == index) {
				if (!edif_busname(conn->NAME))	
					fprintf(edif_file, "\n          (portref %s ", conn->NAME);
				else    fprintf(edif_file, "\n          (portref (member %s ) ",conn->NAME);
				if (name != (char *) NULL)
					fprintf(edif_file, "(instanceref %s )", name);
				fprintf(edif_file, ")");
			}
		}
	}
}

/*------------------------------------------------------------------------------*/
/*		     Writing of Instance's "Ports" (conectors).			*/
/*------------------------------------------------------------------------------*/

static void edit_con (ptcon)
locon_list *ptcon;
{
	locon_list	*ptcon_first_bus;
	char dummy[50], *array_name, *str;
	int n;

	strcpy(dummy , "");
	while (ptcon != (locon_list *) NULL) 
	{       
		if (ptcon -> DIRECTION == 'I') strcat(dummy, "input");
		else  	if ((ptcon -> DIRECTION == 'O') || (ptcon->DIRECTION == 'Z'))
				strcat(dummy, "output");
			else strcat(dummy, "inout");
		
		if (!(array_name = edif_busname (ptcon->NAME)))
		     fprintf(edif_file, "\n      (port %s (direction %s ))", ptcon->NAME, dummy);
		else {
			n = 1;
			ptcon_first_bus = ptcon;
        		while (ptcon->NEXT != (locon_list *) NULL && (str = edif_busname (ptcon->NEXT->NAME)))
			{
			 	if (array_name !=  str)	break;
				if (ptcon->NEXT->DIRECTION != ptcon_first_bus->DIRECTION) {
				    fprintf(edif_file, "\nConnectors %s and %s of the same bus must have a same direction\n", 
							ptcon_first_bus->NAME, ptcon->NEXT->NAME);
				    printf("\n---MbkEdif driver--- Error in MBK Structure");
			            printf("\n   Connectors %s and %s of the same bus must have a same direction\n", 
							ptcon_first_bus->NAME, ptcon->NEXT->NAME);
				    exit(1);
				}
			 	n++; 
				ptcon = ptcon->NEXT; 
			}

			fprintf(edif_file, "\n      (port (array %s %d ) (direction %s ))", 
				array_name, n, dummy);

			if (ptcon == (locon_list *) NULL) break;
		}
		strcpy(dummy , "");
		ptcon = ptcon -> NEXT;
	}

	fprintf(edif_file, ")");
}


/*------------------------------------------------------------------------------*/
/*        		     Writing of Edif "Instances"			*/
/*------------------------------------------------------------------------------*/

static void edit_ins(ptins)
loins_list *ptins;
{
char cellref_type;

	while (ptins != (loins_list *) NULL)
	{      
		cellref_type = (incatalog(ptins->FIGNAME) ? 'I' : 'A');
		fprintf(edif_file, "\n      (instance %s (viewref %s (cellref %s )))",
				ptins->INSNAME, 
				(cellref_type == 'I') ? &outline[0] : &all[0],
				ptins->FIGNAME);
		ptins = ptins -> NEXT;
	}
}

/*------------------------------------------------------------------------------*/
/*        		     Writing of Edif Empty "Net"       			*/
/*------------------------------------------------------------------------------*/

static void edit_leaf_sig(ptlofig)
lofig_list *ptlofig;
{
	locon_list *ptcon;

	for (ptcon = ptlofig->LOCON; ptcon != (locon_list *)NULL; ptcon = ptcon->NEXT) 
		fprintf(edif_file, "\n\t\t\t\t\t(net %s (joined (portRef %s )))", ptcon->NAME, ptcon->NAME);
	fprintf(edif_file, "\n");

	return;
}

/*------------------------------------------------------------------------------*/
/*        		     Writing of Edif Full "Net"       			*/
/*------------------------------------------------------------------------------*/

static void edit_sig(ptlofig)
lofig_list *ptlofig;
{
	losig_list *ptsig, *ptsig_first;
	loins_list *sig_ins;
	char 	   *sig_con_name;
	int	    sig_index;
	int	    width = 0, idx = 0;
	char	   *array_name = (char *) NULL;
	char	   *name = (char *) NULL;

	/* check for not allowed (portref toto) (portref titi) construct */
	for (ptsig = ptlofig->LOSIG; ptsig != (losig_list *) NULL; ptsig = ptsig->NEXT)
		check_fig_portref(ptlofig->NAME, ptlofig->LOCON, ptsig->INDEX);

	ptsig = ptlofig->LOSIG;
	while (ptsig != (losig_list *) NULL) {
		sig_index = ptsig -> INDEX;
		name = getsigname(ptsig);
		if ((array_name = edif_busname(name)) && ((idx = bus_index(name)) != -1))
		{
/*
			ptsig_first = ptsig;
			* check if signal bus *
			if (ptsig = bus_sig_def(ptsig, array_name, &width)) {
				fprintf(edif_file,"\n      (net (array %s %d ) (joined ",array_name, width);
				if (ptsig->TYPE != 'I') {
					bus_connect (ptlofig->LOCON, ptlofig->LOCON, 
						     ptsig_first, (char *)NULL, width);
				}

				for (sig_ins = ptlofig->LOINS; sig_ins != NULL; sig_ins = sig_ins->NEXT) 
					bus_connect (sig_ins->LOCON, sig_ins->LOCON, 
						     ptsig_first, sig_ins->INSNAME, width);
			}
*/
			fprintf(edif_file, "\n      (net %s_%d (joined ",array_name,idx);
		} 
		else {
			if (!isdigit(name[0]))
			  fprintf(edif_file, "\n      (net %s (joined ",name);
			else 
			  fprintf(edif_file, "\n      (net &_%s (joined ",name);
			
		}
                        if (ptsig->TYPE != 'I') port_ext(ptlofig->LOCON,sig_index);

                        for(sig_ins = ptlofig->LOINS; sig_ins != NULL;
                                sig_ins = sig_ins->NEXT)
                                connect(sig_ins->LOCON, sig_index, sig_ins->INSNAME);
		
		fprintf(edif_file, ")"); /* joined */

		fprintf(edif_file, ")"); /* net */
		if (ptsig) ptsig = ptsig->NEXT;
	}
	return;
}

static check_fig_portref(lofig_name, ptcon, sig_index)
char		*lofig_name;
locon_list	*ptcon;
int		sig_index;
{
	int	nb = 0;
	
	for (; (ptcon != (locon_list *) NULL) && (nb <= 1); ptcon = ptcon->NEXT)
		if (ptcon->SIG->INDEX == sig_index) nb++;

	if (nb > 1) {
		fprintf(edif_file,"\n multiple (portref ..) to lofig '%s' not");
		fprintf(edif_file,"\n allowed on signal of type 'E' (cadence)",lofig_name);
                printf("\n--- MbkEdif Driver--- Error in MBK Structure");
		printf("\n    multiple (portref ..) to lofig '%s' not ");
		printf("\n    allowed on signal of type 'E' (cadence)",lofig_name);
                exit(1);
	}
	
}


/*------------------------------------------------------------------------------*/
/*			Searching for External Ports.				*/
/*------------------------------------------------------------------------------*/

static void port_ext(sig_con,sig_index)
locon_list 	*sig_con;
int 		sig_index;
{
	losig_list 	*sig_con_sig;
	locon_list 	*connector, *fig_con;
	char 		*sig_con_name;

	connector = (locon_list *)NULL;
	fig_con = sig_con;
	sig_con_name = (char *)NULL;

	while (sig_con != (locon_list *)NULL) {
		sig_con_sig = sig_con -> SIG;
		if (sig_con_sig -> INDEX == sig_index) {
			sig_con_name = sig_con -> NAME;
			connector=sig_con;
		}
		sig_con = sig_con -> NEXT;
	}
	
	if (sig_con_name == NULL) {
		fprintf(edif_file, "\nNo Connector on Signal of type 'E'");
		printf("\n---MbkEdif driver--- Error in MBK Structure");
		printf("\n                         No Connector on Signal of type 'E'");
		exit(1);
	}
	
	connect(fig_con, sig_index, (char *)NULL);
}

/*------------------------------------------------------------------------------*/
/*			Searching for Bus External Ports.			*/
/*------------------------------------------------------------------------------*/

static void bus_connect (lofig_con, sig_con, ptsig, ins_name, width)
locon_list 	*sig_con, *lofig_con;
losig_list	*ptsig;
char		*ins_name;
int 		width;
{
	losig_list 	*sig_con_sig, *ptsig_save;
	locon_list 	*fig_con;
	char 		*sig_name, *array_name, *str;
	int		n;


	ptsig_save = ptsig;	

	/* first member of connector bus (if exists) attached to signal bus */
	for ( ;sig_con != (locon_list *)NULL ; sig_con = sig_con->NEXT)
		 if (sig_con->SIG->INDEX == ptsig->INDEX) break;

	if (sig_con == (locon_list *) NULL)
		if (ins_name == (char *) NULL)	{
			/* signal bus with 'E' type must be connected to one */
			/* connector bus of a figure 			     */
			fprintf(edif_file,"\nNo Connector Bus on Signal bus of type 'E'");
			printf("\n---MbkEdif Driver--- Error in MBK Structure");
			printf("\n                     No Connector Bus on Signal of type 'E'");
			exit(1);
		}
		/* in case of instance in figure. Report no connection */
		else return; 

	/* check that there is a connector bus with same width attached to signal bus */
	fig_con = sig_con;
	if (!bus_sig_con (sig_con, lofig_con, ptsig, width))
	{
		fprintf(edif_file, "\n Connector Bus not properly joined on Signal Bus '%s'", 
					edif_busname(getsigname(ptsig_save)));
               	printf("\n---MbkEdif driver--- Error in MBK Structure");
		printf("\n                     Connector Bus not properly joined on Signal Bus '%s'", 
					edif_busname(getsigname(ptsig_save)));   
               	exit(1);
	}

	fprintf(edif_file, "\n          (portref  %s ", edif_busname(fig_con->NAME));

	if (ins_name != (char *) NULL)	
        	fprintf(edif_file, "(instanceref %s )", ins_name);

	fprintf(edif_file, ")");

	/* to possible next connector bus attached to this signal */
	for (n = 0; n < width ; n++) sig_con = sig_con->NEXT;
	if (sig_con != (locon_list *) NULL && ins_name != (char *) NULL)
		bus_connect (lofig_con, sig_con, ptsig, ins_name, width);
		
	return;
}

static char bus_sig_con(sig_con, fig_con, ptsig, width)
locon_list	*sig_con, *fig_con;
losig_list	*ptsig;
int		width;
{
	char	*array_name, *str, n;
	locon_list *con_save;
	losig_list *sig_save;

	if (sig_con == (locon_list *) NULL) return 0;

	con_save = sig_con;
	sig_save = ptsig;

	if (!(array_name = edif_busname (sig_con->NAME))) n = width + 1;
	else {
		for (n = 0; (sig_con != (locon_list *) NULL) && (ptsig != (losig_list *) NULL); 
			sig_con = sig_con->NEXT, ptsig = ptsig->NEXT, n++) {
			if (!(str = edif_busname(sig_con->NAME))) break;
			if ((array_name != str)
			 	|| (ptsig->INDEX != sig_con->SIG->INDEX)
		     	 	|| (!same_bus_rank(namealloc(getsigname(ptsig)), sig_con->NAME))) break;
		}
	}

	/* case of connector bus width < signal bus width */
	if (n != width) return 0; 

	/* case of connector bus width > signal bus width */
	if ((sig_con != (locon_list *) NULL) &&
	    (str = edif_busname(sig_con->NAME)) && (array_name == str)) return 0;

	for (sig_con = fig_con; sig_con != (locon_list *) NULL; 
		sig_con = sig_con->NEXT)
		if ((str = edif_busname(sig_con->NAME)) && (array_name == str)) break;

	if ((sig_con != (locon_list *) NULL) &&
		(sig_save->INDEX != sig_con->SIG->INDEX)) 
		return 0;	
	
	return 1;
}

/*------------------------------------------------------------------------------*/
/* function edif_busname for Edif driver : return '/0' or radix if edif_busname.		*/	
/*------------------------------------------------------------------------------*/

char *edif_busname(name)
char 	*name;
{
  	char *s;
  	char c[100];

  	if (!(s = strchr(name, ' '))) return (char *) NULL;

  	/*c = mbkalloc(strlen(name) + 1);*/
  	strncpy(&c[0], name, (int)(s - name));
	c[(int)(s - name)] = '\0';
  	for (s++; *s != '\0'; s++) 
		if (!isdigit(*s)) return (char *) NULL;

  	return namealloc(&c[0]);
}

/*------------------------------------------------------------------------------*/
/* function same_bus_rank for Edif driver : return '0' if signal bus members 	*/
/* have same rank.								*/
/*------------------------------------------------------------------------------*/

static char same_bus_rank(s1, s2) 
char *s1, *s2;
{
  char *s, *t;

  if (!(s = strchr(s1, ' ')) || !(t = strchr(s2, ' '))) return 0;

  return (atoi(s) == atoi(t));
}

/* function is called only for edif_busname string s */

static int bus_index(s)
char *s;
{
	char *t;

	if (!(t = strchr(s, ' '))) return -1;
	return atoi(t);
}


/*------------------------------------------------------------------------------*/
/* bus_sig_def for Edif driver : checks if we are in presence of signal. If so, it  */
/* returns pointer on first member of the bus and bus width, (nil) otherwise. 	*/	
/*------------------------------------------------------------------------------*/

static losig_list *bus_sig_def(ptsig, signame, width)
losig_list	*ptsig;
char		*signame;
int		*width;
{

	losig_list	*ptsig_save;
	char		sig_type;
	char		*str;
 
	*width = 1;
	ptsig_save =  ptsig;
	sig_type = ptsig->TYPE;
	while (ptsig->NEXT != (losig_list *) NULL
		&& (str = edif_busname(getsigname(ptsig->NEXT)))
		&& (ptsig->NEXT->TYPE == sig_type))
	{
		if (strcmp(signame, str)) break;
		(*width)++;
		ptsig = ptsig->NEXT;
	}
	
	if (ptsig_save->TYPE != ptsig->TYPE) {
		printf("---MbkEdif Driver---: array with signals of different types\n");
		fprintf(edif_file, "---MbkEdif Driver---: array with signals of different types\n");
		exit(1);
	}

	return ptsig;
}
