/************************************************************************
*       MBK : Driver alliance logic                                     *
*                                                                       *
*	version : 4.00					                                    *
*	date	: 23/07/92				                                    *
************************************************************************/

#include "generic_target.h"
#include MUT_H 
#include MLO_H 

#ident "@(#)Driver alliance logic v4.00 23/07/92 by Vincent POUILLEY"

#define TAILLE_CHAINE 64

/************************************************************************
*                  get_date()                                           *
************************************************************************/

static void get_date(date)
char * date;
{
time_t tim;
struct tm *rest;

	(void)time(&tim);
   rest=localtime(&tim);
	(void)sprintf(date,"%2d/%2d/%2d",rest->tm_mday,rest->tm_mon,rest->tm_year);
}

/************************************************************************
*                  alc_decodetype()                                     *
************************************************************************/

char * alc_decodetype(type)
char type;
{
	switch(type)
		{
		case 'I' :
			return "IN";
		case 'O' :
			return "OUT";
		case 'B' :
			return "INOUT";
		case 'X' :
			return "UNKNOWN";
		case 'Z' :
			return "TRISTATE";
		case 'T' :
			return "TRANSCV";
		default :
			(void)fprintf(stderr,"\n*** mbk error *** invalid connector direction : %c\n",type);
			return "UNKNOWN";
		}
}

/************************************************************************
*                  alcsavelofig()                                       *
************************************************************************/
void alcsavelofig(pfig)
lofig_list * pfig;
{
	locon_list * pcon;
	lotrs_list * ptrs;
	loins_list * pins;
	losig_list * psig;
	chain_list * tmp;
	char * name;
	FILE *in;
	char nomfic[TAILLE_CHAINE];
	char nomp[TAILLE_CHAINE];
	long nbdes;
/* to check a signal name unicity */
	long nbsig;
	ht *h;
	
	if (alc_verif_transistor_lo(pfig->NAME,&nbdes,&nbdes))
		{
		(void)fprintf(stderr,"\n*** mbk error *** bad file name : %s\n",pfig->NAME);
		EXIT(1);
		}
	(void)sprintf(nomfic,"%s/%s.%s",WORK_LIB,pfig->NAME,OUT_LO);
	in=mbkfopen(pfig->NAME, OUT_LO, WRITE_TEXT);
	if(!in)
		{
		(void)fprintf(stderr,"\n*** mbk error *** can't open file : %s\n",nomfic);
		EXIT(1);
		}
	if (TRACE_MODE == 'Y')
		{
		(void)printf("\n--- mbk --- writing the file : %s\n",nomfic);
		}
/*   reverse connectors, instances, etc.  */
  pfig->LOCON = (locon_list *)reverse((chain_list *)pfig->LOCON);
  pfig->LOINS = (loins_list *)reverse((chain_list *)pfig->LOINS);
  pfig->LOTRS = (lotrs_list *)reverse((chain_list *)pfig->LOTRS);
  for(pins = pfig->LOINS ; pins ; pins = pins->NEXT)
    {
    pins->LOCON = (locon_list *)reverse((chain_list *)pins->LOCON);
    }
/* calculate number of descriptor */
	for (nbdes = 0, pcon = pfig->LOCON; pcon != NULL; pcon = pcon->NEXT, nbdes++);
	for (ptrs = pfig->LOTRS; ptrs != NULL; ptrs = ptrs->NEXT, nbdes++);
	for (pins = pfig->LOINS; pins != NULL; pins = pins->NEXT, nbdes++)
		for (pcon = pins->LOCON; pcon != NULL; pcon = pcon->NEXT, nbdes++);
	for (psig = pfig->LOSIG, nbsig = 0; psig != NULL; psig = psig->NEXT, nbdes++, nbsig++);
/* write header */
	(void)fprintf(in,"V ALLIANCE 2.2 SETUP : 3\n");
	get_date(nomp);
	(void)fprintf(in,"H %s,L,%s,%d\n",pfig->NAME,nomp,nbdes);
/* write connectors of the figure */
	for (pcon = pfig->LOCON; pcon != NULL; pcon = pcon->NEXT)
		{
		(void)fprintf(in,"C %s,%s,%ld\n",pcon->NAME,alc_decodetype(pcon->DIRECTION),pcon->SIG->INDEX);
		}
/* write transistors */
	for (ptrs = pfig->LOTRS; ptrs != NULL; ptrs = ptrs->NEXT)
		{
		(void)fprintf(in,"T %c,%g,%g,%ld,%ld,%ld,%g,%g,%g,%g,%g,%g\n", (ptrs->TYPE == TRANSN)?'N':'P', (float)((float)(ptrs->LENGTH)/(float)SCALE_X), (float)((float)(ptrs->WIDTH)/(float)SCALE_X), ptrs->DRAIN->SIG->INDEX, ptrs->GRID->SIG->INDEX, ptrs->SOURCE->SIG->INDEX, (float)((float)(ptrs->XS)/(float)SCALE_X), (float)((float)(ptrs->XD)/(float)SCALE_X), (float)((float)(ptrs->PS)/(float)SCALE_X), (float)((float)(ptrs->PD)/(float)SCALE_X), (float)((float)(ptrs->X)/(float)SCALE_X), (float)((float)(ptrs->Y)/(float)SCALE_X));
		}
/* write instances */
	for (pins = pfig->LOINS; pins != NULL; pins = pins->NEXT)
		{
		(void)fprintf(in,"I %s,%s\n",pins->FIGNAME,pins->INSNAME);
		for (pcon = pins->LOCON; pcon != NULL; pcon = pcon->NEXT)
			{
			(void)fprintf(in,"C %s,%s,%ld\n",pcon->NAME,alc_decodetype(pcon->DIRECTION),pcon->SIG->INDEX);
			}
		}
/* write signals */
	h = addht(nbsig << 1); /* create Hash Table for signal name unicity */
	for (psig = pfig->LOSIG; psig != NULL; psig = psig->NEXT)
		{
			name = getsigname(psig);
			if (sethtitem(h, name, 0)) /* check unicity */
			{ /* name is not unique */
				(void)fprintf(in,"S %ld,%g,%ld\n",psig->INDEX, psig->CAPA, psig->INDEX);
			}
			else
			{ /* name is unique */
				(void)fprintf(in,"S %ld,%g,%s\n",psig->INDEX, psig->CAPA, name);
			}
		}
	delht(h); /* delete the Hash Table */
/* write End Of File and close the file */
	(void)fputs("EOF\n",in);
	if (fclose(in) != 0)
		{
		(void)fprintf(stderr,"\n*** mbk error *** can't close file : %s\n",nomfic);
		EXIT(1);
		}

/*   reverse back connectors, instances, etc. */
  pfig->LOCON = (locon_list *)reverse((chain_list *)pfig->LOCON);
  pfig->LOINS = (loins_list *)reverse((chain_list *)pfig->LOINS);
  pfig->LOTRS = (lotrs_list *)reverse((chain_list *)pfig->LOTRS);
  for(pins = pfig->LOINS ; pins ; pins = pins->NEXT)
    {
    pins->LOCON = (locon_list *)reverse((chain_list *)pins->LOCON);
    }
}
