/*-----------------------------------------------------*\
|                                                       |
|  Title   :          RDS Tools Box                     |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :         Jacomme ludovic                    |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                Les fichiers a inclure                 |
\------------------------------------------------------*/

#include MUT_H
#include MLO_H
#include MPH_H

#include "mem.h"
#include "rdstools.h"
#include "debug.h"
#include <stdio.h>
#include <string.h>

/*-----------------------------------------------------*\
|               Les variables globales                  |
\------------------------------------------------------*/

 rds_fig        *HeadFigureRds  = (rds_fig *)NULL;

#include "layername.h"
#include "mbktypename.h"
#include "extractname.h"
#include "transfname.h"

/*-----------------------------------------------------*\
|                Les Messages d'erreur                  |
\------------------------------------------------------*/

#include "rdserror.h"

/*-----------------------------------------------------*\
|           Les fonctions d'Allocation d'objets         |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|          Allocation d'une figure pour RDS             |
\------------------------------------------------------*/

  rds_fig *AllocFigureRds()

  {
    return ((rds_fig *)RAZStruct(sizeof(rds_fig)));
  }


/*-----------------------------------------------------*\
|         Allocation d'une instance pour RDS            |
\------------------------------------------------------*/

  rds_ins *AllocInstanceRds()

  {
    return ((rds_ins *)RAZStruct(sizeof(rds_ins)));
  }

/*-----------------------------------------------------*\
|         Allocation d'un rectangle pour RDS            |
\------------------------------------------------------*/

  rds_rec *AllocRectangleRds()

  {
    return ((rds_rec *)RAZStruct(sizeof(rds_rec)));
  }

/*-----------------------------------------------------*\
|          Les fonctions de Creation d'objets           |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|            Creation d'une figure pour RDS             |
\------------------------------------------------------*/

  rds_fig *AddFigureRds( FigName, Mbk  )

           char *FigName;
           void *Mbk;

  {
    rds_fig *Figure;

    Figure        = AllocFigureRds();
    Figure->name  = namealloc( FigName );
    Figure->mbk   = Mbk;
    Figure->next  = HeadFigureRds;
    HeadFigureRds = Figure;

    return( Figure );
  }

/*-----------------------------------------------------*\
|            Creation d'une instance pour RDS           |
\------------------------------------------------------*/

  rds_ins *AddInstanceRds( Figure, ModName, InsName, X, Y, Trans, Mbk )

           rds_fig *Figure;
           char    *ModName;
           char    *InsName;
           long     X;
           long     Y;
           char     Trans;
           void    *Mbk;

  {
    rds_ins *Instance;

    Instance           = AllocInstanceRds();
    Instance->mod_name = namealloc( ModName );
    Instance->ins_name = namealloc( InsName );
    Instance->x        = X;
    Instance->y        = Y;
    Instance->transf   = Trans;
    Instance->mbk      = Mbk;
    Instance->next     = Figure->instance;
    Figure->instance   = Instance;

    return( Instance );
  }

/*-----------------------------------------------------*\
|            Creation d'un rectangle pour RDS           |
\------------------------------------------------------*/

  rds_rec *AddRectangleInsRds( Instance,RecName,X,Y,Dx,Dy,Layer,MbkType,ExType,Mbk )

           rds_ins  *Instance;
           char     *RecName;
           long      X;
           long      Y;
           long      Dx;
           long      Dy;
           char      Layer;
           char      MbkType;
           char      ExType;
           void     *Mbk;

  {
    rds_rec *Rectangle;

    Rectangle = AllocRectangleRds();

    if ( RecName != (char *)NULL )
    {
      if (!((( MbkType == MBK_SEGMENT ) && ( ExType != RDS_SEG_BANAL )) ||
             ( MbkType == MBK_VIA )))

      Rectangle->u_rec.name = namealloc( RecName );
    }
    else if ( MbkType == MBK_CONNECTOR ) UnknownConnector();

    Rectangle->x            = X;
    Rectangle->y            = Y;
    Rectangle->dx           = Dx;
    Rectangle->dy           = Dy;
    Rectangle->layer        = Layer;
    Rectangle->mbk_type     = MbkType;
    Rectangle->extract_type = ExType;
    Rectangle->mbk          = Mbk;

    Rectangle->next           = Instance->layertab[Layer];
    Instance->layertab[Layer] = Rectangle;

    return( Rectangle );
  }

/*-----------------------------------------------------*\
|            Creation d'un rectangle pour RDS           |
\------------------------------------------------------*/

  rds_rec *AddRectangleFigRds( Figure,RecName,X,Y,Dx,Dy,Layer,MbkType,ExType,Mbk )

           rds_fig  *Figure;
           char     *RecName;
           long      X;
           long      Y;
           long      Dx;
           long      Dy;
           char      Layer;
           char      MbkType;
           char      ExType;
           void     *Mbk;

  {
    rds_rec *Rectangle;

    Rectangle = AllocRectangleRds();

    if ( RecName != (char *)NULL )

      if (!((( MbkType == MBK_SEGMENT ) && ( ExType != RDS_SEG_BANAL )) ||
            ( MbkType == MBK_VIA )))

      Rectangle->u_rec.name = namealloc( RecName );

    else if ( MbkType == MBK_CONNECTOR ) UnknownConnector();

    Rectangle->x            = X;
    Rectangle->y            = Y;
    Rectangle->dx           = Dx;
    Rectangle->dy           = Dy;
    Rectangle->layer        = Layer;
    Rectangle->mbk_type     = MbkType;
    Rectangle->extract_type = ExType;
    Rectangle->mbk          = Mbk;

    Rectangle->next         = Figure->layertab[Layer];
    Figure->layertab[Layer] = Rectangle;

    return( Rectangle );
  }

/*-----------------------------------------------------*\
|         Les fonctions de Liberation d'objets          |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|          Liberation d'un rectangle pour RDS           |
\------------------------------------------------------*/

  void FreeRectangleRds( RectangleRds )

       rds_rec *RectangleRds;
  {
    mbkfree((char *)RectangleRds);
  }

/*-----------------------------------------------------*\
|          Liberation d'une instance pour RDS           |
\------------------------------------------------------*/

  void FreeInstanceRds( InstanceRds )

       rds_ins *InstanceRds;
  {
    mbkfree((char *)InstanceRds);
  }

/*-----------------------------------------------------*\
|           Liberation d'une figure pour RDS            |
\------------------------------------------------------*/

  void FreeFigureRds( FigureRds )

       rds_fig *FigureRds;
  {
    mbkfree((char *)FigureRds);
  }

/*-----------------------------------------------------*\
|        Les fonctions de Destruction d'objets          |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|         Destruction d'un rectangle pour RDS           |
\------------------------------------------------------*/

  boolean DelRectangleInsRds( Instance, RectangleRds )

       rds_ins *Instance;
       rds_rec *RectangleRds;
  {
    rds_rec  *Rectangle;
    rds_rec **Previous;

    Previous  = &Instance->layertab[ RectangleRds->layer ];
    Rectangle = *Previous;

    while ( Rectangle != (rds_rec *)NULL )

    {
      if ( Rectangle == RectangleRds )

      {
        *Previous = Rectangle->next;

        FreeRectangleRds( Rectangle );

        return( TRUE );
      }

      Previous  = &Rectangle->next;
      Rectangle = *Previous;
    }

    return ( FALSE );
  }

/*-----------------------------------------------------*\
|         Destruction d'un rectangle pour RDS           |
\------------------------------------------------------*/

  boolean DelRectangleFigRds( Figure, RectangleRds )

       rds_fig *Figure;
       rds_rec *RectangleRds;
  {
    rds_rec  *Rectangle;
    rds_rec **Previous;


    Previous  = &Figure->layertab[ RectangleRds->layer ];
    Rectangle = *Previous;

    while ( Rectangle != (rds_rec *)NULL )

    {
      if ( Rectangle == RectangleRds )

      {
        *Previous = Rectangle->next;

        FreeRectangleRds( Rectangle );

        return( TRUE );
      }

      Previous  = &Rectangle->next;
      Rectangle = *Previous;
    }

    return ( FALSE );
  }

/*-----------------------------------------------------*\
|    Destruction d'une liste de rectangles pour RDS     |
\------------------------------------------------------*/

  void DelListRectangleInsRds( Instance, Layer )

       rds_ins *Instance;
       char     Layer;
  {
    rds_rec *Rectangle;
    rds_rec *Next;

    Rectangle = Instance->layertab[Layer];

    Instance->layertab[Layer] = (rds_rec *)NULL;

    while ( Rectangle != (rds_rec *)NULL )

    {
      Next = Rectangle->next;

      FreeRectangleRds( Rectangle );

      Rectangle = Next;
    }
  }

/*-----------------------------------------------------*\
|    Destruction d'une liste de rectangles pour RDS     |
\------------------------------------------------------*/

  void DelListRectangleFigRds( Figure, Layer )

       rds_fig *Figure;
       char     Layer;
  {
    rds_rec *Rectangle;
    rds_rec *Next;

    Rectangle = Figure->layertab[Layer];

    Figure->layertab[Layer] = (rds_rec *)NULL;

    while ( Rectangle != (rds_rec *)NULL )

    {
      Next = Rectangle->next;

      FreeRectangleRds( Rectangle );

      Rectangle = Next;
    }
  }

/*-----------------------------------------------------*\
|         Destruction d'une instance pour RDS           |
\------------------------------------------------------*/

  boolean DelInstanceRds( FigureRds, InstanceRds )

       rds_fig *FigureRds;
       rds_ins *InstanceRds;
  {
    rds_ins  *Instance;
    rds_ins **Previous;
    char      Count;

    Instance = FigureRds->instance;
    Previous = &FigureRds->instance;

    while ( Instance != (rds_ins *)NULL )

    {
      if ( Instance == InstanceRds )

      {
        for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

          DelListRectangleInsRds( Instance, Count );

        *Previous = Instance->next;

        FreeInstanceRds( Instance );

        return( TRUE );
      }

      Previous = &Instance->next;
      Instance = *Previous;
    }

    return ( FALSE );
  }

/*-----------------------------------------------------*\
|     Destruction d'une liste d'instances pour RDS      |
\------------------------------------------------------*/

  void DelListInstanceRds( FigureRds, InstanceRds )

       rds_fig *FigureRds;
       rds_ins *InstanceRds;
  {
    rds_ins **Previous;
    rds_ins  *Index;
    rds_ins  *Next;
    char      Count;


    Previous = &FigureRds->instance;

    for ( Index = FigureRds->instance;
          ( Index != (rds_ins *)NULL ) &&
          ( Index != InstanceRds     );
          Index = Index->next )
    {
      Previous = &Index->next;
    }

    *Previous = (rds_ins *)NULL;

    while ( Index != (rds_ins *)NULL )

    {
      Next = Index->next;

      for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

        DelListRectangleInsRds( Index, Count );

     FreeInstanceRds( Index );

     Index = Next;
   }
 }

/*-----------------------------------------------------*\
|           Destruction d'une figure pour RDS           |
\------------------------------------------------------*/

  boolean DelFigureRds( FigureRds )

       rds_fig *FigureRds;
  {
    rds_fig  *Figure;
    rds_fig **Previous;
    char      Count;

    Previous = &HeadFigureRds;
    Figure   = *Previous;

    while ( Figure != (rds_fig *)NULL )

    {
      if ( Figure == FigureRds )

      {
        for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

          DelListRectangleFigRds( Figure, Count );

        *Previous = Figure->next;

        DelListInstanceRds( Figure, Figure->instance );

        FreeFigureRds     ( Figure );

        return( TRUE );
      }

      Previous = &Figure->next;
      Figure   = *Previous;
    }

    return ( FALSE );
  }

/*-----------------------------------------------------*\
|      Destruction d'une liste de figures pour RDS      |
\------------------------------------------------------*/

  void DelListFigureRds( FigureRds )

       rds_fig *FigureRds;

  {
    rds_fig  *Index;
    rds_fig **Previous;
    rds_fig  *Next;
    char      Count;


    Previous      = &HeadFigureRds;

    for ( Index  = HeadFigureRds;
          ( Index != (rds_fig *)NULL ) && 
          ( Index != FigureRds );
          Index  = Index->next )
    {
      Previous = &Index->next;
    }

    *Previous = (rds_fig *)NULL;

    while ( Index != (rds_fig *)NULL )

    {
      Next = Index->next;

      for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

        DelListRectangleFigRds( Index, Count );

      DelListInstanceRds( Index, Index->instance );
      FreeFigureRds     ( Index );

     Index = Next;
   }
 }

/*-----------------------------------------------------*\
|        Les fonctions de Visualisation d'objets        |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|            Compte les liens du champ Link             |
\------------------------------------------------------*/

  char CountLink( Rectangle )

       rds_rec *Rectangle;
   {
      rds_rec *Index;
      char     Counter;
     
      Counter = 1;
      Index   = Rectangle->u_rec.link;
      
      while ( Index != Rectangle )
      {
        if (Index == (rds_rec *)NULL) return( 0 );

        Index = Index->u_rec.link;
        Counter++;
      }

      return ( Counter );
   }

/*-----------------------------------------------------*\
|        Visualisation d'un rectangles pour RDS         |
\------------------------------------------------------*/

  void ViewRectangleRds( Rectangle )

       rds_rec  *Rectangle;
  {
    char Counter;
    
    PrintHeadLine();

    printf("|---Rectangle : ");

    if (( Rectangle->mbk_type == MBK_SEGMENT ) &&
        ( Rectangle->extract_type >= RDS_SEG_GRILLE ) &&
        ( Rectangle->extract_type <= RDS_SEG_SOURCE ))
        
        {
          printf("TRANSISTOR");

          if ((Counter = CountLink( Rectangle )) == 3)

               printf(", %d\n", Counter);
          else 
               printf(" Link ERROR, %d !\n", Counter);
        }
    else 
        if ( Rectangle->mbk_type == MBK_VIA )
           {
             printf("VIA");

             if ((Counter = CountLink( Rectangle )) > 1)

                  printf(", %d\n", Counter);
             else 
                  printf(" Link ERROR, %d !\n", Counter);
           }
        else 
            if ( Rectangle->u_rec.name != (char *)NULL )

                 printf("%s\n", Rectangle->u_rec.name );
            else 
                 printf("! No name !\n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    PrintHeadLine();
    printf("|---Position     : X  = %-6d  Y  = %-6d\n", Rectangle->x,Rectangle->y );
    PrintHeadLine();
    printf("|---Size         : Dx = %-6d  Dy = %-6d\n", Rectangle->dx,Rectangle->dy);
    PrintHeadLine();
    printf("|---Mbk Type     : %s\n", MbkTypeName[ Rectangle->mbk_type ]);
    PrintHeadLine();
    printf("|---Extract Type : %s\n", ExtractName[ Rectangle->extract_type ]);
    PrintHeadLine();
    printf("|---Layer        : %s\n", LayerName[ Rectangle->layer ]);
    PrintHeadLine();
    printf("|---Flags        : %d\n", Rectangle->flags );
    PrintHeadLine();
    if ( Rectangle->user == NULL ) printf("|---User         : Empty\n" );
    else                           printf("|---User         : Busy \n" );
    PrintHeadLine();
    if ( Rectangle->equi == (rds_rec *)NULL ) printf("|---Equi         : Empty\n" );
    else                                      printf("|---Equi         : Busy \n" );
    PrintHeadLine();
    printf("|\n");

    HeadLine--;
  }

/*-----------------------------------------------------*\
|       Visualisation d'une liste de rectangles         |
\------------------------------------------------------*/

  long ViewListRectangleRds( Rectangle )

       rds_rec  *Rectangle;
  {
    long Counter;

    for ( Counter = 0; Rectangle != (rds_rec *)NULL; Counter++ )
    {
      ViewRectangleRds( Rectangle );
      Rectangle = Rectangle->next;
    }
    return( Counter );
  }

/*-----------------------------------------------------*\
|        Visualisation d'une Instance pour RDS          |
\------------------------------------------------------*/

  void ViewInstanceRds( Instance )

       rds_ins  *Instance;
  {
    char    Layer;
    boolean Empty;

    PrintHeadLine();

    printf("|---Instance : ");

    if ( Instance->ins_name != (char *)NULL )

         printf("%s\n", Instance->ins_name );
    else 
         printf("! No name ERROR !\n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    PrintHeadLine();
    printf("|---Modele   : ");

    if ( Instance->mod_name != (char *)NULL )

         printf("%s\n", Instance->mod_name );
    else 
         printf("! No name ERROR !\n");

    PrintHeadLine();
    printf("|---Position : X  = %-6d  Y  = %-6d\n", Instance->x , Instance->y );
    PrintHeadLine();
    printf("|---Transf   : %s\n", TransfName[ Instance->transf ] );

    PrintHeadLine();
    printf("|\n");

    for ( Empty = TRUE, Layer = 0; Layer < RDS_MAX_LAYER ; Layer++ )

     Empty &= ViewListRectangleRds( Instance->layertab[ Layer ] ) == 0;

    if ( Empty )
    {
      PrintHeadLine();
      printf("|---Rectangle List is empty\n");
    }

    PrintHeadLine();
    printf("|\n");

    HeadLine--;
  }

/*-----------------------------------------------------*\
|       Visualisation d'une liste d'instances           |
\------------------------------------------------------*/

  void ViewListInstanceRds( Instance )

       rds_ins  *Instance;
  {
    while ( Instance != (rds_ins *)NULL )
    {
      ViewInstanceRds( Instance );
      Instance = Instance->next;
    }
  }

/*-----------------------------------------------------*\
|          Visualisation d'une Figure pour RDS          |
\------------------------------------------------------*/

  void ViewFigureRds( Figure )

       rds_fig  *Figure;
  {
    rds_ins *Instance;
    char     Layer;
    boolean  Empty;

    PrintHeadLine();

    printf("|---Figure : ");

    if ( Figure->name != (char *)NULL )

         printf("%s\n", Figure->name );
    else 
         printf("! No name ERROR !\n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    PrintHeadLine();
    printf("|---Models  : \n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    for ( Empty = TRUE, Instance = Figure->instance;
          Instance != (rds_ins *)NULL;
          Instance = Instance->next )
    {
      Empty = FALSE;
      
      PrintHeadLine();

      if ( Instance->mod_name != (char *)NULL )

           printf("|---%s\n", Instance->mod_name );
      else 
           printf("|---! No name ERROR !\n");
    }

    if ( Empty )
    {
      PrintHeadLine();
      printf("|---Model list is empty\n");
    }
    
    PrintHeadLine();
    printf("|\n");

    HeadLine--;

    if ( ! Empty ) ViewListInstanceRds( Figure->instance );

    for ( Empty = TRUE, Layer = 0; Layer < RDS_MAX_LAYER ; Layer++ )

     Empty &= ViewListRectangleRds( Figure->layertab[ Layer ] ) == 0;

    if ( Empty )
    {
      PrintHeadLine();
      printf("|---Rectangle List is empty\n");
    }

    PrintHeadLine();
    printf("|\n");

    HeadLine--;
  }

/*-----------------------------------------------------*\
|         Visualisation d'une liste de figures          |
\------------------------------------------------------*/

  void ViewListFigureRds( Figure )

       rds_fig  *Figure;
  {
    if ( Figure == (rds_fig *)NULL) 
    {
      printf("\n|---Figure List is empty");
      return;
    }

    while ( Figure != (rds_fig *)NULL )
    {
      ViewFigureRds( Figure );
      Figure = Figure->next;
    }
  }
