/*-----------------------------------------------------*\
|                                                       |
|  Title   :      Translator MBK -> RDS                 |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :         Jacomme Ludovic                    |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|               Les fichiers a inclure                  |
\------------------------------------------------------*/

#include MUT_H
#include MLO_H
#include MPH_H
#include RDS_H
#include "mbkrds102.h"
#include <string.h>

/*-----------------------------------------------------*\
|               Les variables globales                  |
\------------------------------------------------------*/

#include "rules.h"
#include "mbklayer.h"

/*-----------------------------------------------------*\
|               Les messages d'erreurs                  |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|        Les fonctions de passage Mbk -> Rds            |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|     Transformation d'un Segment d'une Figure Mbk      |
\------------------------------------------------------*/

  rds_rec *SegmentMbkRds( FigureRds, Segment )

           rds_fig    *FigureRds;
           phseg_list *Segment;

  {
    rds_rec *Rectangle;
    rds_rec *Inter;
    char     Layer;

    Layer = Segment->LAYER;

    if ( ( Layer == NTRANS ) ||
         ( Layer == PTRANS ) )
    {
      Layer = (Layer == NTRANS) ? RDS_NDIF: RDS_PDIF;

      if ( Segment->TYPE == HOR )

      {
         Rectangle = AddRectangleFigRds
         (
           FigureRds, 
           Segment->NAME,
           Segment->X1 - SEGMENT_EXTENTION[ RDS_GATE ],
           Segment->Y1 - (Segment->WIDTH >> 1),
           Segment->X2 - Segment->X1 + (SEGMENT_EXTENTION[ RDS_GATE ] << 1),
           Segment->WIDTH,
           RDS_GATE, MBK_SEGMENT, RDS_SEG_GRILLE,
           Segment
         );

         Inter = AddRectangleFigRds
         (
           FigureRds, NULL,
           Segment->X1 + TRANSISTOR_EXTENTION,
           Segment->Y1 - ( Segment->WIDTH >> 1 ) - TRANSISTOR_WIDTH,
           Segment->X2 - Segment->X1 - (TRANSISTOR_EXTENTION << 1),
           TRANSISTOR_WIDTH,
           Layer, MBK_SEGMENT, RDS_SEG_DRAIN,
           Segment
         );

         Rectangle->u_rec.link = Inter;

         Inter->u_rec.link = AddRectangleFigRds
         (
           FigureRds, NULL,
           Segment->X1 + TRANSISTOR_EXTENTION,
           Segment->Y1 + ( Segment->WIDTH >> 1 ),
           Segment->X2 - Segment->X1 - (TRANSISTOR_EXTENTION << 1),
           TRANSISTOR_WIDTH,
           Layer, MBK_SEGMENT, RDS_SEG_SOURCE,
           Segment
         );

         return ( Inter->u_rec.link->u_rec.link = Rectangle );
      }

      else

      {
        Rectangle = AddRectangleFigRds
        (
          FigureRds, Segment->NAME,
          Segment->X1 - (Segment->WIDTH >> 1),
          Segment->Y1 - SEGMENT_EXTENTION[ RDS_GATE ],
          Segment->WIDTH,
          Segment->Y2 - Segment->Y1 + (SEGMENT_EXTENTION[ RDS_GATE ] << 1),
          RDS_GATE, MBK_SEGMENT, RDS_SEG_GRILLE,
          Segment
        );

        Inter = AddRectangleFigRds
        (
          FigureRds, NULL,
          Segment->X1 - ( Segment->WIDTH >> 1 ) - TRANSISTOR_WIDTH,
          Segment->Y1 + TRANSISTOR_EXTENTION,
          TRANSISTOR_WIDTH,
          Segment->Y2 - Segment->Y1 - (TRANSISTOR_EXTENTION << 1),
          Layer, MBK_SEGMENT, RDS_SEG_DRAIN,
          Segment
        );

        Rectangle->u_rec.link = Inter;

        Inter->u_rec.link = AddRectangleFigRds
        (
          FigureRds, NULL,
          Segment->X1 + ( Segment->WIDTH >> 1 ),
          Segment->Y1 + TRANSISTOR_EXTENTION,
          TRANSISTOR_WIDTH,
          Segment->Y2 - Segment->Y1 - (TRANSISTOR_EXTENTION << 1),
          Layer, MBK_SEGMENT, RDS_SEG_SOURCE,
          Segment
        );

        return ( Inter->u_rec.link->u_rec.link = Rectangle );
      }
    }

    else

    {
      Layer = LAYER_MBK_TO_RDS[ Layer ];

      if ( Segment->TYPE == HOR )

      return ( AddRectangleFigRds
      (
        FigureRds, Segment->NAME,
        Segment->X1 - SEGMENT_EXTENTION[ Layer ],
        Segment->Y1 - (Segment->WIDTH >> 1),
        Segment->X2 - Segment->X1 + (SEGMENT_EXTENTION[ Layer ] << 1),
        Segment->WIDTH,
        Layer, MBK_SEGMENT, RDS_SEG_BANAL,
        Segment
      )      );

      else

      return ( AddRectangleFigRds
      (
        FigureRds, Segment->NAME,
        Segment->X1 - (Segment->WIDTH >> 1),
        Segment->Y1 - SEGMENT_EXTENTION[ Layer ],
        Segment->WIDTH,
        Segment->Y2 - Segment->Y1 + (SEGMENT_EXTENTION[ Layer ] << 1),
        Layer, MBK_SEGMENT, RDS_SEG_BANAL,
        Segment
      )      );
    }
  }


/*-----------------------------------------------------*\
|             Transformation d'un Via Mbk               |
\------------------------------------------------------*/

  rds_rec *ViaMbkRds( FigureRds, Via )

           rds_fig    *FigureRds;
           phvia_list *Via;

  {
    rds_rec *Rectangle;
    rds_rec *Inter;
    rds_rec *First;

    long     WRectangle;

    char     Index;
    char     LayerRds;

    First = Inter = (rds_rec *)NULL;
    
    for ( Index      = 0;
          ( LayerRds = MBK_VIA_TO_LAYER_RDS[ Via->TYPE ][ Index << 1 ] ) 
          != END_LIST;
          Index++ )
    {
      WRectangle = MBK_VIA_TO_LAYER_RDS[ Via->TYPE ][ ( Index << 1 ) + 1 ];

      Rectangle = AddRectangleFigRds
      (
        FigureRds,
        NULL,
        Via->XVIA - WRectangle,
        Via->YVIA - WRectangle,
        WRectangle << 1,
        WRectangle << 1,
        LayerRds, 
        MBK_VIA, 
        RDS_NONE,
        Via
      );

      if ( Inter == (rds_rec *)NULL )
      {
        Inter = First = Rectangle;
      }
      else
      {
        Rectangle->u_rec.link = Inter;
        Inter                 = Rectangle;
      }
    }

    return( First->u_rec.link = Inter );
  }

/*-----------------------------------------------------*\
|          Transformation d'un Connecteur Mbk           |
\------------------------------------------------------*/

  rds_rec *ConnectorMbkRds( FigureRds, Connector )

           rds_fig    *FigureRds;
           phcon_list *Connector;

  {
    char Layer;
    long X;
    long Y;
    long Dx;
    long Dy;

    if ( Connector->NAME == (char *)NULL ) 

      return((rds_rec *)NULL);

    Layer = LAYER_MBK_TO_RDS[ Connector->LAYER ];

    switch (Connector->ORIENT) 
    {
       case 'N': 
       case 'S':
                 X  = Connector->XCON - ( Connector->WIDTH >> 1);
                 Y  = Connector->YCON - SEGMENT_EXTENTION[ Layer ];
                 Dx = Connector->WIDTH;
                 Dy = SEGMENT_EXTENTION[ Layer ] << 1;
                 break;

       case 'E':
       case 'W':
                 X  = Connector->XCON - SEGMENT_EXTENTION[ Layer ];
                 Y  = Connector->YCON - ( Connector->WIDTH >> 1);
                 Dx = SEGMENT_EXTENTION[ Layer ] << 1;
                 Dy = Connector->WIDTH;
    }

    return( AddRectangleFigRds
    (
      FigureRds, Connector->NAME,
      X,
      Y,
      Dx,
      Dy,
      Layer, 
      MBK_CONNECTOR, 
      RDS_CON_EXTER,
      Connector
    )) ;
  }

/*-----------------------------------------------------*\
|          Transformation d'une Reference Mbk           |
\------------------------------------------------------*/

  static char Buffer[ 256 ];

  rds_rec *ReferenceMbkRds( FigureRds, Reference )

           rds_fig    *FigureRds;
           phref_list *Reference;

  { 
    char *ReferenceName;

    if ( strcmp( Reference->FIGNAME, "ref_con" )) 
    {
      return( AddRectangleFigRds
      (
        FigureRds, 
        Reference->NAME,
        Reference->XREF - REFERENCE_SIZE,
        Reference->YREF - REFERENCE_SIZE,
        REFERENCE_SIZE << 1,
        REFERENCE_SIZE << 1,
        RDS_REF, 
        MBK_REFERENCE,
        RDS_REF_REF,
        Reference
      )) ;
    }
    else
    {
      strcpy( Buffer, Reference->NAME );

      ReferenceName = strrchr( Buffer, '_' ); 

      if ( ReferenceName != (char *)NULL )
      {
        *ReferenceName = '\0';
      }

      ReferenceName = namealloc( Buffer );
       
      return( AddRectangleFigRds
      (
        FigureRds, 
        ReferenceName,
        Reference->XREF - REFERENCE_SIZE,
        Reference->YREF - REFERENCE_SIZE,
        REFERENCE_SIZE << 1,
        REFERENCE_SIZE << 1,
        RDS_ALU1, 
        MBK_REFERENCE,
        RDS_CON_EXTER,
        Reference
      )) ;
    }
  }

/*-----------------------------------------------------*\
|    Transformation d'un Connecteur d'une instance Mbk  |
\------------------------------------------------------*/

  extern char TransfName[ RDS_MAX_TRANSF ][8];

  void  ConnectorInsMbkRds( InstanceRds, FigureMbk, InstanceMbk )

       rds_ins    *InstanceRds;
       phfig_list *FigureMbk;
       phins_list *InstanceMbk;

  {
    phcon_list *Connector;
    long        X1;
    long        Y1;
    long        X2;
    long        Y2;

    long        X;
    long        Y;
    long        Dx;
    long        Dy;
    char        Layer;

    for ( Connector = FigureMbk->PHCON; 
          Connector ;
          Connector = Connector->NEXT
        )
    {
      if ( Connector->NAME == (char *)NULL ) 

        continue;

      Layer = LAYER_MBK_TO_RDS[ Connector->LAYER ];

      switch (Connector->ORIENT) 
      {
         case 'N': 
         case 'S': 
                   X  = Connector->XCON - ( Connector->WIDTH >> 1);
                   Y  = Connector->YCON - SEGMENT_EXTENTION[ Layer ];
                   Dx = Connector->WIDTH;
                   Dy = SEGMENT_EXTENTION[ Layer ] << 1;
                   break;

         case 'E':
         case 'W': 
                   X  = Connector->XCON - SEGMENT_EXTENTION[ Layer ];
                   Y  = Connector->YCON - ( Connector->WIDTH >> 1);
                   Dx = SEGMENT_EXTENTION[ Layer ] << 1;
                   Dy = Connector->WIDTH;
      }

      xyflat
      ( &X1, &Y1,
        X,
        Y,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      xyflat
      ( &X2, &Y2,
        X + Dx,
        Y + Dy,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      if ( X1 > X2 ) 
      {
        X  = X1;
        X1 = X2;
        X2 = X;
      }
  
      if ( Y1 > Y2 )
      {
        Y  = Y1;
        Y1 = Y2;
        Y2 = Y;
      }
 
      AddRectangleInsRds
      (
        InstanceRds, 
        Connector->NAME,
        X1,
        Y1,
        X2 - X1, 
        Y2 - Y1,
        Layer, 
        MBK_CONNECTOR, 
        RDS_CON_INTER,
        Connector
      );
    }
  }

/*-----------------------------------------------------*\
|    Transformation d'une reference d'une instance Mbk  |
\------------------------------------------------------*/

  void ReferenceInsMbkRds( InstanceRds, FigureMbk, InstanceMbk )

       rds_ins    *InstanceRds;
       phfig_list *FigureMbk;
       phins_list *InstanceMbk;

  {
    phref_list *Reference;
    char       *ReferenceName;
    long        X;
    long        Y;

    long        X1;
    long        Y1;
    long        X2;
    long        Y2;

    for ( Reference = FigureMbk->PHREF; 
          Reference ;
          Reference = Reference->NEXT
        )
    {
      X = Reference->XREF;
      Y = Reference->YREF;

      xyflat
      ( &X1, &Y1,
        X - REFERENCE_SIZE,
        Y - REFERENCE_SIZE,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      xyflat
      ( &X2, &Y2,
        X + REFERENCE_SIZE,
        Y + REFERENCE_SIZE,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      if ( X1 > X2 )
      {
        X  = X1;
        X1 = X2;
        X2 = X;
      }

      if ( Y1 > Y2 )
      {
        Y  = Y1;
        Y1 = Y2;
        Y2 = Y;
      }

      if ( strcmp( Reference->FIGNAME, "ref_con" ))
      {
        AddRectangleInsRds
        (
          InstanceRds,
          Reference->NAME,
          X1, Y1,
          X2 - X1, 
          Y2 - Y1,
          RDS_REF,
          MBK_REFERENCE,
          RDS_REF_REF,
          Reference
        );
      }
      else
      {
        strcpy ( Buffer , Reference->NAME );

        ReferenceName = strrchr( Buffer, '_' ); 

        if ( ReferenceName != (char *)NULL )
        {
          *ReferenceName = '\0';
        }

        ReferenceName = namealloc( Buffer );
       
        AddRectangleInsRds
        (
          InstanceRds,
          ReferenceName,
          X1, Y1,
          X2 - X1, 
          Y2 - Y1,
          RDS_ALU1,
          MBK_REFERENCE,
          RDS_CON_INTER,
          Reference
        );
      }
    }
  }

/*-----------------------------------------------------*\
|    Transformation d'un segment d'une instance Mbk     |
\------------------------------------------------------*/

  void SegmentInsMbkRds( InstanceRds, FigureMbk, InstanceMbk )

       rds_ins    *InstanceRds;
       phfig_list *FigureMbk;
       phins_list *InstanceMbk;

  {
    phseg_list *Segment;
    char        Layer;

    long        X;
    long        Y;
    long        Dx;
    long        Dy;

    long        X1;
    long        X2;
    long        Y1;
    long        Y2;

    for ( Segment = FigureMbk->PHSEG; 
          Segment ;
          Segment = Segment->NEXT
        )
    {
      Layer = Segment->LAYER;

      if (( Layer != TPOLY ) &&
          ( Layer != TALU1 ) &&
          ( Layer != TALU2 ) &&
          ( Layer != TALU3 ))  

        continue;

      if ( Segment->TYPE == HOR )
      {
        X  = Segment->X1 - SEGMENT_EXTENTION[ Layer ];
        Y  = Segment->Y1 - (Segment->WIDTH >> 1);
        Dx = Segment->X2 - Segment->X1 + ( SEGMENT_EXTENTION[ Layer ] << 1 );
        Dy = Segment->WIDTH;
      }
      else
      {
        X  = Segment->X1 - (Segment->WIDTH >> 1);
        Y  = Segment->Y1 - SEGMENT_EXTENTION[ Layer ];
        Dx = Segment->WIDTH;
        Dy = Segment->Y2 - Segment->Y1 + (SEGMENT_EXTENTION[ Layer ] << 1);
      }

      xyflat
      ( &X1, &Y1,
        X,
        Y,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      xyflat
      ( &X2, &Y2,
        X + Dx,
        Y + Dy,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      if ( X1 > X2 )
      {
        X  = X1;
        X1 = X2;
        X2 = X;
      }

      if ( Y1 > Y2 )
      {
        Y  = Y1;
        Y1 = Y2;
        Y2 = Y;
      }

      Layer = LAYER_MBK_TO_RDS[ Layer ];

      AddRectangleInsRds
      (
        InstanceRds,
        Segment->NAME,
        X1,
        Y1,
        X2 - X1,
        Y2 - Y1,
        Layer, MBK_SEGMENT, RDS_SEG_BANAL,
        Segment
      );
    }
  }

/*-----------------------------------------------------*\
|           Transformation d'une Instance Mbk           |
\------------------------------------------------------*/

  rds_ins *InstanceMbkRds( FigureRds, InstanceMbk )

           rds_fig    *FigureRds;
           phins_list *InstanceMbk;

  {
    phfig_list *FigureMbk;
    rds_ins    *InstanceRds;
 
    long        X;
    long        Y;

    FigureMbk = getphfig( InstanceMbk->FIGNAME, 'P' );

    xyflat
    ( &X, &Y,
      0,
      0,
      InstanceMbk->XINS,
      InstanceMbk->YINS,
      FigureMbk->XAB1,
      FigureMbk->YAB1,
      FigureMbk->XAB2,
      FigureMbk->YAB2,
      InstanceMbk->TRANSF
    );

    InstanceRds = AddInstanceRds
    (
      FigureRds, 
      InstanceMbk->FIGNAME, 
      InstanceMbk->INSNAME,
      X,
      Y,
      InstanceMbk->TRANSF,
      InstanceMbk
    );
   
    AddRectangleInsRds
    ( 
      InstanceRds,
      InstanceMbk->INSNAME,
      InstanceMbk->XINS,
      InstanceMbk->YINS, 
      FigureMbk->XAB2 - FigureMbk->XAB1,
      FigureMbk->YAB2 - FigureMbk->YAB1,
      RDS_ABOX, 
      MBK_INSTANCE, 
      RDS_NONE, 
      (void *)InstanceMbk
    );

    SegmentInsMbkRds   ( InstanceRds, FigureMbk, InstanceMbk );
    ConnectorInsMbkRds ( InstanceRds, FigureMbk, InstanceMbk );
    ReferenceInsMbkRds ( InstanceRds, FigureMbk, InstanceMbk );

    return( InstanceRds );
  }


/*-----------------------------------------------------*\
|              Transformation Mbk -> Rds                |
\------------------------------------------------------*/

  rds_fig *MbkRds( FigureMbk )

       phfig_list *FigureMbk;

  {
    void    *Pointer;
    rds_fig *FigureRds;

    FigureRds = AddFigureRds
    (
      FigureMbk->NAME,
      FigureMbk
    );

    if (( FigureMbk->XAB1 != FigureMbk->XAB2 ) &&
        ( FigureMbk->YAB1 != FigureMbk->YAB2 ))

    AddRectangleFigRds
    ( 
      FigureRds,
      FigureMbk->NAME,
      FigureMbk->XAB1,
      FigureMbk->YAB1, 
      FigureMbk->XAB2 - FigureMbk->XAB1,
      FigureMbk->YAB2 - FigureMbk->YAB1,
      RDS_ABOX, 
      MBK_FIGURE, 
      RDS_NONE, 
      (void *)FigureMbk
    );

    for ( Pointer = (void *)(FigureMbk->PHSEG); 
          Pointer;
          Pointer = (void *)(((phseg_list *)Pointer)->NEXT))

      SegmentMbkRds( FigureRds, (phseg_list *)Pointer);

    for ( Pointer = (void *)(FigureMbk->PHVIA); 
          Pointer;
          Pointer = (void *)(((phvia_list *)Pointer)->NEXT))

      ViaMbkRds( FigureRds, (phvia_list *)Pointer);

    for ( Pointer = (void *)(FigureMbk->PHINS); 
          Pointer;
          Pointer = (void *)(((phins_list *)Pointer)->NEXT))

      InstanceMbkRds( FigureRds, (phins_list *)Pointer);

    for ( Pointer = (void *)(FigureMbk->PHCON); 
          Pointer;
          Pointer = (void *)(((phcon_list *)Pointer)->NEXT))

      ConnectorMbkRds( FigureRds, (phcon_list *)Pointer);

    for ( Pointer = (void *)(FigureMbk->PHREF); 
          Pointer;
          Pointer = (void *)(((phref_list *)Pointer)->NEXT))

      ReferenceMbkRds( FigureRds, (phref_list *)Pointer);

    return( FigureRds );
  }

/*-----------------------------------------------------*\
|            Transformation Rds -> Mbk                  |
\------------------------------------------------------*/

  void RectangleRdsMbk( FigureMbk, RectangleAbox, RectangleRds )

       phfig_list *FigureMbk;
       rds_rec    *RectangleAbox;
       rds_rec    *RectangleRds;
  {
    rds_rec *Transistor;

    long X;
    long Y;
    long Dx;
    long Dy;

    long X1;
    long Y1;
    long X2;
    long Y2;
    long Width;
  
    char LayerRds;
    char LayerMbk;

    char Orient;

    LayerMbk = LAYER_RDS_TO_MBK[ LayerRds = RectangleRds->layer ];

    if ( ( LayerMbk == END_LIST ) && 
         ( RectangleRds->mbk_type != MBK_VIA ) )

      return;

    X  = RectangleRds->x;
    Y  = RectangleRds->y;
    Dx = RectangleRds->dx;
    Dy = RectangleRds->dy;
   
    switch ( RectangleRds->mbk_type )
    {
      case MBK_CONNECTOR : if ( RectangleRds->extract_type == RDS_CON_EXTER )
                           {
                             if ( Dx == ( SEGMENT_EXTENTION[ LayerRds ] << 1 ))
                             {
                               Width  = Dy;
                               Orient = EAST; 
                             }
                             else
                             {
                               Width = Dx;
                               Orient = SOUTH; 
                             }
                              
                             X = X + ( Dx >> 1 );
                             Y = Y + ( Dy >> 1 );
  
                               if ( ( RectangleRds->extract_type == RDS_CON_EXTER ) &&
                                  ( RectangleAbox != (rds_rec *)NULL            ) )
                             {
                               if ( X == RectangleAbox->x  ) Orient = WEST;
                               else
                               if ( Y == RectangleAbox->y  ) Orient = SOUTH;
                               else
                               if ( X == RectangleAbox->x + RectangleAbox->dx  ) Orient = EAST; 
                               else                                              Orient = NORTH;
                             }
  
                             addphcon( FigureMbk, 
                                       Orient,
                                       RectangleRds->u_rec.name,
                                       X , Y,
                                       LayerMbk,
                                       Width
                                     );
                           }
                           break;
  
      case MBK_SEGMENT   : if ( ( RectangleRds->extract_type > RDS_SEG_BANAL ) &&
                                ( RectangleRds->extract_type < RDS_CON_EXTER ) )
                           {
                             switch ( RectangleRds->extract_type )
                             {
                               case RDS_SEG_GRILLE : Transistor = RectangleRds;
                                                     break;
                               case RDS_SEG_DRAIN  : Transistor = RectangleRds->u_rec.link->u_rec.link;
                                                     break;
                               case RDS_SEG_SOURCE : Transistor = RectangleRds->u_rec.link;
                             }

                             X = Transistor->x;
                             Y = Transistor->y;
                             Dx = Transistor->dx;
                             Dy = Transistor->dy;

                             LayerMbk = ( Transistor->u_rec.link->layer == RDS_NDIF ) ? NTRANS:PTRANS;
                             LayerRds = RDS_GATE;
                           }

                           X1 = X + ( Dx >> 1 );
                           Y1 = Y + SEGMENT_EXTENTION[ LayerRds ];
                           X2 = X1;
                           Y2 = Y + Dy - SEGMENT_EXTENTION[ LayerRds ];
  
                           if ( ( Y1 == Y2 ) ||
                                ( X1 %  10 ) ||
                                ( Y1 %  10 ) ||
                                ( Y2 %  10 ) )
                           {
                             X1 = X + SEGMENT_EXTENTION[ LayerRds ];
                             Y1 = Y + ( Dy >> 1 );
                             X2 = X + Dx - SEGMENT_EXTENTION[ LayerRds ];
                             Y2 = Y1;
                             Width = Dy;
                           }
                           else
                           {
                             Width = Dx;
                           }

                           addphseg( FigureMbk, LayerMbk, 
                                     Width, X1, Y1, X2, Y2, 
                                     ( RectangleRds->extract_type == RDS_SEG_BANAL ) 
                                     ? RectangleRds->u_rec.name : NULL
                                   );
                           
                           break;

      case MBK_REFERENCE : addphref( FigureMbk, 
                                     ( RectangleRds->extract_type == RDS_REF_REF ) 
                                     ? ( "ref_ref" ) : ( "ref_con" ),
                                     RectangleRds->u_rec.name,
                                     X + REFERENCE_SIZE,
                                     Y + REFERENCE_SIZE
                                   );
                           break;

     case MBK_VIA       : if (( LayerRds == RDS_CONT ) ||
                              ( LayerRds == RDS_VIA1 ) ||
                              ( LayerRds == RDS_VIA2 ))
                          {
                            addphvia( FigureMbk, 
                                      LAYER_RDS_TO_MBK_VIA[ RectangleRds->u_rec.link->layer ],
                                      X + ( Dx >> 1 ), Y + ( Dy >> 1 )
                                    );
                          }
                          else
                          if ( RectangleRds->u_rec.link->layer  == RDS_GATE )
                          { 
                            addphvia( FigureMbk, 
                                      ( LayerRds == RDS_NDIF ) 
                                      ? ( C_X_N ) : ( C_X_P ),
                                      X + ( Dx >> 1 ), Y + ( Dy >> 1 )
                                    );
                          } 
    }
  }
