/*------------------------------------------------------\
|                                                       |
|  Title   :        Error Messages for Lynx             |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :         Jacomme ludovic                    |
|                                                       |
\------------------------------------------------------*/

# include <stdio.h>
# include "define.h"

/*------------------------------------------------------\
|                   Pour extract.c                      |
\------------------------------------------------------*/

  void ErrorPhysicalConnector( Name, Core )
      
       char *Name;
       char  Core;
  {
    fprintf( stderr, "\n Lynx.105 Error : connector %s is on two different equis !\n\n", Name);

    if ( Core ) fprintf( stderr, " Lynx.105 Warning : Generates core_equi file !\n\n" );
  }

  void ErrorPhysicalConnectors( FirstName, SecondName, Core )
      
       char *FirstName;
       char *SecondName;
       char  Core;
  {
    fprintf( stderr, "\n Lynx.105 Error : connectors %s and %s are on the same equi !\n\n", 
             FirstName, SecondName );

    if ( Core ) fprintf( stderr, " Lynx.105 Warning : Generates core_equi file !\n\n" );
  }

  void GenerateCoreFloat()

  {
    fprintf( stderr, "\n Lynx.105 Warning : Generates core_float file !\n\n" );
  }

/*------------------------------------------------------\
|                   Pour fence.c                        |
\------------------------------------------------------*/

  void ErrorCutTransistorElbow( Core )

       char Core;
  {
    fprintf( stderr, "\n          Lynx.105 Error : Unable to cut transistor\n\n" );

    if ( Core ) fprintf( stderr, "          Lynx.105 Warning : Generates core_cx file !\n\n" );
    
    exit( ERROR ); 
  }

  void ErrorMaskCounterNull()

  {
    fprintf( stderr, "\n            Lynx.105 Error : No rectangle found\n\n" );

    exit( ERROR ); 
  }

/*------------------------------------------------------\
|                   Pour  Lynx.c                        |
\------------------------------------------------------*/

  void TooFewParameters()

  {
    fprintf( stderr,"\n  Syntax : lynx [-v] [-c] [ -k ] [ -f or -t ] Input_name [ Output_name ]\n\n");

    fprintf( stderr,"    -v  Sets verbose mode on\n"); 
    fprintf( stderr,"    -c  Generates a core file when an error occurs\n"); 
    fprintf( stderr,"    -k  Computes real capacitance for logical signals\n");
    fprintf( stderr,"    -f  Flattens the layout to the catalog level befor extracting\n");
    fprintf( stderr,"    -t  Flattens the layout to transistors level befor extracting\n\n");

    exit( ERROR ); 
  }

  void IllegalCombination()

  {
    fprintf( stderr, "\n          Lynx.105 Error : Illegal combination -t -f !\n\n");

    exit( ERROR ); 
  }

  void IllegalOption( Option )

       char *Option;
  {
    fprintf( stderr, "\n            Lynx.105 Error : Illegal option %s !\n\n", Option );

    exit( ERROR ); 
  }

  void IllegalFileName( Name )

       char *Name;
  {
    fprintf( stderr, "\n           Lynx.105 Error : Illegal file name %s !\n\n", Name );

    exit( ERROR ); 
  }

