/*-----------------------------------------------------*\
|                                                       |
|  Title   :   Constants & Fonctions for Extract        |
|                                                       |
|  Date    :              01/01/93                      |
|                                                       |
|  Author  :           Jacomme Ludovic                  |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                    Les constantes                     |
\------------------------------------------------------*/

#ifndef LIBEXTRACT101
#define LIBEXTRACT101

#  define MAX_FENCE_LAYER RDS_REF

#  define EXTRACT_BITS    ((char)3)
#  define EXTRACT_NONE    ((char)0)
#  define EXTRACT_TAG     ((char)1)
#  define EXTRACT_END     ((char)2)

/*-----------------------------------------------------*\
|                       Les Macros                      |
\------------------------------------------------------*/

#  define IsExtractEnd(X)          (((X) & EXTRACT_BITS ) == EXTRACT_END  )
#  define IsExtractTag(X)          (((X) & EXTRACT_BITS ) == EXTRACT_TAG  )
#  define IsExtractNone(X)         (((X) & EXTRACT_BITS ) == EXTRACT_NONE )

#  define SetExtractEnd(X)    ((X) = (((X) & ~EXTRACT_BITS ) | EXTRACT_END ))
#  define SetExtractTag(X)    ((X) = (((X) & ~EXTRACT_BITS ) | EXTRACT_TAG ))
#  define SetExtractNone(X)   ((X) = ((X) & ~EXTRACT_BITS ))

/*-----------------------------------------------------*\
|                       Les Types                       |
\*-----------------------------------------------------*/

  typedef struct LynxFenceList
  {
    struct LynxFenceList *Next;
    chain_list           *LayerTable[MAX_FENCE_LAYER];

  } FenceList;

/*-----------------------------------------------------*\
|                  Les variables globales               |
\------------------------------------------------------*/

  extern rds_rec    *HeadChainEqui;

  extern char       FenceLayerEnable[ MAX_FENCE_LAYER ];
  extern FenceList *HeadFence;

  extern long       MaskCounterRds;
  extern long       XMaxRds;
  extern long       YMaxRds;
  extern long       XMinRds;
  extern long       YMinRds;

/*-----------------------------------------------------*\
|                 Les fonctions de fenetrage            |
\------------------------------------------------------*/

  extern FenceList *AllocFenceList();
  extern void       FreeFenceList();
  extern void       LinkFenceRectangle();
  extern void       DelFenceList();
  extern long       BuildFenceList();

/*-----------------------------------------------------*\
|                  Les fonctions d'extraction           |
\------------------------------------------------------*/

  extern long        CutTransistorElbow();
  extern long        ChainEqui();
  extern long        FusionEqui();
  extern rds_rec    *Equipotential();
  extern long        ViewChainEqui();

#endif
