/***************************************************************/
/* module   : libpat_l.h                                       */
/* date     : 12/04/92                                         */
/* auteurs  : RENAUD & VENOT                                   */
/* version  : v1.1                                             */
/* contenu  : librairie basse                                  */
/***************************************************************/
#include <stdio.h>
/*------------------------------------------------------------
 *      CONSTANTES
 *------------------------------------------------------------*/
#define GNP_MAXPILE_PARAM   40
#define GNP_PARAM_COURANT (sp_file_param - 1) /* sp_.. pointe tjrs sur le suivant */
#define GNP_MAXTAB_IDENT   500
#define GNP_MAXTAB_PAIOL   500
#define GNP_NO_DUPLICATE    -1
#define GNP_NOT_FOUND       -1
#define GNP_ACTIF 1
#define GNP_INACTIF 0
#define GNP_VECTEUR_VIRTUEL 1
#define GNP_VECTEUR_EFFECTIF 0
#define GNP_UP 1
#define GNP_DO -1
#define GNP_INTERRO '?'

#define GNP_DIM_ZERO    0  /* taille de vecteur = 0 c'est un paiol unique */
#define GNP_DIM_UN      1  /* taille de vecteur = 1*/
#define GNP_SENS_UP     1  /* vecteur declare par valeurs croissantes */
#define GNP_SENS_DOWN  -1  /* vecteur declare par valeurs decroissantes */
#define GNP_MIN_BLANK   0  /* valeur min acceptee apres le ':' */
#define GNP_MAX_BLANK   9  /* valeur min acceptee apres le ':' */
#define GNP_MAX_LENGTH_IDENT 9 /* longueur max admissible d'un parametre */
#define GNP_END_ARG     0  /* fin de liste d'arguments a nb indetermine */

#define GNP_PILE_ZERO   0  /* valeur initiale de la pile  */
#define GNP_MIN_PARAM   0  /* pied de pile des parametres */
#define GNP_MAX_PARAM  10  /* sommet de pile des parametres */

#define GNP_BINAIRE       "B" /* remplit les paiol's et teste la syntaxe d'entree */
#define GNP_OCTAL         "O" /* remplit les paiol's et teste la syntaxe d'entree */
#define GNP_HEXA          "X" /* remplit les paiol's et teste la syntaxe d'entree */

#define GNP_TYPE_IN       "I" /* remplit les paiol's et teste la syntaxe d'entree */
#define GNP_TYPE_OUT      "O" /* remplit les paiol's et teste la syntaxe d'entree */
#define GNP_TYPE_INOUT    "T" /* remplit les paiol's et teste la syntaxe d'entree */
#define GNP_TYPE_SIGNAL   "S" /* remplit les paiol's et teste la syntaxe d'entree */
#define GNP_TYPE_REGISTER "R" /* remplit les paiol's et teste la syntaxe d'entree */

#define GNP_ERR1    1
#define GNP_ERR2    2
#define GNP_ERR3    3
#define GNP_ERR4    4
#define GNP_ERR5    5
#define GNP_ERR6    6
#define GNP_ERR7    7
#define GNP_ERR8    8
#define GNP_ERR9    9
#define GNP_ERR10   10
#define GNP_ERR11   11
#define GNP_ERR12   12
#define GNP_ERR13   13
#define GNP_ERR14   14
#define GNP_ERR15   15
#define GNP_ERR16   16
#define GNP_ERR17   17
#define GNP_ERR18   18
#define GNP_ERR19   19
#define GNP_ERR20   20
#define GNP_ERR21   21
#define GNP_ERR22   22
#define GNP_ERR23   23
#define GNP_ERR24   24
#define GNP_ERR25   25
#define GNP_ERR26   26
#define GNP_ERR27   27
#define GNP_ERR28   28
#define GNP_ERR29   29
#define GNP_ERR30   30
#define GNP_ERR31   31
#define GNP_ERR32   32
#define GNP_ERR33   33
#define GNP_ERR34   34
#define GNP_ERR35   35
#define GNP_ERR36   36
#define GNP_ERR37   37
#define GNP_ERR38   38
#define GNP_ERR39   39
#define GNP_ERR40   40
#define GNP_ERR41   41
#define GNP_ERR42   42
#define GNP_ERR43   43
#define GNP_ERR44   44
#define GNP_ERR45   45
#define GNP_ERR46   46
#define GNP_ERR47   47
#define GNP_ERR48   48
#define GNP_ERR49   49
#define GNP_ERR50   50
#define GNP_ERR51   51
#define GNP_ERR52   52
#define GNP_ERR53   53
#define GNP_ERR54   54
#define GNP_ERR55   55
#define GNP_ERR56   56
#define GNP_ERR57   57
#define GNP_ERR58   58
#define GNP_ERR59   59
#define GNP_ERR60   60
#define GNP_ERR61   61
#define GNP_ERR62   62
#define GNP_ERR63   63
#define GNP_ERR64   64
#define GNP_ERR65   65
#define GNP_ERR66   66
#define GNP_ERR67   67
#define GNP_ERR68   68
#define GNP_ERR69   69
#define GNP_ERR70   70
#define GNP_ERR71   71
#define GNP_ERR72   72
#define GNP_ERR73   73
#define GNP_ERR74   74
#define GNP_ERR75   75
#define GNP_ERR76   76
#define GNP_ERR77   77
#define GNP_ERR78   78
#define GNP_ERR79   79
#define GNP_ERR80   80
#define GNP_ERR81   81
#define GNP_ERR82   82
#define GNP_ERR83   83
#define GNP_ERR84   84
#define GNP_ERR85   85
#define GNP_ERR86   86
#define GNP_ERR87   87
#define GNP_ERR88   88
#define GNP_ERR89   89
#define GNP_ERR90   90
#define GNP_ERR91   91
#define GNP_ERR92   92
#define GNP_ERR93   93
#define GNP_ERR94   94
#define GNP_ERR95   95
#define GNP_ERR96   96


/*-----------------------------------------------------------------*/
#define MAXINST    1000   /* nb max d'instructions */
#define MAXVAR       20   /* nb max de variables locales */
#define MAXPARAM     20   /* nb max de constantes et appels a references */
#define MAXFLAG     100   /* nb max de flags pour les boucles (4 par boucle */
#define MAXEXEC     100   /* taille de la pile d'execution */
#define MAXTYPECHAR 127   /* taille max des variables de type char */
#define MAXVALUE    131   /* taille max des valeurs des vecteurs   */
/*-----------------------------------------------------------------*/
typedef struct  StAlpha_num
{
	  char gauche[MAXTYPECHAR];
	  char droite[MAXTYPECHAR];
	  char alpha[MAXTYPECHAR];
} TAlpha_num;
/*-----------------------------------------------------------------*/
typedef struct StEvent
{
         struct StEvent *next;
	 char param[MAXTYPECHAR];      /* nom du paiol ou du pagrp */
	 char field_ident[MAXTYPECHAR];/* numero optionnel de paiol */
	 TAlpha_num decomp;            /* dimensions du pagrp */
	 char value[MAXVALUE];         /* valeur associee au paiol oupagrp */
} TEvent;
/*-----------------------------------------------------------------*/
typedef struct StAffect
{
              char num_pattern[MAXTYPECHAR];
        struct StEvent *event;
} TAffect;
/*-----------------------------------------------------------------*/
typedef struct
{
       char *id_param[MAXPARAM];
                         /* liste des identificateurs du texte source   */
       char *group_name; /* nom de groupe utilise dans array            */
                         /* variable temporaire utilise dans array      */
       char blk;         /* valeur hexa (sur 1 octet) du nb de blancs   */
       char format;      /* type de la representation de sortie         */
       char type;        /* type de paiol (entree sotrie entree/sortie  */
       int dim;          /* largeur des vecteurs                        */
       int borne_g;      /* valeur a gauche de la declarat de la taille */
       int borne_d;      /* valeur a droite de la declarat de la taille */
       int sens;         /* precise s'il faut incrementer pour aller de */
                         /* borne_g vers borne_d                        */
} TDeclar;
/*-----------------------------------------------------------------*/
typedef struct StVarloc
{
        struct StVarloc *next;
        char *name;
        int   type;
        struct
        {
              unsigned long entier;
	      char *chaine;
        } valeur;
} TVarloc;
/*-----------------------------------------------------------------*/
typedef union StCode
        {
              unsigned long entier;
	      char *pointeur;
} TCode;
/*-----------------------------------------------------------------*/
typedef struct StProcess
        {
        struct StProcess *next;    /* chainage des process */
        char *name;                /* nom du process */
        int debcode;               /* adresse de debut du code du process */
        int nb_param;              /* nombre de parametres declares */
        int nb_arg;                /* nombre de parametres envoyes au fils */
        int sommetvarloc;
        TVarloc varloc[MAXVAR];    /* liste des variables locales chainee avec la liste des constantes */
        struct StProcess *pere;    /* environement de l'appelant */
        int instretour;            /* adresse du code de retour dans l'environement pere */
        int sommetinstr;           /* sommet de la pile de code du process */
        TCode instr[MAXINST];      /* pile de code du process */
        int cptflag;               /* compteur de flags utilises */
        int sommetflag;
        int pileflag[MAXFLAG];     /* pile des flags du process */
        int tabflag[MAXFLAG];      /* pile des flags du process */
} TProcess;













/*------------------------------------------------------------
 *      STRUCTURE PAT
 *------------------------------------------------------------*/
#define racine_pagrp  (racine_paseq->PAGRP)
#define racine_paiol  (racine_paseq->PAIOL)
#define racine_papat  (racine_paseq->PAPAT)
#define racine_pacom  (racine_paseq->PACOM)
#define racine_paevt  (racine_paseq->PAPAT->PAEVT)
#define racine_paini  (racine_paseq->PAPAT->PAINI)

extern struct  paseq  *racine_paseq;
/*------------------------------------------------------------
 *      OPTIONS DU PROGRAMME     
 *------------------------------------------------------------*/
extern short verbose;
extern short syntax;
/*------------------------------------------------------------
 *      LABEL COURANT
 *------------------------------------------------------------*/
extern char           *GNP_LABEL;
/*------------------------------------------------------------
 *      NUMERO DE LIGNE COURANTE
 *------------------------------------------------------------*/
extern int GNP_LIGNE_COURANTE;
/*------------------------------------------------------------
 *      NUMERO DE PATTERN COURANT
 *------------------------------------------------------------*/
extern int GNP_PATTERN_COURANT;
/*------------------------------------------------------------
 *      NUMERO DU DERNIER PATTERN CREE
 *------------------------------------------------------------*/
extern int GNP_PATTERN_MAX;
/*------------------------------------------------------------
 *      TABLE DES PAIOLs
 *------------------------------------------------------------*/
extern struct paiol *tab_paiol[];
extern int      GNP_PAIOL_INDEX;
extern int GNP_TAB_PAIOL_CREE;
/*------------------------------------------------------------
 *      GESTION DES PARAMETRES A NOMBRE INDETERMINE
 *------------------------------------------------------------*/
struct  alpha_num {
                   char gauche[6];
                   char droite[6];
                   char alpha[7];
                  };
extern char    *pile_param[];
extern int      sp_pile_param ;
extern int      sp_file_param ;
extern FILE    *fp;
/*-----------------------------------------------------------------*/
extern TDeclar un_port;           /* structure de donnees des port signal register array */
extern TAffect un_affect;         /* structure de donnees des affect */
extern int   sp_pile_param;
extern int   sp_file_param;

/*------------------------------------------------------------
 *      TABLE DES IDENTIFICATEURS
 *------------------------------------------------------------*/
typedef struct {
          int duplicate;
          int num_paiol;
          void * pointeur;
          } Tptab_ident;
extern Tptab_ident tab_ident[];
extern int     ind_tab_ident;

/*------------------------------------------------------------
 *      FONCTIONS DE LA LIBRAIRIE
 *------------------------------------------------------------*/
extern void              Erreur        ();
extern char             *KillEsp       ();
extern void              CheckWidth    ();
extern void              CheckIdent    ();
extern void              SplitIdent    ();
extern void              DimensionVecteur();
extern void              ChnPagrp      ();
extern void              DupPaiol      ();
extern void              ChnPaiol      ();
extern void              TraiterChaine ();
extern char             *DefileParam   ();
extern void              EmpileParam   ();
extern char             *DepileParam   ();
extern struct paevt     *FusionPaevt   ();
extern struct paini     *FusionPaini   ();
extern void              CreatePapat   ();
extern void              CreatePaiol   ();
extern void              CreatePagrp   ();
extern struct paevt     *CreatePaevt   ();
extern char              CheckSeparate ();
extern char             *FormatInOutValue ();
extern void              CheckPattern  ();
extern void              MajPatternCourant ();
extern void              MajNumeroComment ();
extern struct paini     *CreatePaini   ();
extern void              CreateTabPaiol();
extern char             *FormatInputValue ();
extern char             *FormatInputOrStarValue ();
extern char             *FormatOutputValue ();
extern void              CreerEvent    ();


extern void              CheckBlank    ();
extern void              CheckFormat   ();
extern void              CheckTypeDeclar ();
extern void              CheckEnd      ();
extern void              ClearPort     ();
extern void              FileInPort    ();
extern void              CheckNotDeclared ();
extern char             *FileOutPort   ();
extern struct papat     *AddLabel      ();
extern void              PutInArray    ();
extern void              FileInArray   ();
extern void              SaveGroupName ();
extern void              CheckInitLabel ();

extern short verbose;
extern short syntax;
