/***************************************************************/
/* module   : init.c                                           */
/* date     : 20/11/92                                         */
/* auteurs  : RENAUD & VENOT                                   */
/***************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <malloc.h>
#include <varargs.h>
#include <pat103.h>
#include "libpat_l.h"
#include "conv.h"
#include "action.h"
#include "init.h"

/*----------------------------------------------------------------*/
void Init()
{
extern TAffect un_affect;
TEvent *tmp_event;
char    *value       = " reservation de 20   reservation de 20  ";
char    param[MAXTYPECHAR];
int     dim,borne_g,borne_d,sens,i;
struct paini *tmp_paini;

    if ( GNP_TAB_PAIOL_CREE ==  GNP_INACTIF) {
       CreateTabPaiol();
       GNP_TAB_PAIOL_CREE = GNP_ACTIF;
    }
    tmp_paini = NULL;
    CheckPattern (un_affect.num_pattern);
    MajPatternCourant(un_affect.num_pattern);
    while ( un_affect.event != NULL) {
       SplitIdent (un_affect.event->param,
                   un_affect.event->field_ident);
       CheckIdent (un_affect.event->param);
       if (strlen (un_affect.event->field_ident) == 0)
          dim = 0;
       else {
          TraiterChaine (un_affect.event);
          CheckWidth (un_affect.event);
          if (strlen (un_affect.event->decomp.gauche) == 0)
             dim = 0;
          else {
             if (strlen (un_affect.event->decomp.alpha) == 0)
                dim = 1;
             else {
                borne_g = atoi(un_affect.event->decomp.gauche);
                borne_d = atoi(un_affect.event->decomp.droite);
                if (borne_g > borne_d) {
                   borne_d--;
                   sens = -1;
                   dim = borne_g - borne_d;
                }
                else {
                   borne_d ++;
                   sens = 1;
                   dim = borne_d - borne_g;
                }
             }
          }
       }
       switch (dim)
       {
         case 0: {
           value = FormatInputValue (un_affect.event->value,1,GNP_UP);
           tmp_paini = CreatePaini(tmp_paini,un_affect.event->param,*value);
           break;
         }
         case 1: {
           strcpy(param,un_affect.event->param);
           strcat(param," ");
           strcat(param,un_affect.event->decomp.gauche);
           value = FormatInputValue (un_affect.event->value,1,GNP_UP);
           tmp_paini = CreatePaini(tmp_paini,param,*value);
           break;
         }
         default: {
           value = FormatInputValue (un_affect.event->value,dim,sens);
           for (i = borne_g; i != borne_d; i = i+sens)
             {
             strcpy(param,un_affect.event->param);
             strcat(param," ");
             strcat(param,Conv(i));
             tmp_paini = CreatePaini(tmp_paini,param,*value);
             value ++;
             }
          }
       }
       tmp_event = un_affect.event;
       un_affect.event = un_affect.event->next;
       free(tmp_event);
    }

    CreatePapat (NULL,tmp_paini);
    CreateAction ("I");
    GNP_PATTERN_COURANT ++;
}
/*----------------------------------------------------------------*/

