/***************************************************************/
/* module   : HASH.C                                           */
/* date     : 20/11/92                                         */
/* auteurs  : RENAUD & VENOT                                   */
/***************************************************************/
#include<stdlib.h>
#include<stdio.h>
#include<string.h>

#include <mut309.h>
#include <pat103.h>
#include "mem.h"
#include "hash.h"
#include "libpat_l.h"


/*-------------------------------------------------------------------*/
/*      TABLES DE HACHAGE                                            */
/*-------------------------------------------------------------------*/
elt    *hash_paiol[GNP_HASHSIZE];
elt    *hash_pagrp[GNP_HASHSIZE];
elt    *hash_ident[GNP_HASHSIZE];
/*-------------------------------------------------------------------*/
int Hash(nom)
char *nom;
{
int code = 0;
char *p;
  p = nom;
  while (*p) {
     code = (code << 1) ^ *p;
     *p++;
  }
  if ( code < 0)
     code = -code;
  code %= GNP_HASHSIZE;
  return( code);
}
/*-------------------------------------------------------------------*/
void InitHash(tab)
elt *tab[];
{
int i;
  for (i=0;i< GNP_HASHSIZE ; i++)
    tab[i] = NULL ;
}
/*-------------------------------------------------------------------
 * retourne le pointeur sur la structure ELT
 * le champ name est mis a jour
 * le champs num_index n'est pas mis  a jour
 * il vaut -1
 */
/*-------------------------------------------------------------------*/
elt *SymbAlloc(ident,tab)
char *ident;
elt  *tab[] ;
{
int num_case;
elt *ptr_aux;
char *allocname;
   allocname = (char *)namealloc (ident);
   num_case = Hash(allocname);
   ptr_aux = tab[num_case];
   while (ptr_aux != NULL) {
      if ( strcmp( ptr_aux->name , allocname ) == 0 )
          return(ptr_aux);
      else
          ptr_aux = ptr_aux->next;
   }
   ptr_aux = (elt*) Allouer ( sizeof (elt) );
   ptr_aux->name = allocname;
   ptr_aux->num_index = -1;
   ptr_aux->sens = 0;
   ptr_aux->next = tab[num_case] ;
   tab[num_case] = ptr_aux ;
   return ( ptr_aux );
}
/*-------------------------------------------------------------------*/
char *LocalAlloc(ident,tab)
char *ident;
elt  *tab[] ;
{
int num_case;
elt *ptr_aux;
   num_case = Hash(ident);
   ptr_aux = tab[num_case];
   while (ptr_aux != NULL) {
      if ( strcmp( ptr_aux->name , ident ) == 0 )
          return(ptr_aux->name);
      else
          ptr_aux = ptr_aux->next;
   }
   ptr_aux = (elt*) Allouer ( sizeof (elt) );
   ptr_aux->name = Allouer (strlen (ident) +1);
   strcpy (ptr_aux->name,ident);
   ptr_aux->num_index = num_case;          /* numero d'entree dans le tableau */
   ptr_aux->sens = (tab[num_case] == NULL ? 0 : tab[num_case]->sens +1);  /* numreo de l'element dans la liste */
   ptr_aux->next = tab[num_case] ;
   tab[num_case] = ptr_aux ;
   return ( ptr_aux->name );
}
/*-------------------------------------------------------------------*/
elt *ExisteIdent(ident,tab)
char *ident;
elt  *tab[] ;
{
elt *ptr_aux;
char *allocname;
   allocname = (char *)namealloc (ident);
   for(ptr_aux = tab[Hash(allocname)];
       (ptr_aux==NULL) || ( strcmp( ptr_aux->name , allocname ) != 0 );
       ptr_aux = ptr_aux->next
       );
   if ( ptr_aux == NULL) {
       Erreur (GNP_ERR82,"identifier not found\n");
   }
   return (ptr_aux);
}
/*-------------------------------------------------------------------
 * retourne soit -1 si le nom n'existe pas
 *          soit le champ num_index si le nom est trouve dans la table
 */
int FindIdent(ident,tab)
char *ident;
elt  *tab[] ;
{
int num_case;
elt *ptr_aux;
char *allocname;
   allocname = (char *)namealloc (ident);
    num_case = Hash(allocname);
    ptr_aux = tab[num_case] ;
    while (ptr_aux != NULL) {
      if ( strcmp( ptr_aux->name , allocname ) == 0 ) {
          return (ptr_aux->num_index);
       }
       else {
          ptr_aux = ptr_aux->next;
       }
    }
    return(-1);
}
/*-------------------------------------------------------------------*/
void FreeHash(tab)
elt *tab[] ;
{
int i;
  elt *ptr_aux ;
  for (i=0;i< GNP_HASHSIZE ; i++)  {
    while ( tab[i] != NULL )         {
      ptr_aux = tab[i]->next ;
      Liberer(tab[i]);
      tab[i] = ptr_aux;
    }
  }
}

