/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : libere.c                                                    */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "ariel.h"

/**********************************************/
/*   Libere les flags de la sortie du cone    */
/*     cone                                   */
/**********************************************/
void DelAllOutput(cone)
cone_list *cone;
{
list_list *out;

for (out=cone->OUTCONE; out; out=out->NEXT)
    {
    if ((getptype(out->USER,OUTPUT_MARK)) == NULL) continue;
    else out->USER=delptype(out->USER,OUTPUT_MARK);
    }

}

/**********************************************/
/*   Libere le flag de la sortie du cone      */
/*     dest_cone pointant sur source_cone     */
/**********************************************/
void DelOutput(source_cone, dest_cone)
cone_list *source_cone, *dest_cone;
{
list_list *out;

out=dest_cone->OUTCONE;
while ( ((cone_list*)out->DATA) != source_cone ) out=out->NEXT;

if ((getptype(out->USER,OUTPUT_MARK)) != NULL)
   out->USER=delptype(out->USER,OUTPUT_MARK);
}

/***************************************/
/**   Detruit le ptype_list PROF du   **/
/**     champ USER de cone            **/
/***************************************/
void DelProf(cone)
cone_list *cone;
{
  
if ((getptype(cone->USER,PROF)) != NULL)
   cone->USER=delptype(cone->USER,PROF);
   
}

/***************************************************/
/*   Libere le Marquage du cone "cone"             */
/*  + tag eventuel suivant la profondeur PROF_MAX  */
/***************************************************/
short PropStepDelOutput(cone)
cone_list *cone;
{
list_list    *input;
locon_list   *userconx;
ptype_list   *user;
short         prof;


if ((user=getptype(cone->USER,PROF)) != NULL) prof=(short)user->DATA;
else prof=PROF_MAX;

if (((prof < PROF_MAX) && ((cone->TYPE & LATCH) != LATCH) && ((cone->TYPE & HZ) != HZ) &&
    ((cone->TYPE & CONFLICT) != CONFLICT)) ||
    (prof==0)) 
   { 

   for (input=(list_list*)cone->INCONE; input; input=input->NEXT) 

       { 
       if ((input->TYPE & LOOP) == LOOP) continue;
       if ((input->TYPE & EXT) != EXT) 
          {
          (void)PropStepDelOutput((cone_list*)input->DATA);
          continue;
             
          }

       else 
          {
          userconx=(locon_list*)input->DATA;
          if ((getptype(userconx->USER,OUTPUT_MARK)) != NULL)
             userconx->USER=delptype(userconx->USER,OUTPUT_MARK);
          if ((user=getptype(userconx->USER,DSB_CONTRAINT)) != NULL) 
             user->DATA = (void*)0; 
          if ((getptype(userconx->USER,BDD_INDEX)) != NULL)
             userconx->USER=delptype(userconx->USER,BDD_INDEX);
          }
       }
       
       DelAllOutput(cone);
       DelProf(cone);
       return(1);
    }	

else 
   {
   DelAllOutput(cone);
   return(1);
   }
}

/**************************************/
/** Libere la fonctionnalite du cone **/ 
/**************************************/
void DelFonc(cone)
cone_list *cone;
{

 if ((getptype(cone->USER,FONC_UP)) != NULL)
    cone->USER=delptype(cone->USER,FONC_UP);

 if ((getptype(cone->USER,FONC_DW)) != NULL)
    cone->USER=delptype(cone->USER,FONC_DW);

}

/**************************************/
/** Detruit l'index bdd associe aux  **/
/** Input non marquees de cone       **/
/**************************************/
void DelBddIndex(cone)
cone_list *cone;
{
cone_list *in_cone;
locon_list *conect;
list_list *in;

for (in=cone->INCONE; in; in=in->NEXT)
    {
    if ((in->TYPE & LOOP) == LOOP) continue;
    if ((getptype(in->USER,INPUT_MARK)) == NULL)
       {
       if ((in->TYPE & EXT) == EXT)
          {
          conect=(locon_list*)in->DATA;
          if ((getptype(conect->USER,BDD_INDEX)) != NULL) 
             {
             conect->USER=delptype(conect->USER,BDD_INDEX);
             index_bdd--;
             }
          }
        else
          {
          in_cone=(cone_list*)in->DATA;
          if ((getptype(in_cone->USER,BDD_INDEX)) != NULL)
             {
             in_cone->USER=delptype(in_cone->USER,BDD_INDEX);
             index_bdd--;
             }
          }
        }
      }
}

/**************************************/
/** Detruit le marquage de tous      **/ 
/**     les inputs de  cone          **/
/**************************************/
void DelAllInput(cone)
cone_list *cone;
{
list_list *list_in;

for (list_in=cone->INCONE; list_in; list_in=list_in->NEXT) 
    {
    if (((list_in->TYPE) & EXT) == EXT) continue;

    if ((getptype(list_in->USER,INPUT_MARK)) != NULL)
       list_in->USER=delptype(list_in->USER,INPUT_MARK);
    }
}

/**************************************/
/** Detruit le marquage de l input du */
/** cone source, dependant de dest   **/ 
/**************************************/
void DelInput(source, dest)
cone_list *source, *dest;
{
list_list *list_in;

for (list_in=source->INCONE; list_in; list_in=list_in->NEXT) 
    {

    if (((list_in->TYPE) & EXT) == EXT) continue;
    if (((cone_list*)list_in->DATA) == dest)
       if ((getptype(list_in->USER,INPUT_MARK)) != NULL)
          list_in->USER=delptype(list_in->USER,INPUT_MARK);

    }
}

/*********************/
/**  destroy Algo.  **/
/*********************/
short DestroyStep(cone)
cone_list *cone;
{
list_list *input;
locon_list *cnx;
ptype_list *user;
short result, prof;

if ((user=getptype(cone->USER,PROF)) != NULL) prof=(short)user->DATA;
else prof=PROF_MAX;

if (prof < PROF_MAX) {

       if ((prof>=1) && (((cone->TYPE & CONFLICT) == CONFLICT) || ((cone->TYPE & HZ) != HZ) ||
           ((cone->TYPE & LATCH) == LATCH)))
          {
          if (CountOutputMark(cone) >= 2)
             {
             cone->USER=delptype(cone->USER,BDD_INDEX);
             index_bdd--;
             }
          return(2);
          }

   for (input=(list_list*)cone->INCONE; input; input=input->NEXT) 
       {

       if (((input->TYPE) & LOOP) == LOOP) continue;
  
       if ((getptype(input->USER,INPUT_MARK)) == NULL) continue;

       if (((input->TYPE) & EXT) != EXT )  
          {
          result=DestroyStep((cone_list*)input->DATA);
	  if (result == 1) continue;
          if (result == 0) 
             { 
             DelBddIndex((cone_list*)input->DATA);
             DelFonc((cone_list*)input->DATA);
             DelAllInput((cone_list*)input->DATA);
             }
	  }
       else
          {
          cnx=(locon_list*)input->DATA;
          if ((user=getptype(cnx->USER,OUTPUT_MARK)) != NULL)
             if ((short)user->DATA >= 2)  
                {
                cnx->USER=delptype(cnx->USER,BDD_INDEX); 
                input->USER=delptype(input->USER,INPUT_MARK);
                DelFonc(cone);
                }
          }
         
       }
 
   if (prof == 0) 
      { 
      DelBddIndex(cone);
      DelAllInput(cone);
      return(1);
      }

   if (CountOutputMark(cone) >= 2) 
      {

      if ((CountInputMark(cone) == 0) && (FindConectPrim(cone) != PRIM))
         {
         if ((getptype(cone->USER,BDD_INDEX)) != NULL)
            {
            cone->USER=delptype(cone->USER,BDD_INDEX);
            index_bdd--;
            }
	 return(2);
	 }
      return(0);
      }

   else 
      {
      if (CountInputMark(cone) > 0 ) 
         {
         return(0);
	 }

      else 
         {
         if (FindConectPrim(cone) == PRIM) 
            {
             DelBddIndex(cone);
             DelFonc(cone);
             return(2);
             }
          else 
             {
	     return(1);
             }
          }
       }

   }

else 
   {
   if (CountOutputMark(cone) >= 2)
      {
      if ((getptype(cone->USER,BDD_INDEX)) != NULL)
         {
         cone->USER=delptype(cone->USER,BDD_INDEX);
         index_bdd--;
         }
      return(2);
      }
   else
      {
      if (FindConectPrim(cone) == PRIM) 
         {
         DelBddIndex(cone);
         DelFonc(cone);
         return(2);
         }
      else 
         {
         return(1);
         }
      }
   }

}
	

