/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : fcfutil.c                                                   */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "ariel.h"


/****************************************************************************
 *                         fonction next_conflit();                         *
 ****************************************************************************/
            /*---------------------------------------+
            |  Renvoi le cone conflictuel suivant    | 
            |   de la liste de cones.                |
            +---------------------------------------*/
cone_list *next_conflit(cone)
cone_list *cone;
{
cone_list *ptr;

for(ptr=cone->NEXT; ptr; ptr=ptr->NEXT) 
{

if (((ptr->TYPE & CONFLICT) == CONFLICT) || ((ptr->TYPE & HZ) == HZ))
   return(ptr);
}
 return(NULL);
} 

/****************************************************************************
 *                         fonction CleanAllCone();                         *
 ****************************************************************************/
void CleanAllCone()
{
cone_list * cone = NULL;
   for(cone=HEAD_DESBFIG->CONE; cone != NULL; cone=cone->NEXT)
   {
   list_list * incone;
   list_list * outcone;
      /*--------------------------------------------------*
       | On nettoie les incones                           |
       *--------------------------------------------------*/
       for(incone=cone->INCONE;incone!=NULL;incone=incone->NEXT)
       {
          if(getptype(incone->USER,INPUT_MARK)!=NULL)
          incone->USER=delptype(incone->USER,INPUT_MARK);
       }

      /*--------------------------------------------------*
       | On nettoie les outcones                          |
       *--------------------------------------------------*/
       for(outcone=cone->OUTCONE;outcone!= NULL ; outcone=outcone->NEXT)
       {
          if(getptype(outcone->USER,OUTPUT_MARK)!=NULL)
          outcone->USER=delptype(outcone->USER,OUTPUT_MARK);
       }

      /*--------------------------------------------------*
       | On nettoie le USER PROF                          |
       *--------------------------------------------------*/
       if(getptype(cone->USER,PROF)!=NULL)
          cone->USER=delptype(cone->USER,PROF);

      /*--------------------------------------------------*
       | On nettoie le USER BDD_INDEX                     |
       *--------------------------------------------------*/
       if(getptype(cone->USER,BDD_INDEX)!=NULL)
          cone->USER=delptype(cone->USER,BDD_INDEX);

      /*--------------------------------------------------*
       | On nettoie le USER FONC_UP                       |
       *--------------------------------------------------*/
       if(getptype(cone->USER,FONC_UP)!=NULL)
          cone->USER=delptype(cone->USER,FONC_UP);

      /*--------------------------------------------------*
       | On nettoie le USER FONC_DW                       |
       *--------------------------------------------------*/
       if(getptype(cone->USER,FONC_DW)!=NULL)
          cone->USER=delptype(cone->USER,FONC_DW);

      /*--------------------------------------------------*
       | On nettoie le USER ABL_UP                        |
       *--------------------------------------------------*/
       if(getptype(cone->USER,ABL_UP)!=NULL)
          cone->USER=delptype(cone->USER,ABL_UP);
   }
}

/****************************************************************************
 *                         fonction CleanAllConect();                       *
 ****************************************************************************/
void CleanAllConect()
{
locon_list *conect;

   for (conect=HEAD_DESBFIG->LOCON; conect != NULL ; conect=conect->NEXT)
   {
   ptype_list * user ;
      /*--------------------------------------------------*
       | On nettoie le USER OUTPUT_MARK                   |
       *--------------------------------------------------*/
      if(getptype(conect->USER,OUTPUT_MARK) != NULL)
      conect->USER=delptype(conect->USER,OUTPUT_MARK);
 
      /*--------------------------------------------------*
       | On nettoie le USER BDD_INDEX                     |
       *--------------------------------------------------*/
      if(getptype(conect->USER,BDD_INDEX) != NULL )
      conect->USER=delptype(conect->USER,BDD_INDEX);
 
      /*--------------------------------------------------*
       | On nettoie le USER DESB_CONTRAINT                |
       *--------------------------------------------------*/
      if((user=getptype(conect->USER,DSB_CONTRAINT)) != NULL )
      user->DATA=(void*) 0 ;
   }
}


/****************************************************************************
 *                         fonction CleanPath();                            *
 ****************************************************************************/
void CleanPath(cone)
cone_list * cone ;
{
list_list * path;
   for(path=cone->PATH; path != NULL ; path=path->NEXT)
   {
      if(getptype(path->USER,BDD_PTR) != NULL ) path->USER = delptype(path->USER,BDD_INDEX);
      if(getptype(path->USER,PATH_NAME)!=NULL)  path->USER = delptype(path->USER,PATH_NAME);
   }
}

/****************************************************************************
 *                         fonction InitializePath();                       *
 ****************************************************************************/
void InitializePath(cone)
cone_list * cone ;
{
list_list * path;
   for (path=cone->PATH ; path!=NULL ; path=path->NEXT )
   {
      if(getptype(path->USER,PATH_NAME)!=NULL)
      path->USER=delptype(path->USER,PATH_NAME);

      if(getptype(path->USER,BDD_PTR)!=NULL)
      path->USER=delptype(path->USER,BDD_PTR);

   path->USER = (ptype_list *)NULL ;
   }
}


/****************************************************************************
 *                         fonction fcfMakeSign();                          *
 ****************************************************************************/
/*--------------------------------------------------------------------------+
| Entree: + indexList, la liste des index de cones primaires                |
| Sortie: + un char *, les index concatenes dans une chaine de caracteres   |
|           unique, namallocee                                              |
+--------------------------------------------------------------------------*/
char * fcfMakeSign(pointrList)
chain_list * pointrList ;
{
int nbIndex=0;
chain_list * chain ;
char  buff[10000];

strcpy(buff,"SigCone->");

   if(pointrList==NULL)return(NULL);

   for(chain=pointrList;chain!=NULL;chain=chain->NEXT)
   {
   strcat(buff,fcfItoa((long)chain->DATA));
   strcat(buff,"-");
      if(strlen(buff)>9990)
      {
      fprintf(stderr,"[ERR] fcfMakeSign() buff overflow\n");
      fflush(stdout);
      exit(-1);
      }
   }
return(namealloc(buff)) ;
}

/****************************************************************************
 *                         fonction fcfItoa();                              *
 ****************************************************************************/
char * fcfItoa(entier)
long entier ;
{
char * res ;
char buff[20];

sprintf(buff,"%ld",entier);
res=(char*)mbkalloc(strlen(buff)+1);
strcpy(res,buff);
return(res);
}
   

/****************************************************************************
 *                         fonction fcfAddPrimCone();                      *
 ****************************************************************************/
void fcfAddPrimCone(cone)
cone_list * cone ;
{
chain_list * chain ;
chain_list * prevChain ;
long         chainIndex ;

   if(FCF_PRIM_INDEX == NULL)
   {
   FCF_PRIM_INDEX=addchain(FCF_PRIM_INDEX,(void*)cone);
   return ;
   }

prevChain=FCF_PRIM_INDEX ;

   for(chain=FCF_PRIM_INDEX;chain!=NULL;chain=chain->NEXT)
   {
   chainIndex=(long)chain->DATA ;

      if((long)cone == chainIndex) return;

      else if((long)cone < chainIndex)
      {
         if(chain==FCF_PRIM_INDEX)
         {
         FCF_PRIM_INDEX=addchain(FCF_PRIM_INDEX,(void*)cone);
         return ;
         }
         else
         {
         chain_list * buff=NULL ;
         buff = addchain(buff,(void*)cone);
         prevChain->NEXT=buff;
         buff->NEXT=chain;
         return;
         }
      }

      else /* cone->INDEX > chainIndex  */
      {
         if (chain->NEXT!=NULL)
         {
         prevChain=chain ;
         continue ;
         }
         else
         {
         chain_list * buff=NULL ; 
         buff = addchain(buff,(void*)cone); 
         chain->NEXT=buff; 
         buff->NEXT=NULL;   
         return;  
         }
      }
   }
}

/****************************************************************************
 *                         fonction fcfAddPrimConect();                     *
 ****************************************************************************/
void fcfAddPrimConect(conect)
locon_list * conect ;
{
chain_list * chain ;
chain_list * prevChain ;
long         chainIndex ;

   if(FCF_PRIM_INDEX == NULL)
   {
   FCF_PRIM_INDEX=addchain(FCF_PRIM_INDEX,(void*)conect);
   return ;
   }

prevChain=FCF_PRIM_INDEX ;

   for(chain=FCF_PRIM_INDEX;chain!=NULL;chain=chain->NEXT)
   {
   chainIndex=(long)chain->DATA ;

      if((long)conect == chainIndex) return;

      else if((long)conect < chainIndex)
      {
         if(chain==FCF_PRIM_INDEX)
         {
         FCF_PRIM_INDEX=addchain(FCF_PRIM_INDEX,(void*)conect);
         return ;
         }
         else
         {
         chain_list * buff=NULL ;
         buff = addchain(buff,(void*)conect);
         prevChain->NEXT=buff;
         buff->NEXT=chain;
         return;
         }
      }

      else /* cone->INDEX > chainIndex  */
      {
         if (chain->NEXT!=NULL)
         {
         prevChain=chain ;
         continue ;
         }
         else
         {
         chain_list * buff=NULL ; 
         buff = addchain(buff,(void*)conect); 
         chain->NEXT=buff; 
         buff->NEXT=NULL;   
         return;  
         }
      }
   }
}

/****************************************************************************
 *                         fonction fcfPathInCone();                        *
 ****************************************************************************/
/*-------------------------------------------------------------------------+
|  Retourne -1 si le cone n'a pas de branche , ou pas de branche           |
|              fonctionelle.                                               |
|            0 si il existe au moins une branche non typee BLEEDER         |
+-------------------------------------------------------------------------*/
short fcfPathInCone(cone)
cone_list * cone ;
{
list_list * path ;

   if(cone->PATH==NULL) return(-1);

   for(path=cone->PATH;path != NULL; path=path->NEXT)
   {
      if((path->TYPE & BLEEDER)!=BLEEDER) return(0);
   }
return(-1);
}
/****************************************************************************
 *                         fonction fcfConeConect();                        *
 ****************************************************************************/
/*-------------------------------------------------------------------------+
| Retourne 0 si le cone est un cone connecteur ie il possede une branche  |
|            fonctionnelle unique qui est la branche maillon connecteur   |
|          -1 si le cone possede au moins une branche fonctionnele qui    |
|             n'est pas externe.                                          |
+-------------------------------------------------------------------------*/
short fcfConeConect(cone)
cone_list *cone;
{
list_list * path ;
short coneconect=0;
short funcPath=0;

   if((cone->TYPE & EXT)!=EXT) return(-1);

   for(path=cone->PATH;path != NULL;path=path->NEXT)
   {
      if((path->TYPE & BLEEDER)==BLEEDER) continue ;

      if((path->TYPE & EXT)==EXT)
      {
         if(((link_list*)path->DATA)->NEXT==NULL)
         {
         coneconect++;
         }
         else funcPath++;
      }
      else funcPath++;
   }

   if(funcPath!=0) return(-1);
   else if(coneconect==1) return(0);
}
  
    

