

#undef IN
#undef INOUT
#undef OUT

#define INF_JOK '*'

#define _BITS_(type)	(8*(int)sizeof(type))
#define _HIL_		(1L<<_BITS_(long)-1)
#define LONG_MAX	(~_HIL_)
#define LONG_MIN	(_HIL_)

#define DUALREBOUCLELATCH 4
#define DUALREBOUCLEBLEED 5
 
#define PRIM           ((long) 0x00000001 ) 
#define TAG            ((long) 0x00000001 ) 

/* type des maillons et des transistors                      */
/*      MAILLONS                              symbole driver */
#define IN             ((long) 0x00000001 )   /*        I       */
#define INOUT          ((long) 0x00000002 )   /*        X       */
#define SWITCH         ((long) 0x00000100 )   /*        S       */
     /* maillons et transistors               symbole driver */
#define TN             ((long) 0x00000004 )   /*        N       */
#define TP             ((long) 0x00000008 )   /*        P       */
#define CAPACITE       ((long) 0x00000010 )   /*        C       */
#define DIODE          ((long) 0x00000020 )   /*        D       */ 
#define RESIST         ((long) 0x00000040 )   /*        R       */
#define PRECHARGE      ((long) 0x00000080 )   /*        p       */
#define USED           ((long) 0x00000001 )   /*  inutile       */
#define IN_CH_BL       ((long) 0x00000002 )   /*  inutile       */
/* type des chemins                                          */
                                           /* symbole driver */
#define VDD            ((long) 0x00000001 )   /*        U       */
#define VSS            ((long) 0x00000002 )   /*        D       */
#define EXT            ((long) 0x00000004 )   /*        E       */
#define TNINVDD        ((long) 0x00000008 )   /*        G       */
#define TPINVSS        ((long) 0x00000010 )   /*        g       */
#define BLEEDER        ((long) 0x00000020 )   /*        B       */
#define CR             ((long) 0x00000080 )   /*        c       */ 
#define CONFLICT       ((long) 0x00000200 )   /*        C       */

/* type des cones                                            */
                                           /* symbole driver */ 
#define VDD            ((long) 0x00000001 )   /*        U       */
#define VSS            ((long) 0x00000002 )   /*        D       */
#define EXT            ((long) 0x00000004 )   /*        E       */
#define TNINVDD        ((long) 0x00000008 )   /*        G       */
#define TPINVSS        ((long) 0x00000010 )   /*        g       */
#define BLEEDER        ((long) 0x00000020 )   /*        B       */
#define PATH_PARA      ((long) 0x00000040 )   /*        P       */
#define PRECHARGE      ((long) 0x00000080 )   /*        p       */
#define SWITCH         ((long) 0x00000100 )   /*        S       */
#define CONFLICT       ((long) 0x00000200 )   /*        C       */
#define HZ             ((long) 0x00000400 )   /*        H       */
#define DUAL           ((long) 0x00000800 )   /*        d       */
#define LATCH          ((long) 0x00001000 )   /*        L       */
#define MEMORY         ((long) 0x00002000 )   /*        M       */
#define AUTRE          ((long) 0x00004000 )   /*        A       */
#define INTERM         ((long) 0x00008000 )   /*                */
#define MAST           ((long) 0x00010000 )   /*        m       */
#define SLAVE          ((long) 0x00020000 )   /*        s       */
#define INUTIL         ((long) 0x00040000 )   /*        s       */
#define MARK           ((long) 0x80000000 )  
#define UNMARK         ((long) 0x7FFFFFFF )  

/* pour les champs INCONE et OUTCONE                         */
                                           /* symbole driver */
#define VDD            ((long) 0x00000001 )   /*        U       */
#define VSS            ((long) 0x00000002 )   /*        D       */
#define EXT            ((long) 0x00000004 )   /*        E       */
#define CONE_TYPE      ((long) 0x00000008 )   /*        C       */
#define LOOP           ((long) 0x00000010 )   /*        L       */
#define COMMAND        ((long) 0x00000020 )   /*        c       */
#define OUTPUT_MARK    ((long) 0x00000100 )
#define INPUT_MARK     ((long) 0x00000200 )
#define DSB_POIDS      ((long) 101192 )

/* pour le champ USER des cones                              */
                                           /*  significatifs */
#define EXT            ((long) 0x00000004 )   /*        E       */
#define BLEEDER        ((long) 0x00000020 )   /*        B       */
#define PATH_PARA      ((long) 0x00000040 )   /*        P       */
#define SWITCH         ((long) 0x00000100 )   /*        S       */
#define CONFLICT       ((long) 0x00000200 )   /*        C       */
#define MEMORY         ((long) 0x00002000 )   /*        M       */
#define MAST           ((long) 0x00010000 )   /*        m       */
#define SLAVE          ((long) 0x00020000 )   /*        s       */
#define PROF           ((long) 0x00080000 )
#define ABL_UP         ((long) 0x00100000 )
#define ABL_DN         ((long) 0x00200000 )
#define FCF_SIGN       ((long) 0x00400000 )
#define DSB_POIDS      ((long) 101192 )
#define DSB_MODEL      ((long) 111192 )
#define BDD_INDEX      ((long) 121192 )
#define FONC_UP        ((long) 131192 )
#define FONC_DW        ((long) 141192 )
#define OLDNAME        ((long) 171192 )
#define OLDINDEX       ((long) 141292 )
#define SAV_PATH       ((long) 151292 )


/* pour le champs USER des path                              */

#define BDD_PTR        ((long) 0x00000001 )
#define BDD_PTR_HZ     ((long) 0x00000002 )
#define ABL_PTR        ((long) 0x00000004 )
#define ABL_PTR_HZ     ((long) 0x00000008 )
#define PATH_NAME      ((long) 0x00000010 )
#define PATH_NAME_HZ   ((long) 0x00000020 )
#define DSB_POIDS      ((long) 101192 )

/* pour le champ USER des connecteurs                        */
                                           /* symboles non   */
                                           /*  significatifs */
#define DSB_CONTRAINT  ((long) 0x00000001 )
#define CAPA_TSP       ((long) 0x00000002 )
#define EXT            ((long) 0x00000004 )   /*        E       */
#define CONE_TYPE      ((long) 0x00000008 )   /*        C       */
#define DSB_MBK_SIG    ((long) 0x00000010 )   /*        C       */

/* pour le champs USER des signaux                           */

#define DSB_VAL_S   (long) 290692  /* de la date de creation */ 
#define DSB_VAL_L   (long) 300692  /* de la date de creation */


typedef struct lotrs trans_list ;       /* structure transistor               */

typedef struct link                     /* structure maillon                  */
        {
        struct link     *NEXT  ;        /* next link                          */
        trans_list      *TRANS ;        /* pointer on transistor              */
                                        /*         or connector or chain      */
        float            CAPA  ;        /* CTOT  (on the output side)         */
        long             TYPE  ;        /* link type: IN, INOUT, TN, TP,      */
                                        /*            CAPACITE, DIODE, RESIST,*/
                                        /*            PRECHARGE, SWITCH       */
        struct ptype    *USER  ;        /* application specific               */
        }
link_list;

typedef struct cone                     /* structure cone                     */
        {
        struct cone     *NEXT    ;      /* next cone                          */
        struct list     *PATH    ;      /* path list head                     */
        struct list     *INCONE  ;      /* list of input cones                */
        struct list     *OUTCONE ;      /* list of cones this one drives      */
        long             INDEX   ;      /* cone index (unique)                */
        char            *NAME    ;      /* most significant signal name       */
        long             X1,Y1,X2,Y2;   /* cone box coordinates               */
        long             TYPE    ;      /* cone type: VDD, VSS, EXT, TPINVDD, */
                                        /*            TPINVSS, BLEEDER,       */
                                        /*            PATH_PARA, PRECHARGE,   */
                                        /*            SWITCH, CONFLICT, HZ,   */
                                        /*            DUAL, LATCH, FLIPFLOP   */
        struct ptype    *USER    ;      /* application specific               */
        }
cone_list;

typedef struct desafig                  /* structure figure desa              */
        {
        struct  desafig *NEXT  ;        /* next desa figure                   */
        struct  cone    *CONE  ;        /* cone list head                     */
        trans_list      *TRANS ;        /* transistor list head               */
        struct  locon   *LOCON ;        /* connector list head                */
        chain_list      *REG   ;        /* register list head                 */
        char            *NAME  ;        /* desa figure name                   */
        struct ptype    *USER  ;        /* application specific               */
        }
desafig_list ;

typedef struct list                     /* structure liste                    */
        {
        struct list     *NEXT ;         /* next pointer                       */
        long             TYPE ;         /* type of the considered element     */
                                        /*  used in desa for input or         */
                                        /*   output cone type                 */
        char            *DATA ;         /* character pointer                  */
        struct ptype    *USER ;         /* application specific               */
        }
list_list;
