/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : desb.c                                                      */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "declar.h"

struct desafig    *HEAD_DESBFIG	= NULL ;   /**** DESB figure list head ****/

char	*NAME_DRAIN  = NULL ;
char	*NAME_GRID   = NULL ;
char    *NAME_SOURCE = NULL ;
char	*NAME_X      = NULL ;
char    *NAME_Y      = NULL ;
char    *NAME_WIDTH  = NULL ;
char	*NAME_LENGTH = NULL ;
char    *NAME_VDD    = NULL ;
char	*NAME_VSS    = NULL ;
char    *DSB_VHDSFX  = NULL ;
int      DSB_SCALE_X ;

int   	DESB_STAT_MODE = 0   ;
int   	DESB_TRACE_MODE = 0   ;
int     DESB_MAIL_MAX   =0   ;
char    DESB_LANG='F';

FILE * DESB_ERR_FILE;
FILE * DESB_WAR_FILE;
FILE * DESB_STAT_FILE;
long   DESB_NB_ERR ;                /* Nombre d'erreur au cours de DESB */
char * DESB_VERSION;
char * DATE_VERSION;

/*--------------------------------------------------------+
|      MODE UNIVERSITE                                    |
+--------------------------------------------------------*/
#ifdef PARIS6
short  DSB_HELP_S = 0 ;            /* on n'utilise pas test_s par defaut */
short  DSB_USE_FCF = 1 ;           /* on n'utilise  FCF par defaut */
short  DSB_VBE     =1  ;           /* On  genere  les equation vhdl */
short  DSB_VECTORISE =0;           /* on ne vectorise pas les equations*/
short  DSB_SUPPLY = 1 ;            /* Tous les vdd et vss        */
short DSB_DEB = 1;                 /* On genere le fichier .deb  */
short DSB_INF = 0 ;                /* On ne lit pas le fichier inf */
short DSB_HIERAR = 0 ;             /* On ne genere pas de netlist */
short DSB_SIG_ALIM = 0 ;
#endif PARIS6

/*--------------------------------------------------------+
|      MODE DISTRIBUTION                                  |
+--------------------------------------------------------*/
#ifdef DISTRIB
short  DSB_HELP_S = 0 ;            /* on n'utilise pas test_s par defaut */
short  DSB_USE_FCF = 1 ;            /* on n'utilise  FCF par defaut */
short  DSB_VBE     =1  ;           /* On  genere  les equation vhdl */
short  DSB_VECTORISE =0;           /* on ne vectorise pas les equations*/
short  DSB_SUPPLY = 1 ;            /* Tous les vdd et vss        */
short  DSB_DEB = 0;                /* On ne genere pas le fichier .deb  */
short  DSB_INF = 0 ;                /* On ne lit pas le fichier inf */
short  DSB_SIG_ALIM = 0 ;
short  DSB_HIERAR = 0 ;             /* On ne genere pas de netlist */
#endif DISTRIB

/*--------------------------------------------------------+
|      MODE BULL                                          |
+--------------------------------------------------------*/
#ifdef BULL
short  DSB_HELP_S = 1 ;            /* on utilise  test_s par defaut */
short  DSB_USE_FCF = 0 ;           /* on n'utilise pas FCF par defaut */
short  DSB_VBE     =0  ;           /* On ne genere pas les equation vhdl */
short  DSB_VECTORISE =0;
short  DSB_SUPPLY = 1 ;            /* Tous les vdd et vss        */
short DSB_DEB = 1;                 /* On genere le fichier .deb  */
short DSB_INF = 0 ;                /* On ne lit pas le fichier inf */
short DSB_SIG_ALIM = 0 ;
short DSB_HIERAR = 0 ;             /* On ne genere pas de netlist */
#endif BULL

short  DSB_PROF = 5 ;                /* prof par defaut pour fcf          */
chain_list * DESB_RECAP_ERR = NULL ;

long MaxNoeud ;


char  DSB_FIGNAME[100] ;
char  VBE_NAME[100] ;
/****************************************************************************
 *                         fonction desb();                                 *
 ****************************************************************************/

                   /**** creation d'une figure DESB ****/

desafig_list	*desb(figname, pt_mbkfig )
char * figname ;
lofig_list *pt_mbkfig;
{
desafig_list	*pt_desafig = NULL ;
locon_list		*pt_con 	= NULL ;
cone_list		*pt_cone 	= NULL ;
trans_list		*pt_trans 	= NULL ;
long 			start 		= 0 ;
long 			end  	 	= 0 ;
long 			counter  	= 1 ;



/*------------------------------------------*
|  Ouverture eventuelle du fichier .stat   |
*------------------------------------------*/
   if (DESB_STAT_MODE==8)
   {
   DESB_STAT_FILE=mbkfopen(figname,"stat",WRITE_TEXT);
      if(DESB_STAT_FILE==NULL)
      {
      char buff[80];
      sprintf(buff,"%s.stat",figname);
      dsbFatalError(7,"desb",buff,0);
      }
   fprintf(DESB_STAT_FILE, "(DESB V%s %s.stat %s",DESB_VERSION,figname, getenv("USER"));
   fprintf(DESB_STAT_FILE, " %s\n", ctime(&counter));
   }


/*--------------------------------*
|  Ouverture  du fichier .err    |
*--------------------------------*/
DESB_ERR_FILE=mbkfopen(figname,"dsbr",WRITE_TEXT);
      if(DESB_ERR_FILE==NULL)
      {
      char buff[80];
      sprintf(buff,"%s.dsbr",figname);
      dsbFatalError(7,"desb",buff,0);
      }
fprintf(DESB_ERR_FILE, "(DESB V%s %s.dsbr %s",DESB_VERSION, figname, getenv("USER"));
fprintf(DESB_ERR_FILE, " %s\n", ctime(&counter));


/*----------------------------------------------------------------------------*
 |mise a plat de la figure  eventuelle                                        |
 *----------------------------------------------------------------------------*/
   if ( pt_mbkfig->LOINS != NULL )
   {
   ( void )time( &start ) ;
   dsbMessage(2,NULL);

      while ( pt_mbkfig->LOINS != NULL )
      {
      flattenlofig( pt_mbkfig , pt_mbkfig->LOINS->INSNAME , 'Y' ) ;
      }

   time( &end ) ;
   end -= start ;
   /* printf( "%02d:%02d \n" , end/60 , end%60 ) ;*/
   }

/*-----------------------------------------------------+
| On fait un reverse pour avoir le meme ordre dans le  |
| fichier fonctionnel                                  |
+-----------------------------------------------------*/
pt_mbkfig->LOCON=(locon_list*)reverse((chain_list*)pt_mbkfig->LOCON);

/*----------------------------------------------------------------------------*
 | Chainage des signaux et des connecteurs                                    |
 *----------------------------------------------------------------------------*/
( void )time( &start ) ;
lofigchain( pt_mbkfig ) ;
( void )time( &end ) ;
end -= start ;
fflush(stdout);

/*----------------------------------------------------------------------------+
 | Prise en compte des noms "_S" du fichier INFO                              |
 +---------------------------------------------------------------------------*/
   if((DSB_HELP_S != 0)&&(INF_HELP_S != NULL))
   {
   time( &start ) ;
   getHelps(pt_mbkfig);
   time( &end ) ;
   end -= start ;
   }

/*----------------------------------------------------------------------------+
 | on ajoute la valeur des _s indices dans le USER de chaque signal           |
 +---------------------------------------------------------------------------*/
   if(DSB_HELP_S != 0)
   {
   addVal_s(pt_mbkfig);
#ifdef PHASE2
   addVal_l(pt_mbkfig) ;
#endif PHASE2
   }
/*----------------------------------------------------------------------------*
 | Allocation de memoire et remplissage des champs                            |
 *----------------------------------------------------------------------------*/
dsbInitMem();
pt_desafig       = ( desafig_list * )mbkalloc( sizeof( desafig_list ) ) ;
pt_desafig->NEXT = HEAD_DESBFIG ;
HEAD_DESBFIG     = pt_desafig ;

pt_desafig->NAME 	= pt_mbkfig->NAME ;
pt_desafig->LOCON 	= pt_mbkfig->LOCON ;
pt_desafig->REG 	= NULL ;
   for (pt_con=pt_desafig->LOCON;pt_con != NULL;pt_con=pt_con->NEXT)
   {
   pt_con->ROOT = ( void* )pt_desafig ;
   pt_con->USER = NULL ;
   pt_con->USER = addptype( pt_con->USER ,CONE_TYPE , (void*)NULL);
   pt_con->USER = addptype( pt_con->USER ,EXT ,(void*)NULL);
   }

/*----------------------------------------------------------------------------*
 | Marquage des signaux d'alimentations                                       |
 *----------------------------------------------------------------------------*/
time( &start ) ;
fflush(stdout);
get_alim( pt_mbkfig ) ;
get_alim_bis(pt_mbkfig);
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Marquage des transparences                                                 |
 *----------------------------------------------------------------------------*/
( void )time( &start ) ;
test_transp( pt_mbkfig ) ;
( void )time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Test des transistors                                                       |
 *----------------------------------------------------------------------------*/
( void )time( &start ) ;
dsbMessage(3,NULL);
test_trans( pt_mbkfig ) ;
(void )time( &end ) ;
end -= start ;
pt_desafig->TRANS = pt_mbkfig->LOTRS ;


/*----------------------------------------------------------------------------*
 | Fabrication de la liste de cones                                           |
 *----------------------------------------------------------------------------*/
time( &start ) ;
dsbMessage(4,NULL);
pt_desafig->CONE = make_conelist( pt_mbkfig ) ;
time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Renumerotation des cones                                                   |
 *----------------------------------------------------------------------------*/
time( &start ) ;
{
register		index 		= 1L ;
   for(index=1L ,pt_cone=pt_desafig->CONE;
       pt_cone != NULL;
       pt_cone=pt_cone->NEXT)
   {
   short toto;
   pt_cone->INDEX = index ++ ;
   toto++;
   }
}
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Detruit les branches autoreferencielles part II                            |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for (pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   {
   RefAuto( pt_cone ) ;
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Remplissage des champs GRID des transistors                                |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_trans=pt_desafig->TRANS;pt_trans!=NULL;pt_trans=pt_trans->NEXT)
   {
   trans_chain( pt_trans ) ;
   }
( void )time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Destruction des chemins bloques ou auto-referents                          |
 *----------------------------------------------------------------------------*/
{
long		N_bloque	= 0L ;
long		N_autoref	= 0L ;
( void )time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   {
   test_ch_bloque( pt_cone , &N_autoref , &N_bloque ) ;
   }
time( &end ) ;
end -= start ;

   if ( DESB_STAT_MODE >= STAT_2 )
   {
   fprintf(DESB_STAT_FILE,"branches autoreferentielles   : %ld \n",N_autoref);
   fprintf(DESB_STAT_FILE, "branches bloques              : %ld \n" , N_bloque ) ;
   fflush(stdout);
   }
}

/*----------------------------------------------------------------------------*
 | Initialisation des systeme Bdd                                             |
 *----------------------------------------------------------------------------*/
initializeBdd(0);


/*----------------------------------------------------------------------------*
 | Test des connecteurs externes                                              |
 *----------------------------------------------------------------------------*/
{
int n_err = 0 ;
time( &start ) ;
dsbMessage(5,NULL);
   for( pt_con = pt_desafig->LOCON ; pt_con != NULL ; pt_con = pt_con->NEXT )
   {
   n_err+=test_ext( pt_con ) ;
   }
time( &end ) ;
end -= start ;
   if(n_err != 0)
   {
   char buff[200];
      if(DESB_LANG=='F')
      sprintf(buff,"[ERR] %d connecteur(s) de direction erronee",n_err);
      else if (DESB_LANG=='E')
      sprintf(buff,"[ERR] %d connectors with false direction",n_err);
   DESB_RECAP_ERR=addchain(DESB_RECAP_ERR,namealloc(buff));
   }
}

/*----------------------------------------------------------------------------*
 | Remplissage des champs INPUT_CONE et OUTPUT_CONE des cones                 |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for (pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   {
   cone_chain( pt_cone ) ;
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Verification des champs INPUT_CONE et OUTPUT_CONE des cones                |
 *----------------------------------------------------------------------------*/
time( &start ) ;
for ( pt_cone = pt_desafig->CONE ; pt_cone != NULL ; pt_cone = pt_cone->NEXT )
{
   /**** test des INCONE ****/
   if ( ( pt_cone->INCONE == NULL ) 
   && ( ( pt_cone->TYPE & ( VDD | VSS ) ) == 0 ) )
   {
   dsbWarning(11,"desb",pt_cone->NAME,NULL,0);
   }

   /**** test des OUTCONE ****/
   if ( pt_cone->OUTCONE == NULL ) 
   {
   dsbWarning(10,"desb",pt_cone->NAME,NULL,0);
   }
}
time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Test des conflits                                                          |
 *----------------------------------------------------------------------------*/
( void )time( &start ) ;
dsbMessage(6,NULL);
   for (pt_cone = pt_desafig->CONE; pt_cone != NULL; pt_cone = pt_cone->NEXT)
   { 
   test_conflict( pt_cone ) ; 
   }
time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Test de la haute impedance sur les cones                                   |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for (pt_cone=pt_desafig->CONE;pt_cone != NULL;pt_cone=pt_cone->NEXT )
   { 
      if( ( pt_cone->TYPE & ( VDD | VSS | EXT ) ) == 0 ) 
      {
      test_hz(pt_cone ) ; 
      }
   }
time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Detection des cones DUAL CMOS                                              |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT )
   {
   test_dual( pt_cone ) ;		
   }
time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Detection des latchs et des bleeder et des point memorisants               |
 *----------------------------------------------------------------------------*/
   {
   int dualReboucle = 0 ;
   ( void )time( &start ) ;
   dsbMessage(7,NULL);
      for(pt_cone = pt_desafig->CONE;pt_cone != NULL ;pt_cone=pt_cone->NEXT )
      { 
      test_latch( pt_cone ,&dualReboucle,pt_desafig ) ; 
      }
     
      if(dualReboucle!=0)
      {
      dsbCrendu(1,NULL,NULL,dualReboucle);
      }

   ( void )time( &end ) ;
   end -= start ;
   }


/*----------------------------------------------------------------------------*
 | Marquage des chemins passant par des points latch ou memorisant            |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   { 
   test_chmlat( pt_cone ) ; 
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Typage des commandes de latch                                              |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!= NULL;pt_cone=pt_cone->NEXT)
   { 
      if (((pt_cone->TYPE & LATCH)==LATCH) 
      || ((pt_cone->TYPE & MEMORY)==MEMORY) )
      type_com_lat( pt_cone ) ; 
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Teste  l'utilite de tous les transistors                                   |
 *----------------------------------------------------------------------------*/
util_trans(pt_desafig->TRANS ) ; 

/*----------------------------------------------------------------------------*
 | Test des connecteurs externes bis repetita...                              |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_con=pt_desafig->LOCON;pt_con!=NULL;pt_con=pt_con->NEXT)
   {
      if(dsbBleeDriveX( pt_con )!=0)
      {
      dsbXDriveNoGate( pt_con );
      }
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | On reteste les conflits: les cones qui ont des fxchemins                   |
 | peuvent changer de statut                                                  |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   { 
      if((pt_cone->TYPE & CONFLICT)==CONFLICT) test_conflict( pt_cone ) ; 
   }
   time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Test de la haute impedance                                                 |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   { 
      if((( ( pt_cone->TYPE & ( VDD | VSS | EXT ) ) == 0 ))&&(((pt_cone->TYPE)& HZ)==HZ))
      {
      test_hz( pt_cone ) ; 
      }
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | ANALYSE FONCTIONNELLE                                                      |
 *----------------------------------------------------------------------------*/
   if(DSB_USE_FCF != 0)
   {
   time( &start ) ;
   dsbMessage(8,NULL);
      if(pt_desafig->CONE != NULL)
      {
      fxConfHz( pt_desafig, 0 ,0,DSB_PROF );/* coneIndex=0,trace=0*/
      }
   time( &end ) ;
   end -= start ;
   }

/*----------------------------------------------------------------------------*
 | Test des connecteurs externes bis repetita...                              |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_con=pt_desafig->LOCON;pt_con!=NULL;pt_con=pt_con->NEXT)
   {
      if(dsbBleeDriveX( pt_con )!=0)
      {
      dsbXDriveNoGate( pt_con );
      }
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Detection des branches paralleles                                          |
 *----------------------------------------------------------------------------*/
time( &start ) ;
dsbMessage(9,NULL);
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   { 
   detect_path_para( pt_cone ) ; 
   }
time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Detection des switchs                                                      |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   { 
   detect_switch( pt_cone ) ;  
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Verification du type degrade                                               |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   {
   test_degr( pt_cone ) ;		
   }
( void )time( &end ) ;
end -= start ;


/*----------------------------------------------------------------------------*
 | Detection des cones DUAL CMOS                                              |
 *----------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   {
   test_dual( pt_cone ) ;		
   }
time( &end ) ;
end -= start ;

/*----------------------------------------------------------------------------*
 | Detection des Boucles illicites                                            |
 *----------------------------------------------------------------------------*/
{
int n_err = 0 ;
time( &start ) ;
dsbMessage(10,NULL);
   for(pt_cone=pt_desafig->CONE ; pt_cone!=NULL ; pt_cone=pt_cone->NEXT )
   {
   n_err += test_loop( pt_cone ) ;		
   }
time( &end ) ;
end -= start ;
   if(n_err != 0)
   {
   dsbCrendu(104,NULL,NULL,n_err);
   }
}

/*--------------------------------------------------------------------------*
 | recapitulatif des conflits et Tristates                                  |
 *-------------------------------------------------------------------------*/

{
int nConf = 0 ;
int nTris = 0 ;
char buff[400];

   for(pt_cone=pt_desafig->CONE ; pt_cone!=NULL ; pt_cone=pt_cone->NEXT )
   {
      if((pt_cone->TYPE & CONFLICT)==CONFLICT)
      {
      nConf++;
      dsbWarning(12,"desb",pt_cone->NAME,NULL,0);
      }
      if((pt_cone->TYPE & HZ)==HZ)
      {
      nTris++;
      dsbWarning(13,"desb",pt_cone->NAME,NULL,0);
      }
   }


   if(nConf!=0)
   {
   dsbCrendu(12,NULL,NULL,nConf);
   }
   if(nTris!=0)
   {
   dsbCrendu(13,NULL,NULL,nTris);
   }
}

/*--------------------------------------------------------------------------*
 | Nettoyage des branches bleeder, des InLoop, des OutLoop                  |
 *--------------------------------------------------------------------------*/
time( &start ) ;
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT )
   {
   rmvBleedPath( pt_cone ) ;		
   rmvLoopIn( pt_cone ) ;		
   rmvLoopOut( pt_cone ) ;		
   }
time( &end ) ;
end -= start ;


/*--------------------------------------------------------------------------*
 | Surtypage des directions des connecteurs a la sauce MBK/Vhdl             |
 *--------------------------------------------------------------------------*/
dsbExtIII(pt_desafig);
dsbAddCapaTransp(pt_desafig);

/*--------------------------------------------------------------------------*
| Detection des Master Slave Sclib                                          |
 *--------------------------------------------------------------------------*/
dsbMessage(11,NULL);
   for(pt_cone=pt_desafig->CONE;pt_cone!=NULL;pt_cone=pt_cone->NEXT)
   {
   int test ;
      if((pt_cone->TYPE & LATCH)!=LATCH) continue ;
   test = dsbMasterSlave(pt_cone);
   }
   
return( pt_desafig ) ;
}
			

/****************************************************************************
 *                         fonction desa_setenv();                          *
 ****************************************************************************/

          /**** test des variables d'environnement de DESB ****/

void	desa_setenv()

{

char 	*str 	= NULL ;

str = getenv( "DESB_SCALE_X" ) ;
if ( str != NULL )
	{
	DSB_SCALE_X = atoi( str ) ;
        }
else 
        DSB_SCALE_X = 10 ;

str = getenv( "VH_BEHSFX" ) ;
if ( str != NULL )
	{
	DSB_VHDSFX = namealloc( str ) ;
        }
else 
        DSB_VHDSFX = namealloc("vbe");

str = getenv( "DESB_DRAIN" ) ;
if ( str != NULL )
	{
	NAME_DRAIN = namealloc( str ) ;
	}
else
	NAME_DRAIN = namealloc( "drain" ) ;

str = getenv( "DESB_GRID" ) ;
if ( str != NULL )
	{
	NAME_GRID = namealloc( str ) ;
	}
else
	NAME_GRID = namealloc( "grid" ) ;

str = getenv( "DESB_SOURCE" ) ;
if ( str != NULL )
	{
	NAME_SOURCE = namealloc( str ) ;
	}
else
	NAME_SOURCE = namealloc( "source" ) ;

str = getenv( "DESB_X" ) ;
if ( str != NULL )
	{
	NAME_X = namealloc( str ) ;
	}
else
	NAME_X = namealloc( "x" ) ;

str = getenv( "DESB_Y" ) ;
if ( str != NULL )
	{
	NAME_Y = namealloc( str ) ;
	}
else
	NAME_Y = namealloc( "y" ) ;

str = getenv( "DESB_WIDTH" ) ;
if ( str != NULL )
	{
	NAME_WIDTH = namealloc( str ) ;
	}
else
	NAME_WIDTH = namealloc( "width" ) ;

str = getenv( "DESB_LENGTH" ) ;
if ( str != NULL )
	{
	NAME_LENGTH = namealloc( str ) ;
	}
else
	NAME_LENGTH = namealloc( "length" ) ;

/* since MBK_VSS/VSS  exist, DESB_VDD/VSS
   are non longer used */

str = getenv( "MBK_VDD" ) ;
if ( str != NULL )
	{
	NAME_VDD = namealloc( str ) ;
	}
else
	NAME_VDD = namealloc( "VDD" ) ;

str = getenv( "MBK_VSS" ) ;
if ( str != NULL )
	{
	NAME_VSS = namealloc( str ) ;
	}
else
	NAME_VSS = namealloc( "VSS" ) ;

str = getenv( "DESB_STAT_MODE" ) ;
if ( str != NULL )
{
   if ((str[0]=='y')||(str[0]=='Y')) 
   {
   DESB_STAT_MODE = 8;
   }
   else	DESB_STAT_MODE = 0 ; 
}
else DESB_STAT_MODE = 0 ; 

str = getenv( "DESB_LANGUAGE" ) ;
if ( str != NULL )
{
   if ((str[0]=='e')||(str[0]=='E')) 
   {
   DESB_LANG = 'E';
   }
   else	DESB_LANG = 'F' ; 
}
else DESB_LANG = 'E' ; 

str = getenv( "DESB_MAIL_MAX" ) ;
if ( str != NULL )
	DESB_MAIL_MAX = atoi( str ) ; 
else
	DESB_MAIL_MAX = 6 ; 

if ( DESB_TRACE_MODE >= MBK_TRACE )
	TRACE_MODE = 'Y' ;
else
	TRACE_MODE = 'N' ;
	
if ( DESB_TRACE_MODE >= MBK_DEBUG )
	DEBUG_MODE = 'Y' ;
else
	DEBUG_MODE = 'N' ;

}
