
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_rmvbemsg.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_rmvbemsg						*/
/* description	: delete a BEMSG structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N	*/
/* called func.	: mbkfree, freeExpr					*/
/* ###--------------------------------------------------------------### */

struct bemsg *beh_rmvbemsg (listbemsg, bemsglabl, mode)

struct bemsg *listbemsg;	/* list of bemsg containing the object	*/
char         *bemsglabl;	/* label of the BEMSG to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct bemsg  headmsg;
  struct bemsg *ptlastmsg;
  struct bemsg *ptbemsg;

  if (listbemsg != NULL)
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headmsg.NEXT = listbemsg;
    ptbemsg      = &headmsg;
    while ((ptbemsg != NULL) && (ptbemsg->LABEL != bemsglabl))
      {
      ptlastmsg = ptbemsg;
      ptbemsg   = ptbemsg->NEXT;
      }

    if (ptbemsg != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if (ptbemsg->ABL != NULL)
          (void) fprintf (stderr,"BEH_warning : bemsg `%s` not empty\n",
                          bemsglabl);
        }
      else
        freeExpr (ptbemsg->ABL);

      ptlastmsg->NEXT = ptbemsg->NEXT;
      mbkfree (ptbemsg);
      }

    listbemsg = headmsg.NEXT;
    }

  return(listbemsg);
  }
