
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_rmvbegen.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_rmvbegen						*/
/* description	: delete a BEGEN structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N	*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct begen *beh_rmvbegen (listbegen, begenname, mode)

struct begen *listbegen;	/* list of begen containing the object	*/
char         *begenname;	/* name of the BEGEN to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct begen  headgen;
  struct begen *ptlastgen;
  struct begen *ptbegen;

  if (listbegen != NULL)
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headgen.NEXT = listbegen;
    ptbegen      = &headgen;
    while ((ptbegen != NULL) && (ptbegen->NAME != begenname))
      {
      ptlastgen = ptbegen;
      ptbegen   = ptbegen->NEXT;
      }

    if (ptbegen != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if (ptbegen->VALUE != NULL)
          (void) fprintf (stderr,"BEH_warning : begen `%s` not empty\n",
                          begenname);
        }
      else
        mbkfree (ptbegen->VALUE);

      ptlastgen->NEXT = ptbegen->NEXT;
      mbkfree (ptbegen);
      }

    listbegen = headgen.NEXT;
    }

  return(listbegen);
  }
