
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebereg.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebereg						*/
/* description	: delete a list of BEAUX structures and all objects	*/
/*		  pointed by any os BEAUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebereg (listbereg)

struct bereg *listbereg;	/* list of bereg to be deleted		*/

  {
  struct bereg *ptbereg;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbereg != NULL)
    {
    beh_frebiabl  (listbereg->BIABL);
    beh_frebinode (listbereg->BINODE);

    ptbereg   = listbereg;
    listbereg = listbereg->NEXT;
    mbkfree (ptbereg);
    }

  }
