
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebemsg.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebemsg						*/
/* description	: delete a list of BEMSG structures and all objects	*/
/*		  pointed by any os BEMSGs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebemsg (listbemsg)

struct bemsg *listbemsg;	/* list of bemsg to be deleted		*/

  {
  struct bemsg *ptbemsg;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbemsg != NULL)
    {
    freeExpr (listbemsg->ABL);

    ptbemsg   = listbemsg;
    listbemsg = listbemsg->NEXT;
    mbkfree (ptbemsg);
    }

  }
